import es
from cfglib import AddonCFG
import playerlib

info = es.AddonInfo()
info.basename = 'hpbalancer'
info.name     = 'Health Point Based Team Balancer'
info.author   = 'ojii'
info.version  = '1.0'

es.ServerVar('hpb_version', info.version).makepublic()

cfg = AddonCFG(str(es.ServerVar('eventscripts_gamedir')) + "/cfg/hpbalancer.cfg")
 
cfg.text("******************************")
cfg.text("  HPBalancer SETTINGS")
cfg.text("******************************")
 
hpb_enabled            = cfg.cvar("hpb_enabled", 1, "Enable/disable HPBalancer")
hpb_ignore_bots        = cfg.cvar("hpb_ignore_bots", 1, "Enable/disable bot ignoring")
hpb_bonus_multiplier   = cfg.cvar("hpb_bonus_multiplier", 1.2, "Factor for HP increasing")
hpb_malus_multiplier   = cfg.cvar("hpb_malus_multiplier", 0.9, "Factor for HP decreasing")
hpb_treshhold          = cfg.cvar("hpb_treshhold",  3, "Minimum rounds to be won by either team to start the effect.")
hpb_reset_on_mapchange = cfg.cvar("hpb_reset_on_mapchange", 1, "Resets streaks on mapchange")
hpb_debugging          = cfg.cvar("hpb_debugging", 0, "Set to one for a debug log")
 
cfg.write()

class Debugger:
    def __init__(self):
        self.filepath = es.getAddonPath('hpbalancer') + '/log.txt'
        self.handler  = None
        
    def __call__(self, x):
        if bool(hpb_debugging):
            if not self.handler:
                try:
                    f = open(self.filepath, 'r')
                    c = f.read()
                    f.close()
                    f = open(self.filepath + '.backup', 'w')
                    f.write(c)
                    f.close()
                except:
                    pass
                self.handler = open(self.filepath, 'w')
            es.dbgmsg(0, '[HPB] %s' % x)
            self.handler.write('%s\n' % x)
        
    def newround(self):
        if self.handler:
            self.handler.close()
            self.handler = None
debug = Debugger()

class BalanceManager:
    def __init__(self):
        self.balance = 0 
        self.winner  = None
        
    def win(self, teamnum):
        teamnum = int(teamnum)
        debug('%s wins' % teamnum)
        if not self.winner:
            debug('no winner so far, new winner is %s' % teamnum)
            self.winner = teamnum
        if teamnum == self.winner:
            self.balance += 1
            debug('winner stays the same, incrementing to %s' % self.balance)
        else:
            self.winner = teamnum
            self.balance -= 1
            if self.balance < 0:
                self.balance *= -1
            debug('winner changes, decrementing to %s' % self.balance)
            
    def spawn(self, userid):
        if es.isbot(userid) and bool(hpb_ignore_bots):
            debug('%s is a bot and will be ignored' % userid)
            return
        if not self.winner:
            debug('no winner yet on spawn, ignoring')
            return
        if int(hpb_treshhold) > self.balance:
            debug('still in treshhold, ignoring')
            return
        calcbalance = self.balance - int(hpb_treshhold)
        debug('%s spawned' % userid)
        player = playerlib.getPlayer(userid)
        if player.team == self.winner:
            newhealth = (player.health * (float(hpb_malus_multiplier) ** calcbalance)) + 1
            debug('user is winner, setting health to %s' % newhealth)
        else:
            newhealth = player.health * (float(hpb_bonus_multiplier) ** calcbalance)
            debug('user is looser, setting health to %s' % newhealth)
        player.health = newhealth
        
    def mapstart(self):
        if bool(hpb_reset_on_mapchange):
            self.balance = 0
            self.winner = None
balancer = BalanceManager()

def load():
   cfg.execute()
   
def round_end(ev):
    balancer.win(ev['winner'])
    
def player_spawn(ev):
    balancer.spawn(ev['userid'])
    
def es_map_start(ev):
    balancer.mapstart()
    
def round_start(ev):
    debug.newround()