# SingleWeapon release 1 by David Bowland
# ./addons/eventscripts/singleweapon/singleweapon.py

# >>> To configure this addon please see singleweapon.cfg(created whent he addon is first loaded) <<<

"""
Randomly chooses a weapon each round for all players to use. Also provides an admin menu for choosing next weapon. Requires only ES 2.0+
"""


import cfglib
import es
import gamethread
import langlib
import os.path
import playerlib
import random
import services

import psyco
psyco.full()


info = es.AddonInfo()
info.name     = 'SingleWeapon'
info.version  = '1'
info.basename = 'singleweapon'
info.url      = 'http://addons.eventscripts.com/addons/view/' + info.basename
info.author   = 'SuperDave'


###


config = cfglib.AddonCFG(es.getAddonPath(info.basename) + '/' + info.basename + '.cfg')

config.text(info.name + ' release %s options' % info.version)
config.text('./addons/eventscripts/%(basename)s/%(basename)s.cfg' % {'basename':info.basename})
config.text(info.url)
config.text('')
config.text('Load this addon with: es_load ' + info.basename)
config.text('\n')
config.text('To configure language settings for %s please see %s_languages.ini' % (info.name, info.basename))
config.text('\n')

config.text('***** General options *****')
cvar_knife        = config.cvar('singleweapon_knife',        1,   '0 = no change, 1 = allow knife in addition to round weapon')
cvar_armor        = config.cvar('singleweapon_armor',        100, 'Amount of armor players receive at the start of each round')
cvar_hegrenade    = config.cvar('singleweapon_hegrenade',    0,   '0 = no change, 1 = players receive an HE grenade each round')
cvar_flashbang    = config.cvar('singleweapon_flashbang',    1,   'Number of flashbangs players receive each round')
cvar_smokegrenade = config.cvar('singleweapon_smokegrenade', 1,   '0 = no change, 1 = players receive a smoke grenade each round')
cvar_nightvision  = config.cvar('singleweapon_nightvision',  1,   '0 = no change, 1 = players receive nightvision goggles each round')
config.text('\n')

config.text('Use the following server command to add weapons to SingleWeapon:')
config.text('')
config.text('singleweapon_add <weapon or tag>')
config.text('')
config.text('Weapon choices: deagle ak47 scout aug g3sg1 galil famas m4a1 sg552 sg550 m249 awp tmp mp5navy glock elite m3 xm1014 usp mac10 ump45 p228 fiveseven p90 knife hegrenade')
config.text('Weapon tag choices: #all #primary #rifle #sniper #smg #shotgun #secondary #pistol')
config.text('\n')

config.text('Place your singleweapon_add commands below:')
config.command('singleweapon_add')
config.text('\n')

config.text('Uncomment the following default options if you wish to use them:')
config.text('')
config.text('singleweapon_add #primary')
config.text('singleweapon_add usp')
config.text('singleweapon_add deagle')
config.text('\n')

config.text('Weapons can be removed with the following server command:')
config.text('')
config.text('singleweapon_remove <weapon or tag>')
config.text('')
config.text('Due to the fact weapons can be added and removed above, this command will not be used by most users.')
config.text('\n')

config.text('***** Admin options *****')
cvar_trigger          = config.cvar('singleweapon_trigger',          '!swadmin', 'Say command to open SingleWeapon admin menu--set to "none" to eliminate')
cvar_trigger_announce = config.cvar('singleweapon_trigger_announce', 2,          '0 = no change, 1 = announce menu trigger to authorized players on the console at the beginning of each round, 2 = announce menu trigger to authorized players in chat area at the beginning of each round')
config.text('\n')

config.text('Use the following server command to add SingleWeapon admins:')
config.text('')
config.text('singleweapon_addadmin <"SteamID">')
config.text('')
config.text('When on a LAN use LAN_<name>.')
config.text('If you use an auth provider the singleweapon_admin permission will allow players to use the menu.')
config.text('That permission is automatically granted to the ADMIN level.')
config.text('\n')

config.text('Place your singleweapon_addadmin commands below:')
config.command('singleweapon_addadmin')
config.text('\n')

config.text('Uncomment the following default options if you wish to use them:')
config.text('')
config.text('singleweapon_addadmin "LAN_SUPERDAVE"')
config.text('singleweapon_addadmin "STEAM_0:0:0000"')
config.text('\n')

config.text('The following server command can be used to remove SingleWeapon admins:')
config.text('')
config.text('singleweapon_removeadmin <"SteamID">')
config.text('')
config.text('Due to the fact SingleWeapon admins can be added and removed above, this command will not be used by most users')

config.write()


###


class SingleWeaponManager(object):
   last_weapon    = ''
   in_round       = False
   current_weapon = None

   def __init__(self):
      self.weapon_choices = set()
      self.players        = {}


   def addWeaponChoice(self, name):
      weapon = weapons.getWeapon(name)
      if weapon:
         self.weapon_choices.add(weapon.name)
         self.pickNextWeapon()

      else:
         raise ValueError, 'Invalid weapon name \'%s\'' % name

   def removeWeaponChoice(self, name):
      weapon = weapons.getWeapon(name)
      if not weapon: return

      if weapon.name in self.weapon_choices:
         self.weapon_choices.remove(weapon.name)
         self.pickNextWeapon()


   def setNextWeapon(self, name):
      weapon = weapons.getWeapon(name)
      if weapon:
         self.next_weapon = weapon
         self.weapon_choices.add(weapon.name)

   def newWeapon(self):
      self.current_weapon = self.next_weapon

      self.pickNextWeapon()

   def pickNextWeapon(self):
      current_name = None
      if self.current_weapon: current_name = self.current_weapon.name

      choices = filter(lambda x: x <> current_name, self.weapon_choices)
      self.next_weapon = weapons.getWeapon(random.choice(choices if choices else weapons.getWeaponNameList('#primary')))

   def giveEveryoneWeapon(self, c4_userid=0):
      announce_option = int(cvar_trigger_announce) if say_command else 0
      for userid in es.getUseridList():
         if not es.getplayerprop(userid, 'CBasePlayer.pl.deadflag'):
            if userid == c4_userid:
               es.server.queuecmd('es_xgive %s weapon_c4' % userid)
            self.giveWeapon(userid)

         if swauth.isAuthed(userid):
            if announce_option == 1:
               es.cexec(userid, 'echo ' + _removeTags(lang_text('admin trigger', {'trigger':say_command}, playerlib.getPlayer(userid).get('lang'))))
            elif announce_option:
               es.tell(userid, '#multi', lang_text('admin trigger', {'trigger':say_command}, playerlib.getPlayer(userid).get('lang')))

   def giveWeapon(self, userid):
      if int(cvar_knife) and self.current_weapon <> 'weapon_knife' and (self.current_weapon <> 'weapon_hegrenade' or es.getplayersteamid(userid) != 'BOT'):
         es.server.queuecmd('es_xgive %s weapon_knife' % userid)

      armor = int(cvar_armor)
      if armor:
         es.setplayerprop(userid, 'CCSPlayer.m_ArmorValue', armor)

      he = int(cvar_hegrenade)
      if he and self.current_weapon <> 'weapon_hegrenade':
         es.server.queuecmd('es_xgive %s weapon_hegrenade' % userid)

      fb = int(cvar_flashbang)
      if fb:
         es.server.queuecmd('es_xgive %(userid)s weapon_flashbang;es_xsetplayerprop %(userid)s CBasePlayer.localdata.m_iAmmo.012 %(count)s' % {'userid':userid, 'count':fb})

      if int(cvar_smokegrenade):
         es.server.queuecmd('es_xgive %s weapon_smokegrenade' % userid)

      if int(cvar_nightvision):
         gamethread.delayed(0.1, es.setplayerprop, (userid, 'CCSPlayer.m_bHasNightVision', 1))

      if es.getplayerteam(userid) == 3 and es.getentityindex('func_bomb_target') <> -1:
         es.setplayerprop(userid, 'CCSPlayer.m_bHasDefuser', 1)

      es.server.queuecmd('es_xgive %(userid)s %(weapon)s;es_xdelayed 0 es_xsexec %(userid)s use %(weapon)s' % {'userid':userid, 'weapon':self.current_weapon})

   def refillAmmo(self, userid):
      if self.current_weapon:
         es.setplayerprop(userid, self.current_weapon.prop, self.current_weapon.maxammo)

   def heDetonate(self, userid):
      if self.current_weapon:
         if self.current_weapon == 'weapon_hegrenade':
            es.server.queuecmd('es_xgive %(userid)s weapon_hegrenade;es_xsexec %(userid)s use weapon_hegrenade' % {'userid':userid})


   def playerSpawn(self, userid):
      if not self.in_round or not self.current_weapon: return

      handle = es.getplayerhandle(userid)
      for index in weapons.getIndexList('#all'):
         if es.getindexprop(index, 'CBaseEntity.m_hOwnerEntity') == handle:
            es.server.cmd('es_xremove %s' % index)

      es.setplayerprop(userid, 'CBasePlayer.localdata.m_iAmmo.011', 0)
      es.setplayerprop(userid, 'CBasePlayer.localdata.m_iAmmo.012', 0)
      es.setplayerprop(userid, 'CBasePlayer.localdata.m_iAmmo.013', 0)

      self.giveWeapon(userid)

   def roundStart(self):
      userid = es.getuserid()
      if not userid: return

      self.newWeapon()
      if not self.current_weapon: return

      self.in_round = True

      c4_userid = 0
      for index in es.createentitylist('weapon_c4'):
         c4_userid = es.getuserid(es.getindexprop(index, 'CBaseEntity.m_hOwnerEntity'))
         break

      es.server.queuecmd('es_xfire %(userid)s func_buyzone disable;es_xfire %(userid)s weapon_* kill' % {'userid':userid})
      gamethread.delayedname(0.3, 'singleweapon_giveweapon', self.giveEveryoneWeapon, c4_userid)

   def roundEnd(self):
      self.in_round = False

   def itemPickup(self, userid, item):
      if not self.in_round: return
      elif item == 'c4': return
      elif item == 'knife' and int(cvar_knife): return
      elif item == 'hegrenade' and int(cvar_hegrenade): return
      elif item == 'flashbang' and int(cvar_flashbang): return
      elif item == 'smokegrenade' and int(cvar_smokegrenade): return

      weapon = weapons.getWeapon(item)
      if weapon == self.current_weapon or not weapon: return

      if es.createplayerlist(userid)[userid]['weapon'] == weapon:
         es.cexec(userid, 'lastinv')

      handle = es.getplayerhandle(userid)
      for index in weapon.indexlist:
         if es.getindexprop(index, 'CBaseEntity.m_hOwnerEntity') == handle:
            es.server.cmd('es_xremove %s' % index)
            break


   def removePlayer(self, userid):
      userid = int(userid)
      popup.removePlayer(userid)

      if userid in self.players:
         del self.players[userid]

   def clearPlayers(self):
      popup.clearPlayers()
      self.players.clear()

   def sendMenu(self, userid):
      weaponlist = self.weapon_choices.copy()
      if not weaponlist: weaponlist = weapons.getWeaponNameList('#primary') + weapons.getWeaponNameList('#secondary')

      self.players[userid] = {'index':0, 'weaponlist':map(lambda x: str(x).replace('weapon_', ''), sorted(weaponlist, key=lambda x: (weapons.getWeapon(x).slot, weapons.getWeapon(x).name)))}

      self.generateMenu(userid)

   def generateMenu(self, userid):
      if userid not in self.players: return

      player = self.players[userid]
      player_lang = playerlib.getPlayer(userid).get('lang')

      current_name = None
      if self.current_weapon: current_name = self.current_weapon.name.replace('weapon_', '')

      index = player['index']

      popup.send(userid, 0, '\n'.join([lang_text('menu title', lang=player_lang), ' '] + [('' if weapon == current_name else '->') + '%s. %s' % (x + 1, weapon) for x, weapon in enumerate(player['weaponlist'][index:index + 7])] + [' ', '8. ' + lang_text('back' if index else 'random', lang=player_lang), ('9. ' + lang_text('next', lang=player_lang)) if player['index'] + 7 < len(player['weaponlist']) else ' ', '0. ' + lang_text('cancel', lang=player_lang), ' ', lang_text('next weapon', {'weapon':self.next_weapon.name.replace('weapon_', '')}, player_lang)]), self.menuSelection)

   def menuSelection(self, userid, item):
      if userid not in self.players: return
      player = self.players[userid]

      selection   = player['index'] + item - 1
      weaponcount = len(player['weaponlist'])
      if 1 <= item <= 7 and selection < weaponcount:
         self.next_weapon = weapons.getWeapon(player['weaponlist'][selection])
         self.confirmSelection(userid)

      elif item == 8:
         if player['index']:
            player['index'] -= 7
            self.generateMenu(userid)

         else:
            self.next_weapon = weapons.getWeapon(random.choice(player['weaponlist']))
            self.confirmSelection(userid)

      elif item == 9 and player['index'] + 7 < weaponcount:
         player['index'] += 7
         self.generateMenu(userid)

      else:
         del self.players[userid]
         return True

      return False

   def confirmSelection(self, userid):
      popup.send(userid, 10, lang_text('next weapon', {'weapon':self.next_weapon.name.replace('weapon_', '')}, playerlib.getPlayer(userid).get('lang')))
      if userid in self.players:
         del self.players[userid]


   @staticmethod
   def removeDelay():
      gamethread.cancelDelayed('singleweapon_giveweapon')

sw = SingleWeaponManager()


def addweapon_cmd():
   """
   singleweapon_add <weapon or tag>
   """
   if es.getargc() == 2:
      for name in weapons.getWeaponNameList(es.getargv(1)):
         sw.addWeaponChoice(name)

   else:
      es.dbgmsg(0, 'Syntax: singleweapon_add <weapon or tag>')

if not es.exists('command', 'singleweapon_add'):
   es.regcmd('singleweapon_add', 'singleweapon/addweapon_cmd', 'singleweapon_add <weapon or tag>\nServer command to add weapons to SingleWeapon')


def removeweapon_cmd():
   """
   singleweapon_remove <weapon or tag>
   """
   if es.getargc() == 2:
      for name in weapons.getWeaponNameList(es.getargv(1)):
         sw.removeWeaponChoice(name)

   else:
      es.dbgmsg(0, 'Syntax: singleweapon_remove <weapon or tag>')

if not es.exists('command', 'singleweapon_remove'):
   es.regcmd('singleweapon_remove', 'singleweapon/removeweapon_cmd', 'singleweapon_remove <weapon or tag>\nServer command to remove weapons from SingleWeapon')


def sendmenu_cmd():
   userid = es.getcmduserid()
   if swauth.isAuthed(userid):
      sw.sendMenu(userid)

   else:
      es.tell(userid, '#multi', lang_text('not authed', lang=playerlib.getPlayer(userid).get('lang')))


###


class SWAuth(object):
   service_auth = lambda self, x: False

   def __init__(self):
      self.admins = set()

      if not services.isRegistered('auth'): return

      auth = services.use('auth')
      auth.registerCapability('singleweapon_admin', auth.ADMIN)

      self.service_auth = lambda self, x: auth.isUseridAuthorized(x, 'singleweapon_admin')

   def addPlayer(self, steamid):
      self.admins.add(steamid)

   def removePlayer(self, steamid):
      if steamid in self.admins:
         self.admins.remove(steamid)

   def isAuthed(self, userid):
      if self.service_auth(userid): return True
      return self.getPlayerSteamID(userid) in self.admins

   @staticmethod
   def getPlayerSteamID(userid):
      steamid = es.getplayersteamid(userid)
      return ('LAN_' + es.getplayername(userid).upper()) if steamid == 'STEAM_ID_LAN' else steamid

swauth = SWAuth()


def addadmin_cmd():
   """
   singleweapon_addadmin <"SteamID">
   """
   if es.getargc() == 2:
      swauth.addPlayer(es.getargv(1).upper())

   else:
      es.dbgmsg(0, 'Syntax: singleweapon_addadmin <\"SteamID\">')

if not es.exists('command', 'singleweapon_addadmin'):
   es.regcmd('singleweapon_addadmin', 'singleweapon/addadmin_cmd', 'singleweapon_addadmin <\"SteamID\">\nServer command to add SingleWeapon admins')


def removeadmin_cmd():
   """
   singleweapon_removeadmin <"SteamID">
   """
   if es.getargc() == 2:
      swauth.removePlayer(es.getargv(1).upper())

   else:
      es.dbgmsg(0, 'Syntax: singleweapon_removeadmin <\"SteamID\">')

if not es.exists('command', 'singleweapon_removeadmin'):
   es.regcmd('singleweapon_removeadmin', 'singleweapon/removeadmin_cmd', 'singleweapon_removeadmin <\"SteamID\">\nServer command to remove SingleWeapon admins')


###


def getLangText():
   lang_path = es.getAddonPath(info.basename) + '/%s_languages.ini' % info.basename
   if os.path.isfile(lang_path):
      return langlib.Strings(lang_path)

   else:
      es.dbgmsg(0, '%(name)s: Unable to load %(basename)s_languages.ini! Please ensure it is in the ./%(basename)s/ directory.' % {'name':info.name, 'basename':info.basename})
      return lambda x, y, z: '%s: %s_languages.ini not found' % (info.name, info.basename)

lang_text = getLangText()


def _removeTags(text):
   return text.replace('#lightgreen', '').replace('#green', '').replace('#default', '')


###


say_command = None

def load():
   global say_command

   config.execute()

   testcmd = str(cvar_trigger)
   if not es.exists('saycommand', testcmd) and testcmd.lower() <> 'none':
      es.regsaycmd(testcmd, 'singleweapon/sendmenu_cmd', 'Say command to display SingleWeapon admin menu')
      say_command = testcmd

   sw.pickNextWeapon()


def es_map_start(event_var):
   sw.clearPlayers()


def round_start(event_var):
   sw.roundStart()


def round_end(event_var):
   sw.roundEnd()


def player_spawn(event_var):
   if int(event_var['es_userteam']) > 1:
      sw.playerSpawn(int(event_var['userid']))


def player_disconnect(event_var):
   sw.removePlayer(event_var['userid'])


def item_pickup(event_var):
   sw.itemPickup(int(event_var['userid']), event_var['item'])


def weapon_fire_on_empty(event_var):
   sw.refillAmmo(int(event_var['userid']))


def hegrenade_detonate(event_var):
   sw.heDetonate(int(event_var['userid']))


def unload():
   userid = es.getuserid()
   if userid:
      es.server.queuecmd('es_xfire %s func_buyzone enable' % userid)

   else:
      es.server.queuecmd('changelevel')

   if say_command:
      es.unregsaycmd(say_command)

   sw.removeDelay()

   popup.clearPlayers(True)

   for cvar in config.getCvars():
      es.ServerVar(cvar).set(0)


###


class WeaponManager(object):
   class Weapon:
      def __init__(self, name, ammoprop='', tags=(), slot=0, clip=0, maxammo=0):
         self.info_name     = name
         self.info_ammoprop = ammoprop
         self.info_tags     = (tags,) if isinstance(tags, str) else tuple(tags)
         self.info_slot     = slot
         self.info_clip     = clip
         self.info_maxammo  = maxammo

      def __str__(self):
         return self.get('name')

      def __coerce__(self, x):
         return (self.get('name'), x) if isinstance(x, str) else None

      def __getattr__(self, x):
         try:
            return self.get(x)

         except ValueError:
            raise AttributeError, 'Weapon instance has no attribute \'%s\'' % x

      def __getitem__(self, x):
         try:
            return self.get(x)

         except ValueError:
            raise KeyError, '\'%s\'' % x

      """ Public functions """

      def get(self, info):
         if info == 'name':
            return 'weapon_' + self.info_name

         elif info == 'prop':
            return ('CBasePlayer.localdata.m_iAmmo.' + self.info_ammoprop) if self.info_ammoprop else None

         elif info == 'tags':
            return self.info_tags

         elif info == 'slot':
            return self.info_slot

         elif info == 'clip':
            return self.info_clip

         elif info == 'maxammo':
            return int(es.ServerVar('ammo_' + self.info_maxammo + '_max')) if isinstance(self.info_maxammo, str) else self.info_maxammo

         elif info == 'indexlist':
            return es.createentitylist(self.name).keys()

         raise ValueError, 'No weapon info \'%s\'' % info

   """ Begin WeaponManager """

   def __init__(self):
      self.weapons = {}

   """ Public functions """

   def getWeapon(self, name):
      name = self._formatName(name)

      return self.weapons[name] if name in self.weapons else None

   def getWeaponList(self, tag):
      if str(tag).startswith('#'):
         return filter(lambda x: tag in x.tags, map(lambda x: self.weapons[x], self.weapons))

      else:
         name = self._formatName(tag)
         return [self.weapons[name]] if name in self.weapons else []

   def getWeaponNameList(self, tag):
      return map(str, self.getWeaponList(tag))

   def getIndexList(self, tag):
      indexlist = []
      for weapon in self.getWeaponList(tag):
         indexlist += weapon.indexlist

      return indexlist

   """ Private functions """

   def _registerWeapon(self, name, ammoprop='', tags=(), slot=0, clip=0, maxammo=0):
      name = self._formatName(name)

      self.weapons[name] = self.Weapon(name, ammoprop, tags, slot, clip, maxammo)

   def _formatName(self, name):
      return str(name).lower().replace('weapon_', '')


###


weapons = WeaponManager()
weapons._registerWeapon('deagle',       '001', ('#all', '#secondary', '#pistol'),         2, 7,      '50AE')
weapons._registerWeapon('ak47',         '002', ('#all', '#primary', '#rifle'),            1, 30,     '762mm')
weapons._registerWeapon('scout',        '002', ('#all', '#primary', '#rifle', '#sniper'), 1, 10,     '762mm')
weapons._registerWeapon('aug',          '002', ('#all', '#primary', '#rifle'),            1, 30,     '762mm')
weapons._registerWeapon('g3sg1',        '002', ('#all', '#primary', '#rifle', '#sniper'), 1, 20,     '762mm')
weapons._registerWeapon('galil',        '003', ('#all', '#primary', '#rifle'),            1, 35,     '556mm')
weapons._registerWeapon('famas',        '003', ('#all', '#primary', '#rifle'),            1, 25,     '556mm')
weapons._registerWeapon('m4a1',         '003', ('#all', '#primary', '#rifle'),            1, 30,     '556mm')
weapons._registerWeapon('sg552',        '003', ('#all', '#primary', '#rifle'),            1, 30,     '556mm')
weapons._registerWeapon('sg550',        '003', ('#all', '#primary', '#rifle', '#sniper'), 1, 30,     '556mm')
weapons._registerWeapon('m249',         '004', ('#all', '#primary'),                      1, 100,    '556mm_box')
weapons._registerWeapon('awp',          '005', ('#all', '#primary', '#rifle', '#sniper'), 1, 10,     '338mag')
weapons._registerWeapon('tmp',          '006', ('#all', '#primary', '#smg'),              1, 30,     '9mm')
weapons._registerWeapon('mp5navy',      '006', ('#all', '#primary', '#smg'),              1, 30,     '9mm')
weapons._registerWeapon('glock',        '006', ('#all', '#secondary', '#pistol'),         2, 20,     '9mm')
weapons._registerWeapon('elite',        '006', ('#all', '#secondary', '#pistol'),         2, 30,     '9mm')
weapons._registerWeapon('m3',           '007', ('#all', '#primary', '#shotgun'),          1, 8,      'buckshot')
weapons._registerWeapon('xm1014',       '007', ('#all', '#primary', '#shotgun'),          1, 7,      'buckshot')
weapons._registerWeapon('mac10',        '008', ('#all', '#primary', '#smg'),              1, 30,     '45acp')
weapons._registerWeapon('ump45',        '008', ('#all', '#primary', '#smg'),              1, 25,     '45acp')
weapons._registerWeapon('usp',          '008', ('#all', '#secondary', '#pistol'),         2, 12,     '45acp')
weapons._registerWeapon('p228',         '009', ('#all', '#secondary', '#pistol'),         2, 13,     '357sig')
weapons._registerWeapon('fiveseven',    '010', ('#all', '#secondary', '#pistol'),         2, 20,     '57mm')
weapons._registerWeapon('p90',          '010', ('#all', '#primary', '#smg'),              1, 50,     '57mm')
weapons._registerWeapon('hegrenade',    '011', ('#all', '#grenade'),                      4, maxammo='hegrenade')
weapons._registerWeapon('knife',          tags=('#all', '#knife'),                   slot=3)


###


class CheapPopup(object):
   class Player(object):
      menu     = ()
      callback = None
      timeout  = None

      def __init__(self, userid, parent):
         self.userid = userid
         self.parent = parent

      def send(self, duration, text, callback=None, timeout=None):
         if not self.menu:
            es.menu(0, self.userid, ' ')
            es.cexec(self.userid, 'slot10')

         self.menu     = (duration, self.userid, text)
         self.callback = callback
         self.timeout  = timeout

      def unSend(self):
         if not self.menu:
            es.cexec(self.userid, 'slot10')

         self.removeDelay()
         self.parent.removePlayer(self.userid)

      def selection(self, item):
         if item == 10 and self.menu:
            es.menu(*self.menu)

            delay = self.menu[0]
            if delay:
               gamethread.delayedname(delay, self.parent.basename + '_popup_' + str(self.userid), self._endDelay)

            self.menu = ()
            return

         self.parent.removePlayer(self.userid)

         if self.callback(self.userid, item) if self.callback else True:
            if item <> 10:
               es.cexec(self.userid, 'slot%s' % item)

      def _endDelay(self):
         self.parent.removePlayer(self.userid)
         if self.timeout:
            self.timeout(self.userid)

      def removeDelay(self):
         gamethread.cancelDelayed(self.parent.basename + '_popup_' + str(self.userid))

   """ Begin CheapPopup """
   basename = __name__

   def __init__(self):
      self.players = {}

   """ Player functions """

   def getPlayer(self, userid):
      userid = int(userid)
      if userid not in self.players:
         self.players[userid] = self.Player(userid, self)
         es.addons.registerClientCommandFilter(self._selection_hook)

      return self.players[userid]

   def removePlayer(self, userid):
      userid = int(userid)
      if userid in self.players:
         self.players[userid].removeDelay()
         del self.players[userid]

   def clearPlayers(self, unsend=False):
      if unsend:
         for userid in self.players.keys():
            self.players[userid].unSend()

      else:
         for userid in self.players:
            self.players[userid].removeDelay()

         self.players.clear()

      es.addons.unregisterClientCommandFilter(self._selection_hook)

   """ Popup functions """

   def send(self, userid, duration, text, callback=None, timeout=None):
      self.getPlayer(userid).send(duration, text, callback, timeout)

   def unsend(self, userid):
      userid = int(userid)
      if userid in self.players:
         self.getPlayer(userid).unSend()

   def _selection_hook(self, userid, args):
      if userid in self.players and args[0].lower() == 'menuselect' and len(args) > 1:
         self.getPlayer(userid).selection(int(args[1]))

      return True

popup = CheapPopup()