"""
//******************************
//Sn4k3 Paint Ball (SPB)
//	for Counter-Strike: Source
//
//* Requires:
//
//	Mattie EventScripts v2.0.0.242+
//	ES_Tools Plugin by Awuh0 v.416d+
//
//* Description:
//
//	Paint Ball Mod
//	
//
//* Install instructions:
//     1. Install Mattie's EventScripts plugins:
//         http://mattie.info/cs
//
//     2. Copy and upload this script to:
//         cstrike/addons/eventscripts/spb/spb.py
//
//     3. Add the following line somewhere in autoexec.cfg:
//         es_load spb
//
//*Credits
//
//sn4k3 -> Script Developer
//
//
//Suport: MSN : Tiago_caza@hotmail.com
//*************************************
"""

import es
import random
import gamethread

# all SPB server variables are declared here for convenience 
spb_version	  		= es.ServerVar("spb_version",			2.0, "Current SPB version.") 
spb	  			= es.ServerVar("spb",				0, "Is SPB enable or disable.") 
spb_decal_time	  		= es.ServerVar("spb_decal_time",		2.0, "How much time the effect stay.") 
spb_blue_effect_scale  		= es.ServerVar("spb_blue_effect_scale",		0, "Blue tint scale.") 
spb_lightblue_effect_scale	= es.ServerVar("spb_lightblue_effect_scale",	0, "Lightblue tint scale.") 
spb_red_effect_scale  		= es.ServerVar("spb_red_effect_scale",		0, "Red tint scale.") 
spb_green_effect_scale 		= es.ServerVar("spb_green_effect_scale",	0, "Green tint scale.") 
spb_lightblue_effect_scale	= es.ServerVar("spb_lightblue_effect_scale",	0, "Lightblue tint scale.") 
spb_yellow_effect_scale		= es.ServerVar("spb_yellow_effect_scale",	0, "Yellow tint scale.") 

spb_use_team_colors		= es.ServerVar("spb_use_team_colors",		0, "Allow use blue tint to CTs and red tint to Ts.") 
spb_bots_can_use		= es.ServerVar("spb_bots_can_use",		0, "Allow bots use paintball.") 

_spb_coord			= es.ServerVar("_spb_coord",			0, "Player Detection.") 

info = es.AddonInfo() 
info.name     = "Sn4k3 PaintBall" 
info.basename = "SPB" 
info.version  	= str(spb_version)
info.url      = "http://addons.eventscripts.com/addons/view/SPB" 
info.description = "A PaintBall mod for SourceGames"
info.author   = "sn4k3" 
#info.contact  	= "Tiago_caza@hotmail.com"
#info.tags = "spb;paintball,effects"

_spb_opt = {}
_spb_opt['tint'] = {}
_spb_opt['tint'][1] = "spb/spb_shot1.vmt"
_spb_opt['tint'][2] = "spb/spb_shot2.vmt"
_spb_opt['tint'][3] = "spb/spb_shot3.vmt"
_spb_opt['tint'][4] = "spb/spb_shot5.vmt"
_spb_opt['tint'][5] = "spb/spb_shot6.vmt"
_spb_opt['tint'][6] = "spb/spb_shot7.vmt"
_spb_opt['cvars'] = {}
_spb_opt['cvars'][1] = "spb_red_effect_scale"
_spb_opt['cvars'][2] = "spb_blue_effect_scale"
_spb_opt['cvars'][3] = "spb_green_effect_scale"
_spb_opt['cvars'][4] = "spb_green_effect_scale"
_spb_opt['cvars'][5] = "spb_yellow_effect_scale"
_spb_opt['cvars'][6] = "spb_lightblue_effect_scale"

def load():
	spb_version.makepublic()
	spb.makepublic()

	es.mexec("spb/spb_server.cfg")
	
	es.doblock('corelib/noisy_on')

	if len(str(es.ServerVar('eventscripts_currentmap'))) > 3:
		es.stringtable("downloadables", "materials/spb/spb_shot1.vtf")
		es.stringtable("downloadables", "materials/spb/spb_shot1.vmt")
		es.stringtable("downloadables", "materials/spb/spb_shot2.vmt")
		es.stringtable("downloadables", "materials/spb/spb_shot2.vtf")
		es.stringtable("downloadables", "materials/spb/spb_shot3.vtf")
		es.stringtable("downloadables", "materials/spb/spb_shot3.vmt")
		es.stringtable("downloadables", "materials/spb/spb_shot5.vmt")
		es.stringtable("downloadables", "materials/spb/spb_shot5.vtf")
		es.stringtable("downloadables", "materials/spb/spb_shot6.vtf")
		es.stringtable("downloadables", "materials/spb/spb_shot6.vmt")
		es.stringtable("downloadables", "materials/spb/spb_shot7.vtf")
		es.stringtable("downloadables", "materials/spb/spb_shot7.vmt")


def unload():
	spb.set(0)
	es.doblock('corelib/noisy_off')

"""
def enable():
	if not int(es.ServerVar('eventscripts_noisy')):
		es.set("eventscripts_noisy", 1)
	
	spb.set(1)

def disable():
	spb.set(0)
	es.set("eventscripts_noisy", 0)
"""

def player_activate(event_var):
	gamethread.delayed(10, spb_delayed_funcs, event_var['userid'])

def es_map_start(event_var):
	es.stringtable("downloadables", "materials/spb/spb_shot1.vtf")
	es.stringtable("downloadables", "materials/spb/spb_shot1.vmt")
	es.stringtable("downloadables", "materials/spb/spb_shot2.vmt")
	es.stringtable("downloadables", "materials/spb/spb_shot2.vtf")
	es.stringtable("downloadables", "materials/spb/spb_shot3.vtf")
	es.stringtable("downloadables", "materials/spb/spb_shot3.vmt")
	es.stringtable("downloadables", "materials/spb/spb_shot5.vmt")
	es.stringtable("downloadables", "materials/spb/spb_shot5.vtf")
	es.stringtable("downloadables", "materials/spb/spb_shot6.vtf")
	es.stringtable("downloadables", "materials/spb/spb_shot6.vmt")
	es.stringtable("downloadables", "materials/spb/spb_shot7.vtf")
	es.stringtable("downloadables", "materials/spb/spb_shot7.vmt")
	
	if not int(es.ServerVar('eventscripts_noisy')):
		es.doblock('corelib/noisy_on')

def bullet_impact(event_var):
	if event_var['es_steamid'] == "BOT" and int(spb_bots_can_use) or not event_var['es_steamid'] == "BOT":
		es.set("_spb_coord", 0)
		es.server.cmd('est_NearCoord _spb_coord #a 70 %s %s %s "_spb_coord 1"' % (event_var['x'], event_var['y'], event_var['z']))
		if not int(_spb_coord):
			if not int(spb_use_team_colors):
				rand = random.randint(1,6)			
				es.server.cmd("est_effect 11 #h 0 %s %s %s %s %s %s 255" % (_spb_opt['tint'][rand], event_var['x'], event_var['y'], event_var['z'], spb_decal_time, es.ServerVar(_spb_opt['cvars'][rand])))
			else:
				es.server.cmd("est_effect 11 #h 0 %s %s %s %s %s %s 255" % (_spb_opt['tint'][event_var['es_userteam']], event_var['x'], event_var['y'], event_var['z'], spb_decal_time, es.ServerVar(_spb_opt['cvars'][event_var['es_userteam']])))

def spb_delayed_funcs(userid):
	if es.exists("userid", userid):
		es.tell(userid, "\x04SPB:\x01 Source Games\x03 PaintBall\x01 Mod, version: \x03%s\n\x04SPB:\x01 Written By:\x03 sn4k3\x01 AKA\x03 Tiago Conceicao\n\x04Visit:\x01 http://addons.eventscripts.com/addons/view/SPB\n" % (spb_version))