import es, effectlib, playerlib, popuplib, gamethread, random, cPickle, os.path

list_markers = []
dict_players = {}
dict_names = {}

claim_distance = 25

def load():
	players_db = es.getAddonPath('trophies') + '/players.db'
	if os.path.isfile(players_db):
		global dict_players
		players = open(players_db)
		dict_players = cPickle.load(players)
		players.close()
	players_namesdb = es.getAddonPath('trophies') + '/names.db'
	if os.path.isfile(players_namesdb):
		global dict_names
		pnames = open(players_namesdb)
		dict_names = cPickle.load(pnames)
		pnames.close()
	es.msg('#multi', '#green[ #lightgreenTrophies#green ] : #lightgreenLoaded')
	es.regclientcmd('claim', 'trophies/claim')
	es.regsaycmd('trophies', 'trophies/mytrophies')

def unload():
	savedb()
	es.unregclientcmd('claim')
	es.unregsaycmd('trophies')
	es.msg('#multi', '#green[ #lightgreenTrophies#green ] : #lightgreenUnloaded')

# Add the location and begin placing markers.
def player_death(ev):
	listappend = es.getplayerlocation(ev['userid'])
	list_markers.append(listappend)
	team = ev['es_userteam']
	attackerteam = ev['es_attackerteam']
	if not team == attackerteam and ev['attacker'] != 0:
		placemarkers()

# Clear the trophy-markers list.
def round_end(ev):
	del list_markers[:]
	savedb()

# Update a players name and insert it into the name dictionary for reference.
def player_spawn(ev):
	steamid = ev['es_steamid']
	name = ev['es_username']
	dict_names[steamid] = name

# Builds the trophies top10 popup.
def round_start(ev):
	global top_tro
	del list_markers[:]
	i = sorted(dict_players.items(), key=lambda x: x[1], reverse=True)
	if popuplib.exists('top_tro'):
		popuplib.delete('top_tro')
	top_tro = popuplib.create('top_tro')
	top_tro.addline('Trophies Top 10')
	top_tro.addline('Servers Best Headhunters')
	top_tro.addline('-----------------------')
	top_l = len(dict_players)-1
	top = 0
	for a in i:
		if top < 10:
			if top <= top_l:
				top_tro.addline('->%i. %s - %s' % (top+1, getname(a), a[1]))
		top += 1
	top_tro.addline('-----------------------')
	top_tro.addline('0. Exit')

# Adds the player's SteamID to the dictionary if it's not already there.
def player_activate(ev):
	steamid = ev['es_steamid']
	name = str(ev['es_username'])
	if not dict_players.has_key(steamid):
		dict_players[steamid] = 0
	dict_names[steamid] = name

# Places all trophy-markers at the location of the player-death until claimed.
def placemarkers():
	counter = 0
	for marker in list_markers:
		loc = list_markers[counter]
		effectlib.drawCircle(loc, 10, steps = 7, seconds=1, width=3, endwidth=3, red=random.randint(10, 200), green=random.randint(10, 200), blue=random.randint(10, 200))
		counter += 1
	if not len(list_markers) == 0:
		gamethread.delayed(1,placemarkers)

# Does pretty much what it says on the box ... Claims a nearby trophy.
def claim():
	userid = es.getcmduserid()
	steamid = es.getplayersteamid(userid)
	team = es.getplayerteam(userid)
	counter = 0
	check = 0
	msgcheck = 0
	if team != 1:
		if len(list_markers) != 0:
			for marker in list_markers:
				loc = list_markers[counter]
				x, y, z = int(float(loc[0])), int(float(loc[1])), int(float(loc[2]))
				ploc = es.getplayerlocation(userid)
				if abs(ploc[0] - x) <= claim_distance and abs(loc[1] - y) <= claim_distance and abs(loc[2] - z) <= claim_distance:
					dict_players[steamid] += 1
					es.tell(userid, '#multi', '#green[ #lightgreenTrophies#green ] : #lightgreenYou now have #green%d#lightgreen trophies.'%dict_players[steamid])
					del list_markers[counter]
				else:
					if msgcheck == 0:
						es.tell(userid, '#multi', '#green[ #lightgreenTrophies#green ] : #lightgreenThere are no un-claimed trophies near your current location.')
						msgcheck += 1
				counter += 1
		else:
			es.tell(userid, '#multi', '#green[ #lightgreenTrophies#green ] : #lightgreenThere are no trophies currently on the map.')
	else:
		es.tell(userid, '#multi', '#green[ #lightgreenTrophies#green ] : #lightgreenPlease do not try to claim trophies whilst not on a team.')

# Custom function to retrieve the players name to populate the top10 listing.
def getname(a):
	val = a[0]
	name = dict_names[val]
	return name
	
# Tells a player their trophy count.
def mytrophies():
	userid = es.getcmduserid()
	steamid = es.getplayersteamid(userid)
	es.tell(userid, '#multi', '#green[ #lightgreenTrophies#green ] : #lightgreenYou have #green%d#lightgreen trophies.'%dict_players[steamid])

# Sends the top10 ranking trophy popup.
def player_say(ev):
	if ev['text'] == 'ttop10':
		top_tro.send(ev['userid'])
	# Sends the players rank after claiming all of the neccessary data.
	elif ev['text'] == 'trank':
		tempsteam = 0
		steamid = ev['es_steamid']
		counter = 0
		name = ev['es_username']
		x = sorted(dict_players.items(), key=lambda x: x[1], reverse=True)
		for sid in x:
			tempsteam = x[counter]
			if tempsteam[0] == steamid:
				es.msg('Player %s has %s trophies, with a rank of %s/%s.'%(name, dict_players[steamid], counter + 1, len(x) + 1))
				break
			counter += 1

def savedb():
	players_db = open(es.getAddonPath('trophies') + '/players.db', 'w')
	cPickle.dump(dict_players, players_db)
	players_db.close()
	players_namesdb = open(es.getAddonPath('trophies') + '/names.db', 'w')
	cPickle.dump(dict_names, players_namesdb)
	players_namesdb.close()