#============================================================================================================================================#
# -*- coding:Utf-8 -*-
# admin_connect V1.3p (09/05/2008) by DoCky
# MATTIE'S EVENTSCRIPTS 2.0, PYTHON OPERATIONNEL




import es, os, re, psyco, keyvalues as _key, playerlib as _use
psyco.full()

ac_info = es.AddonInfo()
ac_info.version = "1.3p"
ac_info.author = "DoCky"
ac_info.name = "admin_connect"
ac_info.url = "http://addons.eventscripts.com/addons/user/11751"
ac_path = es.ServerVar('eventscripts_gamedir') + "/cfg/admin_connect/"




#    SYSTEM    #
class System:
    """
        Script system
    """

    _vers = es.ServerVar(ac_info.name, ac_info.version, "version actuelle du script")
    _tell = es.ServerVar("ac_msgmod")
    _time = es.ServerVar("ac_msgtps")
    _admm = es.ServerVar("ac_msgadm")
    _adms = es.ServerVar("ac_sndadm")
    _down = es.ServerVar("ac_snddlf")

    _user = _key.KeyValues(name="ac_admin")


    @staticmethod
    def loadConf():
        if not os.path.isdir(ac_path):
            os.mkdir(ac_path)

        if not os.path.isfile(ac_path + "config.cfg"):
            es.log("[admin_connect] missing file : cfg/admin_connect/config.cfg")

        else:
            es.server.cmd("es_mexec admin_connect/config.cfg")
            System._vers.set(ac_info.version)
            System._vers.makepublic()

            es.log("[admin_connect] running with %s" % es.getgame())
            System.keyGroup()

            user = System._user.keys()
            if not len(user):
                es.log("[admin_connect] admin list : !warning! no admin registered")

            else:
                es.log("[admin_connect] admin list : %s" % re.sub("[[']|]", "", str(user)))

            es.log("[admin_connect] * config loaded *")
            if not int(System._tell):
                es.log("[admin_connect] advert mode : message")

            elif int(System._tell) == 1:
                es.log("[admin_connect] advert mode : popup")

            elif int(System._tell) == 2:
                es.log("[admin_connect] advert mode : message & popup")

            if int(System._tell):
                if int(System._time):
                    es.log("[admin_connect] popup timer : %s sec" % System._time)

                else:
                    es.log("[admin_connect] popup timer : no timer for expiration")

            if int(System._admm):
                es.log("[admin_connect] advert user : admin only")

            else:
                es.log("[admin_connect] advert user : all player")

            if int(System._adms):
                es.log("[admin_connect] sound user : admin only")

            else:
                es.log("[admin_connect] sound user : all player")

            if int(System._down):
                System.downFile()
                es.log("[admin_connect] sound file : auto-download On")

            else:
                es.log("[admin_connect] sound file : auto-download Off")
            es.log("[admin_connect] * config loaded *")


    @staticmethod
    def keyGroup():
        try:
            if not os.path.isfile(ac_path + "ac_admin.txt"):
                System._user["STEAM_ID"] = _key.KeyValues(name="STEAM_ID")
                System._user["STEAM_ID"]["name"] = "Admin name"
                System._user["STEAM_ID"]["msgc"] = "welcom %1  (%1 : refresh name)"
                System._user["STEAM_ID"]["msgd"] = "good bye %1  (%1 : refresh name)"
                System._user["STEAM_ID"]["sonc"] = "path/soundc.mp3"
                System._user["STEAM_ID"]["sond"] = "path/soundd.mp3"
                System._user.save("cfg/admin_connect/ac_admin.txt")

                es.log("[admin_connect] missing file : cfg/admin_connect/ac_admin.txt")
                es.log("[admin_connect] file created : you must edit it")

        finally:
            System._user.load("cfg/admin_connect/ac_admin.txt")

            """ check keys """
            Keys = ["name", "msgc", "msgd", "sonc", "sond"]

            for user in System._user:
                for keys in Keys:

                    if not keys in System._user[str(user)]:
                        System._user[str(user)][str(keys)] = "0"


    @staticmethod
    def downFile():
        for user in System._user:
            path = System._user[str(user)]["sonc"]
            if path != "0":
                es.stringtable("downloadables", path)

            path = System._user[str(user)]["sond"]
            if path != "0":
                es.stringtable("downloadables", path)


    @staticmethod
    def saveName(unid, name):
        System._user[unid]["name"] = name


    @staticmethod
    def formTell(tell, name):
        return tell.replace("%1", name)


    @staticmethod
    def remColor(tell):
        return re.sub("(#green)+|(#default)+|(#lightgreen)+", "", tell)




#    SCRIPT    #
def load():
    System.loadConf()


def es_map_start(event_var):
    System.loadConf()


def player_changename(event_var):
    unid = es.getplayersteamid(event_var["userid"])
    if unid in System._user:
        System.saveName(unid, event_var["newname"])


def es_player_validated(event_var):
    if event_var["networkid"] in System._user:
        System.saveName(event_var["networkid"], event_var["name"])

        tell = System.formTell(System._user[event_var["networkid"]]["msgc"], event_var["name"])
        menu = System.remColor(tell)

        if tell != "0":
            mode = int(System._tell)
            if int(System._admm):

                for unid in System._user:
                    user = es.getuserid(unid)

                    if user:
                        mode = System._tell

                        if mode == 0 or mode == 2:
                            es.tell(user, "#multi", tell)

                        if mode:
                            es.menu(System._time, user, menu)

            else:
                if mode == 0 or mode == 2:
                    es.msg("#multi", tell)

                if mode:
                    for user in _use.getUseridList("#human"):
                        es.menu(System._time, user, menu)


def player_activate(event_var):
    if event_var["es_steamid"] in System._user:
        path = System._user[event_var["es_steamid"]]["sonc"]

        if path != "0":
            if int(System._adms):

                for unid in System._user:
                    user = es.getuserid(unid)

                    if user:
                        es.playsound(user, path, 1)

            else:
                for user in _use.getUseridList("#human"):
                    es.playsound(user, path, 1)


def player_disconnect(event_var):
    if event_var["networkid"] in System._user:
        tell = System.formTell(System._user[event_var["networkid"]]["msgd"], System._user[event_var["networkid"]]["name"])
        menu = System.remColor(tell)

        if tell != "0":
            mode = int(System._tell)
            if int(System._admm):

                for unid in System._user:
                    user = es.getuserid(unid)

                    if user:
                        if mode == 0 or mode == 2:
                            es.tell(user, "#multi", tell)

                        if mode:
                            es.menu(System._time, user, menu)

            else:
                if mode == 0 or mode == 2:
                    es.msg("#multi", tell)

                if mode:
                    for user in _use.getUseridList("#human"):
                        es.menu(System._time, user, menu)

        path = System._user[event_var["networkid"]]["sond"]
        if path != "0":
            if int(System._adms):

                for unid in System._user:
                    user = es.getuserid(unid)

                    if user:
                        es.playsound(user, path, 1)

            else:
                for user in _use.getUseridList("#human"):
                    es.playsound(user, path, 1)

#============================================================================================================================================#
