# IPToCountry Example by David Bowland
# ./addons/eventscripts/iptocountry_example/iptocountry_example.py

# >>> To configure this addon please see iptocountry_example.cfg <<<

"""
Example addon for IPToCountry library. Requires only ES 2.0+
"""


import es
import iptocountry
import langlib
import os.path
import playerlib
import time

import psyco
psyco.full()


info = es.AddonInfo()
info.name = 'IPToCountry Example'
info.version = '1'
info.url = 'http://addons.eventscripts.com/addons/view/iptocountry'
info.basename = 'iptocountry_example'
info.author = 'SuperDave'
info.database = 'http://software77.net/cgi-bin/ip-country/geo-ip.pl'


dict_options = {'iptocountry_example_update_days':[14, 'Number of days between database updates--set to 0 to eliminate'], 'iptocountry_example_update_load':[0, '0 = no change, 1 = update database every time ipcountry_example is loaded (NOT RECOMMENDED)'], 'iptocountry_example_announce_chat':[2, '0 = no change, 1 = announce on the console the country each player joins from, 2 = annoucne in chat area the country each player joins from'], 'iptocountry_example_announce_center':[1, '0 = no change, 1 = announce in center text the country each player joins from'], 'iptocountry_example_announce_hud':[0, '0 = no change, 1 = announce in a HUD message the country each player joins from']}
func_lang_text = None


def load():
   """
   Ensures critical server variables are created by the config
   Updates the database if necessary
   """
   global func_lang_text

   if not es.exists('command', 'iptocountry_getcountry'):
      es.regcmd('iptocountry_getcountry', 'iptocountry_example/country_cmd', 'iptocountry_getcountry <country var> <abbr var> <\"ip\">\nReturns the country name and three-letter abbreviation of the IP')
   if not es.exists('command', 'iptocountry_getinfo'):
      es.regcmd('iptocountry_getinfo', 'iptocountry_example/info_cmd', 'iptocountry_getinfo <var> <info type> <\"ip\">\nReturns location information of the IP')
   if not es.exists('command', 'iptocountry_getlastupdate'):
      es.regcmd('iptocountry_getlastupdate', 'iptocountry_example/lastupdate_cmd', 'iptocountry_getlastupdate <var>\nReturns the time of the last IPToCountry database update')
   if not es.exists('command', 'iptocountry_updatedata'):
      es.regcmd('iptocountry_updatedata', 'iptocountry_example/updatedata_cmd', 'iptocountry_updatedata [\"url\"]\nSyncs the database with an internet database')

   for str_option in dict_options:
      es.ServerVar(str_option, dict_options[str_option][0], dict_options[str_option][1])
   if os.path.isfile(es.getAddonPath('iptocountry_example') + '/iptocountry_example.cfg'):
      es.server.cmd('es_xmexec ../addons/eventscripts/iptocountry_example/iptocountry_example.cfg')
   else:
      es.dbgmsg(0, 'IPToCountry Example: Unable to load iptocountry_example.cfg! Please ensure it is in the ./iptocountry_example/ directory.')

   str_lang_path = es.getAddonPath('iptocountry_example') + '/iptocountry_example_languages.ini'
   if os.path.isfile(str_lang_path):
      func_lang_text = langlib.Strings(str_lang_path)
   else:
      es.dbgmsg(0, 'IPToCountry Example: Unable to load iptocountry_example_languages.ini! Please ensure it is in the ./iptocountry_example/ directory.')
   if not func_lang_text:
      func_lang_text = missing_lang

   if int(es.ServerVar('iptocountry_example_update_load')):
      data_update()

   else:
      try_update()


def round_end(event_var):
   """Calls try_update to update the database if there are no human players"""
   try_update()


def player_connect(event_var):
   """Announces the connecting player's country"""
   if event_var['networkid'] == 'BOT':
      return

   dict_tokens = {'name':event_var['name'], 'location':iptocountry.get_country(event_var['address'])[0]}
   int_announce_chat = int(es.ServerVar('iptocountry_example_announce_chat'))
   int_announce_center = int(es.ServerVar('iptocountry_example_announce_center'))
   int_announce_hud = int(es.ServerVar('iptocountry_example_announce_hud'))

   es.dbgmsg(0, func_lang_text('connect', dict_tokens))
   for userid in es.getUseridList():
      str_text = func_lang_text('connect', dict_tokens, playerlib.getPlayer(userid).get('lang'))

      if int_announce_chat:
         if int_announce_chat == 2:
            es.tell(userid, '#multi', str_text)
         else:
            es.cexec(userid, 'echo ' + remove_tags(str_text))

      if int_announce_center:
         es.centertell(userid, remove_tags(str_text))

      if int_announce_hud:
         hud_hint(userid, remove_tags(str_text))


def player_disconnect(event_var):
   """Calls try_update to update the database if the player was the last human on the server"""
   try_update()


def unload():
   for str_option in dict_options:
      es.ServerVar(str_option).set(0)


def try_update():
   """Calls data_update if the data is the requisite age and no humans are connected"""
   int_update_days = int(es.ServerVar('iptocountry_example_update_days'))
   if int_update_days and not len(playerlib.getPlayerList('#human')):
      if time.time() - iptocountry.get_last_update() > int_update_days * 86400.:
         data_update()


def data_update():
   """Updates the IPToCountry database"""
   es.dbgmsg(0, 'Updating IPToCountry database')
   if iptocountry.update_data():
      es.dbgmsg(0, 'Update complete')
   else:
      es.dbgmsg(0, 'Error updating database!')


def country_cmd():
   """
   iptocountry_getcountry <country var> <abbr var> <"ip">
   Returns the country name and three-letter abbreviation to server variables
   """
   if es.getargc() == 4:
      list_info = iptocountry.get_country(es.getargv(3))
      es.ServerVar(es.getargv(1)).set(list_info[0])
      es.ServerVar(es.getargv(2)).set(list_info[1])

   else:
      es.dbgmsg(0, 'Syntax: iptocountry_getcountry <country var> <abbr var> <\"ip\">')


def info_cmd():
   """
   iptocountry_getinfo <var> <info type> <"ip">
   Returns location information of the IP
   """
   if es.getargc() == 4:
      str_info_type = es.getargv(2).lower()
      dict_data = iptocountry.get_location_data(es.getargv(3))

      if dict_data.has_key(str_info_type):
         es.ServerVar(es.getargv(1)).set(dict_data[str_info_type])

      else:
         es.dbgmsg(0, 'IPToCountry Example: Info type \"%s\" not found' % str_info_type)

   else:
      es.dbgmsg(0, 'Syntax: iptocountry_getinfo <var> <info type> <\"ip\">')


def lastupdate_cmd():
   """
   iptocountry_getlastupdate <var>
   Returns the time of the last IPToCountry database update
   """
   if es.getargc() == 2:
      es.ServerVar(es.getargv(1)).set(iptocountry.get_last_update())

   else:
      es.dbgmsg(0, 'Syntax: iptocountry_getlastupdate <var>')


def updatedata_cmd():
   """
   iptocountry_updatedata ["url"]
   Syncs the database with an internet database
   """
   int_arg_count = es.getargc()
   if int_arg_count in (1, 2):
      if int_arg_count == 2:
         iptocountry.update_data(es.getargv(1))

      else:
         iptocountry.update_data()

   else:
      es.dbgmsg(0, 'Syntax: iptocountry_updatedata [\"url\"]')


def hud_hint(int_userid, str_message):
   """Sends the player a HUD hint"""
   es.usermsg('create', 'iptocountry_example_hud', 'HintText')
   es.usermsg('write', 'short', 'iptocountry_example_hud', -1)
   es.usermsg('write', 'string', 'iptocountry_example_hud', str_message)
   es.usermsg('send', 'iptocountry_example_hud', int_userid)
   es.usermsg('delete', 'iptocountry_example_hud')


def remove_tags(str_text):
   """Removes #lightgreen, #green and #default tags from the supplied string"""
   return str_text.replace('#lightgreen', '').replace('#green', '').replace('#default', '')


def missing_lang(str_heading, dict_tokens, str_language):
   """Displays an error message because the languages .ini could not be found"""
   return 'IPToCountry Example: iptocountry_example_languages.ini not found'