#include <sourcemod>
#include <clientprefs>

new Handle:g_hEnabled = INVALID_HANDLE;
new Handle:g_hLogEnabled = INVALID_HANDLE;
new Handle:g_hShowToAdmins = INVALID_HANDLE;
new Handle:g_hCookieMessage = INVALID_HANDLE;
new Handle:g_hCookieMessageA = INVALID_HANDLE;

new bool:g_bEnabled;
new bool:g_bLogEnabled;
new bool:g_bShowToAdmins;

new bool:g_bShowMessage[MAXPLAYERS + 1];
new bool:g_bShowMessageA[MAXPLAYERS + 1];

public Plugin:myinfo =
{
	name = "Private Messager", 
	author = "Marcus", 
	description = "A plugin that always players to private message other players.",
	version = "1.1.2", 
	url = "http://www.redspeedservers.com"
}

public OnPluginStart()
{
	CreateConVar("sv_pm_version", "1.0.0", "This is the plugin version for the plugin.", FCVAR_NONE);

	g_hEnabled = CreateConVar("sv_pm_enabled", "1", "This toggles the features of this plugin. (0 = Off, 1 = On)", FCVAR_NONE, true, 0.0, true, 1.0);
	HookConVarChange(g_hEnabled, OnSettingsChange);
	g_hLogEnabled = CreateConVar("sv_pm_log_enabled", "1", "This toggles the logging of all private messages. (0 = Off, 1 = On)", FCVAR_NONE, true, 0.0, true, 1.0);
	HookConVarChange(g_hLogEnabled, OnSettingsChange);
	g_hShowToAdmins = CreateConVar("sv_pm_show_admins", "1", "This toggles if admins receive all private messages. (0 = Off, 1 = On)", FCVAR_NONE, true, 0.0, true, 1.0);
	HookConVarChange(g_hShowToAdmins, OnSettingsChange);

	g_bEnabled = GetConVarBool(g_hEnabled);
	g_bLogEnabled = GetConVarBool(g_hLogEnabled);
	g_bShowToAdmins = GetConVarBool(g_hShowToAdmins);

	g_hCookieMessage = RegClientCookie("show_pms", "This is used to store whether or not a client wants to recieve private messages.", CookieAccess_Protected);
	g_hCookieMessageA = RegClientCookie("show_pms_to_admin", "This is used to store whether or not an admin sees everyones private messages.", CookieAccess_Protected);

	RegAdminCmd("sm_pm", Command_PM, 0, "This command allows a player to send a private message to another player/group of players.");
	RegAdminCmd("sm_toggle", Command_Toggle, 0, "This command toggles an admins ability to view every Private Message sent.");
}

public OnSettingsChange(Handle:cvar, const String:oldvalue[], const String:newvalue[])
{
	if (cvar == g_hEnabled)
	{
		g_bEnabled = bool:StringToInt(newvalue);
	} else if (cvar == g_hLogEnabled)
	{
		g_bLogEnabled = bool:StringToInt(newvalue);
	} else if (cvar == g_hShowToAdmins)
	{
		g_bShowToAdmins = bool:StringToInt(newvalue);
	}
}

public OnClientPostAdminCheck(iClient)
{
	if (1 <= iClient <= MaxClients)
	{
		decl String:sBuffer[16], String:sBuffer2[16];
		GetClientCookie(iClient, g_hCookieMessage, sBuffer, sizeof(sBuffer));
		GetClientCookie(iClient, g_hCookieMessageA, sBuffer2, sizeof(sBuffer2));

		StringToInt(sBuffer) == -1 ? (g_bShowMessage[iClient] = false) : (g_bShowMessage[iClient] = true);
		StringToInt(sBuffer2) == -1 ? (g_bShowMessageA[iClient] = false) : (g_bShowMessageA[iClient] = true);

		CreateTimer(1.0, Timer_Connected, GetClientSerial(iClient));
	}
}

public Action:Command_PM(iClient, iArgs)
{
	if (g_bEnabled)
	{
		if (iArgs < 2)
		{
			PrintToChat(iClient, "[SM] Usage: sm_pm <player> <message>");
			return Plugin_Handled;
		}
		
		decl String:sArg[64], String:sArgS[256];
		GetCmdArg(1, sArg, sizeof(sArg));
		
		GetCmdArgString(sArgS, sizeof(sArgS));
		ReplaceString(sArgS, sizeof(sArgS), sArg, "", false);
		
		new iPlayer = -1;
			
		for(new i = 1; i <= MaxClients ; i++)
		{
			if (!IsClientConnected(i)) continue;
			
			decl String:sName[32];
			GetClientName(i, sName, sizeof(sName));
			
			if (StrContains(sName, sArg, false) != -1) iPlayer = i;
		}
		
		if (iPlayer == -1)
		{
			PrintToChat(iClient, "[SM] Error: Invalid client name: \x04%s\x01", sArg);
			return Plugin_Handled;
		}
		
		if (iPlayer == iClient)
		{
			PrintToChat(iClient, "[SM] Error: You cannot send a pm to yourself!");
			return Plugin_Handled;
		}
		
		if (!g_bShowMessage[iPlayer])
		{
			PrintToChat(iClient, "[SM] Error: %N has disabled his receival of private messages.", iPlayer);
			return Plugin_Handled;
		}

		PrintToChat(iPlayer, "\x01\x04(From: %N)\x01: %s", iClient, sArgS);
		PrintToChat(iClient, "\x01\x04(Sent To: %N)\x01: %s", iPlayer, sArgS);

		if (g_bShowToAdmins)
			PrintToAdmins(iClient, iPlayer, sArgS);

		if (g_bLogEnabled)
			LogMessage("%N sent: \"%s\" to %N", iClient, sArgS, iPlayer);
	} else
	PrintToChat(iClient, "[SM] Error: All features in this plugin have been disabled!");

	return Plugin_Handled;
}

public Action:Command_Toggle(iClient, iArgs)
{
	if (g_bEnabled)
	{
		if (iArgs == 0)
		{
			if (g_bShowMessage[iClient])
			{
				decl String:sBuffer[16], iBuffer;

				g_bShowMessage[iClient] = false;
				g_bShowMessage[iClient] ? (iBuffer = 1) : (iBuffer = -1);

				IntToString(iBuffer, sBuffer, sizeof(sBuffer));
				SetClientCookie(iClient, g_hCookieMessage, sBuffer);

				PrintToChat(iClient, "\x01[SM] \x04Notice\x01: You have disabled your receival of private messages.");
			} else
			{
				decl String:sBuffer[16], iBuffer;

				g_bShowMessage[iClient] = true;
				g_bShowMessage[iClient] ? (iBuffer = 1) : (iBuffer = -1);

				IntToString(iBuffer, sBuffer, sizeof(sBuffer));
				SetClientCookie(iClient, g_hCookieMessage, sBuffer);

				PrintToChat(iClient, "\x01[SM] \x04Notice\x01: You have enabled your receival of private messages.");
			}
		} else
		{
			if (GetUserFlagBits(iClient) & ADMFLAG_CHAT <= 0)
			{
				decl String:sArg[16];
				GetCmdArg(1, sArg, sizeof(sArg));

				if (StrContains(sArg, "admin") != -1)
				{
					if (g_bShowMessageA[iClient])
					{
						decl String:sBuffer[16], iBuffer;

						g_bShowMessageA[iClient] = false;
						g_bShowMessageA[iClient] ? (iBuffer = 1) : (iBuffer = -1);

						IntToString(iBuffer, sBuffer, sizeof(sBuffer));
						SetClientCookie(iClient, g_hCookieMessageA, sBuffer);

						PrintToChat(iClient, "\x01[SM] \x04Notice\x01: You have disabled your receival of everyone's private messages.");
					} else
					{
						decl String:sBuffer[16], iBuffer;

						g_bShowMessageA[iClient] = true;
						g_bShowMessageA[iClient] ? (iBuffer = 1) : (iBuffer = -1);

						IntToString(iBuffer, sBuffer, sizeof(sBuffer));
						SetClientCookie(iClient, g_hCookieMessageA, sBuffer);

						PrintToChat(iClient, "\x01[SM] \x04Notice\x01: You have enabled your receival of everyone's private messages.");
					}
				}
			} else
			PrintToChat(iClient, "[SM] Error: You do not have access to do that!");
		}
	} else
	PrintToChat(iClient, "[SM] Error: All features in this plugin have been disabled!");
}

public Action:Timer_Connected(Handle:timer, any:iBuffer)
{
	new iClient = GetClientFromSerial(iBuffer);

	if (!g_bShowMessage[iClient])
		PrintToChat(iClient, "\x01[SM] \x04Notice\x01: You have your private messages disabled. (sm_toggle)");

	if (!g_bShowMessageA[iClient])
		PrintToChat(iClient, "\x01[SM] \x04Notice\x01: You have your admin private messages disabled. (sm_toggle admin)");

}

stock PrintToAdmins(iClient, iTarget, const String:sMessage[])
{
	if (!(1 <= iClient <= MaxClients || 1 <= iTarget <= MaxClients)) return;

	if (strlen(sMessage) <= 0) return;

	for (new i = 1; i < MaxClients; i++)
	{
		if (!IsClientConnected(i)) continue;

		if (GetUserFlagBits(i) & ADMFLAG_CHAT || ADMFLAG_ROOT <= 0) continue;

		if (iTarget == i || iClient == i) continue;

		if (!g_bShowMessageA[i]) continue;

		PrintToChat(i, "\x01\x04(To: %N, From: %N)\x01: %s", iTarget, iClient, sMessage);
	}
}