#pragma semicolon 1

// ====[ INCLUDES ]============================================================
#include <sourcemod>
#include <sdktools>
#include <nextmap>
#tryinclude <basecomm>

// ====[ DEFINES ]=============================================================
#define PLUGIN_VERSION "1.1.2"

#define KICK 0
#define BAN 1
#define MAP 2
#define MUTE 3
#define TYPE_COUNT 4

// ====[ HANDLES | CVARS ]=====================================================
new Handle:g_hCvarVoteEnabled				[TYPE_COUNT];
new Handle:g_hCvarVoteRatio					[TYPE_COUNT];
new Handle:g_hCvarVoteMinimum				[TYPE_COUNT];
new Handle:g_hCvarVoteDelay					[TYPE_COUNT];
new Handle:g_hCvarVoteLimit					[TYPE_COUNT];
new Handle:g_hCvarVoteTeam					[TYPE_COUNT];
new Handle:g_hCvarChatTriggers;
new Handle:g_hCvarVotesInterval;
new Handle:g_hCvarVotesTimeout;
new Handle:g_hCvarMapExtendTime;
new Handle:g_hCvarMapMaxExtends;
new Handle:g_hCvarMapTimeLimit;
new Handle:g_hCvarMapChangeImmediately;
new Handle:g_hCvarVoteMapLast;
new Handle:g_hCvarVoteBanTime;
new Handle:g_hCvarVoteBanReasons;
new Handle:g_hCvarVoteImmunity;
new Handle:g_hCvarAdminGroups;
new Handle:g_hCvarSourceBans;
new Handle:g_hArrayAdminGroups;
new Handle:g_hArrayVotedForMap					[MAXPLAYERS + 1];
new Handle:g_hArrayLastMaps;
new Handle:g_hArrayMapList;
new Handle:g_hArrayVotedForBan					[MAXPLAYERS + 1];
new Handle:g_hArrayVotedForReason				[MAXPLAYERS + 1];
new Handle:g_hArrayVoteBanClientUserIds;
new Handle:g_hArrayVoteBanClientCurrentUserId;
new Handle:g_hArrayVoteBanClientIdentity;
new Handle:g_hArrayVoteBanClientNames;
new Handle:g_hArrayVoteBanClientTeam;
new Handle:g_hArrayVoteBanReasons;
new Handle:g_hArrayVoteMuteClientIdentity;

// ====[ CVAR VARIABLES ]======================================================
new bool:g_bVoteEnabled[TYPE_COUNT];
new Float:g_fVoteRatio[TYPE_COUNT];
new g_iVoteMinimum[TYPE_COUNT];
new g_iVoteDelay[TYPE_COUNT];
new g_iVoteLimit[TYPE_COUNT];
new g_bVoteTeam[TYPE_COUNT];
new g_iVoteMapLast;
new g_iMapExtendTime;
new g_iMapMaxExtends;
new bool:g_bMapChangeImmediately;
new bool:g_bChatTriggers;
new g_iVotesInterval;
new g_iVotesTimeout;
new g_iVoteBanTime;
new String:g_strVoteBanReasons[256];
new g_iVoteImmunity;
new String:g_strAdminGroups[256];

// ====[ VARIABLES ]===========================================================
new g_iStartTime;
new g_iVoteCount							[TYPE_COUNT][MAXPLAYERS + 1];
new g_iLastVote								[MAXPLAYERS + 1];
new g_iMapListSerial = -1;
new g_iMapCurrent;
new g_iVoteBanClients						[MAXPLAYERS + 1] = {-1, ...};
new bool:g_bVoteAction;
new bool:g_bImmuneByGroup					[MAXPLAYERS + 1];
new bool:g_bVotedForKick					[MAXPLAYERS + 1][MAXPLAYERS + 1];
new bool:g_bVotedForMute					[MAXPLAYERS + 1][MAXPLAYERS + 1];
new bool:g_bMuted							[MAXPLAYERS + 1];

// ====[ PLUGIN ]==============================================================
public Plugin:myinfo =
{
	name = "Players Votes Redux",
	author = "ReFlexPoison",
	description = "Votekick, Voteban, Votemap, & Votemute (Redux)",
	version = PLUGIN_VERSION,
	url = "http://www.sourcemod.net/"
}

// ====[ FUNCTIONS ]===========================================================
public OnPluginStart()
{
	LoadTranslations("playersvotes.phrases");

	CreateConVar("sm_playersvotes_redux_version", PLUGIN_VERSION, "Players Votes Redux Version", FCVAR_PLUGIN | FCVAR_SPONLY | FCVAR_DONTRECORD | FCVAR_NOTIFY);

	g_hCvarMapTimeLimit = FindConVar("mp_timelimit");

	g_hCvarVoteEnabled[KICK] = CreateConVar("sm_votekick_enabled", "1", "Enable votekick votes\n0 = Disabled\n1 = Enabled", FCVAR_PLUGIN, true, 0.0, true, 1.0);
	g_bVoteEnabled[KICK] = GetConVarBool(g_hCvarVoteEnabled[KICK]);
	HookConVarChange(g_hCvarVoteEnabled[KICK], OnConVarChange);

	g_hCvarVoteEnabled[BAN] = CreateConVar("sm_voteban_enabled", "1", "Enable voteban votes\n0 = Disabled\n1 = Enabled", FCVAR_PLUGIN, true, 0.0, true, 1.0);
	g_bVoteEnabled[BAN] = GetConVarBool(g_hCvarVoteEnabled[BAN]);
	HookConVarChange(g_hCvarVoteEnabled[BAN], OnConVarChange);

	g_hCvarVoteEnabled[MAP] = CreateConVar("sm_votemap_enabled", "1", "Enable votemap votes\n0 = Disabled\n1 = Enabled", FCVAR_PLUGIN, true, 0.0, true, 1.0);
	g_bVoteEnabled[MAP] = GetConVarBool(g_hCvarVoteEnabled[MAP]);
	HookConVarChange(g_hCvarVoteEnabled[MAP], OnConVarChange);

	g_hCvarVoteEnabled[MUTE] = CreateConVar("sm_votemute_enabled", "1", "Enable votemute votes\n0 = Disabled\n1 = Enabled", FCVAR_PLUGIN, true, 0.0, true, 1.0);
	g_bVoteEnabled[MUTE] = GetConVarBool(g_hCvarVoteEnabled[MUTE]);
	HookConVarChange(g_hCvarVoteEnabled[MUTE], OnConVarChange);

	g_hCvarVoteRatio[KICK] = CreateConVar("sm_votekick_ratio", "0.6", "Ratio required for successful votekick", FCVAR_PLUGIN, true, 0.0, true, 1.0);
	g_fVoteRatio[KICK] = GetConVarFloat(g_hCvarVoteRatio[KICK]);
	HookConVarChange(g_hCvarVoteRatio[KICK], OnConVarChange);

	g_hCvarVoteRatio[BAN] = CreateConVar("sm_voteban_ratio", "0.8", "Ratio required for successful voteban", FCVAR_PLUGIN, true, 0.0, true, 1.0);
	g_fVoteRatio[BAN] = GetConVarFloat(g_hCvarVoteRatio[BAN]);
	HookConVarChange(g_hCvarVoteRatio[BAN], OnConVarChange);

	g_hCvarVoteRatio[MAP] = CreateConVar("sm_votemap_ratio", "0.6", "Ratio required for successful votemap", FCVAR_PLUGIN, true, 0.0, true, 1.0);
	g_fVoteRatio[MAP] = GetConVarFloat(g_hCvarVoteRatio[MAP]);
	HookConVarChange(g_hCvarVoteRatio[MAP], OnConVarChange);

	g_hCvarVoteRatio[MUTE] = CreateConVar("sm_votemute_ratio", "0.6", "Ratio required for successful votemute", FCVAR_PLUGIN, true, 0.0, true, 1.0);
	g_fVoteRatio[MUTE] = GetConVarFloat(g_hCvarVoteRatio[MUTE]);
	HookConVarChange(g_hCvarVoteRatio[MUTE], OnConVarChange);

	g_hCvarVoteMinimum[KICK] = CreateConVar("sm_votekick_minimum", "4", "Minimum votes required for successful votekick", FCVAR_PLUGIN, true, 1.0, true, 64.0);
	g_iVoteMinimum[KICK] = GetConVarInt(g_hCvarVoteMinimum[KICK]);
	HookConVarChange(g_hCvarVoteMinimum[KICK], OnConVarChange);

	g_hCvarVoteMinimum[BAN] = CreateConVar("sm_voteban_minimum", "4", "Minimum votes required for successful voteban", FCVAR_PLUGIN, true, 1.0, true, 64.0);
	g_iVoteMinimum[BAN] = GetConVarInt(g_hCvarVoteMinimum[BAN]);
	HookConVarChange(g_hCvarVoteMinimum[BAN], OnConVarChange);

	g_hCvarVoteMinimum[MAP] = CreateConVar("sm_votemap_minimum", "4", "Minimum votes required for successful votemap", FCVAR_PLUGIN, true, 1.0, true, 64.0);
	g_iVoteMinimum[MAP] = GetConVarInt(g_hCvarVoteMinimum[MAP]);
	HookConVarChange(g_hCvarVoteMinimum[MAP], OnConVarChange);

	g_hCvarVoteMinimum[MUTE] = CreateConVar("sm_votemute_minimum", "4", "Minimum votes required for successful votemute", FCVAR_PLUGIN, true, 1.0, true, 64.0);
	g_iVoteMinimum[MUTE] = GetConVarInt(g_hCvarVoteMinimum[MUTE]);
	HookConVarChange(g_hCvarVoteMinimum[MUTE], OnConVarChange);

	g_hCvarVoteDelay[KICK] = CreateConVar("sm_votekick_delay", "60", "Time in seconds before votekick is allowed after map start", FCVAR_PLUGIN, true, 0.0, true, 1000.0);
	g_iVoteDelay[KICK] = GetConVarInt(g_hCvarVoteDelay[KICK]);
	HookConVarChange(g_hCvarVoteDelay[KICK], OnConVarChange);

	g_hCvarVoteDelay[BAN] = CreateConVar("sm_voteban_delay", "60", "Time in seconds before voteban is allowed after map start", FCVAR_PLUGIN, true, 0.0, true, 1000.0);
	g_iVoteDelay[BAN] = GetConVarInt(g_hCvarVoteDelay[BAN]);
	HookConVarChange(g_hCvarVoteDelay[BAN], OnConVarChange);

	g_hCvarVoteDelay[MAP] = CreateConVar("sm_votemap_delay", "60", "Time in seconds before votemap is allowed after map start", FCVAR_PLUGIN, true, 0.0, true, 1000.0);
	g_iVoteDelay[MAP] = GetConVarInt(g_hCvarVoteDelay[MAP]);
	HookConVarChange(g_hCvarVoteDelay[MAP], OnConVarChange);

	g_hCvarVoteDelay[MUTE] = CreateConVar("sm_votemute_delay", "60", "Time in seconds before votemute is allowed after map start", FCVAR_PLUGIN, true, 0.0, true, 1000.0);
	g_iVoteDelay[MUTE] = GetConVarInt(g_hCvarVoteDelay[MUTE]);
	HookConVarChange(g_hCvarVoteDelay[MUTE], OnConVarChange);

	g_hCvarVoteLimit[KICK] = CreateConVar("sm_votekick_limit", "0", "Number of kick votes allowed per player, per map\n0 = No Limit", FCVAR_PLUGIN, true, 0.0, true, 1000.0);
	g_iVoteLimit[KICK] = GetConVarInt(g_hCvarVoteLimit[KICK]);
	HookConVarChange(g_hCvarVoteLimit[KICK], OnConVarChange);

	g_hCvarVoteLimit[BAN] = CreateConVar("sm_voteban_limit", "0", "Number of ban votes allowed per player, per map\n0 = No Limit", FCVAR_PLUGIN, true, 0.0, true, 1000.0);
	g_iVoteLimit[BAN] = GetConVarInt(g_hCvarVoteLimit[BAN]);
	HookConVarChange(g_hCvarVoteLimit[BAN], OnConVarChange);

	g_hCvarVoteLimit[MAP] = CreateConVar("sm_votemap_limit", "0", "Number of map votes allowed per player, per map\n0 = No Limit", FCVAR_PLUGIN, true, 0.0, true, 1000.0);
	g_iVoteLimit[MAP] = GetConVarInt(g_hCvarVoteLimit[MAP]);
	HookConVarChange(g_hCvarVoteLimit[MAP], OnConVarChange);

	g_hCvarVoteLimit[MUTE] = CreateConVar("sm_votemute_limit", "0", "Number of mute votes allowed per player, per map\n0 = No Limit", FCVAR_PLUGIN, true, 0.0, true, 1000.0);
	g_iVoteLimit[MUTE] = GetConVarInt(g_hCvarVoteLimit[MUTE]);
	HookConVarChange(g_hCvarVoteLimit[MUTE], OnConVarChange);

	g_hCvarVoteTeam[KICK] = CreateConVar("sm_votekick_team_restrict", "0", "Enable restricting kick votes to teams (Affects ratios)\n0 = Disabled\n1 = Enabled", FCVAR_PLUGIN, true, 0.0, true, 1.0);
	g_bVoteTeam[KICK] = GetConVarBool(g_hCvarVoteTeam[KICK]);
	HookConVarChange(g_hCvarVoteTeam[KICK], OnConVarChange);

	g_hCvarVoteTeam[BAN] = CreateConVar("sm_voteban_team_restrict", "0", "Enable restricting ban votes to teams (Affects ratios)\n0 = Disabled\n1 = Enabled", FCVAR_PLUGIN, true, 0.0, true, 1.0);
	g_bVoteTeam[BAN] = GetConVarBool(g_hCvarVoteTeam[BAN]);
	HookConVarChange(g_hCvarVoteTeam[BAN], OnConVarChange);

	g_hCvarVoteTeam[MUTE] = CreateConVar("sm_votemute_team_restrict", "0", "Enable restricting votes to teams (Affects ratios)\n0 = Disabled\n1 = Enabled", FCVAR_PLUGIN, true, 0.0, true, 1.0);
	g_bVoteTeam[MUTE] = GetConVarBool(g_hCvarVoteTeam[MUTE]);
	HookConVarChange(g_hCvarVoteTeam[MUTE], OnConVarChange);

	g_hCvarVoteMapLast = CreateConVar("sm_votemap_lastmaps", "4", "Last number of played maps that will not show in votemap list", FCVAR_PLUGIN, true, 0.0, true, 64.0);
	g_iVoteMapLast = GetConVarInt(g_hCvarVoteMapLast);
	HookConVarChange(g_hCvarVoteMapLast, OnConVarChange);

	g_hCvarMapExtendTime = CreateConVar("sm_votemap_extend", "20", "Number of minutes to add to the timelimit if the players vote to extend\n0 = Disabled", FCVAR_PLUGIN, true, 0.0, true, 120.0);
	g_iMapExtendTime = GetConVarInt(g_hCvarMapExtendTime);
	HookConVarChange(g_hCvarMapExtendTime, OnConVarChange);

	g_hCvarMapMaxExtends = CreateConVar("sm_votemap_max_extends", "1", "Number of extensions to allow per map\n-1 = No limit", FCVAR_PLUGIN, true, -1.0, true, 100.0);
	g_iMapMaxExtends = GetConVarInt(g_hCvarMapMaxExtends);
	HookConVarChange(g_hCvarMapMaxExtends, OnConVarChange);

	g_hCvarMapChangeImmediately = CreateConVar("sm_votemap_immediate", "1", "0 = Setting sm_nextmap\n1 = to Change map immediately", FCVAR_PLUGIN, true, 0.0, true, 1.0);
	g_bMapChangeImmediately = GetConVarBool(g_hCvarMapChangeImmediately);
	HookConVarChange(g_hCvarMapChangeImmediately, OnConVarChange);

	g_hCvarChatTriggers = CreateConVar("sm_playersvotes_chat", "1", "Enable use of chat triggers\n0 = Disabled\n1 = Enabled", FCVAR_PLUGIN, true, 0.0, true, 1.0);
	g_bChatTriggers = GetConVarBool(g_hCvarChatTriggers);
	HookConVarChange(g_hCvarChatTriggers, OnConVarChange);

	g_hCvarVotesInterval = CreateConVar("sm_playersvotes_interval", "0", "Interval in seconds between another vote cast", FCVAR_PLUGIN, true, 0.0, true, 10000.0);
	g_iVotesInterval = GetConVarInt(g_hCvarVotesInterval);
	HookConVarChange(g_hCvarVotesInterval, OnConVarChange);

	g_hCvarVotesTimeout = CreateConVar("sm_playersvotes_menu_timeout", "0", "Number of seconds to display voting menus\n0 = No limit", FCVAR_PLUGIN, true, 0.0, true, 10000.0);
	g_iVotesTimeout = GetConVarInt(g_hCvarVotesTimeout);
	HookConVarChange(g_hCvarVotesTimeout, OnConVarChange);

	g_hCvarVoteBanTime = CreateConVar("sm_voteban_time", "25", "Ban time in minutes\n0 = Permanently");
	g_iVoteBanTime = GetConVarInt(g_hCvarVoteBanTime);
	HookConVarChange(g_hCvarVoteBanTime, OnConVarChange);

	g_hCvarVoteBanReasons = CreateConVar("sm_voteban_reasons", "", "Semi-colon delimited list of ban reasons\n(ex: \"Hacking; Spamming; Griefing\")");
	GetConVarString(g_hCvarVoteBanReasons, g_strVoteBanReasons, sizeof(g_strVoteBanReasons));
	HookConVarChange(g_hCvarVoteBanReasons, OnConVarChange);

	g_hCvarVoteImmunity = CreateConVar("sm_playersvotes_immunity", "0.0", "Admins with equal or higher immunity level will not be affected by votekick, ban, or mute\n0 = Immunize all admins\n-1 = Ignore", FCVAR_PLUGIN, true, -1.0, true, 99.0);
	g_iVoteImmunity = GetConVarInt(g_hCvarVoteImmunity);
	HookConVarChange(g_hCvarVoteImmunity, OnConVarChange);

	g_hCvarAdminGroups = CreateConVar("sm_playersvotes_immunegroups", "", "Admins that are members of these groups will not be affected by votekick, ban, or mute (ex: \"Full Admins; Clan Members; etc\")", FCVAR_PLUGIN);
	GetConVarString(g_hCvarAdminGroups, g_strAdminGroups, sizeof(g_strAdminGroups));
	HookConVarChange(g_hCvarAdminGroups, OnConVarChange);

	AutoExecConfig(true, "plugin.playersvotes");

	RegAdminCmd("sm_votemenu", ChooseVoteMenuCmd, 0, "Open voting menu");
	AddCommandListener(SayCmd, "say");
	AddCommandListener(SayCmd, "say_team");

	if(g_hArrayMapList == INVALID_HANDLE)
		g_hArrayMapList = CreateArray(33);

	if(g_hArrayLastMaps == INVALID_HANDLE)
		g_hArrayLastMaps = CreateArray(33);

	if(g_hArrayVoteBanClientUserIds == INVALID_HANDLE)
		g_hArrayVoteBanClientUserIds = CreateArray();

	if(g_hArrayVoteBanClientCurrentUserId == INVALID_HANDLE)
		g_hArrayVoteBanClientCurrentUserId = CreateArray();

	if(g_hArrayVoteBanClientTeam == INVALID_HANDLE)
		g_hArrayVoteBanClientTeam = CreateArray();

	if(g_hArrayVoteBanClientIdentity == INVALID_HANDLE)
		g_hArrayVoteBanClientIdentity = CreateArray(33);

	if(g_hArrayVoteBanClientNames == INVALID_HANDLE)
		g_hArrayVoteBanClientNames = CreateArray(33);

	if(g_hArrayVoteBanReasons == INVALID_HANDLE)
		g_hArrayVoteBanReasons = CreateArray(33);

	if(g_hArrayVoteMuteClientIdentity == INVALID_HANDLE)
		g_hArrayVoteMuteClientIdentity = CreateArray(33);

	if(g_hArrayAdminGroups == INVALID_HANDLE)
		g_hArrayAdminGroups = CreateArray();

	for(new i = 0; i <= MAXPLAYERS; ++i)
	{
		if(g_hArrayVotedForMap[i] == INVALID_HANDLE)
			g_hArrayVotedForMap[i] = CreateArray();

		if(g_hArrayVotedForBan[i] == INVALID_HANDLE)
			g_hArrayVotedForBan[i] = CreateArray();

		if(g_hArrayVotedForReason[i] == INVALID_HANDLE)
			g_hArrayVotedForReason[i] = CreateArray();
	}
}

public OnConVarChange(Handle:hConvar, const String:strOldValue[], const String:strNewValue[])
{
	if(hConvar == g_hCvarVoteEnabled[KICK])
		g_bVoteEnabled[KICK] = GetConVarBool(g_hCvarVoteEnabled[KICK]);

	if(hConvar == g_hCvarVoteEnabled[BAN])
		g_bVoteEnabled[BAN] = GetConVarBool(g_hCvarVoteEnabled[BAN]);

	if(hConvar == g_hCvarVoteEnabled[MAP])
		g_bVoteEnabled[MAP] = GetConVarBool(g_hCvarVoteEnabled[MAP]);

	if(hConvar == g_hCvarVoteEnabled[MUTE])
		g_bVoteEnabled[MUTE] = GetConVarBool(g_hCvarVoteEnabled[MUTE]);

	if(hConvar == g_hCvarVoteRatio[KICK])
		g_fVoteRatio[KICK] = GetConVarFloat(g_hCvarVoteRatio[KICK]);

	if(hConvar == g_hCvarVoteRatio[BAN])
		g_fVoteRatio[BAN] = GetConVarFloat(g_hCvarVoteRatio[BAN]);

	if(hConvar == g_hCvarVoteRatio[MAP])
		g_fVoteRatio[MAP] = GetConVarFloat(g_hCvarVoteRatio[MAP]);

	if(hConvar == g_hCvarVoteRatio[MUTE])
		g_fVoteRatio[MUTE] = GetConVarFloat(g_hCvarVoteRatio[MUTE]);

	if(hConvar == g_hCvarVoteMinimum[KICK])
		g_iVoteMinimum[KICK] = GetConVarInt(g_hCvarVoteMinimum[KICK]);

	if(hConvar == g_hCvarVoteMinimum[BAN])
		g_iVoteMinimum[BAN] = GetConVarInt(g_hCvarVoteMinimum[BAN]);

	if(hConvar == g_hCvarVoteMinimum[MAP])
		g_iVoteMinimum[MAP] = GetConVarInt(g_hCvarVoteMinimum[MAP]);

	if(hConvar == g_hCvarVoteMinimum[MUTE])
		g_iVoteMinimum[MUTE] = GetConVarInt(g_hCvarVoteMinimum[MUTE]);

	if(hConvar == g_hCvarVoteDelay[KICK])
		g_iVoteDelay[KICK] = GetConVarInt(g_hCvarVoteDelay[KICK]);

	if(hConvar == g_hCvarVoteDelay[BAN])
		g_iVoteDelay[BAN] = GetConVarInt(g_hCvarVoteDelay[BAN]);

	if(hConvar == g_hCvarVoteDelay[MAP])
		g_iVoteDelay[MAP] = GetConVarInt(g_hCvarVoteDelay[MAP]);

	if(hConvar == g_hCvarVoteDelay[MUTE])
		g_iVoteDelay[MUTE] = GetConVarInt(g_hCvarVoteDelay[MUTE]);

	if(hConvar == g_hCvarVoteLimit[KICK])
		g_iVoteLimit[KICK] = GetConVarInt(g_hCvarVoteLimit[KICK]);

	if(hConvar == g_hCvarVoteLimit[BAN])
		g_iVoteLimit[BAN] = GetConVarInt(g_hCvarVoteLimit[BAN]);

	if(hConvar == g_hCvarVoteLimit[MAP])
		g_iVoteLimit[MAP] = GetConVarInt(g_hCvarVoteLimit[MAP]);

	if(hConvar == g_hCvarVoteLimit[MUTE])
		g_iVoteLimit[MUTE] = GetConVarInt(g_hCvarVoteLimit[MUTE]);

	if(hConvar == g_hCvarVoteTeam[KICK])
		g_bVoteTeam[KICK] = GetConVarBool(g_hCvarVoteTeam[KICK]);

	if(hConvar == g_hCvarVoteTeam[BAN])
		g_bVoteTeam[BAN] = GetConVarBool(g_hCvarVoteTeam[BAN]);

	if(hConvar == g_hCvarVoteTeam[MUTE])
		g_bVoteTeam[MUTE] = GetConVarBool(g_hCvarVoteTeam[MUTE]);

	if(hConvar == g_hCvarVoteMapLast)
		g_iVoteMapLast = GetConVarInt(g_hCvarVoteMapLast);

	if(hConvar == g_hCvarMapExtendTime)
		g_iMapExtendTime = GetConVarInt(g_hCvarMapExtendTime);

	if(hConvar == g_hCvarMapMaxExtends)
		g_iMapMaxExtends = GetConVarInt(g_hCvarMapMaxExtends);

	if(hConvar == g_hCvarMapChangeImmediately)
		g_bMapChangeImmediately = GetConVarBool(g_hCvarMapChangeImmediately);

	if(hConvar == g_hCvarChatTriggers)
		g_bChatTriggers = GetConVarBool(g_hCvarChatTriggers);

	if(hConvar == g_hCvarVotesInterval)
		g_iVotesInterval = GetConVarInt(g_hCvarVotesInterval);

	if(hConvar == g_hCvarVotesTimeout)
		g_iVotesTimeout = GetConVarInt(g_hCvarVotesTimeout);

	if(hConvar == g_hCvarVoteBanTime)
		g_iVoteBanTime = GetConVarInt(g_hCvarVoteBanTime);

	if(hConvar == g_hCvarVoteBanReasons)
		GetConVarString(g_hCvarVoteBanReasons, g_strVoteBanReasons, sizeof(g_strVoteBanReasons));

	if(hConvar == g_hCvarVoteImmunity)
		g_iVoteImmunity = GetConVarInt(g_hCvarVoteImmunity);

	if(hConvar == g_hCvarAdminGroups)
		GetConVarString(g_hCvarAdminGroups, g_strAdminGroups, sizeof(g_strAdminGroups));
}

// ====[ COMMANDS ]============================================================
public Action:ChooseVoteMenuCmd(iClient, iArgs)
{
	if(!IsValidClient(iClient))
		return Plugin_Continue;

	ChooseVoteMenu(iClient);
	return Plugin_Handled;
}

public Action:SayCmd(iClient, const String:strCommand[], iArgc)
{
	if(g_bVoteAction || !g_bChatTriggers)
		return Plugin_Continue;

	decl String:strText[192];
	GetCmdArgString(strText, sizeof(strText));
	StripQuotes(strText);

	if(StrEqual(strText, "votekick", false))
		ProcessClientVoteCommand(KICK, iClient, "Votekick");
	else if(StrEqual(strText, "voteban", false))
		ProcessClientVoteCommand(BAN, iClient, "Voteban");
	else if(StrEqual(strText, "votemap", false))
		ProcessClientVoteCommand(MAP, iClient, "Votemap");
	else if(StrEqual(strText, "votemute", false))
		ProcessClientVoteCommand(MUTE, iClient, "Votemute");
	return Plugin_Continue;
}

// ====[ EVENTS ]==============================================================
public OnConfigsExecuted()
{
	RefreshMapsList();

	decl String:strMap[64];
	GetCurrentMap(strMap, sizeof(strMap));

	g_iMapCurrent = -1;

	decl String:strMapListEntry[65];
	for(new i = 0; i < GetArraySize(g_hArrayMapList); i++)
	{
		GetArrayString(g_hArrayMapList, i, strMapListEntry, sizeof(strMapListEntry));
		if(StrEqual(strMapListEntry, strMap, false))
			g_iMapCurrent = i;
	}

	ClearArray(g_hArrayAdminGroups);

	decl String:strAdminGroupList[256];
	strcopy(strAdminGroupList, sizeof(strAdminGroupList), g_strAdminGroups);
	StrCat(strAdminGroupList, sizeof(strAdminGroupList), ";");

	decl String:strAdminGroupName[33];
	new iGroupListOffset;
	decl GroupId:idImmuneGroup;
	for(new i = SplitString(strAdminGroupList, ";", strAdminGroupName, sizeof(strAdminGroupName)); i != -1; i = SplitString(strAdminGroupList[iGroupListOffset], ";", strAdminGroupName, sizeof(strAdminGroupName)))
	{
		iGroupListOffset += i;
		TrimString(strAdminGroupName);
		idImmuneGroup = FindAdmGroup(strAdminGroupName);
		if(idImmuneGroup != INVALID_GROUP_ID)
			PushArrayCell(g_hArrayAdminGroups, idImmuneGroup);
	}

	decl String:strBanReasonList[256];
	strcopy(strBanReasonList, sizeof(strBanReasonList), g_strVoteBanReasons);
	StrCat(strBanReasonList, sizeof(strBanReasonList), ";");

	new iBanReasonOffset;
	decl String:strBanReason[33];
	ClearArray(g_hArrayVoteBanReasons);
	for(new i = SplitString(strBanReasonList, ";", strBanReason, sizeof(strBanReason)); i != -1; i = SplitString(strBanReasonList[iBanReasonOffset], ";", strBanReason, sizeof(strBanReason)))
	{
		iBanReasonOffset += i;
		TrimString(strBanReason);
		if(!StrEqual(strBanReason, ""))
			PushArrayString(g_hArrayVoteBanReasons, strBanReason);
	}
}

public OnMapStart()
{
	g_iStartTime = GetTime();

	g_hCvarSourceBans = FindConVar("sb_version");

	decl String:strMap[64];
	GetCurrentMap(strMap, sizeof(strMap));

	PushArrayString(g_hArrayLastMaps, strMap);
	if(GetArraySize(g_hArrayLastMaps) > 64)
		RemoveFromArray(g_hArrayLastMaps, 0);

	ResetVotes(KICK);
	ResetVotes(BAN);
	ResetVotes(MAP);
	ResetVotes(MUTE);

	for(new i = 0; i <= MAXPLAYERS; ++i)
	{
		g_iVoteCount[KICK][i] = 0;
		g_iVoteCount[BAN][i] = 0;
		g_iVoteCount[MAP][i] = 0;
		g_iVoteCount[MUTE][i] = 0;
		g_iVoteBanClients[i] = -1;
		g_bMuted[i] = false;
	}

	ClearArray(g_hArrayVoteMuteClientIdentity);
}

public OnClientDisconnect(iClient)
{
	g_bImmuneByGroup[iClient] = false;
	g_iLastVote[iClient] = 0;
	g_iVoteCount[KICK][iClient] = 0;
	g_iVoteCount[BAN][iClient] = 0;
	g_iVoteCount[MAP][iClient] = 0;
	g_iVoteCount[MUTE][iClient] = 0;
	g_iVoteBanClients[iClient] = -1;

	for(new i = 0; i <= MAXPLAYERS; i++)
	{
		g_bVotedForKick[iClient][i] = false;
		g_bVotedForKick[i][iClient] = false;
		g_bVotedForMute[iClient][i] = false;
		g_bVotedForMute[i][iClient] = false;
	}

	new iBanVotes = GetArraySize(g_hArrayVotedForBan[iClient]);
	for(new i = 0; i < iBanVotes; ++i)
	{
		new iTarget = GetArrayCell(g_hArrayVotedForBan[iClient], i);
		if(VotesFor(iTarget, BAN) == 1)
		{
			RemoveBanVotesForTarget(iTarget);
			--i;
			--iBanVotes;
		}
	}

	ClearArray(g_hArrayVotedForBan[iClient]);
	ClearArray(g_hArrayVotedForReason[iClient]);

	ResetClientMapVotes(iClient);

	if(g_bMuted[iClient] && !(GetClientListeningFlags(iClient) & VOICE_MUTED))
	{
		decl String:strClientAuth[33];
		GetIdentity(iClient, strClientAuth, sizeof(strClientAuth));

		new iRemoveMuteIndex = MatchIdentity(g_hArrayVoteMuteClientIdentity, strClientAuth);
		if(iRemoveMuteIndex != -1)
			RemoveFromArray(g_hArrayVoteMuteClientIdentity, iRemoveMuteIndex);
	}

	g_bMuted[iClient] = false;
}

public OnClientConnected(iClient)
{
	decl String:strIp[33];
	GetClientIP(iClient, strIp, sizeof(strIp));

	g_iVoteBanClients[iClient] = MatchIdentity(g_hArrayVoteBanClientIdentity, strIp);

	new iBanTarget = g_iVoteBanClients[iClient];
	if(iBanTarget != -1)
	{
		decl String:strClientName[33];
		GetClientName(iClient, strClientName, sizeof(strClientName));

		decl String:strStoredName[33];
		GetArrayString(g_hArrayVoteBanClientNames, iBanTarget, strStoredName, sizeof(strStoredName));

		if(strcmp(strClientName, strStoredName) != 0)
		{
			PrintToChatAll("[SM] Bans: %s changed name to %s!!", strStoredName, strClientName);
			SetArrayString(g_hArrayVoteBanClientNames, iBanTarget, strClientName);
		}
		SetArrayCell(g_hArrayVoteBanClientCurrentUserId, iBanTarget, GetClientUserId(iClient));
	}
	if(MatchIdentity(g_hArrayVoteMuteClientIdentity, strIp) != -1)
		g_bMuted[iClient] = true;
}

public OnClientAuthorized(iClient, const String:auth[])
{
	new iBanTarget = g_iVoteBanClients[iClient];
	if(iBanTarget != -1)
	{
		if(AuthIsValid(auth))
			SetArrayString(g_hArrayVoteBanClientIdentity, iBanTarget, auth);
	}
	else
	{
		g_iVoteBanClients[iClient] = MatchIdentity(g_hArrayVoteBanClientIdentity, auth);
		iBanTarget = g_iVoteBanClients[iClient];
	}

	if(iBanTarget != -1)
	{
		decl String:strClientName[33];
		GetClientName(iClient, strClientName, sizeof(strClientName));

		decl String:strStoredName[33];
		GetArrayString(g_hArrayVoteBanClientNames, iBanTarget, strStoredName, sizeof(strStoredName));

		if(strcmp(strClientName, strStoredName) != 0)
		{
			PrintToChatAll("[SM] Bans: %s changed name to %s!!", strStoredName, strClientName);
			SetArrayString(g_hArrayVoteBanClientNames, iBanTarget, strClientName);
		}
		SetArrayCell(g_hArrayVoteBanClientCurrentUserId, iBanTarget, GetClientUserId(iClient));
	}
	if(MatchIdentity(g_hArrayVoteMuteClientIdentity, auth) != -1)
		g_bMuted[iClient] = true;
}

public OnClientPostAdminCheck(iClient)
{
	new AdminId:idTargetAdmin = GetUserAdmin(iClient);
	if(idTargetAdmin != INVALID_ADMIN_ID)
	{
		new iGroupCount = GetAdminGroupCount(idTargetAdmin);
		new iImmuneGroupCount = GetArraySize(g_hArrayAdminGroups);
		new GroupId:idTargetGroup;
		decl String:strThrowaway[1];
		for(new i = 0; i < iGroupCount; ++i)
		{
			idTargetGroup = GetAdminGroup(idTargetAdmin, i, strThrowaway, sizeof(strThrowaway));
			if(idTargetGroup != INVALID_GROUP_ID)
			{
				for(new j = 0; j < iImmuneGroupCount; ++j)
				{
					if(idTargetGroup == GetArrayCell(g_hArrayAdminGroups, j))
					{
						g_bImmuneByGroup[iClient] = true;
						break;
					}
				}
			}
			if(g_bImmuneByGroup[iClient])
				break;
		}
	}
	if(g_bMuted[iClient])
		PerformMute(iClient);
}

// ====[ TIMERS ]==============================================================
public Action:DelayedVoteAction(Handle:hTimer, Handle:hDataPack)
{
	decl String:strMap[65];
	new iTarget;

	ResetPack(hDataPack);
	new iType = ReadPackCell(hDataPack);

	switch(iType)
	{
		case BAN:
		{
			decl String:strReason[100];
			iTarget = ReadPackCell(hDataPack);
			ReadPackString(hDataPack, strReason, sizeof(strReason));
			ServerCommand("kickid %d %s", iTarget, strReason);
		}
		case KICK:
		{
			iTarget = ReadPackCell(hDataPack);
			ServerCommand("kickid %d %t", iTarget, "kicked by users");
		}
		case MAP:
		{
			ReadPackString(hDataPack, strMap, sizeof(strMap));
			ServerCommand("changelevel \"%s\"", strMap);
		}
	}
	g_bVoteAction = false;
	return Plugin_Stop;
}

// ====[ MENUS ]===============================================================
public ChooseVoteMenu(iClient)
{
	new bool:bCanceling;
	if(CheckCommandAccess(iClient, "sm_votecanceling", ADMFLAG_GENERIC))
		bCanceling = true;

	if(!bCanceling && !g_bVoteEnabled[KICK] && !g_bVoteEnabled[BAN] && !g_bVoteEnabled[MAP] && !g_bVoteEnabled[MUTE])
	{
		PrintToChat(iClient, "[SM] %t.", "all disabled votes");
		return;
	}

	new Handle:hMenu = CreateMenu(ChooseVoteMenuHandler);
	decl String:strInfo[56];
	Format(strInfo, sizeof(strInfo), "%t:", "Voting Menu");
	SetMenuTitle(hMenu, strInfo);

	if(!g_bVoteAction)
	{
		if(g_bVoteEnabled[KICK] && CheckCommandAccess(iClient, "sm_votekick_flag", 0))
		{
			Format(strInfo, sizeof(strInfo), "%t", "Kick");
			AddMenuItem(hMenu, "Kick", strInfo);
		}
		if(g_bVoteEnabled[BAN] && CheckCommandAccess(iClient, "sm_voteban_flag", 0))
		{
			Format(strInfo, sizeof(strInfo), "%t", "Ban");
			AddMenuItem(hMenu, "Ban", strInfo);
		}
		if(g_bVoteEnabled[MAP] && CheckCommandAccess(iClient, "sm_votemap_flag", 0))
		{
			Format(strInfo, sizeof(strInfo), "%t", "Map");
			AddMenuItem(hMenu, "Map", strInfo);
		}
		if(g_bVoteEnabled[MUTE] && CheckCommandAccess(iClient, "sm_votemute_flag", 0))
		{
			Format(strInfo, sizeof(strInfo), "%t", "Mute");
			AddMenuItem(hMenu, "Mute", strInfo);
		}
	}
	if(bCanceling)
	{
		Format(strInfo, sizeof(strInfo), "%t", "Settings");
		AddMenuItem(hMenu, "Settings", strInfo);
	}
	DisplayMenu(hMenu, iClient, MENU_TIME_FOREVER);
}

public ChooseVoteMenuHandler(Handle:hMenu, MenuAction:iAction, iParam1, iParam2)
{
	if(iAction == MenuAction_End)
		CloseHandle(hMenu);

	switch(iAction)
	{
		case MenuAction_Cancel:
		{
			if(iParam2 == MenuCancel_ExitBack)
				ChooseVoteMenu(iParam1);
		}
		case MenuAction_Select:
		{
			decl String:strInfo[16];
			GetMenuItem(hMenu, iParam2, strInfo, sizeof(strInfo));
			if(StrEqual(strInfo, "Kick"))
				ProcessClientVoteCommand(KICK, iParam1, "Votekick");
			if(StrEqual(strInfo, "Ban"))
				ProcessClientVoteCommand(BAN, iParam1, "Voteban");
			if(StrEqual(strInfo, "Map"))
				ProcessClientVoteCommand(MAP, iParam1, "Votemap");
			if(StrEqual(strInfo, "Mute"))
				ProcessClientVoteCommand(MUTE, iParam1, "Votemute");
			if(StrEqual(strInfo, "Settings"))
				SettingMenu(iParam1);
		}
	}
}

public SettingMenu(iClient)
{
	new Handle:hMenu = CreateMenu(SettingMenuHandler);

	decl String:strInfo[100];
	Format(strInfo, sizeof(strInfo), "%t:", "Settings");
	SetMenuTitle(hMenu, strInfo);
	SetMenuExitBackButton(hMenu, true);

	if(CheckCommandAccess(iClient, "sm_votecanceling", ADMFLAG_GENERIC))
	{
		Format(strInfo, sizeof(strInfo), "%t", "cancel map votes");
		AddMenuItem(hMenu, "CancelMap", strInfo);

		Format(strInfo, sizeof(strInfo), "%t", "cancel ban votes");
		AddMenuItem(hMenu, "CancelBan", strInfo);

		Format(strInfo, sizeof(strInfo), "%t", "cancel mute votes");
		AddMenuItem(hMenu, "CancelMute", strInfo);

		Format(strInfo, sizeof(strInfo), "%t", "cancel kick votes");
		AddMenuItem(hMenu, "CancelKick", strInfo);
	}
	DisplayMenu(hMenu, iClient, MENU_TIME_FOREVER);
}

public SettingMenuHandler(Handle:hMenu, MenuAction:iAction, iParam1, iParam2)
{
	if(iAction == MenuAction_End)
		CloseHandle(hMenu);
	else if(iAction == MenuAction_Cancel)
	{
		if(iParam2 == MenuCancel_ExitBack)
			ChooseVoteMenu(iParam1);
	}
	else if(iAction == MenuAction_Select)
	{
		decl String:strInfo[16];
		GetMenuItem(hMenu, iParam2, strInfo, sizeof(strInfo));
		if(StrEqual(strInfo, "CancelBan"))
		{
			ResetVotes(BAN);
			ShowActivity2(iParam1, "[SM] ", "%t.", "canceled votes", "Ban");
		}
		else if(StrEqual(strInfo, "CancelMap"))
		{
			ResetVotes(MAP);
			ShowActivity2(iParam1, "[SM] ", "%t.", "canceled votes", "Map");
		}
		else if(StrEqual(strInfo, "CancelMute"))
		{
			ResetVotes(MUTE);
			ShowActivity2(iParam1, "[SM] ", "%t.", "canceled votes", "Mute");
		}
		else if(StrEqual(strInfo, "CancelKick"))
		{
			ResetVotes(KICK);
			ShowActivity2(iParam1, "[SM] ", "%t.", "canceled votes", "Kick");
		}
	}
}

public BanReasonMenu(iClient, iTarget)
{
	new iNumReasons = GetArraySize(g_hArrayVoteBanReasons);
	if(iNumReasons <= 0)
	{
		ProcessBanVote(iClient, iTarget, -1);
		return;
	}

	new Handle:hMenu = CreateMenu(BanReasonMenuHandler);

	decl String:strTitle[32];
	Format(strTitle, sizeof(strTitle), "%t:", "ban reasons");
	SetMenuTitle(hMenu, strTitle);

	decl String:strTarget[8];
	Format(strTarget, sizeof(strTarget), "%d", iTarget);

	decl String:strReason[33];
	for(new i = 0; i < iNumReasons; ++i)
	{
		GetArrayString(g_hArrayVoteBanReasons, i, strReason, sizeof(strReason));
		AddMenuItem(hMenu, strTarget, strReason);
	}

	SetMenuExitButton(hMenu, true);
	DisplayMenu(hMenu, iClient, g_iVotesTimeout);
}

public BanReasonMenuHandler(Handle:hMenu, MenuAction:iAction, iParam1, iParam2)
{
	if(iAction == MenuAction_End)
		CloseHandle(hMenu);
	else if(iAction == MenuAction_Select)
	{
		decl String:strUserId[8];
		GetMenuItem(hMenu, iParam2, strUserId, sizeof(strUserId), _, "", 0);
		new iTarget = StringToInt(strUserId[0]);
		ProcessBanVote(iParam1, iTarget, iParam2);
	}
}

// ====[ FUNCTIONS ]===========================================================
public RefreshMapsList()
{
	ReadMapList(g_hArrayMapList, g_iMapListSerial, "playersvotes", MAPLIST_FLAG_CLEARARRAY | MAPLIST_FLAG_MAPSFOLDER);
	ResetVotes(MAP);
}

public MatchIdentity(const Handle:hIdentityArray, const String:strIdentity[])
{
	decl String:strStoredIdentity[33];
	for(new i = 0; i < GetArraySize(hIdentityArray); ++i)
	{
		GetArrayString(hIdentityArray, i, strStoredIdentity, sizeof(strStoredIdentity));
		if(strcmp(strIdentity, strStoredIdentity, false) == 0)
			return i;
	}
	return -1;
}

public PerformMute(iClient)
{
	if(!IsValidClient(iClient))
		return;

	#if defined _basecomm_included
		BaseComm_SetClientMute(iClient, true);
	#else
		SetClientListeningFlags(iClient, VOICE_MUTED);
	#endif
}

public ResetClientMapVotes(iClient)
{
	for(new iTarget = 0; iTarget < GetArraySize(g_hArrayVotedForMap[iClient]); ++iTarget)
		SetArrayCell(g_hArrayVotedForMap[iClient], iTarget, 0);
}

public ResetVotes(iType)
{
	switch(iType)
	{
		case KICK:
		{
			for(new iClient = 0; iClient <= MAXPLAYERS; ++iClient)
			{
				for(new iTarget = 0; iTarget <= MAXPLAYERS; ++iTarget)
					g_bVotedForKick[iClient][iTarget] = false;
			}
		}
		case BAN:
		{
			ClearArray(g_hArrayVoteBanClientUserIds);
			ClearArray(g_hArrayVoteBanClientCurrentUserId);
			ClearArray(g_hArrayVoteBanClientTeam);
			ClearArray(g_hArrayVoteBanClientIdentity);
			ClearArray(g_hArrayVoteBanClientNames);
			for(new iClient = 0; iClient <= MAXPLAYERS; ++iClient)
			{
				ClearArray(g_hArrayVotedForBan[iClient]);
				ClearArray(g_hArrayVotedForReason[iClient]);
				g_iVoteBanClients[iClient] = -1;
			}
		}
		case MAP:
		{
			new iMapCount = GetArraySize(g_hArrayMapList);
			for(new iClient = 0; iClient <= MAXPLAYERS; ++iClient)
			{
				ResizeArray(g_hArrayVotedForMap[iClient], iMapCount);
				ResetClientMapVotes(iClient);
			}
		}
		case MUTE:
		{
			for(new iClient = 0; iClient <= MAXPLAYERS; ++iClient)
			{
				for(new iTarget = 0; iTarget <= MAXPLAYERS; ++iTarget)
					g_bVotedForMute[iClient][iTarget] = false;
			}
		}
	}
}

public RemoveBanVotesForTarget(iTarget)
{
	RemoveFromArray(g_hArrayVoteBanClientUserIds, iTarget);
	RemoveFromArray(g_hArrayVoteBanClientCurrentUserId, iTarget);
	RemoveFromArray(g_hArrayVoteBanClientTeam, iTarget);
	RemoveFromArray(g_hArrayVoteBanClientIdentity, iTarget);
	RemoveFromArray(g_hArrayVoteBanClientNames, iTarget);
	for(new i = 1; i <= MAXPLAYERS; ++i)
	{
		new iVoteToRemove = -1;
		for(new j = 0; j < GetArraySize(g_hArrayVotedForBan[i]); ++j)
		{
			new iVote = GetArrayCell(g_hArrayVotedForBan[i], j);
			if(iVote == iTarget)
				iVoteToRemove = j;
			else if(iVote > iTarget)
				SetArrayCell(g_hArrayVotedForBan[i], j, iVote - 1);
		}
		if(iVoteToRemove != -1)
		{
			RemoveFromArray(g_hArrayVotedForBan[i], iVoteToRemove);
			RemoveFromArray(g_hArrayVotedForReason[i], iVoteToRemove);
		}
		if(g_iVoteBanClients[i] == iTarget)
			g_iVoteBanClients[i] = -1;
		else if(g_iVoteBanClients[i] > iTarget)
			--g_iVoteBanClients[i];
	}
}

public ProcessClientVoteCommand(iType, iClient, const String:strVoteName[])
{
	if(!g_bVoteEnabled[iType])
		return;

	if(!CheckCommandAccess(iClient, "sm_votemenu", 0))
	{
		ReplyToCommand(iClient, "[SM] %t.", "No Access");
		return;
	}
	if(iType == KICK && !CheckCommandAccess(iClient, "sm_votekick_flag", 0))
	{
		ReplyToCommand(iClient, "[SM] %t.", "No Access");
		return;
	}
	if(iType == BAN && !CheckCommandAccess(iClient, "sm_voteban_flag", 0))
	{
		ReplyToCommand(iClient, "[SM] %t.", "No Access");
		return;
	}
	if(iType == MAP && !CheckCommandAccess(iClient, "sm_votemap_flag", 0))
	{
		ReplyToCommand(iClient, "[SM] %t.", "No Access");
		return;
	}
	if(iType == MUTE && !CheckCommandAccess(iClient, "sm_votemute_flag", 0))
	{
		ReplyToCommand(iClient, "[SM] %t.", "No Access");
		return;
	}

	new iFromStart = GetTime() - g_iStartTime;
	new iFromLast = GetTime() - g_iLastVote[iClient];
	if(g_iVoteLimit[iType] != 0 && g_iVoteLimit[iType] <= g_iVoteCount[iType][iClient])
	{
		PrintToChat(iClient, "[SM] %t.", "votes spent", g_iVoteLimit[iType], strVoteName);
		return;
	}
	if(iFromLast < g_iVotesInterval)
	{
		PrintToChat(iClient, "[SM] %t.", "voting not allowed again", g_iVotesInterval - iFromLast);
		return;
	}
	if(iFromStart < g_iVoteDelay[iType])
	{
		PrintToChat(iClient, "[SM] %t.", "voting not allowed", g_iVoteDelay[iType] - iFromStart);
		return;
	}
	g_iLastVote[iClient] = GetTime();
	DisplayVoteMenu(iClient, iType, strVoteName);
}

public DisplayVoteMenu(iClient, iType, const String:strVoteName[])
{
	new Handle:hMenu = CreateMenu(VoteMenuHandler);
	decl String:strTitle[32];
	if(g_iVoteLimit[iType] > 0)
		Format(strTitle, sizeof(strTitle), "%t: %t", strVoteName, "votes remaining", g_iVoteLimit[iType] - g_iVoteCount[iType][iClient]);
	else
		Format(strTitle, sizeof(strTitle), "%t:", strVoteName);
	SetMenuTitle(hMenu, strTitle);
	SetMenuExitBackButton(hMenu, true);

	decl String:strPrefix[1];
	switch(iType)
	{
		case KICK:
			strPrefix[0] = 'k';
		case BAN:
			strPrefix[0] = 'b';
		case MAP:
			strPrefix[0] = 'm';
		case MUTE:
			strPrefix[0] = 'u';
		default:
		{
			CloseHandle(hMenu);
			return;
		}
	}

	if(iType == MAP)
	{
		decl String:strMap[65];
		decl String:strPos[8];

		new iRequired;
		new iVotes;

		new bool:bExtendAdded;
		for(new i = 0; i < GetArraySize(g_hArrayMapList); i++)
		{
			GetArrayString(g_hArrayMapList, i, strMap, sizeof(strMap));
			if(IsMapValid(strMap))
			{
				if(g_iMapCurrent == i && g_iMapMaxExtends != 0 && g_iMapExtendTime > 0)
				{
					iVotes = VotesFor(i, iType);
					RequiredVotes(iClient, iType, iRequired);

					Format(strPos, sizeof(strPos), "%s%d", strPrefix, i);
					Format(strMap, sizeof(strMap), "%t [%d/%d]", "extend map by", g_iMapExtendTime, iVotes, iRequired);

					if(g_iMapCurrent == 0)
						AddMenuItem(hMenu, strPos, strMap);
					else
						InsertMenuItem(hMenu, 0, strPos, strMap);

					bExtendAdded = true;

				}
				else if(!IsLastPlayed(strMap))
				{
					iVotes = VotesFor(i, iType);
					RequiredVotes(iClient, iType, iRequired);

					Format(strPos, sizeof(strPos), "%s%d", strPrefix, i);
					Format(strMap, sizeof(strMap), "%s [%d/%d]", strMap, iVotes, iRequired);

					if(iVotes > 0)
					{
						if(bExtendAdded)
						{
							InsertMenuItem(hMenu, 1, strPos, strMap);
						}
						else
						{
							if(i == 0)
								AddMenuItem(hMenu, strPos, strMap);
							else
								InsertMenuItem(hMenu, 0, strPos, strMap);
						}
					}
					else
						AddMenuItem(hMenu, strPos, strMap);
				}
			}
		}
	}
	else if(iType == KICK || iType == MUTE)
	{
		decl String:strName[72];
		decl String:strClient[8];

		new iFlags = ITEMDRAW_DEFAULT;
		new iRequired;
		new iVotes;

		for(new i = 1; i <= MaxClients; i++) if(IsValidClient(i))
		{
			if(IsFakeClient(i))
				continue;

			if(g_bVoteTeam[iType] && GetClientTeam(iClient) != GetClientTeam(i))
				continue;

			if(i == iClient || IsImmune(i) || (iType == MUTE && g_bMuted[iClient]))
				continue;
			else
				iFlags = ITEMDRAW_DEFAULT;

			iVotes = VotesFor(i, iType);
			RequiredVotes(iClient, iType, iRequired);

			Format(strClient, sizeof(strClient), "%s%d", strPrefix, i);
			Format(strName, sizeof(strName), "%N [%d/%d]", i, iVotes, iRequired);

			if(iVotes > 0)
			{
				if(i == 1)
					AddMenuItem(hMenu, strClient, strName, iFlags);
				else
					InsertMenuItem(hMenu, 0, strClient, strName, iFlags);
			}
			else
				AddMenuItem(hMenu, strClient, strName, iFlags);
		}
	}
	else if(iType == BAN)
	{
		decl String:strName[72];
		decl String:strClient[8];

		new iFlags = ITEMDRAW_DEFAULT;
		new iRequired, iVotes;

		RequiredVotes(iClient, iType, iRequired);
		for(new i = 0; i < GetArraySize(g_hArrayVoteBanClientNames); ++i)
		{
			new iTarget = GetClientOfUserId(GetArrayCell(g_hArrayVoteBanClientCurrentUserId, i));
			new bool:bShowTarget;
			if(g_bVoteTeam[BAN])
			{
				new iTeam = GetClientTeam(iClient);
				if(iTarget != 0)
				{
					if(iTeam == GetClientTeam(iTarget))
						bShowTarget = true;
				}

				if(GetArrayCell(g_hArrayVoteBanClientTeam, i) == iTeam)
					bShowTarget = true;
			}
			else
				bShowTarget = true;

			if(bShowTarget)
			{
				decl String:strBanName[33];

				iVotes = VotesFor(i, iType);

				GetArrayString(g_hArrayVoteBanClientNames, i, strBanName, sizeof(strBanName));

				Format(strClient, sizeof(strClient), "%s%d", strPrefix, GetArrayCell(g_hArrayVoteBanClientUserIds, i));
				Format(strName, sizeof(strName), "%s [%d/%d]", strBanName, iVotes, iRequired);

				AddMenuItem(hMenu, strClient, strName, iFlags);
			}
		}

		iVotes = 0;
		for(new i = 1; i <= MaxClients; i++) if(IsValidClient(i))
		{
			if(IsFakeClient(i))
				continue;

			if(g_iVoteBanClients[i] != -1)
				continue;

			if(g_bVoteTeam[iType] && GetClientTeam(iClient) != GetClientTeam(i))
				continue;

			if(i == iClient || IsImmune(i))
				continue;
			else
				iFlags = ITEMDRAW_DEFAULT;

			Format(strClient, sizeof(strClient), "%s%d", strPrefix, GetClientUserId(i));
			Format(strName, sizeof(strName), "%N [%d/%d]", i, iVotes, iRequired);

			AddMenuItem(hMenu, strClient, strName, iFlags);
		}

	}
	SetMenuExitButton(hMenu, true);
	DisplayMenu(hMenu, iClient, g_iVotesTimeout);
}

public VoteMenuHandler(Handle:hMenu, MenuAction:iAction, iParam1, iParam2)
{
	if(iAction == MenuAction_End)
		CloseHandle(hMenu);
	if(iAction == MenuAction_Cancel)
	{
		if(iParam2 == MenuCancel_ExitBack)
			ChooseVoteMenu(iParam1);
	}
	if(iAction == MenuAction_Select)
	{
		decl String:strUserId[8];
		GetMenuItem(hMenu, iParam2, strUserId, sizeof(strUserId), _, "", 0);

		new iType;
		if(strUserId[0] == 'k')
			iType = KICK;
		else if(strUserId[0] == 'u')
			iType = MUTE;
		else if(strUserId[0] == 'm')
			iType = MAP;
		else if(strUserId[0] == 'b')
			iType = BAN;

		new iTarget = StringToInt(strUserId[1]);
		if(iType == MAP)
		{
			ResetClientMapVotes(iParam1);
			SetArrayCell(g_hArrayVotedForMap[iParam1], iTarget, 1);
			g_iVoteCount[iType][iParam1] += 1;
			CheckVotes(iParam1, iTarget, iType);
		}
		else if(iType == KICK)
		{
			if(IsValidClient(iTarget) && !IsFakeClient(iTarget))
			{
				g_bVotedForKick[iParam1][iTarget] = true;
				g_iVoteCount[iType][iParam1] += 1;
				CheckVotes(iParam1, iTarget, iType);
			}
		}
		else if(iType == MUTE)
		{
			if(IsValidClient(iTarget) && !IsFakeClient(iTarget))
			{
				g_bVotedForMute[iParam1][iTarget] = true;
				g_iVoteCount[iType][iParam1] += 1;
				CheckVotes(iParam1, iTarget, iType);
			}
		}
		else if(iType == BAN)
		{
			if(GetArraySize(g_hArrayVoteBanReasons) > 0)
				BanReasonMenu(iParam1, iTarget);
			else
				ProcessBanVote(iParam1, iTarget, -1);
		}
	}
}

public ProcessBanVote(iVoter, iTarget, iReason)
{
	new iTargetIndex = FindValueInArray(g_hArrayVoteBanClientUserIds, iTarget);
	if(iTargetIndex == -1)
	{
		new iClient = GetClientOfUserId(iTarget);
		if(IsValidClient(iClient) && !IsFakeClient(iClient))
		{
			decl String:strClientName[33];
			GetClientName(iClient, strClientName, sizeof(strClientName));

			decl String:strClientAuth[33];
			GetIdentity(iClient, strClientAuth, sizeof(strClientAuth));

			PushArrayCell(g_hArrayVoteBanClientUserIds, iTarget);
			PushArrayString(g_hArrayVoteBanClientNames, strClientName);
			PushArrayString(g_hArrayVoteBanClientIdentity, strClientAuth);
			PushArrayCell(g_hArrayVoteBanClientCurrentUserId, iTarget);
			PushArrayCell(g_hArrayVoteBanClientTeam, GetClientTeam(iClient));

			g_iVoteBanClients[iClient] = GetArraySize(g_hArrayVoteBanClientNames) - 1;
			iTargetIndex = g_iVoteBanClients[iClient];
		}
	}
	if(iTargetIndex != -1)
	{
		new bool:bDuplicateVote;
		for(new i = 0; i < GetArraySize(g_hArrayVotedForBan[iVoter]); ++i)
		{
			if(GetArrayCell(g_hArrayVotedForBan[iVoter], i) == iTargetIndex)
				bDuplicateVote = true;
		}
		if(!bDuplicateVote)
		{
			PushArrayCell(g_hArrayVotedForBan[iVoter], iTargetIndex);
			PushArrayCell(g_hArrayVotedForReason[iVoter], iReason);
		}
		g_iVoteCount[BAN][iVoter] += 1;
		CheckVotes(iVoter, iTargetIndex, BAN);
	}
}

public GetBanReason(iTarget)
{
	if(GetArraySize(g_hArrayVoteBanReasons) <= 0)
		return -1;

	new Handle:hReasonTally = CreateArray(1, GetArraySize(g_hArrayVoteBanReasons));
	new iTargetIndex;
	new iFinalReason = -1;
	new iFinalReasonCount;

	for(new i = 0; i < GetArraySize(hReasonTally); ++i)
		SetArrayCell(hReasonTally, i, 0);

	for(new i = 1; i <= MAXPLAYERS; ++i)
	{
		iTargetIndex = FindValueInArray(g_hArrayVotedForBan[i], iTarget);
		if(iTargetIndex >= 0)
		{
			new iReason = GetArrayCell(g_hArrayVotedForReason[i], iTargetIndex);
			new iCount = GetArrayCell(hReasonTally, iReason);
			SetArrayCell(hReasonTally, iReason, iCount + 1);
		}
	}

	for(new i = 0; i < GetArraySize(hReasonTally); ++i)
	{
		if(iFinalReasonCount < GetArrayCell(hReasonTally, i))
		{
			iFinalReasonCount = GetArrayCell(hReasonTally, i);
			iFinalReason = i;
		}
	}
	CloseHandle(hReasonTally);
	return iFinalReason;
}

public PrintVoteAction(iVoter, iType, const String:strMessage[])
{
	if(iType != MAP && g_bVoteTeam[iType])
	{
		for(new i = 1; i <= MaxClients; ++i) if(IsValidClient(i))
		{
			if(IsFakeClient(i))
				continue;

			if(GetClientTeam(i) == GetClientTeam(iVoter))
				PrintToChat(i, strMessage);
		}
	}
	else
		PrintToChatAll(strMessage);
}

public CheckVotes(iVoter, iTarget, iType)
{
	new iVotesRequired;
	new Votes = VotesFor(iTarget, iType);
	RequiredVotes(iVoter, iType, iVotesRequired);

	decl String:strVoterName[65];
	decl String:strTargetName[65];
	decl String:strMessage[256];

	GetClientName(iVoter, strVoterName, sizeof(strVoterName));
	if(iType == KICK || iType == MUTE)
		GetClientName(iTarget, strTargetName, sizeof(strTargetName));
	else if(iType == BAN)
		GetArrayString(g_hArrayVoteBanClientNames, iTarget, strTargetName, sizeof(strTargetName));

	if(iType == KICK)
	{
		Format(strMessage, sizeof(strMessage), "[SM] %t.", "voted to kick", strVoterName, strTargetName);
		PrintVoteAction(iVoter, iType, strMessage);

		if(Votes >= iVotesRequired)
		{
			PrintToChatAll("[SM] %t.", "kicked by vote", strTargetName);
			LogAction(-1, iTarget, "Vote kick successful, kicked \"%L\" (iReason \"voted by players\")", iTarget);
			if(IsValidClient(iTarget))
			{
				new Handle:hDataPack;
				CreateDataTimer(5.0, DelayedVoteAction, hDataPack);
				WritePackCell(hDataPack, iType);
				WritePackCell(hDataPack, GetClientUserId(iTarget));
				g_bVoteAction = true;
			}
		}
		else
		{
			Format(strMessage, sizeof(strMessage), "[SM] %t.", "votes required", Votes, iVotesRequired);
			PrintVoteAction(iVoter, iType, strMessage);
		}
	}
	else if(iType == MUTE)
	{
		Format(strMessage, sizeof(strMessage), "[SM] %t.", "voted to mute", strVoterName, strTargetName);
		PrintVoteAction(iVoter, iType, strMessage);
		if(Votes >= iVotesRequired)
		{
			PrintToChatAll("[SM] %t.", "muted by vote", strTargetName);
			LogAction(-1, iTarget, "Vote mute successful, muted \"%L\" (iReason \"voted by players\")", iTarget);
			if(IsValidClient(iTarget))
			{
				g_bMuted[iTarget] = true;
				decl String:strClientAuth[33];
				GetIdentity(iTarget, strClientAuth, sizeof(strClientAuth));
				PushArrayString(g_hArrayVoteMuteClientIdentity, strClientAuth);
				PerformMute(iTarget);
			}
		}
		else
		{
			Format(strMessage, sizeof(strMessage), "[SM] %t.", "votes required", Votes, iVotesRequired);
			PrintVoteAction(iVoter, iType, strMessage);
		}

	}
	else if(iType == BAN)
	{
		Format(strMessage, sizeof(strMessage), "[SM] %t.", "voted to ban", strVoterName, strTargetName);
		PrintVoteAction(iVoter, iType, strMessage);
		if(Votes >= iVotesRequired)
		{
			decl String:strIdentity[33];
			decl String:strVoteReason[33];
			decl String:strReason[100];

			new iReason = GetBanReason(iTarget);
			new iUserId = GetArrayCell(g_hArrayVoteBanClientCurrentUserId, iTarget);
			new iClientId = GetClientOfUserId(iUserId);
			new iBanFlags = BANFLAG_AUTHID;

			GetArrayString(g_hArrayVoteBanClientIdentity, iTarget, strIdentity, sizeof(strIdentity));
			if(strncmp(strIdentity, "STEAM", 5) != 0)
				iBanFlags = BANFLAG_IP;

			if(iReason > -1)
			{
				GetArrayString(g_hArrayVoteBanReasons, iReason, strVoteReason, sizeof(strVoteReason));
				PrintToChatAll("[SM] %t (\x05%s\x01).", "banned by vote", strTargetName, strVoteReason);
				if(iClientId > 0)
					Format(strReason, sizeof(strReason), "%t (%s)", "banned by users", strVoteReason);
				else
					Format(strReason, sizeof(strReason), "(%s) %t (%s)", strTargetName, "banned by users", strVoteReason);
			}
			else
			{
				strcopy(strVoteReason, sizeof(strVoteReason), "unspecified");
				PrintToChatAll("[SM] %t.", "banned by vote", strTargetName);
				if(iClientId > 0)
					Format(strReason, sizeof(strReason), "%t", "banned by users");
				else
					Format(strReason, sizeof(strReason), "(%s) %t", strTargetName, "banned by users");
			}

			LogAction(-1, -1, "Vote ban successful, banned \"%s\" (iReason \"%s\")", strTargetName, strVoteReason);
			if(g_hCvarSourceBans == INVALID_HANDLE)
				BanIdentity(strIdentity, g_iVoteBanTime, iBanFlags, strReason, "players vote");
			else
			{
				if(iClientId > 0)
					ServerCommand("sm_ban #%d %d \"%s\"", iUserId, g_iVoteBanTime, strReason);
				else
				{
					if(iBanFlags == BANFLAG_AUTHID)
						ServerCommand("sm_addban %d %s \"%s\"", g_iVoteBanTime, strIdentity, strReason);
					else
						ServerCommand("sm_banip %s %d \"%s\"", strIdentity, g_iVoteBanTime, strReason);
				}
			}
			if(iBanFlags == BANFLAG_AUTHID)
			{
				new Handle:hDataPack;
				CreateDataTimer(0.25, DelayedVoteAction, hDataPack);
				WritePackCell(hDataPack, BAN);
				WritePackCell(hDataPack, iUserId);
				WritePackString(hDataPack, strReason);
				g_bVoteAction = true;
			}
			RemoveBanVotesForTarget(iTarget);
		}
		else
		{
			Format(strMessage, sizeof(strMessage), "[SM] %t.", "votes required", Votes, iVotesRequired);
			PrintVoteAction(iVoter, iType, strMessage);
		}
	}
	else if(iType == MAP)
	{
		decl String:strMap[32];
		GetArrayString(g_hArrayMapList, iTarget, strMap, sizeof(strMap));
		if(IsMapValid(strMap))
		{
			if(g_iMapCurrent == iTarget && g_iMapMaxExtends != 0 && g_iMapExtendTime > 0)
			{
				PrintToChatAll("[SM] %t.", "voted for extend", strVoterName, g_iMapExtendTime);
				if(Votes >= iVotesRequired)
				{
					PrintToChatAll("[SM] %t.", "map extend by vote", g_iMapExtendTime);
					LogAction(-1, -1, "Extending map to due to players vote.");
					SetConVarFloat(g_hCvarMapTimeLimit, GetConVarFloat(g_hCvarMapTimeLimit) + g_iMapExtendTime);

					if(g_iMapMaxExtends > 0)
						g_iMapMaxExtends =- 1;

					ResetVotes(MAP);
				}
				else
					PrintToChatAll("[SM] %t.", "votes required", Votes, iVotesRequired);
			}
			else
			{
				if(g_bMapChangeImmediately)
					PrintToChatAll("[SM] %t.", "voted for map", strVoterName, strMap);
				else
					PrintToChatAll("[SM] %t.", "voted for nextmap", strVoterName, strMap);

				if(Votes >= iVotesRequired)
				{
					if(g_bMapChangeImmediately)
					{
						PrintToChatAll("[SM] %t.", "map change by vote", strMap);
						LogAction(-1, -1, "Changing map to %s due to players vote.", strMap);

						new Handle:hDataPack;
						CreateDataTimer(10.0, DelayedVoteAction, hDataPack);
						WritePackCell(hDataPack, iType);
						WritePackString(hDataPack, strMap);
						g_bVoteAction = true;
					}
					else
					{
						PrintToChatAll("[SM] %t.", "nextmap change by vote", strMap);
						if(SetNextMap(strMap))
							LogAction(-1, -1, "Setting nextmap to %s due to players vote.", strMap);
						else
							LogAction(-1, -1, "ERROR: Failed to set nextmap to %s", strMap);

						ResetVotes(MAP);
					}
				}
				else
					PrintToChatAll("[SM] %t.", "votes required", Votes, iVotesRequired);
			}
		}
	}
}

public RequiredVotes(iVoter, iType, &iRequired)
{
	new iPlayers;
	for(new i = 1; i <= MaxClients; i++) if(IsValidClient(i))
	{
		if(IsFakeClient(i))
			continue;

		if(iType != MAP && g_bVoteTeam[iType] && GetClientTeam(i) != GetClientTeam(iVoter))
			continue;

		iPlayers++;
	}
	iRequired = RoundToCeil(float(iPlayers) * g_fVoteRatio[iType]);
	if(iRequired < g_iVoteMinimum[iType])
		iRequired = g_iVoteMinimum[iType];
}

public VotesFor(iTarget, iType)
{
	new iVotes;
	if(iType == MAP)
	{
		for(new i = 1; i <= MAXPLAYERS; ++i)
			iVotes = iVotes + GetArrayCell(g_hArrayVotedForMap[i], iTarget);
	}
	else if(iType == KICK)
	{
		for(new i = 1; i <= MAXPLAYERS; i++)
		{
			if(g_bVotedForKick[i][iTarget])
				iVotes++;
		}
	}
	else if(iType == MUTE)
	{
		for(new i = 1; i <= MAXPLAYERS; i++)
		{
			if(g_bVotedForMute[i][iTarget])
				iVotes++;
		}
	}
	else if(iType == BAN)
	{
		new nBanVotes;
		for(new i = 1; i <= MAXPLAYERS; i++)
		{
			nBanVotes = GetArraySize(g_hArrayVotedForBan[i]);
			for(new j = 0; j < nBanVotes; ++j)
			{
				if(GetArrayCell(g_hArrayVotedForBan[i], j) == iTarget)
					iVotes++;
			}
		}
	}
	return iVotes;
}

// ====[ STOCKS ]==============================================================
stock bool:IsValidClient(iClient, bool:bReplay = true)
{
	if(iClient <= 0 || iClient > MaxClients || !IsClientInGame(iClient))
		return false;
	if(bReplay && (IsClientSourceTV(iClient) || IsClientReplay(iClient)))
		return false;
	return true;
}

stock bool:AuthIsValid(const String:strClientAuth[])
{
	return (strcmp(strClientAuth, "STEAM_ID_LAN", false) != 0) && (strcmp(strClientAuth, "STEAM_ID_PENDING", false) != 0);
}

stock bool:GetIdentity(iClient, String:strClientIdentity[], iClientIdentitySize)
{
	GetClientAuthString(iClient, strClientIdentity, iClientIdentitySize);
	if(!IsClientAuthorized(iClient) || !AuthIsValid(strClientIdentity))
	{
		GetClientIP(iClient, strClientIdentity, iClientIdentitySize);
		return false;
	}
	return true;
}

stock bool:IsLastPlayed(const String:strMap[])
{
	new iEndOfLastMapList = GetArraySize(g_hArrayLastMaps);
	new iOldestMapToCheck = iEndOfLastMapList - g_iVoteMapLast;
	if(iOldestMapToCheck < 0)
		iOldestMapToCheck = 0;

	decl String:strMap2[64];
	for(new i = iOldestMapToCheck; i < iEndOfLastMapList; ++i)
	{
		GetArrayString(g_hArrayLastMaps, i, strMap2, sizeof(strMap2));
		if(StrEqual(strMap2, strMap, false))
			return true;
	}
	return false;
}

stock bool:IsImmune(iTarget)
{
	if(g_bImmuneByGroup[iTarget])
		return true;

	if(g_iVoteImmunity > -1)
	{
		new AdminId:idTargetAdmin = GetUserAdmin(iTarget);
		if(idTargetAdmin != INVALID_ADMIN_ID)
			return GetAdminImmunityLevel(idTargetAdmin) >= g_iVoteImmunity;
	}
	return false;
}