/**
 * ======================================================================
 * BEsaysounds, Copyright (C) BehaartesEtwas@quantentunnel.de 2007-2008
 * ======================================================================
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *     Author(s):    BehaartesEtwas AT quantentunnel DOT de
 *
 * Use at your OWN risk! Please submit your changes of this
 * script to BehaartesEtwas AT quantentunnel DOT de
**/

//
// ************************************************************************************************
//
// BEStripQuotes: Strip surrounding quotes from a text
//
  BEStripQuotes(String:text[]) {
    new startidx = 0
    new String:newtext[1024]
    if(text[0] == '"') {
      startidx = 1
      /* Strip the ending quote, if there is one */
      new len = strlen(text)
      if(text[len-1] == '"') {
        text[len-1] = '\0'
      }
    }
    strcopy(newtext,1024,text[startidx])
    strcopy(text,strlen(text),newtext)
    return true
  }

//
// ************************************************************************************************
//
// BEsaysoundsConsole_Server: Send console message
//
  public BEsaysoundsConsole_Server(String:text[], any:...)
  {
    new String:message[255]
    VFormat(message, sizeof(message), text, 2)
    PrintToServer("[BEsaysounds] %s", message)
  }

//
// ************************************************************************************************
//
// BEsaysoundsConsole_Debug: Send debug console message
//
  public BEsaysoundsConsole_Debug(String:text[], any:...)
  {
    if (EnableBEsaysoundsDebug)
    {
        new String:message[255]
        VFormat(message, sizeof(message), text, 2)
        PrintToServer("[BEsaysounds DEBUG] %s", message)
    }
  }
