/**
 * ======================================================================
 * BEsaysounds, Copyright (C) BehaartesEtwas@quantentunnel.de 2007-2008
 * ======================================================================
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *     Author(s):    BehaartesEtwas AT quantentunnel DOT de
 *
 * Use at your OWN risk! Please submit your changes of this
 * script to BehaartesEtwas AT quantentunnel DOT de
**/
#include <morecolors>
//
// ************************************************************************************************
//
// Command_Soundlist: Executed on sm_soundlist command
//
public Action:Command_Soundlist(client,args) {
//
//  Header Message
//
    CPrintToChat(client,"%c[BEsaysounds]%c %t", GREEN, YELLOW, "sl_title")
//
//  Output sound lists
//
    soundlist(0,client)      // normal sounds
    CPrintToChat(client,"%c%t", LIGHTGREEN,"sl_multi")
    soundlist(1,client)      // multi sounds
    CPrintToChat(client,"%c%t", LIGHTGREEN,"sl_admin")
    soundlist(2,client)      // admin-only sounds
}
//
// ************************************************************************************************
//
// soundlist: output a list of sounds of one type to a client
//
public soundlist(ityp,client) {
//
//  Some preparations
//
    new String:spacer[5]
//    Format(spacer,sizeof(spacer)," %c",9)
    Format(spacer,sizeof(spacer)," ")
//
//  Iterate all sounds
//
    KvRewind(kvGConfig)
    if(!KvJumpToKey(kvGConfig, "saysounds")) {
      BEsaysoundsConsole_Server("Key 'saysounds' not found!")
      return
    }
//
    new String:line[64] = ""
//
    new bool:res = KvGotoFirstSubKey(kvGConfig)
    while(res) {
      new String:name[16]
      KvGetSectionName(kvGConfig, name,sizeof(name))
//
//    Get type of sound
//
      new isMulti
      isMulti = 0
      if(KvJumpToKey(kvGConfig,"files")) {
        isMulti = 1
        KvGoBack(kvGConfig)
      }
//
      new String:group[64]
      new isAdmin
      isAdmin = 0
      KvGetString(kvGConfig,"group",group,sizeof(group),"")
      if(strcmp(group,"")) {
        isAdmin = 1
      }
//
      if( (ityp == 0 && isAdmin == 0 && isMulti == 0) || (ityp == 1 && isAdmin == 0 && isMulti == 1) || (ityp == 2 && isAdmin == 1) ) {
        StrCat(line,sizeof(line),name)
        StrCat(line,sizeof(line),spacer)
      }
//
      if(strlen(line) > 32) {
        CPrintToChat(client,"%s",line)
        line = ""
      }
//
      res = KvGotoNextKey(kvGConfig)
    }
//
    if(strlen(line) > 0) {
      CPrintToChat(client,"%s",line)
    }
//
    return
}
