/**
 * ======================================================================
 * BEsaysounds, Copyright (C) BehaartesEtwas@quantentunnel.de 2007-2008
 * ======================================================================
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *     Author(s):    BehaartesEtwas AT quantentunnel DOT de
 *
 * Use at your OWN risk! Please submit your changes of this
 * script to BehaartesEtwas AT quantentunnel DOT de
**/

//
// Global vars
//
new bomb_timeleft

//
// ************************************************************************************************
//
// InitBombTimer
//
public InitBombTimer() {
//
//  Hook events
//
    HookEvent("bomb_planted", Event_BombPlanted)
    HookEvent("round_start",  Event_RoundEnd_Bomb)
    HookEvent("round_end",    Event_RoundEnd_Bomb)
}

//
// ************************************************************************************************
//
// Event_BombPlanted: Called when bomb is planted
//
public Event_BombPlanted(Handle:event, const String:name[], bool:dontBroadcast) {
    new Handle:cv = FindConVar("mp_c4timer")
    bomb_timeleft = GetConVarInt(cv)
    CloseHandle(cv)
//
//  Create a repeating timer
//
    CreateTimer(1.0, BombTimer,_, TIMER_REPEAT)
}

//
// ************************************************************************************************
//
// Event_RoundEnd: Called when round is over (to stop the bomb timer)
//
public Event_RoundEnd_Bomb(Handle:event, const String:name[], bool:dontBroadcast) {
    bomb_timeleft = 0
}

//
// ************************************************************************************************
//
// BombTimer: Called every second after the bomb has been planted
//
public Action:BombTimer(Handle:timer) {
    bomb_timeleft = bomb_timeleft - 1
    if(bomb_timeleft < 0) {
      KillTimer(timer)
      return
    }
//
    new String:st[6]
    Format(st,6,"%d",bomb_timeleft)
//
    KvRewind(kvGConfig)
    if(!KvJumpToKey(kvGConfig, "c4timer")) {
      BEsaysoundsConsole_Debug("no c4timer config found")
      return
    }
    if(!KvJumpToKey(kvGConfig, st)) {
      BEsaysoundsConsole_Debug("no c4timer config for second %d found",bomb_timeleft)
      return
    }
//
    new String:file[1024]
    new String:cmsg[1024]
    new String:text[1024]
    KvGetString(kvGConfig, "file", file, sizeof(file), "")
    KvGetString(kvGConfig, "cmsg", cmsg, sizeof(cmsg), "")
    KvGetString(kvGConfig, "text", text, sizeof(text), "")
//
    if(strcmp(file,"")) EmitSoundToAll(file)
    if(strcmp(cmsg,"")) PrintCenterTextAll("%s",cmsg)
    if(strcmp(text,"")) PrintToChatAll("%s",text)
}
