/**
 * ======================================================================
 * BEsaysounds, Copyright (C) BehaartesEtwas@quantentunnel.de 2007-2008
 * ======================================================================
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *     Author(s):    BehaartesEtwas AT quantentunnel DOT de
 *
 * Use at your OWN risk! Please submit your changes of this
 * script to BehaartesEtwas AT quantentunnel DOT de
**/
#include <morecolors>
//
// Some global stuff...
//
new Handle:kvDeadtimes        // temporary KV for dead times
new Handle:kvCounters         // temporary KV for holding per-round counters
new bool:isGlobalDead         // status variable for global dead time

//
// ************************************************************************************************
//
// Command_Say: Look for saysounds in chat messages
//
public Action:Command_Say(client,args) {
//
//  Check if plugin is enabled
//
    if(!GetConVarInt(g_BEsaysoundsStatus)) return Plugin_Continue
    // if(client == 0) return Plugin_Continue
//
//  Obtain infos on chat message
//
    decl String:speech[128]
    GetCmdArgString(speech,sizeof(speech))
    BEStripQuotes(speech)
//
    BEsaysoundsConsole_Debug("Processing speech '%s' by client '%d'",speech,client)
//
//  Trigger sound?
//
    new String:file[1024]
    new condit = LookupSound(client,speech,file,1024)
    if(condit == 0) return Plugin_Continue
//
//  Check global dead time and spam conditions
//
    if(condit == 3) {
      CPrintToChat(client,"%t", "sf_admin")
      return Plugin_Continue
    }
//
    if(condit == 2) {
      CPrintToChat(client,"%t", "sf_spam")
      return Plugin_Continue
    }
//
    if(isGlobalDead) {
      CPrintToChat(client,"%t", "sf_globalblock")
      return Plugin_Continue
    }
//
    BEsaysoundsConsole_Debug("Speech '%s' by client '%d' triggers playing of file '%s'...",speech,client,file)
    PlaySound(client,speech,file)
//
    return Plugin_Continue
}
//
// ************************************************************************************************
//
// LookupSound: Searches for a sound
//
// Return value: 0: no sound found
//               1: playable sound found
//               2: sound found but filtered by rules
//
  LookupSound(senderid, const String:name[], String:file[], maxlen) {
//
    new String:steamid[64]
    if(senderid != 0) {
      GetClientAuthString(senderid,steamid,sizeof(steamid))
    }
    else {
      steamid = "CONSOLE"
    }
//
    KvRewind(kvGConfig)
    if(!KvJumpToKey(kvGConfig, "saysounds"))
    {
        BEsaysoundsConsole_Server("config file broken! Key 'regular' not found!")
        return false
    }
    if(!KvJumpToKey(kvGConfig, name)) return 0
//
//  Admin only sound?
//
    new String:group[64], String:sendergroup[64]
    KvGetString(kvGConfig,"group",group,sizeof(group),"")
    if(strcmp(group,"")) {
      KvRewind(kvGConfig)
      if(!KvJumpToKey(kvGConfig, "admin")) return 3
      if(!KvJumpToKey(kvGConfig, steamid)) return 3
      if(!KvJumpToKey(kvGConfig, "settings")) return 3
      KvGetString(kvGConfig,"group",sendergroup,sizeof(sendergroup),"")
      if(strcmp(group,sendergroup)) return 3
//
      KvRewind(kvGConfig)
      KvJumpToKey(kvGConfig, "saysounds")
      KvJumpToKey(kvGConfig, name)
    }
//
//  Single sound file?
//
    if(!KvJumpToKey(kvGConfig,"files")) {
      KvGetString(kvGConfig,"file",file,maxlen,"***NOTFOUND***")
      if(!strcmp(file,"***NOTFOUND***")) return 0
      if(filter(senderid, senderid, file)) return 2
      return 1
    }
//
//  Count number of sound files for this sound and put unfiltered sounds into a KV
//
    new nof = 0 // Numer of files
    new String:snof[6]
    Format(snof,6,"%d",nof)
//
    new i = 1
    new String:si[6]
    Format(si,6,"%d",i)
//
    new Handle:kvTemp = CreateKeyValues("BEsaysoundsTemp")
//
    while(KvGetString(kvGConfig,si,file,maxlen,"***NOTFOUND***") && strcmp(file,"***NOTFOUND***")) {
      i++
      Format(si,6,"%d",i)
      if(! filter(senderid, senderid, file)) {
        Format(snof,6,"%d",nof)
        KvSetString(kvTemp,snof,file)
        nof++
      }
    }
//
//  All files filtered?
//
    if(nof == 0) return 2
//
//  Pick a random file
//
    i = GetRandomInt(0, nof-1);
    Format(si,6,"%d",i)
    KvGetString(kvTemp,si,file,maxlen)
    BEsaysoundsConsole_Debug("Picking sound file #%d: '%s'",i,file)
//
    CloseHandle(kvTemp)
    return 1
  }

//
// ************************************************************************************************
//
//  Check if sound file should currently not be played on target client due to filter rules
//
  bool:filter(const client, const target, const String:file[]) {
//
    new String:steamidc[64]
    if(client != 0) {
      GetClientAuthString(client,steamidc,sizeof(steamidc))
    }
    else {
      steamidc = "CONSOLE"
    }
//
    new String:steamidt[64]
    if(target != 0) {
      GetClientAuthString(target,steamidt,sizeof(steamidt))
    }
    else {
      steamidt = "CONSOLE"
    }
//
    BEsaysoundsConsole_Debug("Cheking filter condition: Sender %d, Target %d, File %s",client,target,file)
//
//  get targets's config
//
    new String:cc_disable[8], String:cc_filteralive[8], String:cc_filterdead[8]
    new String:cc_fromdead[8], String:cc_deadonly[8]
    GetCConfig(target, cc_disable, cc_filteralive, cc_filterdead, cc_fromdead, cc_deadonly)
//
//  sounds currently muted?
//
    KvRewind(kvMutedPs)
    if(KvJumpToKey(kvMutedPs, steamidt)) return true
//
//  get current status of sound
//
    KvRewind(kvDeadtimes)
    KvJumpToKey(kvDeadtimes, file, true)
    new String:isdeadtime[6]
    KvGetString(kvDeadtimes, "isdeadtime", isdeadtime, sizeof(isdeadtime), "no")
//
//  get per-round counters
//
    KvRewind(kvCounters)
    KvJumpToKey(kvCounters, "files", true)
    KvJumpToKey(kvCounters, file, true)
    new csound
    csound = KvGetNum(kvCounters, "counter", 0)
//
    KvRewind(kvCounters)
    KvJumpToKey(kvCounters, "players", true)
    KvJumpToKey(kvCounters, steamidc, true)
    new cplayr
    cplayr = KvGetNum(kvCounters, "counter", 0)
//
//  Check filter rules
//
    new tAlive
    if(target != 0) {
      tAlive = IsPlayerAlive(target)
    }
    else {
      tAlive = 1
    }
//
    new cAlive
    if(client != 0) {
      cAlive = IsPlayerAlive(client)
    }
    else {
      cAlive = 1
    }
//
    BEsaysoundsConsole_Debug("tAlive: %d    cAlive: %d",tAlive,cAlive)
//
    if(!strcmp(cc_disable,"yes")) return true
//
    if( tAlive && !strcmp(cc_filteralive,"yes") && !strcmp(isdeadtime,"yes")) return true
    if(!tAlive && !strcmp(cc_filterdead ,"yes") && !strcmp(isdeadtime,"yes")) return true
//
    if( tAlive && !strcmp(cc_filteralive,"yes") && csound >= maxprosound) return true
    if(!tAlive && !strcmp(cc_filterdead ,"yes") && csound >= maxprosound) return true
//
    if( tAlive && !strcmp(cc_filteralive,"yes") && cplayr >= maxproplayr) return true
    if(!tAlive && !strcmp(cc_filterdead ,"yes") && cplayr >= maxproplayr) return true
//
    if( tAlive && !cAlive && !strcmp(cc_fromdead,"no")) return true
    if( tAlive && !strcmp(cc_deadonly,"yes")) return true
//
//  No filter rule applied
//
    BEsaysoundsConsole_Debug("Not filtered...")
    return false
  }

//
// ************************************************************************************************
//
// PlaySound: Plays a sound file while obeying the filter rules
//
  PlaySound(const senderid, const String:name[], const String:file[]) {
//
//  Get nick name of sender
//
    new String:player[256]
    if(senderid != 0) {
      GetClientName(senderid, player, sizeof(player))
    }
    else {
      player = "CONSOLE"
    }
//
//  obtain texts to display
//
    KvRewind(kvGConfig)
    KvJumpToKey(kvGConfig, "saysounds")
    KvJumpToKey(kvGConfig, name)
//
    new String:cmsg[1024]
    KvGetString(kvGConfig, "cmsg", cmsg,sizeof(cmsg))
    new String:text[1024]
    KvGetString(kvGConfig, "text", text,sizeof(text))
//
//  Play sound
//
    new playersconnected;
    playersconnected = GetMaxClients();
    for (new i = 1; i <= playersconnected; i++){
      if(IsClientInGame(i)) {
        if(! filter(senderid,i,file)) {
          EmitSoundToClient(i, file);
          CPrintToChat(i,"%t", "sp_played", player, name)
//
          if(strcmp(text,"")) CPrintToChat(i,"%s",text)
          if(strcmp(cmsg,"")) PrintCenterText(i,"%s",cmsg)
        }
        else {
          CPrintToChat(i,"%t", "sp_filtered", player, name)
        }
      }
    }
//
//  start global dead time
//
    isGlobalDead = true
    CreateTimer(globaldeadtime,EndGlobalDeadTime)
//
//  start dead time for specific file
//
    KvRewind(kvDeadtimes)
    KvJumpToKey(kvDeadtimes, file, true)
    KvSetString(kvDeadtimes, "isdeadtime", "yes")
//
    new Handle:pack
    CreateDataTimer(deadtime, EndDeadTime, pack)
    WritePackString(pack, file)
//
//  Per-round counters
//
    new counter
    new String:steamid[64]
    if(senderid != 0) {
      GetClientAuthString(senderid,steamid,sizeof(steamid))
    }
    else {
      steamid = "CONSOLE"
    }
//
    KvRewind(kvCounters)
    KvJumpToKey(kvCounters, "files", true)
    KvJumpToKey(kvCounters, file, true)
    counter = KvGetNum(kvCounters, "counter", 0)
    counter++
    KvSetNum(kvCounters, "counter", counter)
//
    KvRewind(kvCounters)
    KvJumpToKey(kvCounters, "players", true)
    KvJumpToKey(kvCounters, steamid, true)
    counter = KvGetNum(kvCounters, "counter", 0)
    counter++
    KvSetNum(kvCounters, "counter", counter)
//
//  Write history
//
    KvRewind(kvHistory)
    KvJumpToKey(kvHistory, file, true)
    counter = KvGetNum(kvHistory, "counter", 0)
    counter++
    KvSetNum(kvHistory, "counter", counter)
//
    KvJumpToKey(kvHistory, steamid, true)
    counter = KvGetNum(kvHistory, "counter", 0)
    counter++
    KvSetNum(kvHistory, "counter", counter)
  }

//
// CallBack funtions for ending dead times
//
  public Action:EndGlobalDeadTime(Handle:timer) {
    BEsaysoundsConsole_Debug("EndGlobalDeadTime")
    isGlobalDead = false
  }
//
  public Action:EndDeadTime(Handle:timer, any:pack) {
    new String:file[1024]
    ResetPack(pack)
    ReadPackString(pack, file, sizeof(file))
//
    BEsaysoundsConsole_Debug("EndDeadTime for file '%s'", file)
    KvRewind(kvDeadtimes)
    KvJumpToKey(kvDeadtimes, file, true)
    KvSetString(kvDeadtimes, "isdeadtime", "no")
  }
