/**
 * ======================================================================
 * BEsaysounds, Copyright (C) BehaartesEtwas@quantentunnel.de 2007-2008
 * ======================================================================
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *     Author(s):    BehaartesEtwas AT quantentunnel DOT de
 *
 * Use at your OWN risk! Please submit your changes of this
 * script to BehaartesEtwas AT quantentunnel DOT de
**/
#include <morecolors>
//
// Some colors...
//
#define YELLOW               0x01
#define LIGHTGREEN           0x03
#define GREEN                0x04

//
// Some other global stuff...
//
new Handle:g_BEsaysoundsStatus                   // Handle for the ConVar
new bool:EnableBEsaysoundsDebug                  // Status var for debug output

//
// ************************************************************************************************
//
// BEsaysoundsStatus: Handle the status ConVar
//
public BEsaysoundsStatus(Handle:convar, const String:oldValue[], const String:newValue[]) {
    if (GetConVarInt(g_BEsaysoundsStatus) != 1)
    {
        CPrintToChatAll("%c[BEsaysounds]%c BEsaysounds plugin turned off.", GREEN, YELLOW)
    } else {
        CPrintToChatAll("%c[BEsaysounds]%c BEsaysounds plugin turned on.", GREEN, YELLOW)
    }
}
//
public ChangeBEsaysoundsStatus(status) {
    SetConVarInt(g_BEsaysoundsStatus, status)
}
