/**
 * ======================================================================
 * BEsaysounds, Copyright (C) BehaartesEtwas@quantentunnel.de 2007-2008
 * ======================================================================
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *     Author(s):    BehaartesEtwas AT quantentunnel DOT de
 *
 * Use at your OWN risk! Please submit your changes of this
 * script to BehaartesEtwas AT quantentunnel DOT de
**/
#include <morecolors>
//
// ************************************************************************************************
//
// InitAdminSounds
//
public InitAdminSounds() {
    HookEvent("player_activate", PlayerActivate)
    HookEvent("player_disconnect", PlayerDisconnect)
}

//
// ************************************************************************************************
//
// PlayerActivate: Player has connected to server and loaded the game
//
public Action:PlayerActivate(Handle:event, const String:name[], bool:dontBroadcast) {
//
//  Create a delay of 5 seconds for playing back the connect sound
//
    CreateTimer(5.0, ConnectSound, GetEventInt(event, "userid"))
}

//
// ************************************************************************************************
//
// ConnectSound: Play connect sound
//
public Action:ConnectSound(Handle:timer, any:userid) {
    new String:steamid[64]
    new client = GetClientOfUserId(userid)
    if(client == 0) return Plugin_Continue
    GetClientAuthString(client,steamid,sizeof(steamid))
//
    BEsaysoundsConsole_Debug("Looking for connect sound of client %s",steamid)
//
    KvRewind(kvGConfig)
    if(!KvJumpToKey(kvGConfig, "admin")) {
      BEsaysoundsConsole_Debug("No admin sound configuration found")
      return Plugin_Continue
    }
//
    if(!KvJumpToKey(kvGConfig, steamid)) return Plugin_Continue
    if(!KvJumpToKey(kvGConfig, "connect")) return Plugin_Continue
//
    new String:file[1024]
    KvGetString(kvGConfig, "file", file,sizeof(file))
    new String:cmsg[1024]
    KvGetString(kvGConfig, "cmsg", cmsg,sizeof(cmsg))
    new String:text[1024]
    KvGetString(kvGConfig, "text", text,sizeof(text))
    new String:team[1024]
    KvGetString(kvGConfig, "team", team,sizeof(team), "any")
//
    if(strcmp(file,"")) EmitSoundToAll(file)
    if(strcmp(cmsg,"")) PrintCenterTextAll("%s",cmsg)
    if(strcmp(text,"")) CPrintToChatAll("%s",text)
    return Plugin_Continue
}

//
// ************************************************************************************************
//
// PlayerDisconnect: Player has disconnected
//
public Action:PlayerDisconnect(Handle:event, const String:name[], bool:dontBroadcast) {
    new userid = GetEventInt(event, "userid")
    new String:steamid[64]
    new client = GetClientOfUserId(userid)
    if(client == 0) return Plugin_Continue
    GetClientAuthString(client,steamid,sizeof(steamid))
//
    BEsaysoundsConsole_Debug("Looking for disconnect sound of client %s",steamid)
//
    KvRewind(kvGConfig)
    if(!KvJumpToKey(kvGConfig, "admin")) {
      BEsaysoundsConsole_Debug("No admin sound configuration found")
      return Plugin_Continue
    }
//
    if(!KvJumpToKey(kvGConfig, steamid)) return Plugin_Continue
    if(!KvJumpToKey(kvGConfig, "disconnect")) return Plugin_Continue
//
    new String:file[1024]
    KvGetString(kvGConfig, "file", file,sizeof(file))
    new String:cmsg[1024]
    KvGetString(kvGConfig, "cmsg", cmsg,sizeof(cmsg))
    new String:text[1024]
    KvGetString(kvGConfig, "text", text,sizeof(text))
    new String:team[1024]
    KvGetString(kvGConfig, "team", team,sizeof(team), "any")
//
    if(strcmp(file,"")) EmitSoundToAll(file)
    if(strcmp(cmsg,"")) PrintCenterTextAll("%s",cmsg)
    if(strcmp(text,"")) CPrintToChatAll("%s",text)
    return Plugin_Continue
}
