/**
 * ======================================================================
 * BEsaysounds, Copyright (C) BehaartesEtwas@quantentunnel.de 2007-2008
 * ======================================================================
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *     Author(s):    BehaartesEtwas AT quantentunnel DOT de
 *
 * Use at your OWN risk! Please submit your changes of this
 * script to BehaartesEtwas AT quantentunnel DOT de
**/
#include <morecolors>
//
// ************************************************************************************************
//
// InitEventSounds
//
public InitEventSounds() {
//
//  Iterate all specified events
//
    KvRewind(kvGConfig)
    if(!KvJumpToKey(kvGConfig, "events")) {
      BEsaysoundsConsole_Debug("no event sounds config found")
      return
    }
//
    if(!KvGotoFirstSubKey(kvGConfig)) return
    do
    {
      new String:event[64]
      KvGetSectionName(kvGConfig, event, sizeof(event))
      BEsaysoundsConsole_Debug("Hooking event '%s'...",event)
      HookEvent(event, TriggerEventSound)
//
    } while (KvGotoNextKey(kvGConfig))
}

//
// ************************************************************************************************
//
// TriggerEventSound: Start timer for delayed playback of event sound
//
public Action:TriggerEventSound(Handle:event, const String:name[], bool:dontBroadcast) {
//
    KvRewind(kvGConfig)
    if(!KvJumpToKey(kvGConfig, "events")) {
      BEsaysoundsConsole_Debug("no event sounds config found")
      return
    }
//
    new id                               // numerical section id can be passed to the timer easily
    KvGetNameSymbol(kvGConfig, name, id);
//
    if(!KvJumpToKey(kvGConfig, name)) {
      BEsaysoundsConsole_Debug("no event sounds config for event '%s' found",name)
      return
    }
//
//  Start the timer
//
    new Float:t = KvGetFloat(kvGConfig, "delay", 0.1)
    BEsaysoundsConsole_Debug("Triggering delayed event sound for event '%s', id = %d...",name,id)
    CreateTimer(t, EventSoundTimer, id)
}

//
// ************************************************************************************************
//
// BombTimer: Called every second after the bomb has been planted
//
public Action:EventSoundTimer(Handle:timer, any:id) {
    KvRewind(kvGConfig)
    if(!KvJumpToKey(kvGConfig, "events")) {
      BEsaysoundsConsole_Debug("no event sounds config found")
      return
    }
//
    new String:name[1024]
    KvFindKeyById(kvGConfig,id,name,sizeof(name))
//    
    if(!KvJumpToKey(kvGConfig, name)) {
      BEsaysoundsConsole_Debug("no event sounds config for event '%s' found",name)
      return
    }
//
    new String:file[1024]
    KvGetString(kvGConfig, "file", file,sizeof(file))
    new String:cmsg[1024]
    KvGetString(kvGConfig, "cmsg", cmsg,sizeof(cmsg))
    new String:text[1024]
    KvGetString(kvGConfig, "text", text,sizeof(text))
    new String:team[1024]
    KvGetString(kvGConfig, "team", team,sizeof(team), "any")
//
    BEsaysoundsConsole_Debug("Playing event sound for event '%s', id = %d, file='%s', cmsg='%s', text='%s', team='%s' ...",name,id, file,cmsg,text,team)
//
    new playersconnected;
    playersconnected = GetMaxClients();
    for (new i = 1; i <= playersconnected; i++) {
      if(IsClientInGame(i)) {
        if(GetClientTeam(i) == FindTeamByName(team) || !strcmp(team,"any")) {
          if(strcmp(file,"")) EmitSoundToClient(i,file)
          if(strcmp(text,"")) CPrintToChat(i,"%s",text)
          if(strcmp(cmsg,"")) PrintCenterText(i,"%s",cmsg)
        }
        else {
          new String:team2[1024]
          GetTeamName(GetClientTeam(i),team2,sizeof(team2))
          BEsaysoundsConsole_Debug("Not playing sound for client %d as he (%s) is not in the right team (%s)...",i,team2,team)
        }
      }
    }
    
}
