/**
 * ======================================================================
 * BEsaysounds, Copyright (C) BehaartesEtwas@quantentunnel.de 2007-2008
 * ======================================================================
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.cl

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *     Author(s):    BehaartesEtwas AT quantentunnel DOT de
 *
 * Use at your OWN risk! Please submit your changes of this
 * script to BehaartesEtwas AT quantentunnel DOT de
**/
#include <morecolors>
//
// Handles for key values
//
  new Handle:kvGConfig
  new Handle:kvCConfig
  new Handle:kvHistory
  new Handle:kvMutedPs

//
// Global config vars
//
  new Float:globaldeadtime
  new Float:deadtime
  new maxprosound
  new maxproplayr

//
// ************************************************************************************************
//
// InitConfigs: Open the config files
//
  InitConfigs() {
    kvGConfig = CreateKeyValues("BEsaysounds")
    kvCConfig = CreateKeyValues("BEsaysoundsUsers")
    kvHistory = CreateKeyValues("BEsaysoundsHistory")
    kvMutedPs = CreateKeyValues("BEsaysoundsMutedPlayers")
//
    new String:path[PLATFORM_MAX_PATH];
    BuildPath(Path_SM, path, sizeof(path), "configs/BEsaysounds.cfg");
    if(!FileToKeyValues(kvGConfig, path)) BEsaysoundsConsole_Server("BEsaysounds.cfg not found!")
    BuildPath(Path_SM, path, sizeof(path), "data/BEsaysoundsUsers.cfg");
    if(!FileToKeyValues(kvCConfig, path)) BEsaysoundsConsole_Server("BEsaysoundsUsers.cfg not found!")
    BuildPath(Path_SM, path, sizeof(path), "data/BEsaysoundsHistory.cfg");
    if(!FileToKeyValues(kvHistory, path)) BEsaysoundsConsole_Server("BEsaysoundsHistory.cfg not found!")
//
//  Hook event "player_death" to unmute the dying player
//
    HookEvent("player_death", Player_Unmute)
  }

//
// ************************************************************************************************
//
// LoadGConfig: Load global config
//
  LoadGConfig() {
    KvRewind(kvGConfig)
    if(!KvJumpToKey(kvGConfig, "config")) {
      BEsaysoundsConsole_Server("config file broken! Key 'config' not found!")
      return false
    }
//
    globaldeadtime = KvGetFloat(kvGConfig, "globaldeadtime", 5.0)
    deadtime = KvGetFloat(kvGConfig, "deadtime", 45.0)
    maxprosound = KvGetNum(kvGConfig, "maxprosound", 2)
    maxproplayr = KvGetNum(kvGConfig, "maxproplayer", 5)
    return true
  }

//
// ************************************************************************************************
//
// GetCConfig: Get client config
//
  GetCConfig(client, String:cc_disable[8], String:cc_filteralive[8], String:cc_filterdead[8],
             String:cc_fromdead[8], String:cc_deadonly[8]) {
//
    new String:steamid[64]
    if(client == 0) return
    GetClientAuthString(client,steamid,sizeof(steamid))
//
//  Find key for client's steamid
//
    KvRewind(kvCConfig)
    if(!KvJumpToKey(kvCConfig, steamid)) {      // not found: assign default values
      BEsaysoundsConsole_Debug("Setting default values for client config for SteamID %s",steamid)
      KvJumpToKey(kvCConfig, steamid, true)     // create the key
      cc_disable = "no"                         // not completely disabled on default
      cc_filteralive = "yes"                    // spam filter enabled while alive
      cc_filterdead = "yes"                     // spam filter enabled while dead
      cc_fromdead = "yes"                       // enable sounds from dead players while alive
      cc_deadonly = "no"                        // also play sounds if alive
      KvSetString(kvCConfig, "disable", cc_disable)
      KvSetString(kvCConfig, "filteralive", cc_filteralive)
      KvSetString(kvCConfig, "filterdead", cc_filterdead)
      KvSetString(kvCConfig, "fromdead", cc_fromdead)
      KvSetString(kvCConfig, "deadonly", cc_deadonly)
      return
    }
//
    KvGetString(kvCConfig, "disable", cc_disable, 8, "no")
    KvGetString(kvCConfig, "filteralive", cc_filteralive, 8, "yes")
    KvGetString(kvCConfig, "filterdead", cc_filterdead, 8, "yes")
    KvGetString(kvCConfig, "fromdead", cc_fromdead, 8, "yes")
    KvGetString(kvCConfig, "deadonly", cc_deadonly, 8, "no")
//
    BEsaysoundsConsole_Debug("Get client config for SteamID %s: %s %s %s %s %s",steamid,cc_disable,cc_filteralive,cc_filterdead,cc_fromdead,cc_deadonly)
//
    return
  }

//
// ************************************************************************************************
//
// SaveConfigs: Save the config to files
//
  SaveConfigs() {
    KvRewind(kvCConfig)
    KvRewind(kvHistory)
    if(!KeyValuesToFile(kvCConfig, "addons/sourcemod/data/BEsaysoundsUsers.cfg")) {
      BEsaysoundsConsole_Server("BEsaysoundsUsers.cfg could not be created!")
    }
    if(!KeyValuesToFile(kvHistory, "addons/sourcemod/data/BEsaysoundsHistory.cfg")) {
      BEsaysoundsConsole_Server("BEsaysoundsHistory.cfg could not be created!")
    }
  }

//
// ************************************************************************************************
//
// Command_Configuration: Executed on sm_saysounds command
//
public Action:Command_Configuration(client,args) {
//
//  Check if plugin is enabled
//
    if(!GetConVarInt(g_BEsaysoundsStatus)) return Plugin_Continue
    if(client == 0) return Plugin_Continue
//
//  get current config
//
    new String:cc_disable[8], String:cc_filteralive[8], String:cc_filterdead[8], String:cc_fromdead[8], String:cc_deadonly[8]
    GetCConfig(client, cc_disable, cc_filteralive, cc_filterdead, cc_fromdead, cc_deadonly)
//
//  Build menu
//
    new String:item[1024]
//
    new Handle:menu = CreateMenu(MenuHandler1)
    Format(item,sizeof(item),"%T","menu_title",client)
    SetMenuTitle(menu, item)
//
    Format(item,sizeof(item),"%T: %T","cc_disable",client,cc_disable,client)
    AddMenuItem(menu, "disable",item)
//
    Format(item,sizeof(item),"%T: %T","cc_filteralive",client,cc_filteralive,client)
    AddMenuItem(menu, "filteralive",item)
//
    Format(item,sizeof(item),"%T: %T","cc_filterdead",client,cc_filterdead,client)
    AddMenuItem(menu, "filterdead",item)
//
    Format(item,sizeof(item),"%T: %T","cc_fromdead",client,cc_fromdead,client)
    AddMenuItem(menu, "fromdead",item)
//
    Format(item,sizeof(item),"%T: %T","cc_deadonly",client,cc_deadonly,client)
    AddMenuItem(menu, "deadonly",item)
//
    SetMenuExitButton(menu, true)
    DisplayMenu(menu, client, 600)
//
    return Plugin_Handled
}

//
// ************************************************************************************************
//
// MenuHandler1: used by Command_Configuration for the user config menu
//
public MenuHandler1(Handle:menu, MenuAction:action, client, param)
{
    if(action == MenuAction_Select) {
//
//    Obtain variable name to toggle
//
      new String:info[32]
      new bool:found = GetMenuItem(menu, param, info, sizeof(info))
//
      if(found) {
//
//      Query current status of variable
//
        new String:steamid[64]
        new String:cc_value[8]
        GetClientAuthString(client,steamid,sizeof(steamid))
        KvRewind(kvCConfig)
        KvJumpToKey(kvCConfig, steamid, true)                      // should always already exist, as it is created on menu display at least
        KvGetString(kvCConfig, info, cc_value, 8, "no")
//
//      Toggle the value
//
        if(!strcmp(cc_value,"no")) {
          cc_value = "yes"
        }
        else {
          cc_value = "no"
        }
//
//      Write the new value into config
//
        KvSetString(kvCConfig, info, cc_value)
      }
//
//    Redisplay the menu
//
      Command_Configuration(client,0)
    }
//
//  If users hits cancel, save configuration
//
    if(action == MenuAction_Cancel) {
      SaveConfigs()
    }
}

//
// ************************************************************************************************
//
// Command_Mute: Executed on sm_mute command
//
public Action:Command_Mute(client,args) {
    new String:steamid[64]
    if(client == 0) return Plugin_Continue
    GetClientAuthString(client,steamid,sizeof(steamid))
//
//  Add SteamID to list of muted players
//
    KvRewind(kvMutedPs)
    KvJumpToKey(kvMutedPs, steamid, true)
//
//  Output message to player
//
    PrintToChat(client,"%c[BEsaysounds]%c Say sounds muted until end of round or your death!", GREEN, YELLOW)
    return Plugin_Continue
}
//
// ************************************************************************************************
//
// Player_Unmute: Called on player_death to unmute the player
//
public Player_Unmute(Handle:event, const String:name[], bool:dontBroadcast) {
    new String:steamid[64]
    new client = GetClientOfUserId(GetEventInt(event, "userid"))
    GetClientAuthString(client,steamid,sizeof(steamid))
//
//  Delete SteamID from list of muted players
//
    KvRewind(kvMutedPs)
    if(KvJumpToKey(kvMutedPs, steamid)) {
      KvDeleteThis(kvMutedPs)
//
//    Output message to player
//
      PrintToChat(client,"%c[BEsaysounds]%c Say sounds unmuted!", GREEN, YELLOW)
    }
}

//
// ************************************************************************************************
//
// MakeDownloadable: Precache all sounds in a section and put them to the download table
//
  MakeDownloadable(const String:section[]) {
//
    KvRewind(kvGConfig)
    if(!KvJumpToKey(kvGConfig, section)) {
      BEsaysoundsConsole_Server("Key '%s' not found!",section)
      return false
    }
//
//  Iterate all subkeys
//
    if(!KvGotoFirstSubKey(kvGConfig)) return false
    do
    {
      new String:file[1024]
      if(KvJumpToKey(kvGConfig,"files")) {
        new i = 1
        new String:si[6]
        Format(si,6,"%d",i)
        while(KvGetString(kvGConfig,si,file,sizeof(file),"***NOTFOUND***") && strcmp(file,"***NOTFOUND***")) {
          new String:dl[1024]
          Format(dl, sizeof(dl), "sound/%s", file);
          if(FileExists(dl)) {
            BEsaysoundsConsole_Debug("Precaching file '%s'...",dl)
            PrecacheSound(file, true);
            AddFileToDownloadsTable(dl);
          }
          else {
            BEsaysoundsConsole_Server("*** File '%s' not found!",dl)
          }
          i++
          Format(si,6,"%d",i)
        }
        KvGoBack(kvGConfig)
      }
      else {
        KvGetString(kvGConfig,"file",file,sizeof(file),"***NOTFOUND***")
        if(strcmp(file,"***NOTFOUND***")) {
          new String:dl[1024]
          Format(dl, sizeof(dl), "sound/%s", file);
          if(FileExists(dl)) {
            BEsaysoundsConsole_Debug("Precaching file '%s'...",dl)
            PrecacheSound(file, true);
            AddFileToDownloadsTable(dl);
          }
          else {
            BEsaysoundsConsole_Server("*** File '%s' not found!",dl)
          }
        }
        else {
          if(KvJumpToKey(kvGConfig,"connect")) {
            KvGetString(kvGConfig,"file",file,sizeof(file),"***NOTFOUND***")
            if(strcmp(file,"***NOTFOUND***")) {
              new String:dl[1024]
              Format(dl, sizeof(dl), "sound/%s", file);
              if(FileExists(dl)) {
                BEsaysoundsConsole_Debug("Precaching file '%s'...",dl)
                PrecacheSound(file, true);
                AddFileToDownloadsTable(dl);
              }
              else {
                BEsaysoundsConsole_Server("*** File '%s' not found!",dl)
              }
            }
            KvGoBack(kvGConfig)
          }
//
          if(KvJumpToKey(kvGConfig,"disconnect")) {
            KvGetString(kvGConfig,"file",file,sizeof(file),"***NOTFOUND***")
            if(strcmp(file,"***NOTFOUND***")) {
              new String:dl[1024]
              Format(dl, sizeof(dl), "sound/%s", file);
              if(FileExists(dl)) {
                BEsaysoundsConsole_Debug("Precaching file '%s'...",dl)
                PrecacheSound(file, true);
                AddFileToDownloadsTable(dl);
              }
              else {
                BEsaysoundsConsole_Server("*** File '%s' not found!",dl)
              }
            }
            KvGoBack(kvGConfig)
          }
        }
      }
    } while (KvGotoNextKey(kvGConfig))
    return true
  }
