/**
 * ======================================================================
 * BEsaysounds, Copyright (C) BehaartesEtwas@quantentunnel.de 2007-2008
 * ======================================================================
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *     Author(s):    BehaartesEtwas AT quantentunnel DOT de
 *
 * Use at your OWN risk! Please submit your changes of this
 * script to BehaartesEtwas AT quantentunnel DOT de
**/

#define BESAYSOUNDS_VERSION "0.1f"
#include <morecolors>
#include "BEsaysounds/BEsaysounds.inc"

//
// ************************************************************************************************
//
// OnPluginStart: Do the initializations that has to be done once per server session
//
public OnPluginStart()
{
//
//  Load translated messages
//
    LoadTranslations("BEsaysounds.phrases")
//
//  Enable debug?
//
    EnableBEsaysoundsDebug = false
//
//  Reset dead time
//
    isGlobalDead = false
//
//  Status ConVars
//
    g_BEsaysoundsStatus = CreateConVar("sm_BEsaysounds_status","1","Current status of the BEsaysounds plugin.",FCVAR_PLUGIN,true,0.0,true,1.0)
    CreateConVar("sm_BEsaysounds_version",BESAYSOUNDS_VERSION,"The version of 'BEsaysounds' running.",FCVAR_PLUGIN|FCVAR_SPONLY|FCVAR_REPLICATED|FCVAR_NOTIFY)
    CreateConVar("sm_BEsaysounds_build",SOURCEMOD_VERSION,"The version of 'BEsaysounds' was built on.",FCVAR_PLUGIN)
//
    HookConVarChange(g_BEsaysoundsStatus, BEsaysoundsStatus)
//
//  Load config files
//
    InitConfigs()
    LoadGConfig()
//
//  Register say commands
//
    RegConsoleCmd("say", Command_Say)
    RegConsoleCmd("say_team", Command_Say)
//
//  Register commands for user configuration, sound list and muting
//
    RegConsoleCmd("sm_saysounds", Command_Configuration)
    RegConsoleCmd("sm_soundlist", Command_Soundlist)
    RegConsoleCmd("sm_mutesays",  Command_Mute)           // sm_mute is already taken by some other plugin...
//
//  Hook round_end event to save config
//
    HookEvent("round_end", Event_RoundEnd)
    HookEvent("game_end", Event_RoundEnd)
//
//  Initialize bomb timer
//
    InitBombTimer()
//
//  Initialize event sounds
//
    InitEventSounds()
//
//  Initialize admin (=connect+disconnect) sounds
//
    InitAdminSounds()
}

//
// ************************************************************************************************
//
// OnConfigsExecuted: Do the initializations that has to be done once per map
//
public OnConfigsExecuted() {
//
//  Make sounds downloadable
//
    MakeDownloadable("saysounds")
    MakeDownloadable("c4timer")
    MakeDownloadable("events")
    MakeDownloadable("admin")
//
//  Initialize some temporary KVs
//
    kvDeadtimes = CreateKeyValues("BEsaysoundsDeadtimes")
    kvCounters = CreateKeyValues("BEsaysoundsCounters")
//
    BEsaysoundsConsole_Server("version %s initialized!",BESAYSOUNDS_VERSION)
}

//
// ************************************************************************************************
//
// Event_RoundEnd: Do end-of-round stuff
//
public Event_RoundEnd(Handle:event, const String:name[], bool:dontBroadcast) {
    BEsaysoundsConsole_Debug("End of round, saving configs...")
    SaveConfigs()
//
//  Reset per-round counters
//
    CloseHandle(kvCounters)
    kvCounters = CreateKeyValues("BEsaysoundsCounters")
//
//  Clear list of muted players
//
    CloseHandle(kvMutedPs)
    kvMutedPs = CreateKeyValues("BEsaysoundsMutedPlayers")
}

