#pragma semicolon 1

#include <sourcemod>
#include <sdktools_functions>
#include <sdktools_engine>
#include <sdktools_trace>

public Plugin:myinfo = 
{
	name	= "GetCoords",
	author	= "wS / World-Source.Ru",
	version = "1.3"
};

new Handle:get_coords_enabled;

public OnPluginStart()
{
	get_coords_enabled = CreateConVar("get_coords_enabled",	"1", "1 - GetCoords plugin ON; 0 = OFF", _, true, 0.0, true, 1.0);
	RegConsoleCmd("get_coords", get_coords);
}

public Action:get_coords(client, args)
{
	if (!(0 < client <= MaxClients) || !GetConVarBool(get_coords_enabled))
		return Plugin_Handled;

	decl Float:origin[3], Float:angles[3];
	GetClientEyePosition(client, origin); GetClientEyeAngles(client, angles);
	TR_TraceRayFilter(origin, angles, MASK_SOLID, RayType_Infinite, wS_Filter, client);

	if (!TR_DidHit())
		return Plugin_Handled;

	new ent = TR_GetEntityIndex();
	TR_GetEndPosition(origin);

	if (ent < 1)
	{
		PrintToChat(client, "%f %f %f", origin[0], origin[1], origin[2]);
		return Plugin_Handled;
	}

	decl String:class[45], String:name[65]; 
	class[0] = '\0'; GetEntityClassname(ent, class, 45);
	name[0] = '\0'; GetEntPropString(ent, Prop_Data, "m_iName", name, 65);
	GetEntPropVector(ent, Prop_Send, "m_vecOrigin", origin);
	PrintToChat(client, "\x01classname = '\x04%s\x01'\nindex = '\x04%d\x01', targetname = '\x04%s\x01'\norigin = %f %f %f", class, ent, name, origin[0], origin[1], origin[2]);

	return Plugin_Handled;
}

public bool:wS_Filter(ent, mask, any:client)
{
	return client != ent;
}