/*
Description:

Allows players to drop all grenades of your inventory

This plugin has been rewritten from the original made by member: Rodipm
Original thread: http://forums.alliedmods.net/showthread.php?t=172315

The cause of rewriting the plugin? Support bugs and add cvars.

I removed knife drop function.

Bugs fixed:

Infinite grenades: http://forums.alliedmods.net/showpost.php?p=1599372&postcount=11

CVARs:

sm_grenadedrop_enabled = 1/0 - Plugin is enabled/disabled.
sm_drop_he = 0/1 - Allow drop HE Grenades?
sm_drop_smoke = 0/1 Allow drop SMOKE Grenades?
sm_drop_flash = 0/1 Allow drop FLASH Grenades?
sm_grenadedrop_version - Current plugin version

Changelog:

* Version 1.0.0 *
Initial Release
*/

#include <sourcemod>
#include <sdktools>
#include <cstrike>

#define HEGRENADE_AMMO 11
#define FLASH_AMMO 12
#define SMOKE_AMMO 13
#define PLUGIN_VERSION "Build 1.0.0"

new Handle:gGrenadeDropEnabled = INVALID_HANDLE;
new Handle:gAllowDropHe = INVALID_HANDLE;
new Handle:gAllowDropSmoke = INVALID_HANDLE;
new Handle:gAllowDropFlash = INVALID_HANDLE;
new GrenadeDropEnabled;
new AllowDropHe;
new AllowDropSmoke;
new AllowDropFlash;

public Plugin:myinfo = {
	name = "SM: Grenade Drop",
	author = "Rodrigo286",
	description = "Allows players to drop all grenades of your inventory",
    version = PLUGIN_VERSION,
	url = "http://forums.alliedmods.net/showthread.php?t=224570"
}

public OnPluginStart()
{
	CreateConVar("sm_grenadedrop_version", PLUGIN_VERSION, "\"SM: Grenade Drop\" version", FCVAR_NONE|FCVAR_SPONLY|FCVAR_NOTIFY);

	gGrenadeDropEnabled = CreateConVar("sm_grenadedrop_enabled", "1", "SM: Grenade Drop plugin is enabled?");
	gAllowDropHe = CreateConVar("sm_drop_he", "1", "Allow drop he grenades?");
	gAllowDropSmoke = CreateConVar("sm_drop_smoke", "1", "Allow drop smoke grenades?");
	gAllowDropFlash = CreateConVar("sm_drop_flash", "1", "Allow drop flash grenades?");
	AutoExecConfig(true, "sm_grenade_drop");

	AddCommandListener(Drop, "drop");

	HookConVarChange(gGrenadeDropEnabled, ConVarChange);
	GrenadeDropEnabled = GetConVarBool(gGrenadeDropEnabled);
	HookConVarChange(gAllowDropHe, ConVarChange);
	AllowDropHe = GetConVarBool(gAllowDropHe);
	HookConVarChange(gAllowDropSmoke, ConVarChange);
	AllowDropSmoke = GetConVarBool(gAllowDropSmoke);
	HookConVarChange(gAllowDropFlash, ConVarChange);
	AllowDropFlash = GetConVarBool(gAllowDropFlash);
}

public ConVarChange(Handle:convar, const String:oldValue[], const String:newValue[])
{
	GrenadeDropEnabled = GetConVarBool(gGrenadeDropEnabled);
	AllowDropHe = GetConVarBool(gAllowDropHe);
	AllowDropSmoke = GetConVarBool(gAllowDropSmoke);
	AllowDropFlash = GetConVarBool(gAllowDropFlash);
}

public Action:Drop(client, const String:command[], argc)
{
	if(GrenadeDropEnabled != 1)
		return Plugin_Handled;

	decl String:name[80];
	new wpindex = GetEntPropEnt(client, Prop_Data, "m_hActiveWeapon");

	if(!IsValidEntity(wpindex))
		return Plugin_Handled;

	GetEntityClassname(wpindex, name, sizeof(name));

	if(IsValidClient(client))
	{
		if(StrEqual(name, "weapon_flashbang", false))
		{
			if(AllowDropFlash != 1)
				return Plugin_Handled;

			new flash = GetEntProp(client, Prop_Send, "m_iAmmo", _, FLASH_AMMO);

			if(flash >= 1)
			{
				SetEntProp(client, Prop_Send, "m_iAmmo", -1, _, FLASH_AMMO);
				CS_DropWeapon(client, wpindex, true, true);
				RemovePlayerItem(client, wpindex); 
			}

			return Plugin_Handled;
		}
		else if(StrEqual(name, "weapon_hegrenade", false))
		{
			if(AllowDropHe != 1)
				return Plugin_Handled;

			new he = GetEntProp(client, Prop_Send, "m_iAmmo", _, HEGRENADE_AMMO);

			if(he >= 1)
			{
				SetEntProp(client, Prop_Send, "m_iAmmo", -1, _, HEGRENADE_AMMO);
				CS_DropWeapon(client, wpindex, true, true);
				RemovePlayerItem(client, wpindex); 
			}

			return Plugin_Handled;
		}
		else if(StrEqual(name, "weapon_smokegrenade", false))
		{
			if(AllowDropSmoke != 1)
				return Plugin_Handled;

			new smoke = GetEntProp(client, Prop_Send, "m_iAmmo", _, SMOKE_AMMO);

			if(smoke >= 1)
			{
				SetEntProp(client, Prop_Send, "m_iAmmo", -1, _, SMOKE_AMMO);
				CS_DropWeapon(client, wpindex, true, true);
				RemovePlayerItem(client, wpindex); 
			}

			return Plugin_Handled;
		}
	}

	return Plugin_Continue;
}

public IsValidClient(client) 
{ 
    if ( !( 1 <= client <= MaxClients ) || !IsClientInGame(client) ) 
        return false; 
     
    return true; 
}