// =============================================================
// >> INCLUDES
// =============================================================
#include <sourcemod>
#include <sdktools>
#include <sdkhooks>


// =============================================================
// >> PLUGIN INFORMATION
// =============================================================
public Plugin:myinfo = 
{
	name 		= "[ BuyZone Protector ]",
	author 		= "Regent",
	description = "protects certain time players, which inside of their buy zone",
	version 	= "2.0",
	url 		= ""
};


// =============================================================
// >> DEFINES
// =============================================================
#define EFFECT_MODEL		"materials/sprites/lgtning.vmt"


// =============================================================
// >> CONSOLE VARIABLES
// =============================================================
new Handle:	g_hConVar_sCTLineColor;
new Handle:	g_hConVar_sTLineColor;
new Handle:	g_hConVar_flProtectionTime;
new Handle:	g_hConVar_bDrawProtectionZone;


// =============================================================
// >> SHADOW CONSOLE VARIABLES
// =============================================================
new Float:	g_flProtectionTime;
new bool:	g_bDrawProtectionZone;
new 		g_iCTLineColor[4];
new 		g_iTLineColor[4];


// =============================================================
// >> GLOBAL VARIABLES
// =============================================================
new Handle:	g_hProtectionTimer	= INVALID_HANDLE;

new Float:	g_flTBuyZoneMins[2][3];
new Float:	g_flTBuyZoneMaxs[2][3];
new Float:	g_flCTBuyZoneMins[2][3];
new Float:	g_flCTBuyZoneMaxs[2][3];

new			g_iModelEntity;


// =============================================================
// >> PLUGIN SOURCE CODE
// =============================================================
public OnPluginStart()
{
	g_hConVar_bDrawProtectionZone 	= CreateConVar("sm_bzp_drawzone", "1", "ENG: draw (1) or not (0) zone of protection\nRUS: рисовать (1) или нет (0) зону защиты", FCVAR_PLUGIN);
	g_hConVar_flProtectionTime 		= CreateConVar("sm_bzp_prottime", "20.0", "ENG: how long in seconds will lasts protection of buyzone\nRUS: как долго в секундах будет длится защита зон покупок", FCVAR_PLUGIN);
	g_hConVar_sCTLineColor 			= CreateConVar("sm_bzp_ctlinecolor", "0 0 255 255", "ENG: color of lines ct zone\nRUS: цвет зоны КТ", FCVAR_PLUGIN);
	g_hConVar_sTLineColor 			= CreateConVar("sm_bzp_tlinecolor", "255 0 0 255", "ENG: color of lines t zone\nRUS: цвет зоны Т", FCVAR_PLUGIN);
	
	HookConVarChange(g_hConVar_bDrawProtectionZone, Hook_ConVarChanged);
	HookConVarChange(g_hConVar_flProtectionTime, 	Hook_ConVarChanged);
	HookConVarChange(g_hConVar_sCTLineColor, 		Hook_ConVarChanged);
	HookConVarChange(g_hConVar_sTLineColor, 		Hook_ConVarChanged);
	
	HookEvent("round_start", Ev_RoundStart);
	AutoExecConfig(true, "buyzone_protector");
	CreateConVar("sm_bzp_version",	"2.0 by Regent", "version of plugin", FCVAR_PLUGIN|FCVAR_NOTIFY|FCVAR_DONTRECORD);
}

public Hook_ConVarChanged(Handle:hConVar, const String:sOldValue[], const String:sNewValue[])
{
	if ( hConVar == g_hConVar_bDrawProtectionZone )
	{
		g_bDrawProtectionZone = GetConVarBool(g_hConVar_bDrawProtectionZone);
	}
	else if ( hConVar == g_hConVar_flProtectionTime )
	{
		g_flProtectionTime = GetConVarFloat(g_hConVar_flProtectionTime);
	}
	else if ( hConVar == g_hConVar_sCTLineColor )
	{
		StringToIntArray(sNewValue, g_iCTLineColor);
	}
	else if ( hConVar == g_hConVar_sTLineColor )
	{
		StringToIntArray(sNewValue, g_iTLineColor);
	}
}

public OnPluginEnd()
{
	if ( g_hProtectionTimer != INVALID_HANDLE )
	{
		KillTimer(g_hProtectionTimer);
		g_hProtectionTimer = INVALID_HANDLE;
	}
}

public OnMapStart()
{
	new iEntity = -1;
	while ((iEntity = FindEntityByClassname(iEntity, "func_buyzone")) != -1)
    {
		decl Float:flOrigin[3], Float:flVecMins[3], Float:flVecMaxs[3];
		new iTeam = GetEntProp(iEntity, Prop_Send, "m_iTeamNum");
		GetEntPropVector(iEntity, Prop_Send, "m_vecMins", flVecMins);
		GetEntPropVector(iEntity, Prop_Send, "m_vecMaxs", flVecMaxs);
		GetEntPropVector(iEntity, Prop_Send, "m_vecOrigin", flOrigin);
		
		if ( iTeam == 2 )
		{
			g_flTBuyZoneMins[0][0] = flOrigin[0] + flVecMins[0];
			g_flTBuyZoneMins[0][1] = flOrigin[1] + flVecMins[1];
			g_flTBuyZoneMins[0][2] = flOrigin[2] + flVecMins[2];
			g_flTBuyZoneMaxs[0][0] = flOrigin[0] + flVecMaxs[0];
			g_flTBuyZoneMaxs[0][1] = flOrigin[1] + flVecMaxs[1];
			g_flTBuyZoneMaxs[0][2] = flOrigin[2] + flVecMaxs[2];
			
			g_flTBuyZoneMins[1][0] = flOrigin[0] + flVecMins[0];
			g_flTBuyZoneMins[1][1] = flOrigin[1] + flVecMaxs[1];
			g_flTBuyZoneMins[1][2] = flOrigin[2] + flVecMins[2];
			g_flTBuyZoneMaxs[1][0] = flOrigin[0] + flVecMaxs[0];
			g_flTBuyZoneMaxs[1][1] = flOrigin[1] + flVecMins[1];
			g_flTBuyZoneMaxs[1][2] = flOrigin[2] + flVecMaxs[2];
		}
		else if ( iTeam == 3 )
		{
			g_flCTBuyZoneMins[0][0] = flOrigin[0] + flVecMins[0];
			g_flCTBuyZoneMins[0][1] = flOrigin[1] + flVecMins[1];
			g_flCTBuyZoneMins[0][2] = flOrigin[2] + flVecMins[2];
			g_flCTBuyZoneMaxs[0][0] = flOrigin[0] + flVecMaxs[0];
			g_flCTBuyZoneMaxs[0][1] = flOrigin[1] + flVecMaxs[1];
			g_flCTBuyZoneMaxs[0][2] = flOrigin[2] + flVecMaxs[2];
			
			g_flCTBuyZoneMins[1][0] = flOrigin[0] + flVecMins[0];
			g_flCTBuyZoneMins[1][1] = flOrigin[1] + flVecMaxs[1];
			g_flCTBuyZoneMins[1][2] = flOrigin[2] + flVecMins[2];
			g_flCTBuyZoneMaxs[1][0] = flOrigin[0] + flVecMaxs[0];
			g_flCTBuyZoneMaxs[1][1] = flOrigin[1] + flVecMins[1];
			g_flCTBuyZoneMaxs[1][2] = flOrigin[2] + flVecMaxs[2];
		}
	}
	
	g_iModelEntity = PrecacheModel(EFFECT_MODEL);
}

public OnConfigsExecuted()
{
	g_bDrawProtectionZone = GetConVarBool(g_hConVar_bDrawProtectionZone);
	g_flProtectionTime = GetConVarFloat(g_hConVar_flProtectionTime);
	
	decl String:sBuffer[20];
	GetConVarString(g_hConVar_sCTLineColor, sBuffer, sizeof(sBuffer) - 1);
	StringToIntArray(sBuffer, g_iCTLineColor);
	
	GetConVarString(g_hConVar_sTLineColor, sBuffer, sizeof(sBuffer) - 1);
	StringToIntArray(sBuffer, g_iTLineColor);
	
	for ( new i = 1; i <= MaxClients; i++ )
	{
		if ( IsClientInGame(i) )
		{
			OnClientPutInServer(i);
		}
	}
}

StringToIntArray(const String:sInput[], Array[])
{
	decl String:sBuffer[4][5]
	ExplodeString(sInput, " ", sBuffer, sizeof(sBuffer), sizeof(sBuffer[]) - 1);
	Array[0] = StringToInt(sBuffer[0]);
	Array[1] = StringToInt(sBuffer[1]);
	Array[2] = StringToInt(sBuffer[2]);
	Array[3] = StringToInt(sBuffer[3]);
}

public OnClientPutInServer(iClient)
{
	SDKHook(iClient, SDKHook_OnTakeDamage, OnTakeDamage);
}

public OnClientDisconnect_Post(iClient)
{
	SDKUnhook(iClient, SDKHook_OnTakeDamage, OnTakeDamage);
}

public Action:OnTakeDamage(iClient, &iAttacker, &iInflictor, &Float:flDamage, &iDamageType)
{
	if ( g_hProtectionTimer != INVALID_HANDLE )
	{
		if ( GetEntProp(iClient, Prop_Send, "m_bInBuyZone") == 1 )
		{
			if ( GetClientTeam(iClient) == 2 )
			{
				if ( IsClientInside(iClient, g_flTBuyZoneMins[0], g_flTBuyZoneMaxs[0]) )
				{
					flDamage = 0.0;
					return Plugin_Changed;
				}
			}
			else if ( GetClientTeam(iClient) == 3 )
			{
				if ( IsClientInside(iClient, g_flCTBuyZoneMins[0], g_flCTBuyZoneMaxs[0]) )
				{
					flDamage = 0.0;
					return Plugin_Changed;
				}
			}
		}
	}
			
	return Plugin_Continue;
}

public Ev_RoundStart(Handle:hEvent, const String:sEvName[], bool:bSilent)
{
	if ( g_bDrawProtectionZone )
	{
		DrawZoneByCoords(g_flCTBuyZoneMins, g_flCTBuyZoneMaxs, g_iCTLineColor);
		DrawZoneByCoords(g_flTBuyZoneMins, g_flTBuyZoneMaxs, g_iTLineColor);
	}
	
	if ( g_hProtectionTimer != INVALID_HANDLE )
	{
		KillTimer(g_hProtectionTimer);
	}
	g_hProtectionTimer = CreateTimer(g_flProtectionTime, Timer_RemoveProtection, _, TIMER_FLAG_NO_MAPCHANGE);
}

public Action:Timer_RemoveProtection(Handle:hTimer, any:data)
{
	g_hProtectionTimer = INVALID_HANDLE;
	return Plugin_Stop;
}

DrawZoneByCoords(const Float:flMins[2][3], const Float:flMaxs[2][3], const iColor[4])
{
	decl Float:flBuffer1[3], Float:flBuffer2[3];
	
	flBuffer1[0] = flMaxs[0][0];
	flBuffer1[1] = flMaxs[0][1];
	flBuffer1[2] = flMaxs[0][2];
	flBuffer2[0] = flMaxs[1][0];
	flBuffer2[1] = flMaxs[1][1];
	flBuffer2[2] = flMaxs[0][2];
	
	TE_SetupBeamPoints(flBuffer1, flBuffer2, g_iModelEntity, 0, 0, 0, g_flProtectionTime, 20.0, 20.0, 0, 0.0, iColor, 0);
	TE_SendToAll();
	
	flBuffer1[0] = flMaxs[0][0];
	flBuffer1[1] = flMaxs[0][1];
	flBuffer1[2] = flMaxs[0][2];
	flBuffer2[0] = flMins[1][0];
	flBuffer2[1] = flMins[1][1];
	flBuffer2[2] = flMaxs[0][2];
	TE_SetupBeamPoints(flBuffer1, flBuffer2, g_iModelEntity, 0, 0, 0, g_flProtectionTime, 20.0, 20.0, 0, 0.0, iColor, 0);
	TE_SendToAll();
	
	flBuffer1[0] = flMins[0][0];
	flBuffer1[1] = flMins[0][1];
	flBuffer1[2] = flMaxs[0][2];
	flBuffer2[0] = flMaxs[1][0];
	flBuffer2[1] = flMaxs[1][1];
	flBuffer2[2] = flMaxs[0][2];
	TE_SetupBeamPoints(flBuffer1, flBuffer2, g_iModelEntity, 0, 0, 0, g_flProtectionTime, 20.0, 20.0, 0, 0.0, iColor, 0);
	TE_SendToAll();
	
	flBuffer1[0] = flMins[0][0];
	flBuffer1[1] = flMins[0][1];
	flBuffer1[2] = flMaxs[0][2];
	flBuffer2[0] = flMins[1][0];
	flBuffer2[1] = flMins[1][1];
	flBuffer2[2] = flMaxs[0][2];
	TE_SetupBeamPoints(flBuffer1, flBuffer2, g_iModelEntity, 0, 0, 0, g_flProtectionTime, 20.0, 20.0, 0, 0.0, iColor, 0);
	TE_SendToAll();
}

bool:IsClientInside(const &iClient, const Float:flMins[3], const Float:flMaxs[3])
{
	decl Float:flOrigin[3];
	GetClientAbsOrigin(iClient, flOrigin);
	
	if (flOrigin[0] >= flMins[0] && flOrigin[0] <= flMaxs[0] &&
		flOrigin[1] >= flMins[1] && flOrigin[1] <= flMaxs[1] &&
		flOrigin[2] >= flMins[2] && flOrigin[2] <= flMaxs[2])
	{
		return true;
	}
	else
	{
		return false;
	}
}