#pragma semicolon 1
#include <sourcemod>

//--------------------------------------------------------------------------------------
// CONSOLE VARIABLES
//--------------------------------------------------------------------------------------
new Handle:		g_hConVar_MaxDigits				= INVALID_HANDLE;

//--------------------------------------------------------------------------------------
// VARIABLES
//--------------------------------------------------------------------------------------
new				g_iMaxDigits;

public Plugin:myinfo =
{
	name = "[ Name Controller ]",
	description = "",
	author = "Regent",
	version = "1.1",
	url = "<- http://all4css.ru ->"
};

public OnPluginStart()
{
	g_hConVar_MaxDigits = CreateConVar("sm_maxdigitsinname", "5", 
										"maximum digits in client's nickname, -1 to disable", _,
										true, 1.0);
	HookConVarChange(g_hConVar_MaxDigits, ConVar_Callback);
	
	HookEvent("player_changename", Event_PlayerChangeName);
}
public OnClientPutInServer(iClient)
{
	decl String:szName[MAX_NAME_LENGTH];
	GetClientName(iClient, szName, sizeof(szName));
	
	if ( CheckNickName(szName) )
		KickClient(iClient, "в нике не должно быть больше %d цифр", g_iMaxDigits);
}

public Event_PlayerChangeName(Handle:event, const String:name[], bool:silent)
{
	decl String:szName[MAX_NAME_LENGTH];
	GetEventString(event, "newname", szName, sizeof(szName));
	
	if ( CheckNickName(szName) )
	{
		new iClient = GetClientOfUserId(GetEventInt(event, "userid"));
		KickClient(iClient, "в нике не должно быть больше %d цифр", g_iMaxDigits);
	}
}
public ConVar_Callback(Handle:cvar, const String:oldVal[], const String:newVal[])
{
	new iValue = StringToInt(newVal);
	if ( iValue != 0 )
		g_iMaxDigits = iValue;
	else
		LogError("incorrect value of sm_maxdigitsinname");
}

bool:CheckNickName(String:szString[])
{
	new iNumberCount = 0;
	for (new i = 0; i < strlen(szString); i++)
		if ( IsCharNumeric(szString[i]) )
		{
			iNumberCount++;
			if ( iNumberCount > g_iMaxDigits )
				return true;
		}
	return false;
}