#pragma semicolon 1

#include <sourcemod>
#include <sdktools_sound>
#include <sdktools_stringtables>

public Plugin:myinfo = 
{
	name	= "Round Start Music",
	author	= "wS / Schmidt",
	version	= "1.1",
	url		= "http://world-source.ru/"
};

new Handle:g_Array;
new g_Sounds_Count;
new g_CurrPos = -1;

public OnPluginStart()
{
	new Handle:dir = OpenDirectory("sound/round_start_music");
	if (dir == INVALID_HANDLE)
	{
		SetFailState("Не удалось открыть \"sound/round_start_music\"");
		return;
	}
	g_Array = CreateArray(150);
	decl String:SoundName[150], FileType:type;
	while (ReadDirEntry(dir, SoundName, 150, type))
	{
		if (type == FileType_File && StrContains(SoundName, ".ztmp") == -1)
		{
			if (StrContains(SoundName, ".mp3") > 0 || StrContains(SoundName, ".wav") > 0)
			{
				Format(SoundName, 150, "round_start_music/%s", SoundName);
				PushArrayString(g_Array, SoundName);
			}
		}
	}
	CloseHandle(dir);

	if ((g_Sounds_Count = GetArraySize(g_Array)) < 1)
	{
		SetFailState("В \"sound/round_start_music\" нет звуков");
		return;
	}

	HookEvent("round_freeze_end", round_freeze_end, EventHookMode_PostNoCopy);
}

public OnMapStart()
{
	decl String:SoundName[150];
	for (new i = 0; i < g_Sounds_Count; i++)
	{
		GetArrayString(g_Array, i, SoundName, 150); PrecacheSound(SoundName, true);
		Format(SoundName, 150, "sound/%s", SoundName); AddFileToDownloadsTable(SoundName);
	}
}

public round_freeze_end(Handle:event, const String:name[], bool:silent)
{
	if (++g_CurrPos >= g_Sounds_Count) g_CurrPos = 0;
	decl String:SoundName[150]; GetArrayString(g_Array, g_CurrPos, SoundName, 150);
	EmitSoundToAll(SoundName);
}