#include <sourcemod>

new Handle:Enabled 
new Handle:HsAdd 
new Handle:HgAdd
new Handle:HkAdd  
new Handle:HpAdd 
new Handle:MaxHp 
new Handle:Announce

public Plugin:myinfo =  
{ 
    name = "Kill Bonus", 
    author = "Fredd", 
    description = "Gives someone Hp on a kill", 
    version = "1.0.4", 
    url = "www.hlmod.ru" 
} 

public OnPluginStart() 
{ 
    CreateConVar("kb_version", "1.0.4", "Kill Bonus Version", FCVAR_PLUGIN|FCVAR_SPONLY|FCVAR_REPLICATED|FCVAR_NOTIFY) 
     
    Enabled    =    CreateConVar("kb_enabled",     "1",     "Enables - Disables the Kill bonus plugin", FCVAR_NOTIFY) 
    HsAdd    =    CreateConVar("kb_headshot",     "10",     "value #  equals the amount of hp to add, when attacker headshots", FCVAR_NOTIFY) 
    HgAdd    =    CreateConVar("kb_hegrenade",     "10",     "value #  equals the amount of hp to add, when attacker hegrenade", FCVAR_NOTIFY)
    HkAdd    =    CreateConVar("kb_knife",     "20",     "value #  equals the amount of hp to add, when attacker knife", FCVAR_NOTIFY) 
    HpAdd    =    CreateConVar("kb_hp",         "5",    "value # equals the amount of hp to add, when the someone kills someone", FCVAR_NOTIFY) 
    MaxHp    =     CreateConVar("kb_maxhp",    "110",    "value # equals the max hp that the attacker could get", FCVAR_NOTIFY) 
    Announce    =     CreateConVar("kb_announce",    "1",    "Enables - Disables announce", FCVAR_NOTIFY) 
     
    HookEvent("player_death", OnPlayerDeath);
    LoadTranslations("plugin.killbonus");

    AutoExecConfig(true, "Kill_Bonus");
} 

public Action:OnPlayerDeath(Handle:event, const String:name[], bool:dontBroadcast)
{
    new client = GetClientOfUserId(GetEventInt(event, "userid"));
    new attacker =  GetClientOfUserId(GetEventInt(event, "attacker"));
    
    new Max = GetConVarInt(MaxHp);
    new CurrentHp    = GetClientHealth(attacker);
    new adverts =  GetConVarInt(Announce);
    
    if(!GetConVarBool(Enabled))
        return;
    
    if(CurrentHp >= Max)
        return;

    new bool:headshot = GetEventBool(event, "headshot");
    
    new String:Weapon[32];
    GetEventString(event, "weapon", Weapon, sizeof(Weapon));


    if (client && attacker && GetClientTeam(client) != GetClientTeam(attacker))
    {	
        if(!strcmp(Weapon, "hegrenade", false))
        {
            new Hg    = GetConVarInt(HgAdd);
            if((CurrentHp + Hg) > Max)
            {        
                SetEntProp(attacker, Prop_Send, "m_iHealth", Max);
                if (adverts)
                {
                PrintToChat(attacker, "%t", "hegrenadehp", Max - CurrentHp);
                }
            } 
            else 
            {
                SetEntProp(attacker, Prop_Send, "m_iHealth", Hg + CurrentHp);
                if (adverts)
                {
                    PrintToChat(attacker, "%t", "hegrenadehp", Hg);
                }
            }
        }
	
        else if(!strcmp(Weapon, "knife", false))
        {
            new Hk    = GetConVarInt(HkAdd)
            if((CurrentHp + Hk) > Max)
            {        
                SetEntProp(attacker, Prop_Send, "m_iHealth", Max); 
                if (adverts)
                {
                    PrintToChat(attacker, "%t", "knifehp", Max - CurrentHp);
                }           
            } 
            else
            {
                SetEntProp(attacker, Prop_Send, "m_iHealth", Hk + CurrentHp);
                if (adverts)
                {
                    PrintToChat(attacker, "%t", "knifehp", Hk);
                }  
            }
        }

        else if(headshot)
        {
            new Hs    = GetConVarInt(HsAdd);
            if((CurrentHp + Hs) > Max)
            {        
                SetEntProp(attacker, Prop_Send, "m_iHealth", Max);
                if (adverts)
                {
                    PrintToChat(attacker, "%t", "headshothp", Max - CurrentHp);
                } 
            } 
            else 
            {
                SetEntProp(attacker, Prop_Send, "m_iHealth", Hs + CurrentHp);
            
                if (adverts)
                {
                    PrintToChat(attacker, "%t", "headshothp", Hs);
                }  
            }
        }
        else
        {
            new Hp     = GetConVarInt(HpAdd);
            if((CurrentHp + Hp) > Max)
            {        
                SetEntProp(attacker, Prop_Send, "m_iHealth", Max);
                if (adverts)
                {
                    PrintToChat(attacker, "%t", "killhp", Max - CurrentHp);
                }
            } 
            else 
            {
                SetEntProp(attacker, Prop_Send, "m_iHealth", Hp + CurrentHp);
            
                if (adverts)
                {
                    PrintToChat(attacker, "%t", "killhp", Hp);
                }
            }    
            
        }
    }
}