#pragma semicolon 1

#include <sourcemod>
#include <sdktools>
#include <sdkhooks>
#include <adminmenu>
#undef REQUIRE_PLUGIN
#include <updater>
#include <morecolors>

#define ADMIN_LEVEL		ADMFLAG_ROOT

#define TEAM_ALL 1
#define TEAM_ONE 2
#define TEAM_TWO 3

#define UPDATE_URL	""	// Ololo

new bool:b_late;

new Handle:h_menu,
	Handle:h_hETitleMenu,
	Handle:h_PropsMenu,
	Handle:h_RoteMenu,
	Handle:h_ColorMenu,
	Handle:h_SettingsMenu;

new Handle:blocker_en, Handle:h_anonce, 
	bool:b_enabled, bool:b_anonce,
	Handle:Block_min_player, i_min_players, 
	Handle:h_printchat, bool:g_printchat,
	Handle:Block_accounting_teams, bool:acc_teams,
	Handle:blocker_game_m, bool:b_game_m,
	Handle:blocker_autosave, bool:b_autosave,
	Handle:Block_AutoUpdateEnable, bool:b_autoup;
	
new Handle:kv_list, 
	Handle:data_props;

new String:s_MapName[64],
	String:g_sPropList[64][256];

public Plugin:myinfo = 
{
	name = "Blocker passes",
	author = ">>Satan<<",
	description = "Blocker passes on maps",
	version = "1.2.0",
	url = "http://hlmod.ru/"
};

public APLRes:AskPluginLoad2(Handle:myself, bool:late, String:error[], err_max)
{
	b_late = late;
	return APLRes_Success;
}

public OnPluginStart() 
{
	
	h_hETitleMenu 	= CreateMenu(MenuPropMenuHandler);
	SetMenuTitle(h_hETitleMenu, "| Управление предметами |");
	SetMenuExitBackButton(h_hETitleMenu, true);
	
	AddMenuItem(h_hETitleMenu, "PropsMenu", 	"Меню предметов");
	AddMenuItem(h_hETitleMenu, "ColorMenu", 	"Меню покраски");
	AddMenuItem(h_hETitleMenu, 	"", 		"", ITEMDRAW_SPACER);
	AddMenuItem(h_hETitleMenu, "SaveProps", 	"Сохранить предметы");
	
	
	h_RoteMenu = CreateMenu(PropRoteMenuHandle);
	SetMenuTitle(h_RoteMenu, "| Повернуть предмет |");
	SetMenuExitBackButton(h_RoteMenu, true);
	
	AddMenuItem(h_RoteMenu, "RotateX+45", "Повернуть на +45° по оси X");
	AddMenuItem(h_RoteMenu, "RotateX-45", "Повернуть на -45° по оси X");
	AddMenuItem(h_RoteMenu, "RotateY+45", "Повернуть на +45° по оси Y");
	AddMenuItem(h_RoteMenu, "RotateY-45", "Повернуть на -45° по оси Y");
	AddMenuItem(h_RoteMenu, "RotateZ+45", "Повернуть на +45° по оси Z");
	AddMenuItem(h_RoteMenu, "RotateZ-45", "Повернуть на -45° по оси Z");
	
	h_ColorMenu = CreateMenu(MenuPropColorHandler);
	SetMenuTitle(h_ColorMenu, "| Окрасить предмет |");
	SetMenuExitBackButton(h_ColorMenu, true);	
	
	AddMenuItem(h_ColorMenu, "color1", "Красный");
	AddMenuItem(h_ColorMenu, "color2", "Зеленый");
	AddMenuItem(h_ColorMenu, "color3", "Синий");
	AddMenuItem(h_ColorMenu, "color4", "Желтый");
	AddMenuItem(h_ColorMenu, "color5", "Голубой");
	AddMenuItem(h_ColorMenu, "color6", "Розовый\n ");
	AddMenuItem(h_ColorMenu, "color7", "Прозрачный (25%)");
	AddMenuItem(h_ColorMenu, "color8", "Прозрачный (100%)");
	
	blocker_en = CreateConVar("sm_bp_enable", 					"1", 	"1|0 Включить/Выключить плагин", _, true, 0.0, true, 1.0);
	b_enabled = GetConVarBool(blocker_en);
	HookConVarChange(blocker_en, OnConVarChanged);
	
	h_anonce = CreateConVar("sm_bp_anonce", 					"1", 	"1|0 Включить/Выключить сообщения плагина о статусе блокировки", FCVAR_NOTIFY, true, 0.0, true, 1.0);
	b_anonce = GetConVarBool(h_anonce);
	HookConVarChange(h_anonce, OnConVarChanged);
	
	h_printchat = CreateConVar("sm_bp_amode", 					"1", 	"Тип отображения сообщений (0 - HUD, 1 - Чат)", _, true, 0.0, true, 1.0);
	g_printchat = GetConVarBool(h_printchat);
	HookConVarChange(h_printchat, OnConVarChanged);
	
	Block_min_player = CreateConVar("sm_bp_minplayer", 			"10", 	"Минимальное кол-во игроков для автомат. удаления ВСЕХ пропсов, блокирующих проход", FCVAR_NOTIFY, true, 0.0, true, 64.0);
	i_min_players = GetConVarInt(Block_min_player);
	HookConVarChange(Block_min_player, OnConVarChanged);
	
	Block_accounting_teams = CreateConVar("sm_bp_onlyct", 		"0", 	"1|0 Включить/Выключить подсчёт ТОЛЬКО игроков из команды КТ для решения о блокировке", FCVAR_NOTIFY, true, 0.0, true, 1.0);
	acc_teams = GetConVarBool(Block_accounting_teams);
	HookConVarChange(Block_accounting_teams, OnConVarChanged);
	
	blocker_autosave = CreateConVar("sm_bp_autosave", 			"0", 	"1|0 Включить/Выключить автоматическое сохранение пропсов в конце каждого раунда", FCVAR_NOTIFY, true, 0.0, true, 1.0);
	b_autosave = GetConVarBool(blocker_autosave);
	HookConVarChange(blocker_autosave, OnConVarChanged);
	
	blocker_game_m = CreateConVar("sm_bp_enableadmmenu",		"1",	"1|0 Включить/Выключить меню управления плагином в игре",  _, true, 0.0, true, 1.0);
	b_game_m = GetConVarBool(blocker_game_m);
	HookConVarChange(blocker_game_m, OnConVarChanged);
	
	Block_AutoUpdateEnable = CreateConVar("sm_bp_autoupdate",	"0",	"Включить/Выключить авто обновление.",  _, true, 0.0, true, 255.0);
	b_autoup = GetConVarBool(Block_AutoUpdateEnable);
	HookConVarChange(Block_AutoUpdateEnable, OnConVarChanged);
	
	AutoExecConfig(true, "Blocker");
	LoadTranslations("blocker_passes.phrases"); 

	data_props = CreateArray();
	
	HookEvent("round_start", OnRoundStart);
	HookEvent("round_end", OnRoundEnd);
	
	RegAdminCmd("sm_bpmenu", CommandAdminPasses, ADMFLAG_ROOT);
	RegAdminCmd("sm_getaimpos", CommandGetPoss, ADMFLAG_ROOT);
	
	if (b_late){
		PreloadConfigs();
		b_late = false;
	}
	
	if (b_autoup){
		if (LibraryExists("updater")){
			Updater_AddPlugin(UPDATE_URL);
		}
	}
	
	if (b_game_m){
		new Handle:topmenu;
		if (LibraryExists("adminmenu") && ((topmenu = GetAdminTopMenu()) != INVALID_HANDLE)){
			OnAdminMenuReady(topmenu);
		}
	}
}

public OnLibraryAdded(const String:name[])
{
	if (!b_autoup){
		return;
	}
	if (StrEqual(name, "updater"))
		Updater_AddPlugin(UPDATE_URL);
}

public OnMapStart() 
{
	PreloadConfigs();
	LoadPropsMenu();
	
	ServerCommand("sv_tags blocker_passes");
}

public OnMapEnd()
{
	CloseHandle(kv_list);
}

PreloadConfigs()
{
	GetCurrentMap(s_MapName, sizeof(s_MapName));
	
	new String:path[PLATFORM_MAX_PATH];
	BuildPath(Path_SM, path, sizeof(path), "data/blocker_passes/");
	
	if (!DirExists(path)){
		CreateDirectory(path, 511);
	}
	
	kv_list = CreateKeyValues("blocker_passes");
	BuildPath(Path_SM, path, sizeof(path), "data/blocker_passes/%s.txt", s_MapName);
	FileToKeyValues(kv_list, path);
}

public Action:CommandAdminPasses(client, args)
{
	if (b_game_m){
		DisplayTopMenu(h_menu, client, TopMenuPosition_LastCategory);
	}
	return Plugin_Handled;
}

public Action:CommandGetPoss(client, args)
{
	decl Float:g_fOrigin[3];
	GetClientEyePosition(client, g_fOrigin);
	
	if(TR_DidHit(INVALID_HANDLE)){
		TR_GetEndPosition(g_fOrigin, INVALID_HANDLE);
		PrintToChat(client, "\x04[SM]\x04 Координаты: \x01%-.1f\x04; \x01%-.1f\x04; \x01%-.1f\x04.", g_fOrigin[0], g_fOrigin[1], g_fOrigin[2]);
	}
	return Plugin_Handled;
}

public OnConVarChanged(Handle:convar, const String:oldValue[], const String:newValue[])
{
	if (convar == blocker_en){
		b_enabled = bool:StringToInt(newValue);
	}else if (convar == h_anonce){
		b_anonce = bool:StringToInt(newValue);
	}else if (convar == h_printchat){
		g_printchat = bool:StringToInt(newValue);
	}else if (convar == Block_min_player){
		i_min_players = StringToInt(newValue);
	}else if (convar == Block_accounting_teams){
		acc_teams = bool:StringToInt(newValue);
	}else if (convar == blocker_autosave){
		b_autosave = bool:StringToInt(newValue);	
	}else if (convar == blocker_game_m){
		b_game_m = bool:StringToInt(newValue);	
	}else if (convar == Block_AutoUpdateEnable){
		b_autoup = bool:StringToInt(newValue);
	}
}

public OnRoundStart(Handle:event, const String:name[], bool:dontBroadcast) 
{
	if (!b_enabled){
		return;
	}
	
	ClearArray(data_props);
	
	
	new clients = GetRealClientCount(acc_teams ? TEAM_TWO : TEAM_ALL);
	
	if (clients < i_min_players){
	
		SpawnBlocks();
		
		if (!b_anonce){
			return;
		}
			
		if (acc_teams){
			switch(g_printchat){
				case 0: { PrintCenterTextAll("%t", "Blocked due to lack of CT"); }
				case 1: { CPrintToChatAll("\x05[SM Blocker Passes]\x01 %t", "Blocked due to lack of CT");}
			}
		}else{
			switch(g_printchat){
				case 0: { PrintCenterTextAll("%t", "Blocked due to lack of CT"); }
				case 1: { CPrintToChatAll("\x05[SM Blocker Passes]\x01 %t", "Block Because of the user"); }
			}
		}
	}else{
	
		if (!b_anonce){
			return;
		}
			
		switch(g_printchat){
			case 0: { PrintCenterTextAll("%t", "UnBlock B"); }
			case 1: { CPrintToChatAll("\x05[SM Blocker Passes]\x01 %t", "UnBlock B"); }
		}
	}
}

public OnRoundEnd(Handle:event, const String:name[], bool:dontBroadcast)
{
	if (b_autosave){
		SaveAllProps(0);
	}
}

public OnEntityDestroyed(entity)
{
	new index = -1;
	if ((index = FindValueInArray(data_props, entity)) != -1){
		RemoveFromArray(data_props, index);
	}
}

public OnAdminMenuReady(Handle:topmenu)
{
	if (!b_game_m){
		return;
	}
	
	if (h_menu == topmenu){
		return;
	}
	
	h_menu = topmenu;
	
	new TopMenuObject:blocker_passes = FindTopMenuCategory(h_menu, "blocker_passes");
		
	if (blocker_passes == INVALID_TOPMENUOBJECT){
		blocker_passes = AddToTopMenu(h_menu, "blocker_passes", TopMenuObject_Category, Handle_Category, INVALID_TOPMENUOBJECT, "sm_blocker_passes", ADMIN_LEVEL);
	}
			
	AddToTopMenu(h_menu,
	"sm_bp_plsettings",
	TopMenuObject_Item,
	blocker_passes_Settings,
	blocker_passes,
	"sm_bp_plsettings",
	ADMIN_LEVEL);
	
	AddToTopMenu(h_menu,
	"sm_bp_props",
	TopMenuObject_Item,
	blocker_passes_Props,
	blocker_passes,
	"sm_bp_props",
	ADMIN_LEVEL);
	
	AddToTopMenu(h_menu,
	"sm_bp_save",
	TopMenuObject_Item,
	blocker_passes_Save,
	blocker_passes,
	"sm_bp_save",
	ADMIN_LEVEL);
}


public Handle_Category( Handle:topmenu, TopMenuAction:action, TopMenuObject:object_id, param, String:buffer[], maxlength )
{
	switch(action){
		case TopMenuAction_DisplayTitle:{
			Format(buffer, maxlength, "Управление Blocker Passes");
		}
		case TopMenuAction_DisplayOption:{
			Format(buffer, maxlength, "Управление Blocker Passes");
		}
	}
}

public blocker_passes_Settings(Handle:topmenu, TopMenuAction:action, TopMenuObject:object_id, param, String:buffer[], maxlength)
{
	switch (action){
		case TopMenuAction_DisplayOption :{
			Format(buffer, maxlength, "Настройки"); 
		}
		case TopMenuAction_SelectOption :{
			ShowSettingsMenu(param);
		}
	}
}

public blocker_passes_Props(Handle:topmenu, TopMenuAction:action, TopMenuObject:object_id, param, String:buffer[], maxlength)
{
	switch (action){
		case TopMenuAction_DisplayOption :{
			Format(buffer, maxlength, "[Управление предметами]");
		}
		case TopMenuAction_SelectOption :{
			DisplayMenu(h_hETitleMenu, param, MENU_TIME_FOREVER);
		}
	}
}

public blocker_passes_Save(Handle:topmenu, TopMenuAction:action, TopMenuObject:object_id, param, String:buffer[], maxlength)
{
	switch (action){
		case TopMenuAction_DisplayOption :{
			Format(buffer, maxlength, "Сохранить предметы");
		}
		case TopMenuAction_SelectOption :{
			SaveAllProps(param);
		}
	}
}

ShowSettingsMenu(client)
{
	decl String:buffer[64];
	
	h_SettingsMenu 	= CreateMenu(MenuSettingsHandler);
	SetMenuTitle(h_SettingsMenu, "Настройки переменных плагина");
	SetMenuExitBackButton(h_SettingsMenu, true);
	
	Format(buffer, sizeof(buffer), "Плагин: %s", b_enabled ? "Включен" : "Выключен");
	AddMenuItem(h_SettingsMenu, "Enable", buffer);
	
	Format(buffer, sizeof(buffer), "Учет всех игроков: %s", acc_teams ? "Выключен" : "Включен");
	AddMenuItem(h_SettingsMenu, "Acc_Team", buffer);
	
	Format(buffer, sizeof(buffer), "Сообщения плагина: %s", b_anonce ? "Включены" : "Выключены");
	AddMenuItem(h_SettingsMenu, "Anonce", buffer);
	
	DisplayMenu(h_SettingsMenu, client, MENU_TIME_FOREVER);
}

public MenuSettingsHandler(Handle:menu, MenuAction:action, param1, param2)
{
	switch (action){
		case MenuAction_Cancel :{
			if (param2 == MenuCancel_ExitBack){
				if (h_menu != INVALID_HANDLE)
					DisplayTopMenu(h_menu, param1, TopMenuPosition_LastCategory);
			}
		}
		case MenuAction_Select :{
		
			decl String:s_Type[32];
			GetMenuItem(menu, param2, s_Type, sizeof(s_Type));
			
			if (StrEqual(s_Type, "Enable", false)){
				b_enabled = !b_enabled;
			}else if (StrEqual(s_Type, "Acc_Team", false)){
				acc_teams = !acc_teams;
			}else if (StrEqual(s_Type, "Anonce", false)){
				b_anonce = !b_anonce;
			}
			ShowSettingsMenu(param1);
		}
	}
}

public MenuPropMenuHandler(Handle:menu, MenuAction:action, param1, param2)
{
	switch (action){
		case MenuAction_Cancel :{
			if (param2 == MenuCancel_ExitBack){
				if (h_menu != INVALID_HANDLE)
					DisplayTopMenu(h_menu, param1, TopMenuPosition_LastCategory);
			}
		}
		case MenuAction_Select :{
		
			decl String:s_Type[32];
			GetMenuItem(menu, param2, s_Type, sizeof(s_Type));
			
			if (StrEqual(s_Type, "PropsMenu", false)){
				DisplayMenu(h_PropsMenu, param1, MENU_TIME_FOREVER);
			}else if (StrEqual(s_Type, "ColorMenu", false)){
				DisplayMenu(h_ColorMenu, param1, MENU_TIME_FOREVER);
			}else if (StrEqual(s_Type, "SaveProps", false)){
				SaveAllProps(param1);
			}
		}
	}
}

public PropMenuHandler(Handle:menu, MenuAction:action, param1, param2)
{
	switch (action){
		case MenuAction_Cancel :{
			if (param2 == MenuCancel_ExitBack){
				DisplayMenu(h_hETitleMenu, param1, MENU_TIME_FOREVER);
			}
		}
		case MenuAction_Select :{
		
			decl String:info[64];
			GetMenuItem(menu, param2, info, sizeof(info));
			
			new ent = -1, index = -1, index2 = StringToInt(info);
			
			decl Float:g_fOrigin[3], Float:g_fAngles[3];
			
			GetClientEyePosition(param1, g_fOrigin);
			GetClientEyeAngles(param1, g_fAngles);
			TR_TraceRayFilter(g_fOrigin, g_fAngles, MASK_SOLID, RayType_Infinite, Trace_FilterPlayers, param1);
			
			if(TR_DidHit(INVALID_HANDLE)){
			
				TR_GetEndPosition(g_fOrigin, INVALID_HANDLE);
				TR_GetPlaneNormal(INVALID_HANDLE, g_fAngles);
				GetVectorAngles(g_fAngles, g_fAngles);
				g_fAngles[0] += 90.0;
				
				if (!strcmp(info, "rote")){
					DisplayMenu(h_RoteMenu, param1, MENU_TIME_FOREVER);
					return;
				}else if (!strcmp(info, "remove")){
					if ((ent = GetClientAimTarget(param1, false)) > MaxClients){
						if ((index = FindValueInArray(data_props, ent)) != -1){
							RemoveFromArray(data_props, index);
							DeleteProp(ent);
							PrintHintText(param1, "Предмет успешно удалён!");
						}
					}else{
						PrintToChat(param1, "\x05[SM Blocker Passes]\x01 Неверный предмет!");
					}
				}else{
					CreateEntity(g_fOrigin, g_fAngles, g_sPropList[index2]);
					PrintHintText(param1, "Блокирующая перегородка успешно\nустановлена!");
				}
				DisplayMenuAtItem(menu, param1, GetMenuSelectionPosition(), MENU_TIME_FOREVER);
			}
		}
	}
}

public PropRoteMenuHandle(Handle:menu, MenuAction:action, client, param2)
{
	switch (action){
		case MenuAction_Cancel :{
			if (param2 == MenuCancel_ExitBack){
				DisplayMenu(h_PropsMenu, client, MENU_TIME_FOREVER);
			}
		}
		case MenuAction_Select :{
		
			decl String:info[64];
			GetMenuItem(menu, param2, info, sizeof(info));
			
			decl Float:RotateVec[3];
			new entity = GetClientAimTarget2(client, false);
			
			if (entity > MaxClients){
			
				GetEntPropVector(entity, Prop_Send, "m_angRotation", RotateVec);
				
				if (StrEqual(info, "RotateX+45")){
					RotateVec[0] = RotateVec[0] + 45.0;
				}else if (StrEqual(info, "RotateX-45")){
					RotateVec[0] = RotateVec[0] - 45.0;
				}else if (StrEqual(info, "RotateY+45")){
					RotateVec[1] = RotateVec[1] + 45.0;
				}else if (StrEqual(info, "RotateY-45")){
					RotateVec[1] = RotateVec[1] - 45.0;
				}else if (StrEqual(info, "RotateZ+45")){
					RotateVec[2] = RotateVec[2] + 45.0;
				}else if (StrEqual(info, "RotateZ-45")){
					RotateVec[2] = RotateVec[2] - 45.0;
				}
				TeleportEntity(entity, NULL_VECTOR, RotateVec, NULL_VECTOR);	
			}
			DisplayMenu(menu, client, MENU_TIME_FOREVER);
		}
	}
}

public MenuPropColorHandler(Handle:menu, MenuAction:action, param1, param2)
{
	switch (action){
		case MenuAction_Cancel :{
			if (param2 == MenuCancel_ExitBack){
				if (h_menu != INVALID_HANDLE){
					DisplayMenu(h_hETitleMenu, param1, MENU_TIME_FOREVER);
				}
			}
		}
		case MenuAction_Select :{
		
			decl String:s_Type[10];
			GetMenuItem(menu, param2, s_Type, sizeof(s_Type));
			
			new ent = -1;
			
			if ((ent = GetClientAimTarget(param1, false)) > MaxClients){
				if (!strcmp(s_Type, "color1")){
					SetEntityRenderColor(ent, 255, 0, 0, 255);
				}else if (!strcmp(s_Type, "color2")){
					SetEntityRenderColor(ent, 0, 255, 0, 255);
				}else if (!strcmp(s_Type, "color3")){
					SetEntityRenderColor(ent, 0, 0, 255, 255);
				}else if (!strcmp(s_Type, "color4")){
					SetEntityRenderColor(ent, 255, 255, 0, 255);
				}else if (!strcmp(s_Type, "color5")){
						SetEntityRenderColor(ent, 0, 255, 255, 255);
				}else if (!strcmp(s_Type, "color6")){
					SetEntityRenderColor(ent, 255, 0, 255, 255);
				}else if (!strcmp(s_Type, "color7")){
					SetEntityRenderColor(ent, 255, 255, 255, 50);
				}else if (!strcmp(s_Type, "color8")){
					SetEntityRenderColor(ent, 255, 255, 255, 0);
				}
			}
			DisplayMenuAtItem(menu, param1, GetMenuSelectionPosition(), MENU_TIME_FOREVER);
		}
	}
}

SpawnBlocks()
{
	new Float:pos[3], Float:ang[3], entity, color[4];
	new String:nemegostroka[16], String:Models[256];
	
	new clients = GetRealClientCount(acc_teams ? TEAM_TWO : TEAM_ALL);
	
	if (KvGotoFirstSubKey(kv_list)){
		do{
		
			new String:s_text[256], UnLockNum;
			
			KvGetVector(kv_list, "Position", pos);
			KvGetVector(kv_list, "Angles", ang);
			KvGetString(kv_list, "Model", Models, sizeof(Models));
			KvGetString(kv_list, "Text", s_text, sizeof(s_text));
			KvGetString(kv_list, "Colors", nemegostroka, sizeof(nemegostroka));
			UnLockNum = KvGetNum(kv_list, "UnLockNum", i_min_players);
			
			StringToColor(nemegostroka, color);
			
			if (UnLockNum > clients){
				if (strlen(s_text) > 2){
					ReplaceString(s_text, sizeof(s_text), "{default}", "\x01", false);
					ReplaceString(s_text, sizeof(s_text), "{teamcolor}", "\x02", false);
					ReplaceString(s_text, sizeof(s_text), "{lightgreen}", "\x03", false);
					ReplaceString(s_text, sizeof(s_text), "{green}", "\x04", false);
					ReplaceString(s_text, sizeof(s_text), "{darkgreen}", "\x05", false);
					CPrintToChatAll(s_text);
				}
				if ((entity = CreateEntity(pos, ang, Models)) != -1){
					SetEntityColor(entity, color);
				}
			}
		} while (KvGotoNextKey(kv_list));
	}
	KvRewind(kv_list);
}

CreateEntity(const Float:pos[3], const Float:ang[3], const String:g_szModel[])
{
	new entity = CreateEntityByName("prop_dynamic_override");
	
	if (entity == -1){
		return -1;
	}
	
	if (!IsModelPrecached(g_szModel)){
		PrecacheModel(g_szModel);
	}
	
	SetEntityModel(entity, g_szModel);
	DispatchKeyValue(entity, "Solid", "6"); 
	DispatchSpawn(entity);
	
	TeleportEntity(entity, pos, ang, NULL_VECTOR);
	
	PushArrayCell(data_props, entity);
	return entity;
}

public bool:Trace_FilterPlayers(entity, contentsMask, any:data)
{
	if(entity != data && entity > MaxClients){
		return true;
	}
	return false;
}

public bool:TRFilter_AimTarget(entity, mask, any:client)
{
    return (entity != client);
}

public bool:TraceEntityFilterPlayer(entity, contentsMask, any:client)
{
	return ((entity > MaxClients) || !entity);
}

GetRealClientCount(team = TEAM_ALL)
{
	new clients = 0;
	
	for (new i = 1; i <= MaxClients; i++){
		if (IsClientInGame(i) && IsPlayerAlive(i)){
			if (team > TEAM_ALL) {
				if (GetClientTeam(i) == team){
					clients++;
				}else{
					continue;
				}
			}else{
				clients++;
			}
		}
	}
	return clients;
}

Kv_Clear(Handle:kvhandle)
{
	KvRewind(kvhandle);
	
	if (KvGotoFirstSubKey(kvhandle)){
		do{
			KvDeleteThis(kvhandle);
			KvRewind(kvhandle);
		}
		while (KvGotoFirstSubKey(kvhandle));
	}
	KvRewind(kvhandle);
}

stock bool:GetPlayerEye(client, Float:pos[3])
{
	new Float:vAngles[3], Float:vOrigin[3];

	GetClientEyePosition(client, vOrigin);
	GetClientEyeAngles(client, vAngles);

	new Handle:trace = TR_TraceRayFilterEx(vOrigin, vAngles, MASK_SOLID, RayType_Infinite, TraceEntityFilterPlayer, client);

	if(TR_DidHit(trace)){
		TR_GetEndPosition(pos, trace);
		CloseHandle(trace);
		return true;
	}
	CloseHandle(trace);
	return false;
}

stock RotateYaw( Float:angles[3], Float:degree )
{
    decl Float:direction[3], Float:normal[3];
    GetAngleVectors( angles, direction, NULL_VECTOR, normal );
    
    new Float:sin = Sine( degree * 0.01745328 );
    new Float:cos = Cosine( degree * 0.01745328 );
    new Float:a = normal[0] * sin;
    new Float:b = normal[1] * sin;
    new Float:c = normal[2] * sin;
    new Float:x = direction[2] * b + direction[0] * cos - direction[1] * c;
    new Float:y = direction[0] * c + direction[1] * cos - direction[2] * a;
    new Float:z = direction[1] * a + direction[2] * cos - direction[0] * b;
    direction[0] = x;
    direction[1] = y;
    direction[2] = z;
    
    GetVectorAngles( direction, angles );

    decl Float:up[3];
    GetVectorVectors( direction, NULL_VECTOR, up );

    new Float:roll = GetAngleBetweenVectors( up, normal, direction );
    angles[2] += roll;
}

stock GetClientAimTarget2(client, bool:only_clients = true)
{
    new Float:eyeloc[3], Float:ang[3];
    GetClientEyePosition(client, eyeloc);
    GetClientEyeAngles(client, ang);
    TR_TraceRayFilter(eyeloc, ang, MASK_SOLID, RayType_Infinite, TRFilter_AimTarget, client);
	
    new entity = TR_GetEntityIndex();

    if (only_clients){
        if (entity >= 1 && entity <= MaxClients){
            return entity;
		}
    }else{
        if (entity > 0){
            return entity;
		}
    }
    return -1;
}

stock Float:GetAngleBetweenVectors( const Float:vector1[3], const Float:vector2[3], const Float:direction[3] )
{
    decl Float:vector1_n[3], Float:vector2_n[3], Float:direction_n[3], Float:cross[3];
    NormalizeVector( direction, direction_n );
    NormalizeVector( vector1, vector1_n );
    NormalizeVector( vector2, vector2_n );
    new Float:degree = ArcCosine( GetVectorDotProduct( vector1_n, vector2_n ) ) * 57.29577951;
    GetVectorCrossProduct( vector1_n, vector2_n, cross );
    
    if ( GetVectorDotProduct( cross, direction_n ) < 0.0 ){
        degree *= -1.0;
    }

    return degree;
}

stock GetEntityRenderColor(entity, color[4])
{
	new offset = GetEntSendPropOffs(entity, "m_clrRender");
	
	if (offset <= 0){
		ThrowError("GetEntityColor not supported by this mod");
	}
	
	color[0] = GetEntData(entity, offset, 1);
	color[1] = GetEntData(entity, offset + 1, 1);
	color[2] = GetEntData(entity, offset + 2, 1);
	color[3] = GetEntData(entity, offset + 3, 1);
}

stock SetEntityColor(entity, color[4] = {-1, ...})
{
	new dummy_color[4]; 
	
	GetEntityRenderColor(entity, dummy_color);
	
	for (new i = 0; i <= 3; i++){
		if (color[i] != -1){
			dummy_color[i] = color[i];
		}
	}
	
	SetEntityRenderColor(entity, dummy_color[0], dummy_color[1], dummy_color[2], dummy_color[3]);
	SetEntityRenderMode(entity, RENDER_TRANSCOLOR);
}

stock bool:StringToColor(const String:str[], color[4], defvalue = -1)
{
	new bool:result = false;
	new String:Splitter[4][64];
	if (ExplodeString(str, " ", Splitter, sizeof(Splitter), sizeof(Splitter[])) == 4 && String_IsNumeric(Splitter[0]) && String_IsNumeric(Splitter[1]) && String_IsNumeric(Splitter[2]) && String_IsNumeric(Splitter[3])){
		color[0] = StringToInt(Splitter[0]);
		color[1] = StringToInt(Splitter[1]);
		color[2] = StringToInt(Splitter[2]);
		color[3] = StringToInt(Splitter[3]);
		result = true;
	}else{
		color[0] = defvalue;
		color[1] = defvalue;
		color[2] = defvalue;
		color[3] = defvalue;
	}
	return result;
}

stock ColorToString(const color[4], String:buffer[], size)
{
	Format(buffer, size, "%d %d %d %d", color[0], color[1], color[2], color[3]);
}

stock bool:String_IsNumeric(const String:str[])
{
	new x=0;
	new numbersFound=0;

	if (str[x] == '+' || str[x] == '-'){
		x++;
	}

	while (str[x] != '\0'){
		if (IsCharNumeric(str[x])){
			numbersFound++;
		}else{
			return false;
		}
		x++;
	}
	if (!numbersFound){
		return false;
	}
	return true;
}

stock SaveAllProps(client)
{
	Kv_Clear(kv_list);
	
	new index = 1;
	new String:buffer_modelsname[PLATFORM_MAX_PATH], String:buffer_2[64], String:megostroka[16], color[4], Float:pos[3], Float:ang[3], ent;
			
	new String:path[PLATFORM_MAX_PATH];
	BuildPath(Path_SM, path, sizeof(path), "data/blocker_passes/%s.txt", s_MapName);
		
	for (new i = 0; i < GetArraySize(data_props); i++){
		
		ent = GetArrayCell(data_props, i);
		
		if (ent > MaxClients && IsValidEdict(ent)){
			
			GetEntPropString(ent, Prop_Data, "m_ModelName", buffer_modelsname, sizeof(buffer_modelsname));
			GetEntPropVector(ent, Prop_Send, "m_vecOrigin", pos);
			GetEntPropVector(ent, Prop_Send, "m_angRotation", ang);
			GetEntityRenderColor(ent, color);
			ColorToString(color, megostroka, sizeof(megostroka));
			
			IntToString(index, buffer_2, sizeof(buffer_2));
			KvJumpToKey(kv_list, buffer_2, true);
			
			KvSetVector(kv_list, "Position", pos);
			KvSetVector(kv_list, "Angles", ang);
			KvSetString(kv_list, "Model", buffer_modelsname);
			KvSetString(kv_list, "colors", megostroka);
			KvSetString(kv_list, "Text", "");
			KvSetNum(kv_list, 	 "UnLockNum", i_min_players);
			
			KvRewind(kv_list);
			
			index++;
		}
	}
	
	KeyValuesToFile(kv_list, path);
	
	if (client == 0){
		return;
	}
	PrintHintText(client, "Координаты\nуспешно сохранены.\nВсего %d предмета!", index - 1);
		
	DisplayTopMenu(h_menu, client, TopMenuPosition_LastCategory);
}

stock DeleteProp(entity)
{
	decl String:dname[16];
	Format(dname, sizeof(dname), "dis_%d", entity);
	DispatchKeyValue(entity, "targetname", dname);
	new diss = CreateEntityByName("env_entity_dissolver");
	DispatchKeyValue(diss, "dissolvetype", "3");
	DispatchKeyValue(diss, "target", dname);
	AcceptEntityInput(diss, "Dissolve");
	AcceptEntityInput(diss, "kill");
}

stock LoadPropsMenu()
{
	h_PropsMenu = CreateMenu(PropMenuHandler);
	SetMenuTitle(h_PropsMenu, "| Меню предметов |");
	SetMenuExitButton(h_PropsMenu, true);
	SetMenuExitBackButton(h_PropsMenu, true);
	
	decl String:file[255];
	new Handle:kv = CreateKeyValues("Props");
	BuildPath(Path_SM, file, sizeof(file), "data/blocker_passes/props_menu.txt");
	FileToKeyValues(kv, file);
	new menu_items = 0;
	new reqmenuitems = 4;
	
	if (KvGotoFirstSubKey(kv)){
		new index = 0;
		decl String:buffer[255];
		decl String:bufferindex[5];
		do{
			KvGetString(kv, "model", g_sPropList[index], 256);
			
			PrecacheModel(g_sPropList[index]);
			
			KvGetSectionName(kv, buffer, sizeof(buffer));
			IntToString(index, bufferindex, sizeof(bufferindex));
			AddMenuItem(h_PropsMenu, bufferindex, buffer);
			index++;
			menu_items++;
			if (menu_items == reqmenuitems)
			{
				menu_items = 0;
				AddMenuItem(h_PropsMenu, "", 	"", ITEMDRAW_SPACER);
				AddMenuItem(h_PropsMenu, "rote", 	"[Повернуть предмет]");
				AddMenuItem(h_PropsMenu, "remove", 	"[Удалить предмет]");
			}
		}
		while (KvGotoNextKey(kv));
	}
	CloseHandle(kv);
}