
sql_save(String:networkid[], duration, String:name[], String:by[], String:reason[], point)
{

	decl String:error[255];
	new Handle:db = INVALID_HANDLE;

	db = SQLite_UseDatabase("stb-sqlite", error, sizeof(error));

	if (db == INVALID_HANDLE)
	{
		CloseHandle(db);
		SetFailState("error: %s", error);
	}

	decl String:date[30];
	FormatTime(date, sizeof(date), "%m/%d/%Y - %H:%M:%S"); // Create date month/day/year - hour:minute:second

	decl String:query[255];

	switch(point)
	{
		case 0:
		{
			// Save (or replace) new ban, steamid, time, timestamp, name, by, reason, date
			Format(query, sizeof(query), "INSERT OR REPLACE INTO stb VALUES ('%s', '%i', '%i', '%s', 'Banned by %s', '%s', '%s');", networkid, duration, GetTime(), name, by, reason, date);
			if(GetConVarInt(stb_rejectmode) != 0)	// Cvar stb_rejectmode else than 0
			{
				RemoveBan(networkid, BANFLAG_AUTHID); // Remove ban immediatelly from server
			}
		}
		case 1:
		{
			// Update ban to steamid, time, timestamp, name, by, reason, date
			Format(query, sizeof(query), "UPDATE stb set duration = '%i', timestamp = '%i', name = '%s', admin = 'Banned by %s', reason = '%s', date = '%s' WHERE steamid = '%s';", duration, GetTime(), name, by, reason, date, networkid);
		}
		case 2:
		{
			// Update ban to steamid, time, timestamp, by, reason, date
			Format(query, sizeof(query), "UPDATE stb set duration = '%i', timestamp = '%i', admin = 'Banned by %s', reason = '%s', date = '%s' WHERE steamid = '%s';", duration, GetTime(), by, reason, date, networkid);
			if(GetConVarInt(stb_rejectmode) != 0)	// Cvar stb_rejectmode else than 0
			{
				RemoveBan(networkid, BANFLAG_AUTHID); // Remove ban immediatelly from server
			}
		}
		case 3:
		{
			// Update ban to unban, time, timestamp, by
			Format(query, sizeof(query), "UPDATE stb set duration = 0, timestamp = '%i', admin = 'Unbanned by %s' WHERE steamid = '%s';", GetTime(), by, networkid);
		}
		case 4:
		{
			// Update ban, time
			Format(query, sizeof(query), "UPDATE stb set duration = '%i' WHERE steamid = '%s';", duration, networkid);
			if(GetConVarInt(stb_rejectmode) != 0)	// Cvar stb_rejectmode else than 0
			{
				RemoveBan(networkid, BANFLAG_AUTHID); // Remove ban immediatelly from server
			}
		}
		case 5:
		{
			// Update ban, name
			Format(query, sizeof(query), "UPDATE stb set name = '%s' WHERE steamid = '%s';", name, networkid);
		}
		case 6:
		{
			// Delete ban, remove from db
			Format(query, sizeof(query), "DELETE FROM stb WHERE steamid = '%s';", networkid);
		}
	}

	SQL_LockDatabase(db);

	if(!SQL_FastQuery(db, query))
	{
		SQL_GetError(db, error, sizeof(error));
		LogError("Failed to query: %s", error);
	}

	SQL_UnlockDatabase(db);
	CloseHandle(db);
}