
public bool:sql_checkid(const String:networkid[], point)
{

	decl String:error[255];
	new Handle:db = INVALID_HANDLE;

	db = SQLite_UseDatabase("stb-sqlite", error, sizeof(error));

	if (db == INVALID_HANDLE)
	{
		CloseHandle(db);
		SetFailState("SQL error: %s", error);
	}

	decl String:s_query[255];
	Format(s_query, sizeof(s_query), "SELECT * FROM stb WHERE steamid = '%s'", networkid);
	new Handle:query = SQL_Query(db, s_query);

	SQL_LockDatabase(db);

	if(query == INVALID_HANDLE)
	{
		LogError("Query Handle %x has no results", query);
		SQL_UnlockDatabase(db);
		CloseHandle(db);
		CloseHandle(query);
		return false;
	}

	decl String:steamid[32];

	if(SQL_FetchRow(query))	// Found soem results from db
	{
		SQL_FetchString(query, 0, steamid, sizeof(steamid));	// Get first column
	}

	if(StrEqual(networkid, steamid, true))	// Those 2 really are equal ?
	{
		switch(point)
		{
			case 0:	// found steamid from db
			{
				SQL_UnlockDatabase(db);
				CloseHandle(db);
				CloseHandle(query);
				return true;
			}
			case 1:	// Ban added within 5 seconds
			{
				new timestamp = SQL_FetchInt(query, 2) + 5;
				if(timestamp > GetTime())
				{
					SQL_UnlockDatabase(db);
					CloseHandle(db);
					CloseHandle(query);
					return true;
				}
				else
				{
					SQL_UnlockDatabase(db);
					CloseHandle(db);
					CloseHandle(query);
					return false;
				}
			}
			case 2:	// Check name from db
			{
				decl String:name[MAX_NAME_LENGTH];
				SQL_FetchString(query, 3, name, sizeof(name));
				if(StrEqual(name, "", true))
				{
					SQL_UnlockDatabase(db);
					CloseHandle(db);
					CloseHandle(query);
					return false;
				}
				else
				{
					SQL_UnlockDatabase(db);
					CloseHandle(db);
					CloseHandle(query);
					return true;
				}
			}
		}
	}

	SQL_UnlockDatabase(db);
	CloseHandle(db);
	CloseHandle(query);

	return false;
}

sql_checkban(client)
{
	decl String:error[255];
	new Handle:db = INVALID_HANDLE;

	db = SQLite_UseDatabase("stb-sqlite", error, sizeof(error));

	if (db == INVALID_HANDLE)
	{
		CloseHandle(db);
		SetFailState("stbinc/sqlite_check.sp (Line 70) Sqlite_banned = error: %s", error);
	}

	decl String:networkid[32];
	GetClientAuthString(client, networkid, sizeof(networkid));	// Get client steamid

	decl String:s_query[255];
	Format(s_query, sizeof(s_query), "SELECT * FROM stb WHERE steamid = '%s'", networkid);
	new Handle:query = SQL_Query(db, s_query);

	SQL_LockDatabase(db);

	if(query == INVALID_HANDLE)
	{
		LogError("Query Handle %x has no results", query);
		SQL_UnlockDatabase(db);
		CloseHandle(db);
		return;
	}

	decl duration, timestamp, String:date[30], String:name[MAX_NAME_LENGTH];

	if(SQL_FetchRow(query))	// Found data from db by steamid
	{
		//SQL_FetchString(query, 0, steamid, sizeof(steamid));
		duration = SQL_FetchInt(query, 1);	// Get duration
		timestamp = SQL_FetchInt(query, 2);	// Get timestamp
		SQL_FetchString(query, 3, name, sizeof(name));	// Get name
		//SQL_FetchString(query, 4, admin, sizeof(admin));
		//SQL_FetchString(query, 5, reason, sizeof(reason));
		SQL_FetchString(query, 6, date, sizeof(date));	// Get date
	}

	SQL_UnlockDatabase(db);
	CloseHandle(db);
	CloseHandle(query);

	new a = GetTime() - timestamp;	// timenow minus timestamp
	new b = (duration*60) - a;		// duration to seconds minus time difference

	new days = b/86400;				// Found these from Forlix TempBanFix ^^
	new hrs = (b/3600)%24;
	new mins = (b/60)%60;
	new sec = b%60;

	if(b >= 1)	// There is ban left
	{
		if(GetConVarInt(stb_rejectmode) == 1)	// Cvar stb_rejectmode 1, kick
		{
			if(GetConVarInt(stb_printrejected) == 1)	// Cvar stb_printrejected 1, print in chat to all message
			{
				decl String:s_name[MAX_NAME_LENGTH];
				GetClientName(client, s_name, sizeof(s_name));	// Get client name

				if(StrEqual(s_name, name, true) || StrEqual(name, ""))	// Is name equal or have no-name in db
				{
					PrintToChatAll("\x01Dropped \x03%s \x01from server (Banned)\n\x03%s\n%i\x01d \x03%i\x01h \x03%i\x01m \x03%i\x01s left", s_name, date, days, hrs, mins, sec);
				}
				else	// Name different than in db
				{
					PrintToChatAll("\x01Dropped \x03%s \x01from server (Banned)\nalias %s \x03%s\n%i\x01d \x03%i\x01h \x03%i\x01m \x03%i\x01s left", s_name, name, date, days, hrs, mins, sec);
				}
			}

			KickClient(client, "Banned %s\n%id %ih %im %is left", date, days, hrs, mins, sec);	// Kick banned player out from server
		}
		else if(GetConVarInt(stb_rejectmode) == 2)	// cvar stb_rejectmode 2, kick + ban IP 1 minute
		{
			if(GetConVarInt(stb_printrejected) == 1)	// Cvar stb_printrejected 1, print in chat to all message
			{
				decl String:s_name[MAX_NAME_LENGTH];
				GetClientName(client, s_name, sizeof(s_name));	// Get client name

				if(StrEqual(s_name, name, true) || StrEqual(name, ""))	// Is name equal or have no-name in db
				{
					PrintToChatAll("\x01Dropped \x03%s \x01from server (Banned)\n\x03%s\n%i\x01d \x03%i\x01h \x03%i\x01m \x03%i\x01s left", s_name, date, days, hrs, mins, sec);
				}
				else	// Name different than in db
				{
					PrintToChatAll("\x01Dropped \x03%s \x01from server (Banned)\nalias %s \x03%s\n%i\x01d \x03%i\x01h \x03%i\x01m \x03%i\x01s left", s_name, name, date, days, hrs, mins, sec);
				}
			}

			decl String:ip[16];
			GetClientIP(client, ip, sizeof(ip));	// Get client IP
			KickClient(client, "Banned %s\n%id %ih %im %is left", date, days, hrs, mins, sec);	// Kick banned player out from server
			BanIdentity(ip, 1, BANFLAG_IP, "[STB]");	// Add IP ban 1 minute afterwards
		}
	}
}