// SourceMod command sm_ban, sourcemod plugins BanClient
public Action:OnBanClient(client, time, flags, const String:reason[], const String:kick_message[], const String:command[], any:source)
{
	decl String:networkid[32];
	GetClientAuthString(client, networkid, sizeof(networkid)); 	// Get client steamid

	// If not steamid, time 0 or less
	if(strcmp(networkid, "STEAM_", true) == -1 || strlen(networkid) < 11 || time <= 0)
	{
		return;
	}


	// Save only steamid, name, source, reason to db first. Let event server_addban update more information in same row
	decl String:name[MAX_NAME_LENGTH], String:by[MAX_NAME_LENGTH], String:msg[32];

	GetClientName(client, name, sizeof(name));
	Format(by, sizeof(by), "%N", source);
	Format(msg, sizeof(msg), reason);

	if(sql_checkid(networkid, 0)) 	// Check steamid from db
	{
		sql_save(networkid, 0, name, by, msg, 1);	// steamid found, update, name, by, reason
	}
	else
	{
		sql_save(networkid, 0, name, by, msg, 0);	// steamid not found, replace or create new
	}
}




// SourceMod sm_addban, sm_banip, sourcemod plugins BanIdentity
public Action:OnBanIdentity(const String:identity[], time, flags, const String:reason[], const String:command[], any:source)
{
	// If not steamid, time 0 or less
	if(strcmp(identity, "STEAM_", true) == -1 || strlen(identity) < 11 || time <= 0)
	{
		return;
	}

	// Save only steamid, name, source, reason to db first. Let event server_addban update more information in same row
	decl String:by[MAX_NAME_LENGTH], String:msg[32], String:networkid[32];

	Format(by, sizeof(by), "%N", source);
	Format(msg, sizeof(msg), reason);
	Format(networkid, sizeof(networkid), identity);

	if(sql_checkid(identity, 0))	// Check steamid from db
	{
		sql_save(networkid, 0, "", by, msg, 2); // steamid found, update by, reason
	}
	else
	{
		sql_save(networkid, 0, "", by, msg, 0);	// steamid not found, replace or create new
	}
}


// SourceMod sm_unban, sourcemod plugins RemoveBan
public Action:OnRemoveBan(const String:identity[], flags, const String:command[], any:source)
{
	// If not steamid
	if(strcmp(identity, "STEAM_", true) == -1 || strlen(identity) < 11)
	{
		return;
	}

	if(sql_checkid(identity, 0))	// Check steamid from db
	{
		decl String:by[MAX_NAME_LENGTH], String:networkid[32];
		Format(by, sizeof(by), "%N", source);	// String by
		Format(networkid, sizeof(networkid), identity);	// String steamid
		sql_save(networkid, 0, "", by, "", 3)	// Update ban by
	}
}