import os
import es
import re

g_enable = 1         # Enabled?
g_whitelist = []     # SteamIDs of accepted players
mani = str(es.ServerVar('eventscripts_gamedir')) + '/cfg/mani_admin_plugin/clients.txt'
mani_admins = []

g_base_path = None

def load():
    global g_base_path, g_enable, g_whitelist
    loadAdmins()
    g_base_path = es.getAddonPath('privserv')
    if g_enable:
        if os.path.exists(g_base_path + '/whitelist.txt'):
            try:
                file = open(g_base_path + '/whitelist.txt', 'r')
                # Read accepted SteamIDs to g_whitelist
                g_whitelist = file.readlines()
            except IOError:
                # Disable script on fail
                g_enable = 0
            finally:
                file.close()
        else:
            # Disable script on fail
            g_enable = 0

def es_player_validated(ev):
    global g_enable, g_whitelist
    if g_enable:
        steamid = str(ev['networkid'])
        if steamid in mani_admins and steamid not in g_whitelist: #they are in the clients.txt but not in the whitelist = BAN
            # Kick/ban player
            es.server.queuecmd('banid 0 %s kick' % steamid)

def loadAdmins():
    global admins
    if os.path.exists(mani):
        oFile = open(mani, 'r')
        admins = map(lambda x: x.upper(), re.findall('(STEAM_0:[0-1]:\d+)', oFile.read(), re.IGNORECASE))
        oFile.close()