# NowYouSeeMe release 5 by StRiker | BaStAZzz
# ./addons/eventscripts/nowyouseeme/nowyouseeme.py

# >>> To configure this addon please see nowyouseeme.cfg (created when the addon is first loaded) <<<

"""
Sets player visibility based on movement and damage. Requires only ES 2.0+
"""


import cfglib
import es
import gamethread
from collections import deque

import psyco
psyco.full()


info = es.AddonInfo()
info.name     = 'NowYouSeeMe'
info.version  = '5'
info.basename = 'nowyouseeme'
info.url      = 'http://addons.eventscripts.com/addons/view/' + info.basename
info.author   = 'SuperDave'


###


config = cfglib.AddonCFG(es.getAddonPath(info.basename) + '/' + info.basename + '.cfg')

config.text(info.name + ' release %s options' % info.version)
config.text('./addons/eventscripts/%(basename)s/%(basename)s.cfg' % {'basename':info.basename})
config.text(info.url)
config.text('')
config.text('Load this addon with: es_load ' + info.basename)
config.text('\n')

config.text(' ***** Visibility options *****')
config.text(' Note that unequipped weapons or items will always be fully visible.')
cvar_visibility_min = config.cvar('nowyouseeme_visibility_min', 50,  'Minimum visibility a player can have (0 to 255 inclusive)')
cvar_visibility_max = config.cvar('nowyouseeme_visibility_max', 255, 'Maximum visibility a player can have (0 to 255 inclusive)')
config.text('\n')

config.text(' ***** Damage options *****')
cvar_damage_min     = config.cvar('nowyouseeme_damage_min',     10,  'Damage allowed before visibility is affected')
cvar_damage_max     = config.cvar('nowyouseeme_damage_max',     65,  'Damage allowed before a player is fully visible')
cvar_damage_dietime = config.cvar('nowyouseeme_damage_dietime', 5.5, 'Number of seconds damage will affect visibility')
config.text('\n')

config.text(' ***** Movement options *****')
cvar_movement_min         = config.cvar('nowyouseeme_movement_min',         100, 'Movement allowed before visibility is affected')
cvar_movement_max         = config.cvar('nowyouseeme_movement_max',         200, 'Movement allowed before a player is fully visible')
cvar_movement_updatedelay = config.cvar('nowyouseeme_movement_updatedelay', 1,   'Number of seconds between movement updates')
cvar_movement_diecount    = config.cvar('nowyouseeme_movement_diecount',    3,   'Number of updates movement will affect visibility')

config.write()


###


class NYSMPlayer(object):
   alpha        = 0
   location     = (0, 0, 0)
   weapon_index = 0

   def __init__(self, userid):
      self.userid   = userid
      self.handle   = es.getplayerhandle(userid)
      self.damage   = []
      self.weapons  = set()

      es.server.queuecmd('es_xfire %s !self addoutput "rendermode 1"' % userid)

      self.reset()

   def reset(self):
      self.clearDelay()
      self.playerDeath(False)

      self.location     = es.getplayerlocation(self.userid)
      self.movement     = deque([0] * int(cvar_movement_diecount))
      self.damage[:]    = []
      self.weapon_index = 0
      self.weapons.clear()

      self.updateVisibility()

   def clearPlayer(self):
      self.clearDelay()

      if es.exists('userid', self.userid):
         self.alpha = 255
         self.setWeaponAlpha()
         es.server.queuecmd('es_xfire %s !self alpha 255' % self.userid)

      else:
         self.playerDeath(False)

   def itemPickup(self):
      if es.getentityindex('func_buyzone') <> -1 and es.getplayerprop(self.userid, 'CCSPlayer.m_bInBuyZone') % 2:
         self.playerDeath(False)
         self.setWeaponAlpha()

   def playerDeath(self, clear=True):
      for weapon in self.weapons:
         for index in es.createentitylist(weapon):
            if es.getindexprop(index, 'CBaseEntity.m_hOwnerEntity') in (-1, self.handle):
               self._setIndexAlpha(index, 255)

      if clear:
         self.clearPlayer()

   def clearDelay(self):
      gamethread.cancelDelayed('nowyouseeme_damage_%s' % self.userid)

   def movementUpdate(self):
      # Add movement
      old_location  = self.location
      self.location = es.getplayerlocation(self.userid)

      self.movement.appendleft(sum((old_location[x] - self.location[x]) ** 2 for x in range(3)) ** 0.5)

      # Remove movement
      self.movement.pop()

      self.updateVisibility()

   def damageUpdate(self, amount):
      self.damage.insert(0, amount)

      gamethread.delayedname(cvar_damage_dietime, 'nowyouseeme_damage_%s' % self.userid, self._removeDamage)

   def _removeDamage(self):
      self.damage.pop()

      self.updateVisibility()

   def updateVisibility(self):
      damage_min   = int(cvar_damage_min)
      movement_min = int(cvar_movement_min)

      damage_alpha   = min(max((sum(self.damage) - damage_min) * 255. / (cvar_damage_max - damage_min), 0), 255) if self.damage else 0
      movement_alpha = min(max((sum(self.movement) / float(len(self.movement)) - movement_min) * 255. / (cvar_movement_max - movement_min), 0), 255) if self.movement else 0

      self.alpha = int(min(max(damage_alpha + movement_alpha, int(cvar_visibility_min)), int(cvar_visibility_max)))

      es.server.queuecmd('es_xfire %s !self alpha %s' % (self.userid, self.alpha))

      self.setWeaponAlpha()

   def setWeaponAlpha(self):
      weapon = es.createplayerlist(self.userid)[self.userid]['weapon']
      if weapon not in self.weapons:
         self.weapons.add(weapon)
      entlist = es.createentitylist(self.weapon_index) if self.weapon_index else 0
      if entlist and entlist[self.weapon_index]['classname'] == weapon and es.getindexprop(self.weapon_index, 'CBaseEntity.m_hOwnerEntity') == self.handle:
         self._setIndexAlpha(self.weapon_index, self.alpha)

      else:
         for index in es.createentitylist(weapon):
            if es.getindexprop(index, 'CBaseEntity.m_hOwnerEntity') == self.handle:
               self._setIndexAlpha(index, self.alpha)
               self.weapon_index = index
               break

   @staticmethod
   def _setIndexAlpha(index, alpha):
      rendercolor = es.getindexprop(index, 'CBaseEntity.m_clrRender')
      if not rendercolor: return

      es.setindexprop(index, 'CBaseEntity.m_nRenderMode', es.getindexprop(index, 'CBaseEntity.m_nRenderMode') | 1)
      es.setindexprop(index, 'CBaseEntity.m_nRenderFX', es.getindexprop(index, 'CBaseEntity.m_nRenderFX') | 256)
      es.setindexprop(index, 'CBaseEntity.m_clrRender', rendercolor - ((rendercolor >> 24) << 24) + (alpha << 24))


###


class NYSMManager(object):
   def __init__(self):
      self.players = {}

      self.registerClientFilter()

   def getPlayer(self, userid):
      userid = int(userid)

      if userid not in self.players:
         self.players[userid] = NYSMPlayer(userid)

      return self.players[userid]

   def removePlayer(self, userid):
      userid = int(userid)

      if userid in self.players:
         self.players[userid].clearPlayer()
         del self.players[userid]

   def clearPlayers(self, connected=True):
      if connected:
         for userid in self.players:
            self.players[userid].playerDeath()

      else:
         for userid in self.players:
            self.players[userid].clearDelay()

      self.players.clear()

   def clearDelay(self):
      gamethread.cancelDelayed('nowyouseeme_movementupdate')

   def startDelay(self):
      self.clearDelay()

      gamethread.delayedname(cvar_movement_updatedelay, 'nowyouseeme_movementupdate', self._update)

   def _update(self):
      for userid in filter(lambda x: not es.getplayerprop(x, 'CBasePlayer.pl.deadflag'), es.getUseridList()):
         self.players[userid].movementUpdate()

      gamethread.delayedname(cvar_movement_updatedelay, 'nowyouseeme_movementupdate', self._update)

   def registerClientFilter(self):
      es.addons.registerClientCommandFilter(self._clientFilter)

   def unregisterClientFilter(self):
      es.addons.unregisterClientCommandFilter(self._clientFilter)

   def _clientFilter(self, userid, args):
      if args[0].lower() == 'drop':
         player = self.getPlayer(userid)
         weapon = es.createplayerlist(userid)[userid]['weapon']
         for index in es.createentitylist(weapon):
            if es.getindexprop(index, 'CBaseEntity.m_hOwnerEntity') == player.handle:
               player._setIndexAlpha(index, 255)
         if weapon in player.weapons:
            player.weapons.remove(weapon)

      return True

nysm = NYSMManager()


###


def load():
   config.execute()

   for userid in es.getUseridList():
      nysm.getPlayer(userid).reset()

   nysm.startDelay()


def es_map_start(event_var):
   nysm.clearPlayers(False)
   nysm.clearDelay()


def round_start(event_var):
   nysm.startDelay()


def item_pickup(event_var):
   nysm.getPlayer(event_var['userid']).itemPickup()


def player_spawn(event_var):
   nysm.getPlayer(event_var['userid']).reset()


def player_hurt(event_var):
   attacker = int(event_var['attacker'])
   damage   = int(event_var['dmg_health'])

   nysm.getPlayer(event_var['userid']).damageUpdate(damage)

   if attacker:
      nysm.getPlayer(attacker).damageUpdate(damage)


def player_death(event_var):
   nysm.getPlayer(event_var['userid']).playerDeath()


def player_disconnect(event_var):
   nysm.removePlayer(event_var['userid'])


def unload():
   nysm.clearPlayers()
   nysm.clearDelay()
   nysm.unregisterClientFilter()

   for cvar in config.getCvars():
      es.ServerVar(cvar).set(0)