﻿###########################################
##  BackRaw's Notifications-Script v1.1  ##
##           by BackRaw                  ##
###########################################

import es
from usermsg import hudhint
from gamethread import delayed
from langlib import Strings
from cfglib import AddonCFG

config = AddonCFG(es.getAddonPath('notifications') + '/notifications_config.cfg')

config.text('********************************')
config.text('* Notifications v 1.2 Settings *')
config.text('********************************')
config.text('\n')
config.text('***************')
config.text(' -> WEBSEITE <- ')
config.text('***************')
website_enable = config.cvar('website_enable', 1, 'Website advert on/off')
website = config.cvar('website', 'Website', 'Name of your website here')
config.text('\n')
config.text('**********************************************')
config.text(' -> FRIENDLY FIRE - RATES - MAP - LANGUAGE <- ')
config.text('**********************************************')
ff = config.cvar('ff', 1, "'ff' command on/off - if a player types it in, he sees if it's turned on or off")
rate_player = config.cvar('rate_player', 1, '"!rates" command on/off - the player sees what his rates are set to')
player_rates = config.cvar('player_rates', 1, '"showrates" command on/off - everyone sees what the rates of the user who typed it in are set to')
map_player = config.cvar('map_player', 1, '"map" command on/off - shows which map this is')
config.text('\n')
config.text('*********************')
config.text(' -> JOIN - ACTIVE <- ')
config.text('*********************')
player_join = config.cvar('player_join', 1, 'Turns on/off if it should be shown that a player is joining the game')
player_active = config.cvar('player_active', 1, 'Turns on/off if it should be shown that the player is ready for battle')
config.text('\n')
config.text('***************')
config.text(' -> FUNMAPS <- ')
config.text('***************')
funmaps = config.cvar('funmaps', 1, 'Turns on/off if every player should be given the "Assaultsuit" if they spawn on a fun map')
fun_maps = config.cvar('fun_maps', 'Funmaps', 'If the above setting is set to 1, write in your funmaps here (split with ";")')
config.text('\n')
config.text('*********************************************************')
config.text(' -> SELF-HIT - LAST HIT - TEAM ATTACK - KILLER-WEAPON <- ')
config.text('*********************************************************')
hurt_self = config.cvar('hurt_self', 1, 'Turns on/off if the player should be warned, because he/she hurt his-/herself')
last_hit = config.cvar('last_hit', 1, "Turns on/off if the player should be shown how many damage he's given the vitcim with his last hit.")
team_attack = config.cvar('team_attack', 1, 'Turns on/off if the player should be warned if he attacks a team mate. Shows how many HP the mate has left, too')
death_weapon = config.cvar('death_weapon', 1, 'Turns on/off if the player should be told what weapon he was killed with and how many HP the attacker has left')
config.text('\n')
config.text('************')
config.text(' -> BOMB <- ')
config.text('************')
bomb_drop_death = config.cvar('bomb_drop_death', 1, 'Turns on/off if the Terrorists should be told that the bomber dropped the bomb because of his death')
bomb_drop = config.cvar('bomb_drop', 1, 'Turns on/off if the Terrorists should be told that the bomb has been thrown away')
bomb_picksup = config.cvar('bomb_picksup', 1, 'Turns on/off if the Terrorists should be told that the bomb has been picked up')
bomb_planting = config.cvar('bomb_planting', 1, 'Turns on/off if the Terrorists should be told that the bomber is planting the bomb')
bomb_has_been_planted = config.cvar('bomb_has_been_planted', 1, 'Turns on/off if the Terrorists should be told that the bomber has planted the bomb successfully')
bomb_defusing = config.cvar('bomb_defusing', 1, 'Turns on/off if the Counter-Terrorists should be told that the bomb is being defused')
bomb_has_been_defused = config.cvar('bomb_has_been_defused', 1, 'Turns on/off if the Counter-Terrorists should be told that the bomb has been defused by defuser')
config.text('\n')
config.text('***************')
config.text(' -> FLASHED <- ')
config.text('***************')
player_flash_duration = config.cvar('player_flash_duration', 1, "Turns on/off if the player should be told how long he/she's been flashed (in sec)")

config.write()

player = {}
curmap = str(es.ServerVar('eventscripts_currentmap'))
new_weapon_names = {'defuser':'Entschärfungskit', 'knife':'Messer', 'glock':'9x19-MM-Revolver', 'usp':'KM 45, Taktisch', 'p228':'228 (Kompakt)', 'deagle':'Night Hawk .50C', 'fiveseven':'ES Five-Seven', 'elite':'40 Dual Elites', 'ak47':'Avtomat Kalashnikova - 47', 'm4a1':'Maverick M4A1 Karabiner', 'galil':'IDF Defender', 'famas':'FAMAS (Clarion 5.56)', 'sg552':'Kreig 552', 'aug':'Bullpop', 'g3sg1':'D3/AU-1 (G3/SG1)', 'sg550':'Krieg 550 Kommando', 'scout':'Schmidt Scout', 'awp':'Artic Warfare Police', 'mp5navy':'MP5-Navy', 'p90':'ES-C90 (P90)', 'tmp':'Schmidt Maschinenpistole (TMP)', 'ump45':'KM UMP45', 'mac10':'Ingram MAC-10', 'm249':'M249 Para', 'm3':'Leone Kaliber 12 Super (M3)', 'xm1014':'Leone YG1265 Automatik-Schrotgewehr', 'hegrenade':'HE-Granate'}
new_map_names = {'de_dust':'Defusal - Dust', 'de_dust2':'Defusal - Dust2', 'de_aztec':'Defusal - Aztec', 'de_cbble':'Defusal - Cobblestone', 'de_chateau':'Defusal - Castle (Chateau)', 'de_piranesi':'Defusal - Piranesi', 'de_train':'Defusal - Train', 'de_tides':'Defusal - Tides', 'de_port':'Defusal - Port', 'de_inferno':'Defusal - Inferno', 'de_nuke':'Defusal - Nuke', 'de_prodigy':'Defusal - Prodigy', 'cs_italy':'Hostage Rescue - Italy', 'cs_office':'Hostage Rescue - Office', 'cs_havana':'Hostage Rescue - Havana', 'cs_compound':'Hostage Rescue - Compound', 'cs_assault':'Hostage Rescue - Assault', 'cs_militia':'Hostage Rescue - Militia', 'aim_ak-colt':'Aim - AK47 - M4A1', 'he_tennis_2005':'HE - Tennis, 2005'}
round_count = 0

class Notifications(object):
    def __init__(self, userid):
        self.userid = userid
        self.rate = self.cmdrate = self.updaterate = 0
    def say(self, Text):
        if ff and Text == 'ff':
            if es.ServerVar('mp_friendlyfire') == '1':
                es.msg('#multi', text('ff on'))
            else:
                es.msg('#multi', text('ff off'))
        elif map_player and Text == 'map':
            es.tell(self.userid, '#multi', text('map', {'curmap':new_map_names.get(curmap, curmap)}))
    def getrates(self):
        self.rate = es.getclientvar(self.userid, 'rate')
        self.cmdrate = es.getclientvar(self.userid, 'cl_cmdrate')
        self.updaterate = es.getclientvar(self.userid, 'cl_updaterate')
    def _rates(self):
        self.getrates()
        es.tell(self.userid, '#multi', text('rates are'))
        delayed(.2, es.tell, (self.userid, '#multi', '#green[#lightgreenNotifications#green] #lightgreenrate: #green%s' % self.rate))
        delayed(.2, es.tell, (self.userid, '#multi', '#green[#lightgreenNotifications#green] #lightgreencl_cmdrate: #green%s' % self.cmdrate))
        delayed(.2, es.tell, (self.userid, '#multi', '#green[#lightgreenNotifications#green] #lightgreencl_updaterate: #green%s' % self.updaterate))
    def _showrates(self):
        self.getrates()
        es.msg('#multi', text('show rates', {'name':es.getplayername(self.userid)}))
        delayed(.2, es.msg, ('#multi', '#green[#lightgreenNotifications#green] #lightgreenrate: #green%s' % self.rate))
        delayed(.2, es.msg, ('#multi', '#green[#lightgreenNotifications#green] #lightgreencl_cmdrate: #green%s' % self.cmdrate))
        delayed(.2, es.msg, ('#multi', '#green[#lightgreenNotifications#green] #lightgreencl_updaterate: #green%s' % self.updaterate))
    def spawn(self):
        if curmap in str(fun_maps).split(';'):
            es.server.queuecmd('es_xgive %s item_assaultsuit' % self.userid)
            es.tell(self.userid, '#multi', text('funmaps', {'map':new_map_names.get(curmap, curmap)}))
    def hurt(self, userid, name, health, dmg):
        if es.getplayerteam(self.userid) == es.getplayerteam(userid):
            if self.userid != userid:
                if team_attack:
                    if health > 1:
                        es.tell(self.userid, '#multi', text('team attack', {'name':name, 'health':health}))
                    elif not health:
                        es.tell(self.userid, '#multi', text('team mate down', {'name':name, 'dmg':dmg}))
            else:
                if hurt_self:
                    es.tell(userid, '#multi', text('selfhit'))
        else:
            if last_hit and not health:
                es.tell(self.userid, '#multi', text('last hit', {'name':name, 'dmg':dmg}))
    def death(self, attacker, weapon, name, health):
        if attacker != self.userid:
            es.tell(self.userid, '#multi', text('attacker + weapon', {'name':name, 'weapon':new_weapon_names.get(weapon, weapon)}))
            delayed(0, es.tell, (self.userid, '#multi', text('attacker health', {'health':health})))
        elif attacker == self.userid:
            if weapon == 'hegrenade':
                es.tell(self.userid, '#multi', text('nade selfkill'))
            else:
                es.tell(self.userid, '#multi', text('selfkill'))
    def dropped(self, health, name):
        if not health:
            es.tell(self.userid, '#multi', text('killed bomber', {'name':name}))
        elif bomb_drop and health:
            es.tell(self.userid, '#multi', text('bomb thrown away', {'name':name}))
    def flashed(self, duration):
        if duration > 1.0:
            delayed(duration, hudhint, (self.userid, text('flash duration', {'duration':round(duration)})))
        else:
            delayed(duration, hudhint, (self.userid, text('flash a sec')))

def load():
    global text
    text = Strings(es.getAddonPath('notifications') + '/langs.ini')
    config.execute()
    if not es.exists('saycommand', '!rates'):
        es.regsaycmd('!rates', 'notifications/rates')
    if not es.exists('saycommand', 'showrates'):
        es.regsaycmd('showrates', 'notifications/showrates')
    for userid in es.getUseridList():
        uid = int(userid)
        if not player.has_key(uid):
            player[uid] = Notifications(uid)

def unload():
    player.clear()
    es.unregsaycmd('!rates')
    es.unregsaycmd('showrates')

def player_connect(ev):
    if player_join:
        es.msg('#multi', text('joinmsg', {'name':ev['name']}))

def player_disconnect(ev):
    del player[int(ev['userid'])]

def player_activate(ev):
    userid = int(ev['userid'])
    if not player.has_key(userid):
        player[userid] = Notifications(userid)
    if player_active:
        es.msg('#multi', text('activemsg', {'name':ev['es_username']}))

def player_spawn(ev):
    userid = int(ev['userid'])
    if player.has_key(userid) and int(ev['es_userteam']) > 1:
        player[userid].spawn()

def round_start(ev):
    global round_count
    if website_enable:
        round_count += 1
        if round_count == 4:
            es.msg('#multi', text('website', {'site':str(website)}))
            round_count = 0

def player_say(ev):
    player[int(ev['userid'])].say(ev['text'])

def player_blind(ev):
    userid = int(ev['userid'])
    if player_flash_duration and player.has_key(userid):
        player[userid].flashed(float(es.getplayerprop(userid, 'CCSPlayer.m_flFlashDuration')))

def player_hurt(ev):
    attacker = int(ev['attacker'])
    if player.has_key(attacker):
        player[attacker].hurt(ev['userid'], ev['es_username'], int(ev['health']), int(ev['dmg_health']))

def player_death(ev):
    userid = int(ev['userid'])
    if death_weapon and player.has_key(userid):
        player[userid].death(ev['attacker'], ev['weapon'], ev['es_attackername'], int(ev['es_attackerhealth']))

def bomb_dropped(ev):
    userid = bomb(2)
    if bomb_drop_death and player.has_key(userid):
        player[userid].dropped(int(ev['es_userhealth']), ev['es_username'])

def bomb_pickup(ev):
    userid = bomb(2)
    if bomb_picksup and player.has_key(userid):
        es.tell(userid, '#multi', text('bomb picked up', {'name':ev['es_username']}))

def bomb_beginplant(ev):
    userid = bomb(2)
    if bomb_planting and player.has_key(userid):
        es.tell(userid, '#multi', text('bomb planting', {'name':ev['es_username']}))

def bomb_planted(ev):
    userid = bomb(2)
    if bomb_has_been_planted and player.has_key(userid):
        es.tell(userid, '#multi', text('bomb planted', {'name':ev['es_username']}))

def bomb_begindefuse(ev):
    userid = bomb(3)
    if bomb_defusing and player.has_key(userid):
        es.tell(userid, '#multi', text('bomb defusing', {'name':ev['es_username']}))

def bomb_defused(ev):
    userid = bomb(3)
    if bomb_has_been_defused and player.has_key(userid):
        es.tell(userid, '#multi', text('bomb defused', {'name':ev['es_username']}))

def bomb(team):
    for x in filter(lambda x: es.getplayerteam(x) == team, es.getUseridList()):
        return x

def rates():
    userid = int(es.getcmduserid())
    if rate_player and player.has_key(userid):
        player[userid]._rates()

def showrates():
    userid = int(es.getcmduserid())
    if player_rates and player.has_key(userid):
        player[userid]._showrates()
