﻿import es
import gamethread
import popuplib
import usermsg
import msglib


updaterate = 1 # How often the menu should update (in seconds)
style = 2 # The style the spectators are shown ( 1 = hud hint, 2 = popup, 3 = toptext [You can set the updaterate pretty high with toptext])
max_length = 20 # The maximum length a name may have (Will be shortened otherwise: Absolute123 would be shortened to Absolu..)
advert_time = 120 # The time between the adverts (in seconds)
# Following are the colors of the toptext (if its used)
R = 175
G = 175
B = 175

info = es.AddonInfo()
info.author      = "DemonZeks"
info.name        = "Tell Spectator names"
info.basename    = "spec"
info.version     = "1.2"
info.url         = "http://addons.eventscripts.com/addons/view/%s"%info.basename
info.description = "Shows your current spectators" 

es.ServerVar(info.basename, info.version, info.description + " made by " + info.author).makepublic()

enabled = []
advert = 0
update_in_sec = 1 / updaterate
advert_time = advert_time * update_in_sec

def load():
    es.regsaycmd('!Зритель',"%s/disabled"%info.basename,"Включает или выключает меню")
    
def unload():
    es.unregsaycmd('!Зритель')
    
def disabled():
    uid = int(es.getcmduserid())
    if uid in enabled:
        es.tell(uid,"#multi","#green Вы выключили зрителей")
        enabled.remove(uid)
    else:
        es.tell(uid,"#multi","#green Вы включили зрителей")
        enabled.append(uid)

def player_connect(event_var):
    uid = int(event_var['userid'])
    enabled.append(uid)
def player_disconnect(event_var):
    uid = int(event_var['userid'])
    if uid in enabled:
        enabled.remove(uid)

def checkloop():
    global advert
    if not advert:
        advert = 0
    advert = advert + 1
    if advert >= advert_time:
        advert = 0
        es.msg("#multi","#greenВведите #lightgreen'!Зритель'#green для включения или выключения меню зрителей.")
    ulist = es.getUseridList()
    for uid in enabled:
        if es.getplayersteamid(uid) == "BOT":
            continue
        if not es.getplayerprop(uid, "CCSPlayer.baseclass.pl.deadflag"):
            if uid in ulist:
                ulist.remove(uid)
            spectators = ""
            temp = 0
            comparehandle = es.getplayerhandle(uid)
            for specs in ulist:
                if int(es.getplayerprop(specs, "CCSPlayer.baseclass.m_iObserverMode")) in (1,3,4):
                    if es.getplayerprop(specs, 'CBasePlayer.m_hObserverTarget') == comparehandle:
                        if specs in ulist:
                            ulist.remove(specs)
                        if len(es.getplayername(specs)) > max_length:
                            realname = es.getplayername(specs)[:max_length-2] + ".."
                        else:
                            realname = es.getplayername(specs)
                        if style == 3:
                            spectators = spectators + ", " + realname
                        elif style == 2:
                            spectators = spectators + "\n  " + realname
                        elif style == 1:
                            temp = temp + 1
                            if temp == 4:
                                temp = 0
                                spectators = spectators + "\n" + realname
                            else:
                                spectators = spectators + ", " + realname
                else:
                    ulist.remove(specs)
            if spectators:
                if style == 3:
                    msglib.VguiDialog('Your Spectators: ' + spectators[1:],'',5,"%s %s %s 255" % (R,B,G),updaterate).send(uid)
                elif style == 2:
                    popuplib.quicksend(updaterate, uid, "Твои зрители:" + spectators + "\nВведите !Зритель чтобы отключить меню")
                elif style == 1:
                    usermsg.hudhint(uid,"Your Spectators:\n" + spectators[1:])
          
    gamethread.delayed(updaterate,checkloop)
   
checkloop()