# CheapBleed release 5 by David Bowland
# ./addons/eventscripts/cheapbleed/cheapbleed.py

# >>> To configure this addon please see cheapbleed.cfg <<<

"""
Makes players lose health and emit blood as well as a pain sound every few seconds after being hurt. Requires only ES 2.0+
"""


import es
import gamethread
import os.path
import random


info = es.AddonInfo()
info.name = 'CheapBleed'
info.version = '5'
info.url = 'http://addons.eventscripts.com/addons/view/cheapbleed'
info.basename = 'cheapbleed'
info.author = 'SuperDave'


str_last_sound = ''
tuple_bleed_sounds = ('player/pl_pain6.wav', 'player/suit_sprint.wav', 'vo/npc/male01/pain01.wav', 'vo/npc/male01/pain02.wav', 'vo/npc/male01/pain03.wav', 'vo/npc/male01/pain04.wav', 'vo/npc/male01/pain05.wav', 'vo/npc/male01/pain06.wav', 'npc/barnacle/barnacle_crunch2.wav', 'npc/barnacle/barnacle_crunch3.wav', 'physics/flesh/flesh_squishy_impact_hard1.wav', 'physics/flesh/flesh_squishy_impact_hard2.wav', 'physics/flesh/flesh_squishy_impact_hard3.wav', 'physics/flesh/flesh_squishy_impact_hard4.wav')
dict_players = {}

dict_options = {'cheapbleed_damage_initial':[30, 'Percent of damage taken a player will lose on the first bleed'], 'cheapbleed_damage_attenuation':[45, 'Percent of damage taken by previous bleed that will be lost on the next bleed'], 'cheapbleed_delay_initial':[3, 'Number of seconds between taking damage and the first bleed'], 'cheapbleed_delay_attenuation':[150, 'Percent of previous bleed delay that will be the delay for the next bleed'], 'cheapbleed_sound_percent':[10, 'Percent of the map around a player that can hear when that player bleeds--set to 0 for no sound']}


def load():
   """Checks to make sure critical server variables are created by the config"""

   for str_option in dict_options:
      es.ServerVar(str_option, dict_options[str_option][0], dict_options[str_option][1])
   if os.path.isfile(es.getAddonPath('cheapbleed') + '/cheapbleed.cfg'):
      es.server.cmd('es_xmexec ../addons/eventscripts/cheapbleed/cheapbleed.cfg')
   else:
      es.dbgmsg(0, 'CheapBleed: Unable to load cheapbleed.cfg! Please ensure it is in the ./cheapbleed/ directory.')


def es_map_start(event_var):
   """Clears outstanding bleed delays"""
   global dict_players

   for str_userid in dict_players:
      dict_current_player = dict_players[str_userid]['victim']
      for str_attackerid in dict_current_player:
         for int_delay_count in dict_current_player[str_attackerid]:
            gamethread.cancelDelayed('cheapbleed_%s_%s_%s' % (str_userid, str_attackerid, int_delay_count))

   dict_players.clear()


def round_start(event_var):
   """Calls es_map_start to clear delays and prevent bleeding from past rounds"""
   es_map_start({})


def player_hurt(event_var):
   """Calculates the bleed damage from the hit and starts a bleed delay if that damage is over zero"""
   global dict_players

   float_damage = (float(event_var['dmg_health']) * es.ServerVar('cheapbleed_damage_initial')) / 100
   if int(float_damage) and event_var['weapon'] <> 'point_hurt':
      str_userid = event_var['userid']
      str_attackerid = event_var['attacker']
      if str_attackerid == '0':
         str_attackerid = event_var['userid']

      if not dict_players.has_key(str_userid):
         dict_players[str_userid] = {'victim':{}, 'attacker':{}}
      dict_current_victim = dict_players[str_userid]['victim']
      if not dict_players.has_key(str_attackerid):
         dict_players[str_attackerid] = {'victim':{}, 'attacker':{}}
      dict_current_attacker = dict_players[str_attackerid]['attacker']

      if dict_current_victim.has_key(str_attackerid):
         list_delays = dict_current_attacker[str_userid]
         int_delay_count = list_delays[len(list_delays) - 1] + 1
      else:
         dict_current_victim[str_attackerid] = []
         dict_current_attacker[str_userid] = []
         int_delay_count = 0

      dict_current_victim[str_attackerid].append(int_delay_count)
      dict_current_attacker[str_userid].append(int_delay_count)

      float_delay = float(es.ServerVar('cheapbleed_delay_initial'))
      gamethread.delayedname(float_delay, 'cheapbleed_%s_%s_%s' % (str_userid, str_attackerid, int_delay_count), execute_bleed, (int_delay_count, str_userid, str_attackerid, float_damage, float_delay))


def player_death(event_var):
   """Removes bleed delays where there dead player is the victim"""
   global dict_players

   str_userid = event_var['userid']
   if dict_players.has_key(str_userid):
      dict_current_victim = dict_players[str_userid]['victim']
      for str_attackerid in dict_current_victim:
         for int_delay_count in dict_current_victim[str_attackerid]:
            gamethread.cancelDelayed('cheapbleed_%s_%s_%s' % (str_userid, str_attackerid, int_delay_count))
         del dict_players[str_attackerid]['attacker'][str_userid]


def player_disconnect(event_var):
   """
   Calls player_death
   Removes bleed delays where the disconnecting players is the attacker
   """
   global dict_players

   str_userid = event_var['userid']
   if dict_players.has_key(str_userid):
      player_death(event_var)

      dict_current_attacker = dict_players[str_userid]['attacker']
      for str_victimid in dict_current_attacker:
         for int_delay_count in dict_current_attacker[str_victimid]:
            gamethread.cancelDelayed('cheapbleed_%s_%s_%s' % (str_victimid, str_userid, int_delay_count))

         del dict_players[str_victimid]['victim'][str_userid]


def unload():
   """Calls es_map_start to clear delays"""
   es_map_start({})

   for str_option in dict_options:
      es.ServerVar(str_option).set(0)


def execute_bleed(int_delay_count, str_userid, str_attackerid, float_damage, float_delay):
   """
   Gives the player the targetname "cheapbleeder"
   Emits blood from the player
   Hurts the player for the required damage
   Gives the player the targetname "none"
   Emits a bleed sound if necessary
   Calculates the next bleed damage and delay and starts a new bleed delay if necessary
   """
   global str_last_sound
   global dict_players

   es.server.cmd('es_xfire %s !self addoutput \"targetname cheapbleeder\"' % str_userid)

   es.server.cmd('es_xfire %s env_blood kill' % str_userid)
   es.server.cmd('es_xgive %s env_blood' % str_userid)
   es.server.cmd('es_xfire %s env_blood addoutput \"parentname cheapbleeder\"' % str_userid)
   es.server.cmd('es_xfire %s env_blood addoutput \"amount %s\"' % (str_userid, int(float_damage) * 10))
   es.server.cmd('es_xfire %s env_blood addoutput \"spawnflags 13\"' % str_userid)
   es.server.cmd('es_xfire %s env_blood emitblood' % str_userid)

   es.server.cmd('es_xfire %s point_hurt kill' % str_attackerid)
   es.server.cmd('es_xgive %s point_hurt' % str_attackerid)
   es.server.cmd('es_xfire %s point_hurt addoutput \"damagetarget cheapbleeder\"' % str_attackerid)
   es.server.cmd('es_xfire %s point_hurt addoutput \"damage %s\"' % (str_attackerid, int(float_damage)))
   es.server.cmd('es_xfire %s point_hurt addoutput \"damagetype 32\"' % str_attackerid)
   es.server.cmd('es_xfire %s point_hurt hurt' % str_attackerid)

   es.server.cmd('es_xfire %s !self addoutput \"targetname none\"' % str_userid)

   float_sound_attenuation = float(es.ServerVar('cheapbleed_sound_percent'))
   if float_sound_attenuation:
      list_possible_sounds = list(tuple_bleed_sounds)
      if str_last_sound in list_possible_sounds:
         list_possible_sounds.remove(str_last_sound)
      str_last_sound = random.choice(list_possible_sounds)
      es.emitsound('player', str_userid, str_last_sound, 1.0, (100 - float_sound_attenuation) / 100)

   float_damage = (float_damage * es.ServerVar('cheapbleed_damage_attenuation')) / 100
   float_delay = (float_delay * es.ServerVar('cheapbleed_delay_attenuation')) / 100
   if int(float_damage) and int(float_delay):
      gamethread.delayedname(float_delay, 'cheapbleed_%s_%s_%s' % (str_userid, str_attackerid, int_delay_count), execute_bleed, (int_delay_count, str_userid, str_attackerid, float_damage, float_delay))

   else:
      dict_current_victim = dict_players[str_userid]['victim']
      dict_current_victim[str_attackerid].remove(int_delay_count)
      if not dict_current_victim[str_attackerid]:
         del dict_current_victim[str_attackerid]

      dict_current_attacker = dict_players[str_attackerid]['attacker']
      dict_current_attacker[str_userid].remove(int_delay_count)
      if not dict_current_attacker[str_userid]:
         del dict_current_attacker[str_userid]