# ExplosiveDeaths release 3 by David Bowland
# ./addons/eventscripts/explosivedeaths/explosivedeaths.py

# >>> To configure this addon please see explosivedeaths.cfg <<<

"""
Randomly makes players explode when they die. Requires only ES 2.0+
"""


import es
import os.path
import random


info = es.AddonInfo()
info.name = 'ExplosiveDeaths'
info.version = '3'
info.url = 'http://addons.eventscripts.com/addons/view/explosivedeaths'
info.basename = 'explosivedeaths'
info.author = 'SuperDave'


dict_explosive_deaths = {}

tuple_tags = ('#all', '#primary', '#rifle', '#shotgun', '#smg', '#sniper', '#secondary', '#pistol', '#all_headshot', '#primary_headshot', '#rifle_headshot', '#shotgun_headshot', '#smg_headshot', '#sniper_headshot', '#secondary_headshot', '#pistol_headshot')
dict_weapons = {'deagle':['#all', '#secondary', '#pistol'], 'ak47':['#all', '#primary', '#rifle'], 'scout':['#all', '#primary', '#rifle', '#sniper'], 'aug':['#all', '#primary', '#rifle'], 'g3sg1':['#all', '#primary', '#rifle', '#sniper'], 'galil':['#all', '#primary', '#rifle'], 'famas':['#all', '#primary', '#rifle'], 'm4a1':['#all', '#primary', '#rifle'], 'sg552':['#all', '#primary', '#rifle'], 'sg550':['#all', '#primary', '#rifle', '#sniper'], 'm249':['#all', '#primary'], 'awp':['#all', '#primary', '#rifle', '#sniper'], 'tmp':['#all', '#primary', '#smg'], 'mp5navy':['#all', '#primary', '#smg'], 'glock':['#all', '#secondary', '#pistol'], 'elite':['#all', '#secondary', '#pistol'], 'm3':['#all', '#primary', '#shotgun'], 'xm1014':['#all', '#primary', '#shotgun'], 'usp':['#all', '#secondary', '#pistol'], 'mac10':['#all', '#primary', '#smg'], 'ump45':['#all', '#primary', '#smg'], 'p228':['#all', '#secondary', '#pistol'], 'fiveseven':['#all', '#secondary', '#pistol'], 'p90':['#all', '#primary', '#smg'], 'deagle_headshot':['#all', '#all_headshot', '#secondary', '#secondary_headshot', '#pistol', '#pistol_headshot'], 'ak47_headshot':['#all', '#all_headshot', '#primary', '#primary_headshot', '#rifle', '#rifle_headshot'], 'scout_headshot':['#all', '#all_headshot', '#primary', '#primary_headshot', '#rifle', '#rifle_headshot', '#sniper', '#sniper_headshot'], 'aug_headshot':['#all', '#all_headshot', '#primary', '#primary_headshot', '#rifle', '#rifle_headshot'], 'g3sg1_headshot':['#all', '#all_headshot', '#primary', '#primary_headshot', '#rifle', '#rifle_headshot', '#sniper', '#sniper_headshot'], 'galil_headshot':['#all', '#all_headshot', '#primary', '#primary_headshot', '#rifle', '#rifle_headshot'], 'famas_headshot':['#all', '#all_headshot', '#primary', '#primary_headshot', '#rifle', '#rifle_headshot'], 'm4a1_headshot':['#all', '#all_headshot', '#primary', '#primary_headshot', '#rifle', '#rifle_headshot'], 'sg552_headshot':['#all', '#all_headshot', '#primary', '#primary_headshot', '#rifle', '#rifle_headshot'], 'sg550_headshot':['#all', '#all_headshot', '#primary', '#primary_headshot', '#rifle', '#rifle_headshot', '#sniper', '#sniper_headshot'], 'm249_headshot':['#all', '#all_headshot', '#primary', '#primary_headshot'], 'awp_headshot':['#all', '#all_headshot', '#primary', '#primary_headshot', '#rifle', '#rifle_headshot', '#sniper', '#sniper_headshot'], 'tmp_headshot':['#all', '#all_headshot', '#primary', '#primary_headshot', '#smg', '#smg_headshot'], 'mp5navy_headshot':['#all', '#all_headshot', '#primary', '#primary_headshot', '#smg', '#smg_headshot'], 'glock_headshot':['#all', '#all_headshot', '#secondary', '#secondary_headshot', '#pistol', '#pistol_headshot'], 'elite_headshot':['#all', '#all_headshot', '#secondary', '#secondary_headshot', '#pistol', '#pistol_headshot'], 'm3_headshot':['#all', '#all_headshot', '#primary', '#primary_headshot', '#shotgun', '#shotgun_headshot'], 'xm1014_headshot':['#all', '#all_headshot', '#primary', '#primary_headshot', '#shotgun', '#shotgun_headshot'], 'usp_headshot':['#all', '#all_headshot', '#secondary', '#secondary_headshot', '#pistol', '#pistol_headshot'], 'mac10_headshot':['#all', '#all_headshot', '#primary', '#primary_headshot', '#smg', '#smg_headshot'], 'ump45_headshot':['#all', '#all_headshot', '#primary', '#primary_headshot', '#smg', '#smg_headshot'], 'p228_headshot':['#all', '#all_headshot', '#secondary', '#secondary_headshot', '#pistol', '#pistol_headshot'], 'fiveseven_headshot':['#all', '#all_headshot', '#secondary', '#secondary_headshot', '#pistol', '#pistol_headshot'], 'p90_headshot':['#all', '#all_headshot', '#primary', '#primary_headshot', '#smg', '#smg_headshot'], 'knife':['#all'], 'hegrenade':['#all'], 'other':['#all'], 'team':['#all'], 'team_suicide':['#all']}
dict_options = {'explosivedeaths_soundpercent':[15, 'Percent of map that can hear a player explode--set to 0 for no sound']}


def load():
   """
   Creates commands for settings
   Checks to make sure critical server variables are created by the config
   """

   if not es.exists('command', 'explosivedeaths_add'):
      es.regcmd('explosivedeaths_add', 'explosivedeaths/setting_cmd', 'explosivedeaths_add <weapon> <percent to explode> <magnitude> <radius>\nServer command for designating explosive death types')
   if not es.exists('command', 'explosivedeaths_remove'):
      es.regcmd('explosivedeaths_remove', 'explosivedeaths/setting_cmd', 'explosivedeaths_remove <weapon>\nServer command for removing explosive death types')

   for str_option in dict_options:
      es.ServerVar(str_option, dict_options[str_option][0], dict_options[str_option][1])
   if os.path.isfile(es.getAddonPath('explosivedeaths') + '/explosivedeaths.cfg'):
      es.server.cmd('es_xmexec ../addons/eventscripts/explosivedeaths/explosivedeaths.cfg')
   else:
      es.dbgmsg(0, 'ExplosiveDeaths: Unable to load explosivedeaths.cfg! Please ensure it is in the ./explosivedeaths/ directory.')


def player_death(event_var):
   """
   Determines the kill type
   Explodes the player if necessary
   """
   str_weapon = event_var['weapon']
   str_userid = event_var['userid']
   str_attackerid = event_var['attacker']

   if event_var['es_userteam'] == event_var['es_attackerteam']:
      if event_var['userid'] == event_var['attacker']:
         str_kill_type = 'team_suicide'
      else:
         str_kill_type = 'team'
   elif int(event_var['headshot']) and dict_weapons.has_key(str_weapon + '_headshot'):
      str_kill_type = str_weapon + '_headshot'
   elif dict_weapons.has_key(str_weapon):
      str_kill_type = str_weapon
   else:
      str_kill_type = 'other'

   if dict_explosive_deaths.has_key(str_kill_type):
      dict_current_death = dict_explosive_deaths[str_kill_type]
      if random.randint(1, 100) <= dict_current_death['percent']:
         for int_index in es.createentitylist('env_explosion'):
            es.server.cmd('es_xremove %s' % int_index)
         es.server.cmd('es_xgive %s env_explosion' % str_userid)
         es.server.cmd('es_xfire %s env_explosion addoutput \"imagnitude %s\"' % (str_userid, dict_current_death['magnitude']))
         es.server.cmd('es_xfire %s env_explosion addoutput \"iradiusoverride %s\"' % (str_userid, dict_current_death['radius']))
         es.setindexprop(es.ServerVar('eventscripts_lastgive'), 'CBaseEntity.m_hOwnerEntity', es.getplayerhandle(str_attackerid))
         es.server.cmd('es_xfire %s env_explosion explode' % str_userid)
         es.server.cmd('es_xfire %s env_explosion kill' % str_userid)
         es.emitsound('player', str_userid, 'weapons/hegrenade/explode%s.wav' % random.randint(3, 5), '1.0', (100 - float(es.ServerVar('explosivedeaths_soundpercent'))) / 100)


def unload():
   for str_option in dict_options:
      es.ServerVar(str_option).set(0)


def setting_cmd():
   """
   explosivedeaths_add <weapon> <percent chance of explosion> <magnitude> <radius>
   explosivedeaths_remove <weapon>
   Retrieves passed information
   Creates or removed weapons from dict_explosive_deaths
   Displays any necessary error messages
   """
   global dict_explosive_deaths

   str_command = es.getargv(0).lower()
   if es.getargc() == {'explosivedeaths_add':5, 'explosivedeaths_remove':2}[str_command]:
      str_weapon = es.getargv(1).lower()
      if str_command == 'explosivedeaths_add':
         int_percent_to_explode = int(es.getargv(2))
         int_magnitude = int(es.getargv(3))
         int_radius = int(es.getargv(4))

      if dict_weapons.has_key(str_weapon):
         if str_command == 'explosivedeaths_add':
            dict_explosive_deaths[str_weapon] = {'percent':int_percent_to_explode, 'magnitude':int_magnitude, 'radius':int_radius}
         elif dict_explosive_deaths.has_key(str_weapon):
               del dict_explosive_deaths[str_weapon]

      elif str_weapon in tuple_tags:
         if str_command == 'explosivedeaths_add':
            for str_loop_weapon in dict_weapons:
               if str_weapon in dict_weapons[str_loop_weapon]:
                  dict_explosive_deaths[str_loop_weapon] = {'percent':int_percent_to_explode, 'magnitude':int_magnitude, 'radius':int_radius}
         else:
            for str_loop_weapon in dict_weapons:
               if str_weapon in dict_weapons[str_loop_weapon] and dict_explosive_deaths.has_key(str_loop_weapon):
                  del dict_explosive_deaths[str_loop_weapon]

      else:
         es.dbgmsg(0, 'ExplosiveDeaths: Invalid weapon name, %s!' % str_weapon)
   else:
      es.dbgmsg(0, 'Syntax: ' + {'explosivedeaths_add':'explosivedeaths_add <weapon> <percent chance of explosion> <magnitude> <radius>', 'explosivedeaths_remove':'explosivedeaths_remove <weapon>'}[str_command])