#!/usr/bin/env python
# -*- coding: utf-8 -*-

import es
import playerlib
import cfglib

info = es.AddonInfo()
info.name = 'Knife Boost'
info.version = '2.0.1'
info.url = 'http://addons.eventscripts.com/addons/user/43738'
info.basename = 'knife_boost'
info.author = 'maniek23'
info.description   = "Every time you kill someone with knife, you regain 100% HP"

addon_tag = "#default[#greenKnife Boost#default]"

config = cfglib.AddonCFG(es.getAddonPath(info.basename) + '/' + info.basename + '.cfg')

config.text('%s by %s' % (info.name, info. author))
config.text('%s' % info.url)
config.text('')
config.text('Config File')
config.text('Generated with version %s' % info.version)
config.text('')
config.text('Load with: es_load %s' % info.basename)
config.text('')
config.text('')
config_starthealth = config.cvar('kb_starthealth', 100, 'Health value at round start')
config_killhealth = config.cvar('kb_killhealth', 100, 'Health value after killing someone')
config.text('')
config_maps = config.cvar('kb_maps', 'ka_', 'Maps (or prefixes) where Knife Boost is automatically turned on (split with ",")')
config.text('To manually turn on Knife Boost set cvar "kb_enabled" to 1 (Knife Boost must be loaded)')

config.write()

kb_enabled = es.ServerVar('kb_enabled', 0)

def load():
	config.execute()
	es.ServerVar("%s" % info.basename, "%s by %s - v. %s" % (info.name, info.author, info.version)).makepublic()
	es.ServerVar("%s_version" % info.basename, "%s" % info.version).makepublic()
	es.msg('#multi', '%s Loaded' % addon_tag)
	
def unload():
	es.msg('#multi', '%s Unloaded' % addon_tag)
	
def round_start(ev):
	for player in playerlib.getPlayerList('#alive'):
		player.setHealth(int(config_starthealth))
	
def es_map_start(ev):
	for map in str(config_maps).split(','):
		if map == ev['mapname'] or (map.endswith('_') and ev['mapname'].startswith(map)):
			kb_enabled.set(1)
			return
	
	kb_enabled.set(0)
	
def player_death(ev):
	if int(kb_enabled) and ev['es_userteam'] != ev['es_attackerteam'] and ev['es_attackerweapon'] == 'weapon_knife':
		player = playerlib.getPlayer(ev['attacker'])
		if player.getHealth() < int(config_killhealth):
			player.setHealth(int(config_killhealth))
		
