import es, os, string, time

class JoeyCMDs():
    def __init__(self, prefix=None):
        self.prefix = prefix

    class DoCommand:
        def __init__(self, name, prefix):
            self.prefix = prefix
            self.name = name

        def __call__(self, *args):
            command = self.name.lower()
            if not self.prefix == None:
                command = self.prefix + "_" + command
            if es.exists("command", command):
                error = None
                if len(commands) > 0:
                    if command in commands:
                        minargs = len(commands[command][1])
                        maxargs = minargs + len(commands[command][2])
                        if len(args) < minargs or len(args) > maxargs:
                            LogError("Syntax Error: %s - %s" % (command, commands[command][3].replace('"', '')))
                            LogError("Syntax: %s" % commands[command][4])
                            error = 1
                if error == None:
                    for arg in args:
                        arg = str(arg)
                        if len(arg.split()) > 1:
                            if not arg.startswith('"'):
                                arg = '"' + arg + '"'
                        command += " "
                        if isinstance(arg, es.ServerVar):
                            command += arg.getName
                        else:
                            command += str(arg)
                    self.RunCommand(command)
            else:
                LogError("Unknown command: %s" % command)

        def RunCommand(self, output):
            es.server.cmd(output)

    def __getattr__(self, name):
        try:
            return self.DoCommand(name, self.prefix)
        except:
            if not self.prefix == None:
                command = self.prefix + "_" + command
            LogError("An unknown error occure whilst running command: %s" % command)

def LoadCommands():
    commands = {}
    path = es.ServerVar("eventscripts_gamedir") + "/cfg/JoeyCMDs.txt"
    if not os.path.exists(path):
        open(path, "w").close()
    if os.path.exists(path):
        file = open(path, "r").read()
        for cmd in file.split("\n"):
            if not cmd.startswith("//") and not cmd.strip() == "":
                cmd = cmd.split(",")
                command = cmd[0].lower()
                commands[command] = {}
                commands[command][0] = command
                commands[command][1] = []
                commands[command][2] = []
                commands[command][3] = None
                commands[command][4] = None
                numbers = []
                num = -1
                for x in cmd:
                    num += 1
                    numbers.append(num)
                for x in numbers:
                    temp = cmd[x].strip()
                    if temp.startswith("<") and temp.endswith(">"):
                        commands[command][1].append(temp)
                    if temp.startswith("[") and temp.endswith("]"):
                        commands[command][2].append(temp)
                    if temp.startswith('"') and temp.endswith('"'):
                        commands[command][3] = temp
                        syntax = ""
                        temp = cmd[:x]
                        for piece in temp:
                            syntax += piece
                        commands[command][4] = syntax
    return commands

def LogError(e):
    es.dbgmsg(0, e)
    path = es.ServerVar("eventscripts_gamedir") + "/cfg/JoeyCMDs_Errors.txt"
    if not os.path.exists(path):
        open(path, "w").close()
    if os.path.exists(path):
        file = open(path, "a")
        file.write("%s: %s\n" % (time.ctime(), e))
        file.close()

commands = LoadCommands()