# ./addons/eventscripts/extendedevents/events/player_ping.py

"""
player_ping
"""


""" Event imports """

import es
import gamethread

import psyco
psyco.full()


""" ExtendedEvents import """

from extendedevents import extendedevents

""" Event class """

class PlayerPing(extendedevents.Event):
   def __init__(self, gamename):
      if gamename == 'cstrike':
         self.managername = 'cs_player_manager'
      elif gamename == 'dod':
         self.managername = 'dod_player_manager'
      elif gamename == 'hl2mp':
         self.managername = 'player_manager'
      elif gamename == 'tf':
         self.managername = 'player_manager'
      else:
         raise NotImplementedError, 'Event player_ping only supports cstrike/dod/hl2mp/tf'

      self.players = {}

   def mapStart(self):
      self.loadRes('player_ping')
      gamethread.delayed(0.1, self.getManagerIndex)

   def playerSpawn(self, userid):
      index = es.createplayerlist(userid)[userid]['index']
      self.players[userid] = {'index':index, 'ping':self.getPing(index)}

   def playerDisconnect(self, userid):
      if userid in self.players:
         del self.players[userid]

   def tick(self, useridlist):
      for userid in useridlist:
         if userid in self.players:
            player = self.players[userid]
            oldval = player['ping']
            newval = player['ping'] = self.getPing(player['index'])

            if oldval <> newval:
               self.fire('player_ping', {'userid':('int', userid), 'ping':('int', newval)})

         else:
            self.playerSpawn(userid)

   def getPing(index):
      return es.getindexprop(self.managerindex, 'CPlayerResource.m_iPing.%03d' % index)

   def getManagerIndex():
      self.managerindex = es.getentityindex(self.managername)

def getEvent():
   return PlayerPing