# ./addons/eventscripts/extendedevents/events/player_move.py

"""
player_move
"""


""" Event imports """

import es

import psyco
psyco.full()


""" ExtendedEvents import """

from extendedevents import extendedevents


""" Event class """

class PlayerMove(extendedevents.Event):
   def __init__(self, gamename):
      self.players = {}

   def mapStart(self):
      self.loadRes('player_move')
      self.players.clear()

   def playerSpawn(self, userid):
      self.players[userid] = es.getplayerlocation(userid)

   def playerDisconnect(self, userid):
      if userid in self.players:
         del self.players[userid]

   def tick(self, useridlist):
      for userid in useridlist:
         if userid in self.players:
            oldpos = self.players[userid]
            newpos = self.players[userid] = es.getplayerlocation(userid)

            if oldpos <> newpos:
               self.fire('player_move', {'userid':('int', userid), 'x':('float', abs(oldpos[0] - newpos[0])), 'y':('float', abs(oldpos[1] - newpos[1])), 'z':('float', abs(oldpos[2] - newpos[2]))})

         else:
            self.players[userid] = es.getplayerlocation(userid)


""" Event return function """

def getEvent():
   return PlayerMove