# ./addons/eventscripts/extendedevents/events/player_dod.py

"""
player_mgdeploy
player_prone
player_sprint
player_stamina
player_stun
player_unstun
"""


""" Event imports """

import es
import gamethread

import psyco
psyco.full()


""" ExtendedEvents import """

from extendedevents import extendedevents


""" Event class """

class PlayerDoD(extendedevents.Event):
   def __init__(self, gamename):
      if gamename <> 'dod': raise NotImplementedError, 'Event player_dod is only available for DoD:S'

      self.players = {}
      self.stunned = set()

   def mapStart(self):
      self.loadRes('player_dod')
      self.clearDelays()

      self.players.clear()
      self.stunned.clear()

   def playerSpawn(self, userid):
      self.players[userid] = {'sprinting':self.getSprinting(userid), 'prone':self.getProne(userid), 'mg':self.getMGDeployed(userid), 'stamina':self.getStamina(userid), 'stun':self.getStun(userid)}

   def playerDisconnect(self, userid):
      if userid in self.players:
         del self.players[userid]
      self.removeDelay(userid)

   def tick(self, useridlist):
      for userid in useridlist:
         if userid in self.players:
            player = self.players[userid]

            oldval = player['sprinting']
            newval = player['sprinting'] = self.getSprinting(userid)
            if oldval <> newval:
               self.fire('player_sprint', {'userid':('int', userid), 'state':('string', 'START' if newval else 'STOP')})

            oldval = player['prone']
            newval = player['prone'] = self.getProne(userid)
            if oldval <> newval:
               self.fire('player_prone', {'userid':('int', userid), 'state':('string', 'ENTER' if newval else 'EXIT')})

            oldval = player['mg']
            newval = player['mg'] = self.getMGDeployed(userid)
            if oldval <> newval:
               self.fire('player_mgdeploy', {'userid':('int', userid), 'state':('float', newval)})

            oldval = player['stamina']
            newval = player['stamina'] = self.getStamina(userid)
            if oldval <> newval:
               self.fire('player_stamina', {'userid':('int', userid), 'newvalue':('float', newval), 'oldvalue':('float', oldval), 'change':('float', newval - oldval)})

            oldval = player['stun']
            newval = player['stun'] = self.getStun(userid)
            if oldval <> newval:
               duration, alpha = newval
               if duration and alpha:
                  self.fire('player_stun', {'userid':('int', userid), 'duration':('float', duration), 'alpha':('int', alpha)})
                  self.addStun(userid, duration)

               else:
                  self.removeDelay(userid)
                  self.fire('player_unstun', {'userid':('int', userid)})

         else:
            self.playerSpawn(userid)

   def unstun(self, userid):
      if userid in self.stunned:
         self.stunned.remove(userid)
         self.fire('player_unstun', {'userid':('int', userid)})

   def addStun(self, userid, duration):
      self.stunned.add(userid)
      gamethread.delayedname(duration, 'extendedevents_player_dod_%s' % userid, self.unstun, userid)

   def removeDelay(self, userid):
      if userid in self.stunned:
         self.stunned.remove(userid)
         gamethread.cancelDelayed('extendedevents_player_dod_%s' % userid)

   def clearDelays(self):
      for userid in self.stunned:
         gamethread.cancelDelayed('extendedevents_player_dod_%s' % userid)
      self.stunned.clear()

   def unload(self):
      self.clearDelays()

   @staticmethod
   def getSprinting(userid):
      return es.getplayerprop(userid, 'CDODPlayer.m_Shared.m_bIsSprinting') % 2

   @staticmethod
   def getProne(userid):
      return es.getplayerprop(userid, 'CDODPlayer.m_Shared.m_bProne') % 2

   @staticmethod
   def getMGDeployed(userid):
      return es.getplayerprop(userid, 'CDODPlayer.m_Shared.m_flDeployChangeTime')

   @staticmethod
   def getStamina(userid):
      return es.getplayerprop(userid, 'CDODPlayer.m_Shared.m_flStamina')

   @staticmethod
   def getStun(userid):
      return es.getplayerprop(userid, 'CDODPlayer.dodlocaldata.m_flStunDuration'), es.getplayerprop(userid, 'CDODPlayer.dodlocaldata.m_flStunMaxAlpha')


""" Event return function """

def getEvent():
   return PlayerDoD