# ./addons/eventscripts/extendedevents/events/player_capturearea.py
# Special thanks to Ojii and EmbouT for this event module!

"""
player_capturearea
"""


""" Event imports """

import es

import psyco
psyco.full()


""" ExtendedEvents import """

from extendedevents import extendedevents


""" Event class """

class PlayerCaptureArea(extendedevents.Event):
   def __init__(self, gamename):
      if gamename <> 'dod': raise NotImplementedError, 'Event player_capturearea is only available for DoD:S'

      self.players = {}

      self.registerForEvent('player_capturearea', 'dod_bomb_exploded', self.bombExploded)
      self.registerForEvent('player_capturearea', 'dod_point_captured', self.pointCaptured)

   def mapStart(self):
      self.loadRes('player_capturearea')

      self.players.clear()
      self.last_bomb = 0

   def playerSpawn(self, userid):
      self.players[userid] = self.checkCaptureArea(userid)

   def playerDisconnect(self, userid):
      if userid in self.players:
         del self.players[userid]

   def tick(self, useridlist):
      for userid in useridlist:
         if userid in self.players:
            oldstate = self.players[userid]
            newstate = self.players[userid] = self.checkCaptureArea(userid)

            if oldstate <> newstate:
               if newstate == -1:
                  action, cp = 'EXIT', oldstate

               else:
                  action, cp = 'ENTER', newstate

               self.fire('player_capturearea', {'userid':('int', userid), 'action':('string', action), 'cp':('int', cp)})

         else:
            self.playerSpawn(userid)

   def bombExploded(self, event_var):
      self.last_bomb = int(event_var['userid'])

   def pointCaptured(self, event_var):
      capturelist = set()

      cp   = int(event_var['cp'])
      bomb = int(event_var['bomb'])

      if bomb == 1:
         capturelist.add(self.last_bomb)
         self.last_bomb = 0

      else:
         for userid in filter(lambda x: self.checkCaptureArea(x) == cp, es.getUseridList()):
            if not es.getplayerprop(userid, 'CBasePlayer.pl.deadflag'):
               capturelist.add(userid)

      self.fire('dod_flag_captured', {'cp':('int', cp), 'cpname':('string', event_var['cpname']), 'cappers':('string', ','.join(map(str, sorted(capturelist)))), 'bomb':('int', bomb)})

   def unload(self):
      self.unregisterForEvent('player_capturearea', 'dod_bomb_exploded')
      self.unregisterForEvent('player_capturearea', 'dod_point_captured')

   @staticmethod
   def checkCaptureArea(userid):
      return es.getplayerprop(userid, 'CDODPlayer.m_Shared.dodsharedlocaldata.m_iCPIndex')


""" Event return function """

def getEvent():
   return PlayerCaptureArea