# ./addons/eventscripts/extendedevents/events/addon_action.py

"""
addon_action
"""


""" Event imports """

import es

import psyco
psyco.full()


""" ExtendedEvents import """

from extendedevents import extendedevents


""" Event class """

class AddonAction(extendedevents.Event):
   def __init__(self, gamename):
      self.addons = self.getLoadedAddons()

   def mapStart(self):
      self.loadRes('addon_action')

   def tick(self, useridlist):
      old_addons = self.addons
      new_addons = self.addons = self.getLoadedAddons()

      for addon in old_addons:
         if addon in new_addons:
            current_addon = new_addons[addon]
            new_status = current_addon['status']

            if old_addons[addon]['status'] <> new_status:
               self.fire('addon_action', {'name':('string', addon), 'action':('string', 'ENABLE' if new_status == 'enabled' else 'DISABLE'), 'type':('string', current_addon['type'].upper())})

         else:
            self.fire('addon_action', {'name':('string', addon), 'action':('string', 'UNLOAD'), 'type':('string', old_addons[addon]['type'].upper())})
      
      for addon in new_addons:
         if addon not in old_addons:
            self.fire('addon_action', {'name':('string', addon), 'action':('string', 'LOAD'), 'type':('string', new_addons[addon]['type'].upper())})

   @staticmethod
   def getLoadedAddons():
      addons = es.createscriptlist()
      if 'extendedevents' in addons: return addons

      for addon in es.addons.getAddonList():
         name = addon.__name__
         addons[name[0:name.rfind('.')].replace('.', '/')] = {'status':'enabled', 'type':'py'}

      return addons


""" Event return function """

def getEvent():
   return AddonAction