# SplashDamage release 3 by David Bowland
# ./addons/eventscripts/splashdamage/splashdamage.py

# >>> To configure this addon please see splashdamage.cfg <<<

"""
Distributes part of the damage each player takes to surrounding players. Requires only ES 2.0+
"""


import es
import os.path
import random


info = es.AddonInfo()
info.name = 'SplashDamage'
info.version = '3'
info.url = 'http://addons.eventscripts.com/addons/view/splashdamage'
info.basename = 'splashdamage'
info.author = 'SuperDave'


dict_splash_damage = {}

tuple_tags = ('#all', '#primary', '#rifle', '#shotgun', '#smg', '#sniper', '#secondary', '#pistol', '#all_headshot', '#primary_headshot', '#rifle_headshot', '#shotgun_headshot', '#smg_headshot', '#sniper_headshot', '#secondary_headshot', '#pistol_headshot')
dict_weapons = {'deagle':['#all', '#secondary', '#pistol'], 'ak47':['#all', '#primary', '#rifle'], 'scout':['#all', '#primary', '#rifle', '#sniper'], 'aug':['#all', '#primary', '#rifle'], 'g3sg1':['#all', '#primary', '#rifle', '#sniper'], 'galil':['#all', '#primary', '#rifle'], 'famas':['#all', '#primary', '#rifle'], 'm4a1':['#all', '#primary', '#rifle'], 'sg552':['#all', '#primary', '#rifle'], 'sg550':['#all', '#primary', '#rifle', '#sniper'], 'm249':['#all', '#primary'], 'awp':['#all', '#primary', '#rifle', '#sniper'], 'tmp':['#all', '#primary', '#smg'], 'mp5navy':['#all', '#primary', '#smg'], 'glock':['#all', '#secondary', '#pistol'], 'elite':['#all', '#secondary', '#pistol'], 'm3':['#all', '#primary', '#shotgun'], 'xm1014':['#all', '#primary', '#shotgun'], 'usp':['#all', '#secondary', '#pistol'], 'mac10':['#all', '#primary', '#smg'], 'ump45':['#all', '#primary', '#smg'], 'p228':['#all', '#secondary', '#pistol'], 'fiveseven':['#all', '#secondary', '#pistol'], 'p90':['#all', '#primary', '#smg'], 'deagle_headshot':['#all', '#all_headshot', '#secondary', '#secondary_headshot', '#pistol', '#pistol_headshot'], 'ak47_headshot':['#all', '#all_headshot', '#primary', '#primary_headshot', '#rifle', '#rifle_headshot'], 'scout_headshot':['#all', '#all_headshot', '#primary', '#primary_headshot', '#rifle', '#rifle_headshot', '#sniper', '#sniper_headshot'], 'aug_headshot':['#all', '#all_headshot', '#primary', '#primary_headshot', '#rifle', '#rifle_headshot'], 'g3sg1_headshot':['#all', '#all_headshot', '#primary', '#primary_headshot', '#rifle', '#rifle_headshot', '#sniper', '#sniper_headshot'], 'galil_headshot':['#all', '#all_headshot', '#primary', '#primary_headshot', '#rifle', '#rifle_headshot'], 'famas_headshot':['#all', '#all_headshot', '#primary', '#primary_headshot', '#rifle', '#rifle_headshot'], 'm4a1_headshot':['#all', '#all_headshot', '#primary', '#primary_headshot', '#rifle', '#rifle_headshot'], 'sg552_headshot':['#all', '#all_headshot', '#primary', '#primary_headshot', '#rifle', '#rifle_headshot'], 'sg550_headshot':['#all', '#all_headshot', '#primary', '#primary_headshot', '#rifle', '#rifle_headshot', '#sniper', '#sniper_headshot'], 'm249_headshot':['#all', '#all_headshot', '#primary', '#primary_headshot'], 'awp_headshot':['#all', '#all_headshot', '#primary', '#primary_headshot', '#rifle', '#rifle_headshot', '#sniper', '#sniper_headshot'], 'tmp_headshot':['#all', '#all_headshot', '#primary', '#primary_headshot', '#smg', '#smg_headshot'], 'mp5navy_headshot':['#all', '#all_headshot', '#primary', '#primary_headshot', '#smg', '#smg_headshot'], 'glock_headshot':['#all', '#all_headshot', '#secondary', '#secondary_headshot', '#pistol', '#pistol_headshot'], 'elite_headshot':['#all', '#all_headshot', '#secondary', '#secondary_headshot', '#pistol', '#pistol_headshot'], 'm3_headshot':['#all', '#all_headshot', '#primary', '#primary_headshot', '#shotgun', '#shotgun_headshot'], 'xm1014_headshot':['#all', '#all_headshot', '#primary', '#primary_headshot', '#shotgun', '#shotgun_headshot'], 'usp_headshot':['#all', '#all_headshot', '#secondary', '#secondary_headshot', '#pistol', '#pistol_headshot'], 'mac10_headshot':['#all', '#all_headshot', '#primary', '#primary_headshot', '#smg', '#smg_headshot'], 'ump45_headshot':['#all', '#all_headshot', '#primary', '#primary_headshot', '#smg', '#smg_headshot'], 'p228_headshot':['#all', '#all_headshot', '#secondary', '#secondary_headshot', '#pistol', '#pistol_headshot'], 'fiveseven_headshot':['#all', '#all_headshot', '#secondary', '#secondary_headshot', '#pistol', '#pistol_headshot'], 'p90_headshot':['#all', '#all_headshot', '#primary', '#primary_headshot', '#smg', '#smg_headshot'], 'knife':['#all'], 'hegrenade':['#all'], 'other':['#all'], 'team':['#all'], 'team_self':['#all']}


def load():
   """
   Creates the commands for settings
   Executes the option config file
   """

   if not es.exists('command', 'splashdamage_add'):
      es.regcmd('splashdamage_add', 'splashdamage/setting_cmd', 'splashdamage_add <weapon> <percent transferred> <radius>\nServer command for designating splash damage triggers')
   if not es.exists('command', 'splashdamage_remove'):
      es.regcmd('splashdamage_remove', 'splashdamage/setting_cmd', 'splashdamage_remove <weapon>\nServer command for removing splash damage triggers')

   if os.path.isfile(es.getAddonPath('splashdamage') + '/splashdamage.cfg'):
      es.server.cmd('es_xmexec ../addons/eventscripts/splashdamage/splashdamage.cfg')
   else:
      es.dbgmsg(0, 'SplashDamage: Unable to load splashdamage.cfg! Please ensure it is in the ./splashdamage/ directory.')


def player_hurt(event_var):
   """
   Determines the damage type
   Creates splash damage if necessary
   """
   str_weapon = event_var['weapon']
   str_userid = event_var['userid']
   str_attackerid = event_var['attacker']

   if str_weapon == 'env_explosion':
      str_damage_type = 'none'
   elif event_var['es_userteam'] == event_var['es_attackerteam']:
      if event_var['userid'] == event_var['attacker']:
         str_damage_type = 'team_self'
      else:
         str_damage_type = 'team'
   elif int(event_var['hitgroup']) == 1 and dict_weapons.has_key(str_weapon + '_headshot'):
      str_damage_type = str_weapon + '_headshot'
   elif dict_weapons.has_key(str_weapon):
      str_damage_type = str_weapon
   else:
      str_damage_type = 'other'

   if dict_splash_damage.has_key(str_damage_type):
      dict_current_damage = dict_splash_damage[str_damage_type]
      int_magnitude = int((int(event_var['dmg_health']) * dict_current_damage['percent']) / 100)
      if int_magnitude:
         for int_index in es.createentitylist('env_explosion'):
            es.server.cmd('es_xremove %s' % int_index)
         es.setplayerprop(str_userid, 'CBasePlayer.m_iHealth', es.getplayerprop(str_userid, 'CBasePlayer.m_iHealth') + int_magnitude)
         es.server.cmd('es_xgive %s env_explosion' % str_userid)
         es.server.cmd('es_xfire %s env_explosion addoutput \"imagnitude %s\"' % (str_userid, int_magnitude))
         es.server.cmd('es_xfire %s env_explosion addoutput \"iradiusoverride %s\"' % (str_userid, dict_current_damage['radius']))
         es.server.cmd('es_xfire %s env_explosion addoutput \"spawnflags 572\"' % str_userid)
         es.setindexprop(es.ServerVar('eventscripts_lastgive'), 'CBaseEntity.m_hOwnerEntity', es.getplayerhandle(str_attackerid))
         es.server.cmd('es_xfire %s env_explosion explode' % str_userid)
         es.server.cmd('es_xfire %s env_explosion kill' % str_userid)


def setting_cmd():
   """
   Retrieves passed information
   Creates or removed weapons from dict_splash_damage
   Displays any necessary error messages
   """
   global dict_splash_damage

   str_command = es.getargv(0).lower()
   if es.getargc() == {'splashdamage_add':4, 'splashdamage_remove':2}[str_command]:
      str_weapon = es.getargv(1).lower()
      if str_command == 'splashdamage_add':
         int_percent_transferred = int(es.getargv(2))
         int_radius = int(es.getargv(3))

      if dict_weapons.has_key(str_weapon):
         if str_command == 'splashdamage_add':
            dict_splash_damage[str_weapon] = {'percent':int_percent_transferred, 'radius':int_radius}
         elif dict_splash_damage.has_key(str_weapon):
               del dict_splash_damage[str_weapon]

      elif str_weapon in tuple_tags:
         for str_loop_weapon in dict_weapons:
            if str_weapon in dict_weapons[str_loop_weapon]:
               if str_command == 'splashdamage_add':
                  dict_splash_damage[str_loop_weapon] = {'percent':int_percent_transferred, 'radius':int_radius}
               elif dict_splash_damage.has_key(str_loop_weapon):
                  del dict_splash_damage[str_loop_weapon]

      else:
         es.dbgmsg(0, 'SplashDamage: Invalid weapon name, %s!' % str_weapon)
   else:
      es.dbgmsg(0, 'Syntax: ' + {'splashdamage_add':'splashdamage_add <weapon> <percent transferred> <radius>', 'splashdamage_remove':'splashdamage_remove <weapon>'}[str_command])