import es
import cfglib
import gamethread
import playerlib
import popuplib
import langlib

# Addon information

info = es.AddonInfo()
info.name = "VotePlugIn"
info.version = "1"
info.author = "4dd0n"
info.url = "http://www.hammerscript.webcindario.com"
info.basename = "voteplugin"
info.description = "A plugin that allows the players vote to load another plugin, listed in the 'plugins' dict"
voteplugin = es.ServerVar('voteplugin',info.version,'VotePlugIn Version -==- Made by 4dd0n').makepublic()


""" Change with the plugins that you want """
# Dictionary with the plugins
"""
	plugins = {
		"plugin name"		:[1, 'Load "plugin name"'],
		 "radmod"				:[1, "Load Radiactive Mod"],
		 }
"""
plugins = {
	'radmod' :[1, "Load radiactive mod"]
	}

""" DON'T CHANGE ANYTHING FROM HERE !!	"""
""" 			THINKS COULD WORK WRONG			"""

# Dictionary with the default cfg options
dict_options = {
	'voteplugin_votetime'		:[30,'The time allowed to vote, in seconds'],
	'voteplugin_minplayers'	:[2,'Minimum cantity of players to start a vote'],
	'voteplugin_showyes'		:[1,'Notice the players when a player agrees'],
	'voteplugin_showno'			:[1,'Notice the players when a player desagrees']
	}
	
# Dictionary with the vote propierties	
vote = {
	"voting"				:			"0",
	"plugin"				:			"",
	"Si"						:			0,
	"No"						:			0,
	"votedplayers"		:			0,
	"totalplayers"		:			0,
	"players"				: 			[],
	"voter"					:			""
	}
	
text = None	

def load():
	global text
	# Load the default configuration
	for a in dict_options:
		es.ServerVar(a, dict_options[a][0], dict_options[a][1])
	# Make the saycmds
	es.regsaycmd("!pluginmenu", "voteplugin/SendPluginMenu")
	es.regsaycmd("!pluginvote", "voteplugin/reSendMenu")
	#es.regsaycmd("!tellmeall", "voteplugin/tellmeall")  (DEBUG SAYCOMMAND)
	
	# Load the server configuration
	config = cfglib.AddonCFG(es.getAddonPath('voteplugin').replace('\\','/') + '/config.cfg')
	config.execute()
	
	#Notice that the plugin was loaded
	es.msg("#multi", "#lightgreen[#greenVotePlugIn#lightgreen]:#default Loaded!")
	
	# Load the langlib strings
	text = langlib.Strings(es.getAddonPath("voteplugin") + "/strings.ini")

def unload():
	# Delete all the popups
	if popuplib.exists("agreemenu"): 
		popuplib.delete("agreemenu")
	if popuplib.exists("pluginmenu"): 
		popuplib.delete("pluginmenu")
	
	# Unregister the say cmds
	if es.exists('saycommand', "!pluginmenu"):
		es.unregsaycmd("!pluginmenu")
	if es.exists('saycommand', "!pluginvote"):
		es.unregsaycmd("!pluginvote")
		
	#Cancel the posible gamethread delayeds
	gamethread.cancelDelayed('votacion') 
	
	#Notice that the plugin was unloaded
	es.msg("#multi", "#lightgreen[#greenVotePlugIn#lightgreen]:#default Unloaded!")
	
def reSendMenu():
	user = es.getcmduserid()
	if vote['voting'] == "1":
		if not user in vote['players']:
			# If the player didn't has voted and there is a addOn with a vote, send the menu
			# Tokens for the ini file
			tokens = {}
			# The name of the player that wants to load the addon
			tokens['username'] = vote["voter"]
			# The name of the plugin
			tokens['pluginname'] = vote["plugin"]
			if popuplib.exists("agreemenu"): 
				# If the popup exists, delete it
				popuplib.delete("agreemenu")
			# The languaje of the player
			lang = playerlib.getPlayer(user).get("lang")
			# To make the popup
			agreemenu = popuplib.easymenu('agreemenu', '_popup_choice', agree_menu)
			agreemenu.settitle(text("menu 3", tokens, lang))
			agreemenu.addoption("si", text("menu 9", None, lang))
			agreemenu.addoption("no", text("menu 10", None, lang))
			# Send the popup
			agreemenu.send(user)
		else:
			# Notice the player that he already has voted
			es.tell(user, "#multi", text("menu 7", None, playerlib.getPlayer(user).get("lang")))
	else:
		# Notice the player that he already has voted
			es.tell(user, "#multi", text("menu 11", None, playerlib.getPlayer(user).get("lang")))
	
def SendPluginMenu():		
	userid = es.getcmduserid()
	if es.getplayercount() >= int(es.ServerVar("voteplugin_minplayers")):
		if popuplib.exists("pluginmenu"): 
			popuplib.delete("pluginmenu")
		lang = playerlib.getPlayer(userid).get("lang")
		plnmenu = popuplib.easymenu('plnmenu', '_popup_choice', plugin_menu) 
		plnmenu.settitle(text("menu 1", None, lang))
		for plugin in plugins:
			if plugins[plugin][0] == 1:
				plnmenu.addoption(plugin, plugin)
		plnmenu.send(userid)
	else:
		tokens = {}
		tokens['players'] = int(es.ServerVar("voteplugin_minplayers"))
		for user in es.getUseridList():
			es.tell(user, "#multi", text("dont notify", tokens, playerlib.getPlayer(user).get("lang")))

def plugin_menu(userid, choice, popupid):
	if vote['voting'] == "0":
		# If there is not a plugin getting voted
		# Tokens for the ini file
		tokens = {}
		# The name of the player that wants to load the addOn
		tokens['username'] = es.getplayername(userid)
		# The addOn that the player wants to load
		tokens['pluginname'] = choice
		# Set the vote config
		vote["plugin"] = choice
		vote["voting"] = "1"
		vote["voter"]  = es.getplayername(userid)
		for user in es.getUseridList():
			# Notice every player that an addOn is getting voted and send the popup
			es.tell(user, "#multi", text("menu 2", tokens, playerlib.getPlayer(user).get("lang")))
			if popuplib.exists("agreemenu"): 
				# If the popup exists, delete it
				popuplib.delete("agreemenu")
			# The languaje of the player
			lang = playerlib.getPlayer(user).get("lang")
			# To make the popup
			agreemenu = popuplib.easymenu('agreemenu', '_popup_choice', agree_menu)
			agreemenu.settitle(text("menu 3", tokens, lang))
			agreemenu.addoption("si", text("menu 9", None, lang))
			agreemenu.addoption("no", text("menu 10", None, lang))
			# Send the popup
			agreemenu.send(user)
	# Save the number of the current players
	for user in es.getUseridList():
		vote['totalplayers'] += 1
	# Save the time allowed to vote in the config
	time = int(es.ServerVar("voteplugin_votetime"))
	# After the time, end the vote
	gamethread.delayedname(time, "votacion", stopVoting, (choice))
		
def agree_menu(userid, choice, popupid):
	tokens = {}
	# Save the playername of the player that wants to load the addOn
	tokens['exname'] = vote['voter']
	if vote['voting'] == "1":
		if not userid in vote['players']:
			# If the player is not in the players list
			tokens['username'] = es.getplayername(userid)
			if choice == "si":
				# If the choice is "si", increment in 1 the Si answer
				vote['Si'] += 1
				if int(es.ServerVar("voteplugin_showyes")):
					# Notice the other players that the player has agreed with the player
					es.tell(userid, "#multi", text("menu 4", tokens, playerlib.getPlayer(userid).get("lang")))
			elif choice == "no":
				# If the choice is "no", increment in 1 the No answer
				vote['No'] += 1
				if int(es.ServerVar("voteplugin_showno")):
					# Notice the other players that the player has not agreed with the player
					es.tell(userid, "#multi", text("menu 5", tokens, playerlib.getPlayer(userid).get("lang")))
			# Increase in 1 the variable that saves the number of the players that has voted
			vote['votedplayers'] += 1
			# Add his userid in the variable that saves the players that has voted
			vote['players'].append(userid)
		else:
			# Notice the player that he already has voted
			es.tell(userid, "#multi", text("menu 7", None, playerlib.getPlayer(userid).get("lang")))

def stopVoting(plugin):
	# Save the tokens for the ini file
	tokens = {}
	# The name of the plugin
	tokens['pluginname'] = vote['plugin']
	if vote['Si'] > vote['No']:
		# If the players have voted more Si than No, ...
		# Load the plugin
		es.load(vote['plugin'])
		for user in es.getUseridList():
			# Notice every player that the plugin is going to being load
			es.tell(user, "#multi", text("menu 6", tokens, playerlib.getPlayer(user).get("lang")))
	else:
		for user in es.getUseridList():
			# Notice very player that the plugin is not going to being load
			es.tell(user, "#multi", text("menu 8", tokens, playerlib.getPlayer(user).get("lang")))
	# Set the default propierties
	vote['voting'] = "0"
	vote['plugin'] = ""
	vote['Si'] = 0
	vote['No'] = 0
	vote['votedplayers'] = 0
	vote['totalplayers'] = 0
	vote['players'] = []
	vote['voter'] = ""
	
"""def tellmeall():
	userid = es.getcmduserid()
	es.msg(vote['voting'])
	es.msg(vote['plugin'])
	es.msg(vote['Si'])
	es.msg(vote['No'])
	es.msg(vote['votedplayers'])
	es.msg(vote['totalplayers'])
	es.msg(vote['players'])
	es.msg(vote['voter'])"""

def round_start(ev):
	for user in es.getUseridList():
		es.tell(user, "#multi", text("sender 1", None, playerlib.getPlayer(user).get("lang")))
		es.tell(user, "#multi", text("sender 2", None, playerlib.getPlayer(user).get("lang")))