#pragma semicolon 1
#include <sourcemod>

#define PLUGIN_VERSION "0.16"

public Plugin:myinfo =
{
	name = "Rate watcher",
	author = "X@IDER",
	description = "Watches rates and adds some useful commands",
	version = PLUGIN_VERSION,
	url = "http://www.sourcemod.net/"
};

#define YELLOW               0x01
#define NAME_TEAMCOLOR       0x02
#define TEAMCOLOR            0x03
#define GREEN                0x04 

// Common
new Handle:sm_rw_flags = INVALID_HANDLE;

// Rate warnings/kick
new Handle:sm_rate_check = INVALID_HANDLE;
new Handle:sm_rate_warn = INVALID_HANDLE;
new Handle:sm_rate_notify = INVALID_HANDLE;
new Handle:sm_rate_action = INVALID_HANDLE;
new Handle:sm_rate_menutime = INVALID_HANDLE;

// Net warnings/kick
new Handle:sm_net_period = INVALID_HANDLE;
new Handle:sm_net_times = INVALID_HANDLE;
new Handle:sm_net_check = INVALID_HANDLE;
new Handle:sm_net_warn = INVALID_HANDLE;
new Handle:sm_net_notify = INVALID_HANDLE;
new Handle:sm_net_action = INVALID_HANDLE;
new Handle:sm_net_out_max = INVALID_HANDLE;
new Handle:sm_net_in_max = INVALID_HANDLE;
new Handle:sm_net_ping_max = INVALID_HANDLE;
new Handle:sm_net_loss_max = INVALID_HANDLE;
new Handle:sm_net_choke_max = INVALID_HANDLE;

// Check timer
new Handle:Tim = INVALID_HANDLE;

// Server settings
new Handle:sv_minrate = INVALID_HANDLE;
new Handle:sv_maxrate = INVALID_HANDLE;
new Handle:sv_mincmdrate = INVALID_HANDLE;
new Handle:sv_maxcmdrate = INVALID_HANDLE;
new Handle:sv_minupdaterate = INVALID_HANDLE;
new Handle:sv_maxupdaterate = INVALID_HANDLE;

#define MAX_CLIENTS	64

// Warnings
new NetWarnings[MAX_CLIENTS];

public OnPluginStart()
{
	LoadTranslations("plugin.ratewatcher");

	CreateConVar("sm_rw_version", PLUGIN_VERSION, "Ratewatcher version", FCVAR_PLUGIN|FCVAR_SPONLY|FCVAR_REPLICATED|FCVAR_NOTIFY|FCVAR_DONTRECORD);	
	sm_rw_flags = CreateConVar("sm_rw_flags", "b", "Set of flags, that affects sm_{net,rate}_notify and sm_{net,rate}_action", FCVAR_PLUGIN);

	sm_rate_check = CreateConVar("sm_rate_check", "3", "Check rates (use sum like 1+2). 1 - on spawn, 2 - on change", FCVAR_PLUGIN, true, 0.0, true, 3.0);
	sm_rate_warn = CreateConVar("sm_rate_warn", "2", "Warn client each spawn if he/she rates is not in accepted range (1 - in chat, 2 - in menu)", FCVAR_PLUGIN, true, 0.0, true, 2.0);
	sm_rate_notify = CreateConVar("sm_rate_notify", "1", "Notify about player with wrong rates. 0 - disable, 1 - notifies only admins, 2 - everyone", 0);
	sm_rate_action = CreateConVar("sm_rate_action", "sm_freeze #%d", "Do some action with player if he/she rates is not in accepted range", FCVAR_PLUGIN);
	sm_rate_menutime = CreateConVar("sm_rate_menutime", "20", "Time to show menu, when sm_rate_warn is 2", FCVAR_PLUGIN, true, 10.0);

	sm_net_period = CreateConVar("sm_net_period", "5.0", "Check period (sec)", FCVAR_PLUGIN, true, 1.0);
	sm_net_times = CreateConVar("sm_net_times", "3", "Warnings before action (0 to permanent)", FCVAR_PLUGIN, true, 0.0);
	sm_net_check = CreateConVar("sm_net_check", "13", "Check network flow (use sum like 1+2+4). 1 - incoming, 2 - outgoing, 4 - ping, 8 - loss, 16 - choke", FCVAR_PLUGIN, true, 0.0, true, 31.0);
	sm_net_warn = CreateConVar("sm_net_warn", "1", "Warn client with bad networking", FCVAR_PLUGIN);
	sm_net_notify = CreateConVar("sm_net_notify", "1", "Notify about player with bad networking. 0 - disable, 1 - notifies only admins, 2 - everyone", FCVAR_PLUGIN, true, 0.0, true, 2.0);
	sm_net_action = CreateConVar("sm_net_action", "kickid %d Network troubles", "Do some action with player with bad networking", FCVAR_PLUGIN);
	sm_net_out_max = CreateConVar("sm_net_out_max", "25000.0", "Maximum allowed outgoing traffic for client", 0, true, 10000.0);
	sm_net_in_max = CreateConVar("sm_net_in_max", "25000.0", "Maximum allowed incoming traffic for client", FCVAR_PLUGIN, true, 10000.0);
	sm_net_ping_max = CreateConVar("sm_net_ping_max", "150.0", "Maximum allowed ping", 0, true, 10.0);
	sm_net_loss_max = CreateConVar("sm_net_loss_max", "75.0", "Maximum allowed loss", 0, true, 10.0);
	sm_net_choke_max = CreateConVar("sm_net_choke_max", "90.0", "Maximum allowed choke", 0, true, 10.0);

	sv_minrate = FindConVar("sv_minrate");
	sv_maxrate = FindConVar("sv_maxrate");
	sv_mincmdrate = FindConVar("sv_mincmdrate");
	sv_maxcmdrate = FindConVar("sv_maxcmdrate");
	sv_minupdaterate = FindConVar("sv_minupdaterate");
	sv_maxupdaterate = FindConVar("sv_maxupdaterate");
	
	RegAdminCmd("sm_rates", Rates, ADMFLAG_GENERIC);
	RegAdminCmd("sm_users", Users, ADMFLAG_GENERIC);
	RegAdminCmd("sm_netstat", Netstat, ADMFLAG_GENERIC);
	
	HookEvent("player_spawn", Respawn, EventHookMode_Post);
	
	AutoExecConfig(true,"plugin.ratewatcher");

	// For late load
	if (GetConVarInt(sm_net_check))
		Tim = CreateTimer(GetConVarFloat(sm_net_period),NetCheck);
	else Tim = INVALID_HANDLE;
}

public OnMapStart()
{
	// For mystery bugs
	if (Tim != INVALID_HANDLE)
	{
		CloseHandle(Tim);
		Tim = INVALID_HANDLE;
	}
	
	if (GetConVarInt(sm_net_check))
		Tim = CreateTimer(GetConVarFloat(sm_net_period),NetCheck,0,TIMER_REPEAT);
	else Tim = INVALID_HANDLE;
}

public OnMapEnd()
{
	if (Tim != INVALID_HANDLE)
	{
		CloseHandle(Tim);
		Tim = INVALID_HANDLE;
	}
}

public SayText2(to, from, const String:format[], any:...)
{
	decl String:message[256];
	VFormat(message,sizeof(message),format,4);
	
	decl String:gdir[32];
	GetGameFolderName(gdir,32);
	if (strcmp(gdir,"dod") != 0)
	{
		new Handle:hBf = StartMessageOne("SayText2", to);
		BfWriteByte(hBf, from);
		BfWriteByte(hBf, true);
		BfWriteString(hBf, message);
	
		EndMessage();
	} else
	PrintToChat(to,message);
}

GetFlags()
{

	decl String:flags[32];
	GetConVarString(sm_rw_flags,flags,sizeof(flags));
	return ReadFlagString(flags);
}

PerformNotify(client,notify,String:fmt[], any:...)
{
	decl String:message[256];
	VFormat(message,sizeof(message),fmt,4);

	new flag = GetFlags();

	for (new i = 1; i <= MaxClients; i++)
	if (IsClientInGame(i) && !IsFakeClient(i) && (i != client) && ((notify == 2) || ((notify == 1) && ((GetUserFlagBits(i) & flag) == flag))))
		SayText2(i,client,message);
}

public Action:NetCheck(Handle:timer, any:value)
{
	new maxwarn = GetConVarInt(sm_net_times);
	new check = GetConVarInt(sm_net_check);
	if (!check) return Plugin_Handled;

	new bool:warn = GetConVarBool(sm_net_warn);
	new notify = GetConVarInt(sm_net_notify);
	new Float:min = GetConVarFloat(sm_net_in_max);
	new Float:mout = GetConVarFloat(sm_net_out_max);
	new Float:mping = GetConVarFloat(sm_net_ping_max);
	new Float:mloss = GetConVarFloat(sm_net_loss_max);
	new Float:mchoke = GetConVarFloat(sm_net_choke_max);
	new Float:din,Float:dout,Float:dping,Float:dloss,Float:dchoke;
	new bool:in,bool:out,bool:ping,bool:loss,bool:choke;
	
	decl String:action[32];
	decl String:name[32];
	GetConVarString(sm_net_action,action,32);
	
	for (new i = 1; i <= MaxClients; i++)
	if (IsClientInGame(i) && !IsFakeClient(i))
	{
		din = GetClientAvgData(i, NetFlow_Outgoing);
		dout = GetClientAvgData(i, NetFlow_Incoming);
		dping = 1000.0*GetClientAvgLatency(i, NetFlow_Both);
		dchoke = 100.0*GetClientAvgChoke(i, NetFlow_Both);
		dloss = 100.0*GetClientAvgLoss(i, NetFlow_Both);
		in = (check & 1) && (din > min);
		out = (check & 2) && (dout > mout);
		ping = (check & 4) && (dping > mping);
		loss = (check & 8) && (dloss > mloss);
		choke = (check & 16) && (dchoke > mchoke);

		GetClientName(i, name, 31);
		
		if (in)
		{
			if (warn) PrintToChat(i,"%t","Incoming chat",YELLOW,GREEN,din,YELLOW,GREEN,min,YELLOW);
			if (notify) PerformNotify(i,notify,"%t","Incoming notify",TEAMCOLOR,name,YELLOW,GREEN,din,YELLOW,GREEN,min,YELLOW,YELLOW);
		}
		
		if (out)
		{
			if (warn) PrintToChat(i,"%t","Outgoing chat",YELLOW,GREEN,dout,YELLOW,GREEN,mout,YELLOW);
			if (notify) PerformNotify(i,notify,"%t","Outgoing notify",TEAMCOLOR,name,YELLOW,GREEN,dout,YELLOW,GREEN,mout,YELLOW,YELLOW);
		}
		
		if (ping)
		{
			if (warn) PrintToChat(i,"%t","Ping chat",YELLOW,GREEN,dping,YELLOW,GREEN,mping,YELLOW);
			if (notify) PerformNotify(i,notify,"%t","Ping notify",TEAMCOLOR,name,YELLOW,GREEN,dping,YELLOW,GREEN,mping,YELLOW,YELLOW);
		}
		
		if (loss)
		{
			if (warn) PrintToChat(i,"%t","Loss chat",YELLOW,GREEN,dping,YELLOW,GREEN,mping,YELLOW);
			if (notify) PerformNotify(i,notify,"%t","Loss notify",TEAMCOLOR,name,YELLOW,GREEN,dloss,YELLOW,GREEN,mloss,YELLOW,YELLOW);
		}
		
		if (choke)
		{
			if (warn) PrintToChat(i,"%t","Choke chat",YELLOW,GREEN,dping,YELLOW,GREEN,mping,YELLOW);
			if (notify) PerformNotify(i,notify,"%t","Choke notify",TEAMCOLOR,name,YELLOW,GREEN,dchoke,YELLOW,GREEN,mchoke,YELLOW,YELLOW);
		}

		new flag = GetFlags();
		
		if ((in || out || ping || loss || choke) && ((GetUserFlagBits(i) & flag) != flag))
		{
			if ((NetWarnings[i]++ == maxwarn) && strlen(action))
			{
				ServerCommand(action,GetClientUserId(i));
				NetWarnings[i] = 0;
			}
		} else NetWarnings[i] = 0;
	}
	
	return Plugin_Handled;
}

public CheckForRate(client,String:var[],Handle:minvar,Handle:maxvar,notify)
{
	new r = 0;
	if (IsClientInGame(client) && !IsFakeClient(client))
	{
		new String:rate[10],String:nrmrate[10];
		new Rate,MinRate,MaxRate;
		GetClientInfo(client, var, rate, 9);
		Rate = StringToInt(rate);
		IntToString(Rate,nrmrate,9);
		MinRate = GetConVarInt(minvar);
		MaxRate = GetConVarInt(maxvar);


		if (MaxRate && (Rate > MaxRate)) r = Rate;
		if (MinRate && (Rate < MinRate) || !StrEqual(rate,nrmrate)) r = -Rate;
		if (r && notify)
		{
			new String:name[32];
			GetClientName(client, name, 31);
			PerformNotify(client,notify,"%t","Rate notify",TEAMCOLOR,name,YELLOW,GREEN,var,rate,YELLOW,GREEN,MinRate,MaxRate,YELLOW);
		}
	}
	return r;
}

public RateMenu(Handle:menu, MenuAction:action, param1, param2)
{
	if (action == MenuAction_End) CloseHandle(menu);
}

public CheckClient(client)
{
	if (IsClientInGame(client) && !IsFakeClient(client))
	{
		new warn = GetConVarInt(sm_rate_warn);
		new notify = GetConVarInt(sm_rate_notify);

		new rate = CheckForRate(client,"rate",sv_minrate,sv_maxrate,notify);
		new cmdrate = CheckForRate(client,"cl_cmdrate",sv_mincmdrate,sv_maxcmdrate,notify);
		new updrate = CheckForRate(client,"cl_updaterate",sv_minupdaterate,sv_maxupdaterate,notify);

		if (rate || cmdrate || updrate) 
		{
			new String:action[32],flag = GetFlags();
			GetConVarString(sm_rate_action,action,32);
			if (strlen(action) && ((GetUserFlagBits(client) & flag) != flag)) ServerCommand(action,GetClientUserId(client));
			if (warn == 1)
			{
				if (rate) SayText2(client,client,"%t","Rate chat",YELLOW,GREEN,"rate",GetConVarInt((rate < 0)?sv_minrate:sv_maxrate),YELLOW);
				if (cmdrate) SayText2(client,client,"%t","Rate chat",YELLOW,GREEN,"cl_cmdrate",GetConVarInt((cmdrate < 0)?sv_mincmdrate:sv_maxcmdrate),YELLOW);
				if (updrate) SayText2(client,client,"%t","Rate chat",YELLOW,GREEN,"cl_updaterate",GetConVarInt((updrate < 0)?sv_minupdaterate:sv_maxupdaterate),YELLOW);
			}
			if (warn == 2)
			{
				new Handle:hPanel = CreatePanel();
				decl String:buff[1024],String:info[7][128];
				Format(buff,sizeof(buff),"%t","Rate title",client);
				SetPanelTitle(hPanel,buff);
				Format(buff,sizeof(buff),"%t","Rate info",client);
				new n = ExplodeString(buff,"\n",info,7,128);
				for (new i = 0; i <= n; i++)
					DrawPanelItem(hPanel,info[i],ITEMDRAW_DISABLED|ITEMDRAW_RAWLINE);
				
				if (rate)
				{
					Format(buff,sizeof(buff),"rate %d",GetConVarInt((rate < 0)?sv_minrate:sv_maxrate));
					DrawPanelItem(hPanel,buff,ITEMDRAW_DISABLED|ITEMDRAW_RAWLINE);
				}
				if (cmdrate)
				{
					Format(buff,sizeof(buff),"cl_cmdrate %d",GetConVarInt((rate < 0)?sv_mincmdrate:sv_maxcmdrate));
					DrawPanelItem(hPanel,buff,ITEMDRAW_DISABLED|ITEMDRAW_RAWLINE);
				}
				if (updrate)
				{
					Format(buff,sizeof(buff),"cl_updaterate %d",GetConVarInt((rate < 0)?sv_minupdaterate:sv_maxupdaterate));
					DrawPanelItem(hPanel,buff,ITEMDRAW_DISABLED|ITEMDRAW_RAWLINE);
				}
				SendPanelToClient(hPanel,client,RateMenu,GetConVarInt(sm_rate_menutime));
			}
		}
	}
}

public Respawn(Handle:event, const String:name[], bool:dontBroadcast)
{
	if (GetConVarInt(sm_rate_check) & 1) CheckClient(GetClientOfUserId(GetEventInt(event,"userid")));
}

public OnClientSettingsChanged(client)
{
	if (IsClientInGame(client) && GetClientTeam(client))
	{
		if (GetConVarInt(sm_rate_check) & 2) CheckClient(client);
	}
}

public Action:Rates(client, args)
{
	new String:interp[10],String:update[10],String:cmd[10],String:rate[10],String:name[32];
	new ID;
	ReplyToCommand(client,"-------------------------------------------------------------------");
	ReplyToCommand(client,"    ID | rate    | cmdrate | updrate | interp | name");
	ReplyToCommand(client,"-------|---------|---------|---------|--------|--------------------");
	for (new i=1; i<=MaxClients;i++)
	if (IsClientInGame(i) && !IsFakeClient(i))
	{	
		decl String:Bad[3] = "   ";
		GetClientInfo(i, "rate", rate, 9);
		GetClientInfo(i, "cl_cmdrate",cmd, 9);
		GetClientInfo(i, "cl_updaterate", update, 9);
		GetClientInfo(i, "cl_interp", interp, 9);
		GetClientName(i, name, 31);
		ID = GetClientUserId(i);
		if (CheckForRate(i,"rate",sv_minrate,sv_maxrate,0)) Bad[0] = '*';
		if (CheckForRate(i,"cl_cmdrate",sv_mincmdrate,sv_maxcmdrate,0)) Bad[1] = '*';
		if (CheckForRate(i,"cl_updaterate",sv_minupdaterate,sv_maxupdaterate,0)) Bad[2] = '*';
		ReplyToCommand(client,"#%5d | %6s%c | %6s%c | %6s%c | %6s | %s",ID,rate,Bad[0],cmd,Bad[1],update,Bad[2],interp,name);
	}	
	ReplyToCommand(client,"-------------------------------------------------------------------");
	return Plugin_Handled;	
}

public Action:Users(client, args)
{
	ReplyToCommand(client,"--------------------------------------------------------------------------------------");
	ReplyToCommand(client,"    ID | A | IP              | STEAM_ID               | Online   | name");
	ReplyToCommand(client,"-------|---|-----------------|------------------------|----------|--------------------");
	new String:IP[16],String:sID[20],String:name[32];
	new ID,Time,h,m,s;
	for (new i=1; i<=MaxClients;i++)
	if (IsClientInGame(i) && !IsFakeClient(i))
	{
		GetClientIP(i,IP,15,true);
		GetClientAuthString(i,sID,20);
		ID = GetClientUserId(i);
		Time = RoundToFloor(GetClientTime(i));
		h = Time/3600;
		Time %= 3600;
		m = Time/60;
		s = Time%60;
		GetClientName(i, name, 31);
		new adm = '*';
		if (GetUserAdmin(i) == INVALID_ADMIN_ID) adm = ' ';
		ReplyToCommand(client,"#%5d | %c | %15s | %22s | %02d:%02d:%02d | %s",ID,adm,IP,sID,h,m,s,name);
	}
	ReplyToCommand(client,"--------------------------------------------------------------------------------------");
	return Plugin_Handled;	
}

public Action:Netstat(client, args)
{
	ReplyToCommand(client,"---------------------------------------------------------------------------------");
	ReplyToCommand(client,"    ID |  choke |   loss |   ping |   in (b/s) |  out (b/s) | name");
	ReplyToCommand(client,"-------|--------|--------|--------|------------|------------|--------------------");
	new String:name[32];
	new Float:choke,Float:loss,Float:ping,Float:din,Float:dout;
	new ID;
	for (new i=1; i<=MaxClients;i++)
	if (IsClientInGame(i) && !IsFakeClient(i))
	{
		ID = GetClientUserId(i);
		GetClientName(i, name, 31);
		choke = 100.0*GetClientAvgChoke(i, NetFlow_Both);
		loss = 100.0*GetClientAvgLoss(i, NetFlow_Both);
		ping = 1000.0*GetClientAvgLatency(i, NetFlow_Both);
		din = GetClientAvgData(i, NetFlow_Outgoing);
		dout = GetClientAvgData(i, NetFlow_Incoming);
		ReplyToCommand(client,"#%5d | %5.1f%% | %5.1f%% | %6.1f | %10.1f | %10.1f | %s",ID,choke,loss,ping,din,dout,name);
	}
	ReplyToCommand(client,"---------------------------------------------------------------------------------");
	return Plugin_Handled;	
}