#include <sourcemod>
#include <sdktools>

#define MAXCLIENTS 255

new g_iChannels;
new g_iChannelsMode[64];
new String:g_sChannelsName[64][128];
new String:g_sChannelsPass[64][128];
new String:g_sChannelsFlag[64][128];

new g_iClientChannel[MAXCLIENTS+1];

public Plugin:myinfo = {
	name = "VoiceMgr",
	author = "s1dex",
	description = "Advanced Voice Manager [CS:S]",
	version = "2.1.1",
	url = "http://www.adminexe.ru/"
};

public OnPluginStart()
{	
	LoadTranslations("voicemgr.phrases.txt");
	
	RegConsoleCmd("vc_sc", VCSetChnl);
	RegConsoleCmd("vc_list", VCList);
}

public OnClientPutInServer(client)
{
	for (new i=0;i<=g_iChannels;i++)
	{
		if (g_iChannelsMode[i] != 0)
			continue;
		
		decl String:name[64];
		GetClientName(client, name, sizeof(name));
		
		g_iClientChannel[client] = i;
		RefreshClientChannel(client);
		PrintToChatAll("%t", "ChangeChannel", name, g_sChannelsName[i]);
		break;
	}
}

public OnMapStart()
{
	g_iChannels = -1;
	//Путь к кфг каналов
	decl String:file[256];
	BuildPath(Path_SM, file, sizeof(file), "configs/voicemgr.channels.cfg");
	
	//создаем кейвалуи
	new Handle:kv = CreateKeyValues("Channels");
	FileToKeyValues(kv, file);
	if (KvGotoFirstSubKey(kv))
	{
		do
		{
			g_iChannels++;
			
			decl String:buffer[32];
			KvGetSectionName(kv, g_sChannelsName[g_iChannels], 128);
			KvGetString(kv, "mode", buffer, sizeof(buffer), "public");
			if (StrEqual(buffer, "private"))
				g_iChannelsMode[g_iChannels] = 1;
			else if (StrEqual(buffer, "admins"))
				g_iChannelsMode[g_iChannels] = 2;
			else
				g_iChannelsMode[g_iChannels] = 0;
			
			if (g_iChannelsMode[g_iChannels] == 1)
				KvGetString(kv, "password", g_sChannelsPass[g_iChannels], 128, "pw");
			if (g_iChannelsMode[g_iChannels] == 2)
				KvGetString(kv, "flag", g_sChannelsFlag[g_iChannels], 128, "slay");
		}
		while (KvGotoNextKey(kv))
	}
}

public Action:VCSetChnl(client, args)
{
	decl String:arg[32];
	GetCmdArg(1, arg, sizeof(arg));
	
	new chnl = StringToInt(arg);
	if (chnl > g_iChannels)
	{
		PrintToChat(client, "%t", "NotRegistered", chnl);
		return Plugin_Handled;
	}
	else if (chnl == g_iClientChannel[client])
	{
		PrintToChat(client, "%t", "AlreadyIn");
		return Plugin_Handled;
	}
	else
	{
		if (g_iChannelsMode[chnl] == 2)
		{
			new AdminId:admin;
			if ((admin = GetUserAdmin(client)) == INVALID_ADMIN_ID)
			{
				PrintToChat(client, "%t", "AdminsOnly");
				return Plugin_Handled;
			}
			else
			{
				new AdminFlag:flag;
				FindFlagByName(g_sChannelsFlag[chnl], flag);
				
				if (!GetAdminFlag(admin, flag))
				{
					PrintToChat(client, "%t", "InvalidFlag", g_sChannelsFlag[chnl]);
					return Plugin_Handled;
				}
			}
		}
		else if (g_iChannelsMode[chnl] == 1)
		{
			decl String:info[128];
			GetClientInfo(client, "_vcpass", info, sizeof(info));
			if (!StrEqual(info, g_sChannelsPass[chnl]))
			{
				PrintToChat(client, "%t", "Private1");
				PrintToChat(client, "%t", "Private2");
				return Plugin_Handled;
			}
		}
		
		decl String:name[64];
		GetClientName(client, name, sizeof(name));
		
		g_iClientChannel[client] = chnl;
		RefreshClientChannel(client);
		PrintToChatAll("%t", "ChangeChannel", name, g_sChannelsName[chnl]);
	}
	
	return Plugin_Handled;
}

public Action:VCList(client, args)
{
	PrintToConsole(client, "[VoiceMgr 2.0] Channels:");
	for (new i=0;i<=g_iChannels;i++)
		PrintToConsole(client, "ID: %d - %s", i, g_sChannelsName[i]);
	
	PrintToChat(client, "%t", "ListChannels");
	return Plugin_Handled;
}

stock RefreshClientChannel(client)
{
	for (new i=1;i<=MaxClients;i++)
	{
		if (IsClientInGame(i))
		{
			if (g_iClientChannel[client] == g_iClientChannel[i])
			{
				SetListenOverride(client, i, Listen_Yes);
				SetListenOverride(i, client, Listen_Yes);
			}
			else
			{
				SetListenOverride(client, i, Listen_No);
				SetListenOverride(i, client, Listen_No);
			}
		}
	}
}