// Core configs
new bool:g_EnablePlugin = true;
new bool:g_FixFrags = true;

// Scouts configs
new bool:g_EnableScouts = true;
new g_WCGScouts = 2;
new g_ScoutsNum = 0;
new g_ScoutsMax = 1;
new Scouted[MAXPLAYERS+1];
new Scoutsnum = 0;

// Suicide configs
new bool:g_DisableSuicide = true;
new g_WCSuicide = 2;

// Random terrorist configs
new bool:g_EnableRND = true;
new g_RNDTerrorists = 0;
new bool:g_BlockKilling = true;
new nextterrorist;

// Random terrorist configs
new bool:g_EnableBanTer = true;
new g_TimeToBanTer = 15;

// Scores configs
new bool:g_EnableSaveScores = true;
new scoredata[MAXPLAYERS+1];

new bool:g_SourceBans = false;

// Scores configs
new bool:g_EnableBonuses        = true;
new bool:g_EnableBonusesGravity = true;
new bool:g_EnableBonusesSpeed   = true;
new bool:g_EnableBonusesHealth  = true;
new bool:g_EnableBonusesModel   = true;
new bool:g_EnableBonusesGlow    = true;
new bool:g_EnableBonusesColor   = true;

// Parse configs files
GetConfigs()
{
	// Decl variables, build path to file with config keyvalues.
	decl String:path[255], String:buffer[255];
	BuildPath(Path_SM, path, sizeof(path), "configs/deathrun/Configuration.cfg");
	new Handle:ConfigKeyValues = CreateKeyValues("Configuration");
	
	// If Keyvalues not getting, put the error.
	if (!FileToKeyValues(ConfigKeyValues, path))
		LogError("[Elistor Deathrun] Keyvalue config file \"%s\" couldn't be loaded. Config variabless set to default values.", path);

	
	if (KvJumpToKey(ConfigKeyValues, "Core"))
	{
		KvGetString(ConfigKeyValues, "Enable plugin", buffer, sizeof(buffer));
		if (!strcmp(buffer, "yes", false))
			g_EnablePlugin = true;
		else if (!strcmp(buffer, "no", false))
			g_EnablePlugin = false;
		else
			LogError("[Elistor Deathrun] Keyvalue config file \"%s\" not correct. Warning in \"Enable Plugin\" param in \"Core\" section. Can be only \"yes\" or \"no\".", path);
		
		KvGetString(ConfigKeyValues, "Fix frags", buffer, sizeof(buffer));
		if (!strcmp(buffer, "yes", false))
			g_FixFrags = true;
		else if (!strcmp(buffer, "no", false))
			g_FixFrags = false;
		else
			LogError("[Elistor Deathrun] Keyvalue config file \"%s\" not correct. Warning in \"Fix frags\" param in \"Core\" section. Can be only \"yes\" or \"no\".", path);
	}
	else
		LogError("[Elistor Deathrun] Keyvalue config file \"%s\" not correct. Not find a \"Core\" section.", path);
	
	KvRewind(ConfigKeyValues);
	
	if (KvJumpToKey(ConfigKeyValues, "Scouts"))
	{
		// Get "Enable scouts" string information
		KvGetString(ConfigKeyValues, "Enable scouts", buffer, sizeof(buffer));
		if (!strcmp(buffer, "yes", false))
			g_EnableScouts = true;
		else if (!strcmp(buffer, "no", false))
			g_EnableScouts = false;
		else
			LogError("[Elistor Deathrun] Keyvalue config file \"%s\" not correct. Warning in \"Enable Scouts\" param in \"Scouts\" section. Can be only \"yes\" or \"no\". Now \"%s\"", path, buffer);
		
		
		// Get "Who can get scouts" string information
		KvGetString(ConfigKeyValues, "Who can get scouts", buffer, sizeof(buffer));
		if (!strcmp(buffer, "all", false))
			g_WCGScouts = 0;
		else if (!strcmp(buffer, "t", false))
			g_WCGScouts = 2;
		else if (!strcmp(buffer, "ct", false))
			g_WCGScouts = 3;
		else
			LogError("[Elistor Deathrun] Keyvalue config file \"%s\" not correct. Warning in \"Who can get scouts\" param in \"Scouts\" section. Can be only \"all\", \"ct\" or \"t\".", path);
		
		
		// Get "Maximum scouts" string information
		g_ScoutsNum = KvGetNum(ConfigKeyValues, "Maximum scouts");
		
		// Get "Maximum scouts" string information
		g_ScoutsMax = KvGetNum(ConfigKeyValues, "Maximum scouts for one");
	}
	else
		LogError("[Elistor Deathrun] Keyvalue config file \"%s\" not correct. Not find a \"Scouts\" section.", path);
	
	KvRewind(ConfigKeyValues);
	
	if (KvJumpToKey(ConfigKeyValues, "Suicide"))
	{
		// Get "Enable suicide block" string information
		KvGetString(ConfigKeyValues, "Enable suicide block", buffer, sizeof(buffer));
		if (!strcmp(buffer, "yes", false))
			g_DisableSuicide = true;
		else if (!strcmp(buffer, "no", false))
			g_DisableSuicide = false;
		else
			LogError("[Elistor Deathrun] Keyvalue config file \"%s\" not correct. Warning in \"Enable suicide block\" param in \"Suicide\" section. Can be only \"yes\" or \"no\". Now \"%s\"", path, buffer);
		
		
		// Get "Suicide block for" string information
		KvGetString(ConfigKeyValues, "Suicide block for", buffer, sizeof(buffer));
		if (!strcmp(buffer, "all", false))
			g_WCSuicide = 0;
		else if (!strcmp(buffer, "t", false))
			g_WCSuicide = 2;
		else if (!strcmp(buffer, "ct", false))
			g_WCSuicide = 3;
		else
			LogError("[Elistor Deathrun] Keyvalue config file \"%s\" not correct. Warning in \"Suicide block for\" param in \"Suicide\" section. Can be only \"all\", \"ct\" or \"t\".", path);
		
	}
	else
		LogError("[Elistor Deathrun] Keyvalue config file \"%s\" not correct. Not find a \"Suicide\" section.", path);
	
	KvRewind(ConfigKeyValues);
	
	if (KvJumpToKey(ConfigKeyValues, "Random terrorist"))
	{
		// Get "Enable suicide block" string information
		KvGetString(ConfigKeyValues, "Select random terrorist", buffer, sizeof(buffer));
		if (!strcmp(buffer, "yes", false))
			g_DisableSuicide = true;
		else if (!strcmp(buffer, "no", false))
			g_DisableSuicide = false;
		else
			LogError("[Elistor Deathrun] Keyvalue config file \"%s\" not correct. Warning in \"Select random terroris\" param in \"Random terrorist\" section. Can be only \"yes\" or \"no\". Now \"%s\"", path, buffer);
		
		// Get "Suicide block for" string information
		KvGetString(ConfigKeyValues, "Number of terrorists", buffer, sizeof(buffer));
		if (!strcmp(buffer, "half", false))
			g_RNDTerrorists = 0;
		else
			g_RNDTerrorists = KvGetNum(ConfigKeyValues, "Number of terrorists");
		
		// Get "Enable suicide block" string information
		KvGetString(ConfigKeyValues, "Block killing", buffer, sizeof(buffer));
		if (!strcmp(buffer, "yes", false))
			g_BlockKilling = true;
		else if (!strcmp(buffer, "no", false))
			g_BlockKilling = false;
		else
			LogError("[Elistor Deathrun] Keyvalue config file \"%s\" not correct. Warning in \"Block killing\" param in \"Random terrorist\" section. Can be only \"yes\" or \"no\". Now \"%s\"", path, buffer);
		
		
	}
	else
		LogError("[Elistor Deathrun] Keyvalue config file \"%s\" not correct. Not find a \"Random terrorist\" section.", path);
	
	KvRewind(ConfigKeyValues);
	
	if (KvJumpToKey(ConfigKeyValues, "Scores"))
	{
		// Get "Enable suicide block" string information
		KvGetString(ConfigKeyValues, "Save scores", buffer, sizeof(buffer));
		if (!strcmp(buffer, "yes", false))
			g_EnableSaveScores = true;
		else if (!strcmp(buffer, "no", false))
			g_EnableSaveScores = false;
		else
			LogError("[Elistor Deathrun] Keyvalue config file \"%s\" not correct. Warning in \"Save scores\" param in \"Scores\" section. Can be only \"yes\" or \"no\". Now \"%s\"", path, buffer);
	}
	else
		LogError("[Elistor Deathrun] Keyvalue config file \"%s\" not correct. Not find a \"Suicide\" section.", path);
	
	KvRewind(ConfigKeyValues);
	
	if (KvJumpToKey(ConfigKeyValues, "Bonuses"))
	{
		KvGetString(ConfigKeyValues, "Enable bonuses", buffer, sizeof(buffer));
		if (!strcmp(buffer, "yes", false))
			g_EnableBonuses = true;
		else if (!strcmp(buffer, "no", false))
			g_EnableBonuses = false;
		
		KvGetString(ConfigKeyValues, "Gravity", buffer, sizeof(buffer));
		if (!strcmp(buffer, "yes", false))
			g_EnableBonusesGravity = true;
		else if (!strcmp(buffer, "no", false))
			g_EnableBonusesGravity = false;
		
		KvGetString(ConfigKeyValues, "Speed", buffer, sizeof(buffer));
		if (!strcmp(buffer, "yes", false))
			g_EnableBonusesSpeed = true;
		else if (!strcmp(buffer, "no", false))
			g_EnableBonusesSpeed = false;
		
		KvGetString(ConfigKeyValues, "Health", buffer, sizeof(buffer));
		if (!strcmp(buffer, "yes", false))
			g_EnableBonusesHealth = true;
		else if (!strcmp(buffer, "no", false))
			g_EnableBonusesHealth = false;
		
		KvGetString(ConfigKeyValues, "Models", buffer, sizeof(buffer));
		if (!strcmp(buffer, "yes", false))
			g_EnableBonusesModel = true;
		else if (!strcmp(buffer, "no", false))
			g_EnableBonusesModel = false;
		
		KvGetString(ConfigKeyValues, "Glow", buffer, sizeof(buffer));
		if (!strcmp(buffer, "yes", false))
			g_EnableBonusesGlow = true;
		else if (!strcmp(buffer, "no", false))
			g_EnableBonusesGlow = false;
		
		KvGetString(ConfigKeyValues, "Color", buffer, sizeof(buffer));
		if (!strcmp(buffer, "yes", false))
			g_EnableBonusesColor = true;
		else if (!strcmp(buffer, "no", false))
			g_EnableBonusesColor = false;
	}
	else
		LogError("[Elistor Deathrun] Keyvalue config file \"%s\" not correct. Not find a \"Bonuses\" section.", path);
	
	CloseHandle(ConfigKeyValues);
}