Handle:Connect() {
	decl String:error[255];
	new Handle:db;
	
	if (SQL_CheckConfig("deathrun-manager"))
		db = SQL_Connect("deathrun-manager", true, error, sizeof(error));
	else
		db = SQL_Connect("default", true, error, sizeof(error));
	
	if (db == INVALID_HANDLE)
		LogError("Could not connect to database: %s", error);
	else if (!SQL_FastQuery(db, "SET NAMES 'utf8'"))
		LogError("Can't select UTF8 code page");
	
	return db;
}

CreateSQLite(client, Handle:db) {
	if (!DoQuery(client, db, "CREATE TABLE sm_vip_players (id INTEGER PRIMARY KEY AUTOINCREMENT, identity varchar(65) NOT NULL, name varchar(65) NOT NULL, gravity_percent INTEGER NOT NULL, speed_percent INTEGER NOT NULL, health_percent INTEGER NOT NULL, glow INTEGER NOT NULL, model varchar(255) NOT NULL)"))
		return;

	ReplyToCommand(client, "[ELISTOR.RU] Deathrun -> VIP player tables created.");
}

public Action:Command_CreateTables(args) {
	new client = 0;
	new Handle:db = Connect();
	if (db == INVALID_HANDLE) {
		ReplyToCommand(client, "[ELISTOR.RU] Deathrun -> Could not connect to database");
		return Plugin_Handled;
	}
	CreateSQLite(client, db);
	CloseHandle(db);
	
	return Plugin_Handled;
}

stock bool:DoQuery(client, Handle:db, const String:query[])
{
	if (!SQL_FastQuery(db, query))
	{
		decl String:error[255];
		SQL_GetError(db, error, sizeof(error));
		LogError("Query failed: %s", error);
		LogError("Query dump: %s", query);
		ReplyToCommand(client, "[ELISTOR.RU] Deathrun -> Failed to query database");
		return false;
	}

	return true;
}

AddVIPfnc(client, target, Handle:db) {
	decl String:query[255], String:steamid[64];
	GetClientAuthString(target, steamid, sizeof(steamid));
	
	Format(query, sizeof(query), "INSERT INTO sm_vip_players VALUES '%s', '%N', '100', '100', '100', '0', '0'", steamid, target);
	
	if (!DoQuery(0, db, query))
		return;

	ReplyToCommand(client, "[ELISTOR.RU] Deathrun -> VIP player added.");
}