#pragma semicolon 1

// Includes.
#include <sourcemod>
#include <sdktools>
#include <cstrike>
#undef REQUIRE_PLUGIN
#include <sourcebans>
#include <adminmenu>

// Defines.
#define PLUGIN_VERSION "1.5.4"
#define DEATHRUN_ADMINFLAG ADMFLAG_ROOT

// Information about plugin.
public Plugin:myinfo = {
	name		= "Deathrun Manager",
	author		= "Vladislav Dolgov (Elistor.ru)",
	description = "Deathrun manager for Counter-Strike Source.",
	version		= PLUGIN_VERSION,
	url			= "http://elistor.ru"
};

// Including modules.
#include "deathrun-manager/configuration.sp"
#include "deathrun-manager/functions.sp"
#include "deathrun-manager/effects.sp"
#include "deathrun-manager/scouts.sp"
#include "deathrun-manager/bonus.sp"
//#include "deathrun-manager/vip.sp"
#include "deathrun-manager/adminmenu.sp"

public OnPluginStart( ) {
	// Create version var, don't  modify please.
	CreateConVar( "sm_deathrunmanager_version", PLUGIN_VERSION, "Deathrun made by Vladislav Dolgov (Elistor.ru) version.", FCVAR_PLUGIN|FCVAR_SPONLY|FCVAR_REPLICATED|FCVAR_NOTIFY|FCVAR_DONTRECORD );
	
	// Loading translations.
	LoadTranslations( "plugin.deathrun-manager" );
	
	// Hooking events
	HookEvent("round_start", Event_RoundStart );
	HookEvent("player_spawn", Event_OnPlayerSpawn );
	HookEvent("player_death", Event_PlayerDeath );
	HookEvent("round_end", Event_RoundEnd );
	
	// Register console and say commands.
	RegConsoleCmd( "scout", Command_Give_scout, "Give scout without ammo for you." );
	RegConsoleCmd( "resetscores", Command_Reset_Score );
	RegConsoleCmd( "givefrag", Command_Reset_Score );
	RegConsoleCmd( "jointeam", Command_JoinTeam );
	RegConsoleCmd( "joinclass", Command_SuicideAttempt );
	RegConsoleCmd( "spectate", Command_SuicideAttempt );
	RegConsoleCmd( "kill", Command_SuicideAttempt );
	
//	RegConsoleCmd( "deathrun", Command_DeathrunMenu );
//	RegConsoleCmd( "dr", Command_DeathrunMenu );
//	RegConsoleCmd( "", Command_DeathrunMenu );
//	RegConsoleCmd( "elistor", Command_DeathrunMenu );
	
	RegServerCmd( "sm_deathrun_set_ter_num", Command_SetTerNum );
	//RegServerCmd( "sm_deathrun_create_vip_tables", Command_CreateTables );
	
	ResetScouts( );
	
	// Save scores for all players
	CreateTimer( 1.0, SaveScores, _, TIMER_REPEAT );
	
	new Handle:topmenu;
	if (LibraryExists("adminmenu") && ((topmenu = GetAdminTopMenu()) != INVALID_HANDLE))
		OnAdminMenuReady(topmenu);
	GetConfigs( );
}

public OnAllPluginsLoaded( ) {
	decl Handle:g_Temp;
	g_Temp = FindPluginByFile( "sourcebans.smx" );
	if ( g_Temp != INVALID_HANDLE ) {
		g_SourceBans = true;
		CloseHandle( g_Temp );
	}
}

public OnLibraryRemoved( const String:name[] ) {
	if (StrEqual(name, "adminmenu"))
		hAdminMenu = INVALID_HANDLE;
	else if ( StrEqual( name, "sourcebans" ) )
		g_SourceBans = false;
}


public OnMapStart( )
	GetConfigs( );

public Action:PlayerDisconnect_Event( Handle:event, const String:name[], bool:dontBroadcast ) {
	if ( !g_EnablePlugin )
		return Plugin_Continue;
	
	new client = GetClientOfUserId( GetEventInt( event, "userid" ) );
	
	if ( g_EnableBanTer && GetTeamClientCount( 3 ) > 1 ) {
		if ( IsClientInGame( client ) ) {
			if ( GetClientTeam( client ) == 2 ) {
				decl String:nick[64], String:reason[128];
				GetClientName(client, nick, sizeof(nick));
				GetEventString(event, "reason", reason, sizeof(reason));
				if ( StrContains( reason, "disconnect by user", false ) ) {
					if ( g_SourceBans )
						SBBanPlayer( 0, client, g_TimeToBanTer, "DEATHRUN: Terrorist can't disconnect" );
					else
						BanClient( client, g_TimeToBanTer, BANFLAG_AUTHID, "DEATHRUN: Terrorist can't disconnect", "DEATHRUN: Terrorist can't disconnect" );
					
					PrintToChatAll( "\x04%t \x01>\x03 %t", "deathrun", "terr disconnected", nick, g_TimeToBanTer );
				}
				PrintToChatAll( "\x04%t \x01>\x03 %t", "deathrun", "selecting random terr" );
				CreateTimer( 2.0, randomter );
			}
		}
	}
	return Plugin_Continue;
}  

// Round end event
public Action:Event_RoundEnd( Handle:event, const String:name[], bool:dontBroadcast ) {
	if ( !g_EnablePlugin )
		return Plugin_Continue;
	
	if( g_EnableRND ) {
		if( !g_RNDTerrorists )
			PrintToChatAll( "\x04%t \x01>\x03 %t", "deathrun", "selecting random terr" );
		CreateTimer( 2.0, randomter );
	}
	
	if( g_EnableSaveScores )
		for ( new i=1; i<=MaxClients; i++ )
			if ( IsClientInGame( i ) )
				scoredata[i] = GetClientFrags( i );
	
	for ( new i = 1; i <= MaxClients; i++ ) {
		if ( IsClientInGame( i ) && IsPlayerAlive( i ) && GetClientTeam( i ) == CheckWinFrag( ) ) {
			SetEntProp( i, Prop_Data, "m_iFrags", GetClientFrags(i) + 1 );
			if ( GetClientTeam( i ) == 2 && GetTeamClientCount( 2 ) == 1 )
				PrintToChatAll( "\x04%t \x01>\x03 %t", "deathrun", "terrorist win frag" );
		}
	}
	
	return Plugin_Continue;
}

public Action:Command_SuicideAttempt( client, args ) {
	if ( !client && !g_EnablePlugin )
		return Plugin_Continue;
	
	if ( g_DisableSuicide && IsClientInGame( client ) ) {
		new team = GetClientTeam(client);
		if ( team == g_WCSuicide || g_WCSuicide == 0 ) {
			if ( IsPlayerAlive( client ) ) {
				PrintToChat( client, "\x04%t \x01>\x03 %t", "deathrun", "ter cant suicide 2" );
				return Plugin_Handled;
			}
		}
	}

	return Plugin_Continue;
}

public Action:Command_JoinTeam( client, args ) {
	if ( !g_EnablePlugin && !g_DisableSuicide )
		return Plugin_Continue;
	
	decl String:text[192];
	if ( !GetCmdArgString( text, sizeof ( text ) ) )
		return Plugin_Continue;
	
	new startidx = 0;
	if( text[strlen(text)-1] == '"' ) {
		text[strlen(text)-1] = '\0';
		startidx = 1;
	}
	
	if( IsClientInGame( client ) ) {
		new oldTeam = GetClientTeam(client);
		
		if ( oldTeam != 2 ) {
			if( strcmp(text[startidx], "0", false) == 0 || strcmp(text[startidx], "2", false) == 0 || strcmp(text[startidx], "3", false) == 0 ) {
				if ( GetTeamClientCount( 2 ) > 0 ) {
					ChangeClientTeam( client, 3 );
					PrintToChat( client, "\x04%t \x01>\x03 %t", "deathrun", "auto force to ct" );
					return Plugin_Handled;
				} else {
					ChangeClientTeam( client, 2 );
					PrintToChat( client, "\x04%t \x01>\x03 %t", "deathrun", "auto force to t" );
					return Plugin_Handled;
				}
			}
		} else if ( oldTeam == g_WCSuicide || g_WCSuicide == 0 ) {
			PrintToChat( client, "\x04%t \x01>\x03 %t", "deathrun", "ter cant suicide 1" );
			return Plugin_Handled;
		} else if ( strcmp( text[startidx], "2", false ) == 0 ) {
			PrintToChat(client, "\x04%t \x01>\x03 %t", "deathrun", "only choosen terrorist");
			return Plugin_Handled;
		}
	}
	
	return Plugin_Continue;
}

public Action:Event_RoundStart( Handle:event, const String:name[], bool:dontBroadcast ) {
	nextterrorist = 0;
	
	// If plugin disabled do nothing
	if ( !g_EnablePlugin )
		return Plugin_Continue;
	
	if ( g_EnableScouts )
		ResetScouts( );
	
	if ( g_EnableSaveScores )
		for ( new i = 1; i <= MaxClients; i++ )
			if ( IsClientInGame( i ) )
				SetEntProp( i, Prop_Data, "m_iFrags", scoredata[i] );
	
	return Plugin_Continue;
}

public Action:Event_OnPlayerSpawn( Handle:event, const String:name[], bool:dontBroadcast ) {
	new client = GetClientOfUserId( GetEventInt( event, "userid" ) );
	new Team   = GetClientTeam( client );
	
	if ( g_EnableScouts ) {
		Scouted[client] = 0;
		if ( g_WCGScouts == 0 || g_WCGScouts == Team )
			PrintToChat( client, "\x04%t \x01>\x03 %t", "deathrun", "to get scout type this" );
	}
	
	GivePlayerItem( client, "item_nvgs", 0 );
	if( Team == CS_TEAM_CT ) {
		if( g_EnablePlugin )
			CheckBonus( client );
	}
	
	PrintToChat( client, "\x04%t \x01>\x03 Mod author: \x02Vladislav Dolgov\x03.", "deathrun" );
	PrintToChat( client, "\x04%t \x01>\x03 Official site: \x02http://elistor.ru\x03.", "deathrun" );
	
	return Plugin_Continue;
}

public Action:Event_PlayerDeath( Handle:event, const String:name[], bool:dontBroadcast ) {
	new victim_id = GetClientOfUserId( GetEventInt( event, "userid" ) );
	new attacker_id = GetClientOfUserId( GetEventInt( event, "attacker" ) );
	if ( !g_EnablePlugin )
		return Plugin_Continue;
	
	if( g_FixFrags )
		if ( attacker_id == 0 || victim_id == attacker_id )
			SetEntProp( victim_id, Prop_Data, "m_iFrags", GetClientFrags( victim_id ) + 1 );
	
	return Plugin_Continue;
}

public Action:SaveScores( Handle:timer ) {
	if ( !g_EnablePlugin || !g_EnableSaveScores )
		return Plugin_Continue;
	
	for ( new i = 1; i <= MaxClients; i++ )
		if ( IsClientInGame( i ) )
			scoredata[i] = GetClientFrags( i );
	
	return Plugin_Continue;
}

public Action:Command_Reset_Score( client, args ) {
	scoredata[client] = 0;
	SetEntProp( client, Prop_Data, "m_iFrags", 0 );
	
	return Plugin_Continue;
}

public Action:Command_SetTerNum( args ) {
	if ( !g_EnablePlugin )
		return Plugin_Continue;
	
	decl String:argz[256];
	GetCmdArgString( argz, sizeof( argz ) );
	
	if ( !strcmp( argz, "half" ) )
		g_RNDTerrorists = 0;
	else
		g_RNDTerrorists = StringToInt( argz );
	
	return Plugin_Continue;
}
