# ../addons/eventscripts/snowfall/snowfall.py

import es
import vecmath

informations = es.AddonInfo()
informations.name = "Snowfall: Source"
informations.basename = "snowfall"
informations.version = "1.0"
informations.author = "L'In20Cible"
informations.description = "Creates snowfall on all maps!"
informations.url = "http://addons.eventscripts.com/addons/view/snowfall/"

es.ServerVar("snowfall_version", "%s by %s" % (informations.version, informations.author), informations.description).makepublic()

def round_start(event_var):
    index = es.createentity("func_precipitation")
    es.entitysetvalue(index, "model", "maps/%s.bsp" % es.getString("eventscripts_currentmap"))
    es.entitysetvalue(index, "preciptype", 3)
    es.server.insertcmd("es_xspawnentity %i" % index)
    m_WorldMins = vecmath.Vector(es.getindexprop(0, "CWorld.m_WorldMins"))
    m_WorldMaxs = vecmath.Vector(es.getindexprop(0, "CWorld.m_WorldMaxs"))
    es.server.insertcmd("es_xsetindexprop %i CBaseEntity.m_Collision.m_vecMins %s" % (index, m_WorldMins))
    es.server.insertcmd("es_xsetindexprop %i CBaseEntity.m_Collision.m_vecMaxs %s" % (index, m_WorldMaxs))
    m_vecOrigin = (m_WorldMins + m_WorldMaxs) / 2
    es.server.insertcmd("es_xentitysetvalue %i origin \"%f %f %f\"" % (index, m_vecOrigin.x, m_vecOrigin.y, m_vecOrigin.z))