# TeamFog release 4 by David Bowland
# ./addons/eventscripts/teamfog/teamfog.py

# >>> To configure this addon please see teamfog.cfg <<<

"""
Renders colored fog that changes based on the location of teams. Requires only ES 2.0+
"""


import es
import gamethread
import os.path


info = es.AddonInfo()
info.name = 'TeamFog'
info.version = '4'
info.url = 'http://addons.eventscripts.com/addons/view/teamfog'
info.basename = 'teamfog'
info.author = 'SuperDave'


dict_player_t = {}
dict_player_ct = {}
bool_entity_exists = 0

dict_options = {'teamfog_updatedelay':[1, 'Number of seconds between fog updates'], 'teamfog_distance_min':[50, 'Distance from the player fog starts'], 'teamfog_distance_max':[1500, 'Distance from the player at which the fog is completely opaque'], 'teamfog_t_red':[0, 'Red value for Terrorist fog (0 to 255 inclusive)'], 'teamfog_t_green':[150, 'Green value for Terrorist fog (0 to 255 inclusive)'], 'teamfog_t_blue':[0, 'Blue value for Terrorist fog (0 to 255 inclusive)'], 'teamfog_ct_red':[0, 'Red value for Counter-Terrorist fog (0 to 255 inclusive)'], 'teamfog_ct_green':[0, 'Green value for Counter-Terrorist fog (0 to 255 inclusive)'], 'teamfog_ct_blue':[255, 'Blue value for Counter-Terrorist fog (0 to 255 inclusive)']}


def load():
   """
   Checks to make sure critical server variables are created by the config
   Loops through all players and calls player_spawn
   Starts the update_fog loop
   """

   for str_option in dict_options:
      es.ServerVar(str_option, dict_options[str_option][0], dict_options[str_option][1])
   if os.path.isfile(es.getAddonPath('teamfog') + '/teamfog.cfg'):
      es.server.cmd('es_xmexec ../addons/eventscripts/teamfog/teamfog.cfg')
   else:
      es.dbgmsg(0, 'TeamFog: Unable to load teamfog.cfg! Please ensure it is in the ./teamfog/ directory.')

   for int_userid in es.getUseridList():
      player_spawn({'userid':str(int_userid), 'es_userteam':str(es.getplayerteam(int_userid))})

   gamethread.delayedname(es.ServerVar('teamfog_updatedelay'), 'teamfog_update_fog', update_fog)


def es_map_start(event_var):
   """
   Restarts the update_fog loop
   Clears dict_player_t and dict_player_ct of players
   Resets bool_entity_exists to 0
   """
   global bool_entity_exists

   gamethread.cancelDelayed('teamfog_update_fog')
   gamethread.delayedname(es.ServerVar('teamfog_updatedelay'), 'teamfog_update_fog', update_fog)

   dict_player_t.clear()
   dict_player_ct.clear()

   bool_entity_exists = 0


def player_spawn(event_var):
   """
   Creates the spawning player in the corresponding team dictionary
   Removes any env_fog_controller entities not created by TeamFog
   """
   global dict_player_t
   global dict_player_ct

   str_userid = event_var['userid']
   if event_var['es_userteam'] == '2':
      dict_player_t[str_userid] = 0
   elif event_var['es_userteam'] == '3':
      dict_player_ct[str_userid] = 0

   if not bool_entity_exists:
      es.server.cmd('es_xfire %s env_fog_controller kill' % str_userid)


def player_death(event_var):
   """Removes the player from the team dictionary"""
   str_userid = event_var['userid']
   if dict_player_t.has_key(str_userid):
      del dict_player_t[str_userid]
   if dict_player_ct.has_key(str_userid):
      del dict_player_ct[str_userid]


def player_disconnect(event_var):
   """Calls player_death"""
   player_death(event_var)


def unload():
   """
   Removes update_fog loop
   Removes fog
   """
   gamethread.cancelDelayed('teamfog_update_fog')

   int_userid = int(es.getuserid())
   if int_userid:
      es.server.cmd('es_xfire %s env_fog_controller turnoff' % int_userid)
      es.server.cmd('es_xfire %s env_fog_controller kill' % int_userid)

   for str_option in dict_options:
      es.ServerVar(str_option).set(0)


def update_fog():
   """
   Creates the env_fog_controller entity as necessary
   Calculates the middle point for alive Terrorist players
   Calculates the middle point for alive Counter-Terrorist players
   Sets fog direction
   Sets fog color based on live players
   Restarts the update_fog loop
   """
   int_fire_userid = int(es.getuserid())
   if int_fire_userid:
      if not bool_entity_exists:
         create_entity(int_fire_userid)

      if dict_player_t and dict_player_ct:
         list_coord_t = [0, 0, 0]
         for str_userid in dict_player_t:
            list_coord_player = es.getplayerlocation(str_userid)
            for int_count in range(0, 3):
               list_coord_t[int_count] += list_coord_player[int_count]

         list_coord_ct = [0, 0, 0]
         for str_userid in dict_player_ct:
            list_coord_player = es.getplayerlocation(str_userid)
            for int_count in range(0, 3):
               list_coord_ct[int_count] += list_coord_player[int_count]

         list_coord_fog = [0, 0, 0]
         for int_count in range(0, 3):
            list_coord_fog[int_count] = (list_coord_t[int_count] / len(dict_player_t)) - (list_coord_ct[int_count] / len(dict_player_ct))
         es.server.cmd('es_xfire %s env_fog_controller addoutput \"fogdir %s %s %s\"' % (int_fire_userid, list_coord_fog[0], list_coord_fog[1], list_coord_fog[2]))

         es.server.cmd('es_xfire %s env_fog_controller addoutput \"fogcolor %s %s %s\"' % (int_fire_userid, es.ServerVar('teamfog_t_red'), es.ServerVar('teamfog_t_green'), es.ServerVar('teamfog_t_blue')))
         es.server.cmd('es_xfire %s env_fog_controller addoutput \"fogcolor2 %s %s %s\"' % (int_fire_userid, es.ServerVar('teamfog_ct_red'), es.ServerVar('teamfog_ct_green'), es.ServerVar('teamfog_ct_blue')))
      elif dict_player_t and not dict_player_ct:
         es.server.cmd('es_xfire %s env_fog_controller addoutput \"fogcolor %s %s %s\"' % (int_fire_userid, es.ServerVar('teamfog_t_red'), es.ServerVar('teamfog_t_green'), es.ServerVar('teamfog_t_blue')))
         es.server.cmd('es_xfire %s env_fog_controller addoutput \"fogcolor2 %s %s %s\"' % (int_fire_userid, es.ServerVar('teamfog_t_red'), es.ServerVar('teamfog_t_green'), es.ServerVar('teamfog_t_blue')))
      elif not dict_player_t and dict_player_ct:
         es.server.cmd('es_xfire %s env_fog_controller addoutput \"fogcolor %s %s %s\"' % (int_fire_userid, es.ServerVar('teamfog_ct_red'), es.ServerVar('teamfog_ct_green'), es.ServerVar('teamfog_ct_blue')))
         es.server.cmd('es_xfire %s env_fog_controller addoutput \"fogcolor2 %s %s %s\"' % (int_fire_userid, es.ServerVar('teamfog_ct_red'), es.ServerVar('teamfog_ct_green'), es.ServerVar('teamfog_ct_blue')))

   gamethread.delayedname(es.ServerVar('teamfog_updatedelay'), 'teamfog_update_fog', update_fog)


def create_entity(int_userid):
   """
   Creates the env_fog_controller entity
   Sets bool_entity_exists to 1
   """
   global bool_entity_exists

   es.server.cmd('es_xgive %s env_fog_controller' % int_userid)
   es.server.cmd('es_xfire %s env_fog_controller addoutput \"fogstart %s\"' % (int_userid, es.ServerVar('teamfog_distance_min')))
   es.server.cmd('es_xfire %s env_fog_controller addoutput \"fogend %s\"' % (int_userid, es.ServerVar('teamfog_distance_max')))
   es.server.cmd('es_xfire %s env_fog_controller addoutput \"fogblend 1"' % int_userid)
   es.server.cmd('es_xfire %s env_fog_controller turnon' % int_userid)

   bool_entity_exists = 1