# -*- coding:Utf-8 -*-

import es, langlib, playerlib

import threading, time, os, psyco

psyco.full()

info = es.AddonInfo()
info.name = "auto_changemap"
info.version = "1.1"
info.author = "Nicolous"
info.url = "http://addons.eventscripts.com"
info.description = "Change automatiquement de map si le serveur est innactif"

# Internationalisation
i18n = langlib.Strings("%s/strings.ini" % es.getAddonPath(info.name))

# ConVar du script
convar_mapcycle = es.ServerVar("auto_changemap_mapcycle","mapcycle.txt","[Auto ChangeMap] : %s" % i18n("auto_changemap_mapcycle"))
convar_time = es.ServerVar("auto_changemap_time","10","[Auto ChangeMap] : %s" % i18n("auto_changemap_time"))
convar_minplayers = es.ServerVar("auto_changemap_minplayers","2","[Auto ChangeMap] : %s" % i18n("auto_changemap_minplayers"))

# ConVar EventScripts
convar_currentmap = es.ServerVar("eventscripts_currentmap")

class AutoMapChangeException(BaseException):
    """Exception spéficique au script"""
    pass

def message(texte,tags):
    """Envoie un message global dans le TCHAT"""

    for player in playerlib.getPlayerList():
        es.tell(player.userid,"#multi","#green","[Auto ChangeMap] :","#default","%s" % i18n(texte,opts=tags,lang=player.get("lang")))


def changelevel(map):
    """Change de map après un court instant"""
    es.delayed(1,"changelevel %s" % map)


def nextMap():
    """
        Retourne le nom VALIDE de la prochaine map dans le fichier contenant le mapcycle
        Jette une exception de type AutoMapChangeException si un nom valide n'a pas pu être trouvé
    """

    nextmap = None
    pathFichier = "%s/cstrike/%s" % (os.getcwd(),str(convar_mapcycle))

    if os.path.isfile(pathFichier):
        premiereMap = None # Contiendra le nom de la première map trouvée dans le fichier
                                # Au cas où le cycle serait arrivé à son terme

        # Lecture du fichier
        mapcycle = None
        try:
            mapcycle = open(pathFichier,"r")
            ligne = mapcycle.readline()
            while ligne != "":
                laMap = ligne.replace("\n","")

                if premiereMap == None:
                    premiereMap = laMap

                # Si on trouve la map actuelle,
                #      la prochaine est soit à la ligne d'après, soit à la première ligne du fichier
                if laMap == str(convar_currentmap):
                    laMap = mapcycle.readline().replace("\n","")
                    if laMap != "":
                        nextmap = laMap
                        ligne = "" # arrêt de la boucle
                    else:
                        ligne = mapcycle.readline()
                else:
                    ligne = mapcycle.readline()
        except IOError:
            es.dbgmsg(0,"[Auto ChangeMap] : %s" % i18n("ioerror",ops={ "file" : pathFichier}))
        finally:
            if mapcycle != None:
                mapcycle.close()

        # Si aucun map n'a été trouvée après la map courante, le cycle est terminé
        if nextmap == None:
            nextmap = premiereMap # retour à la première map
    else:
        es.dbgmsg(0,"[Auto ChangeMap] : %s" % i18n("file_not_found",opts={ "file" : pathFichier}))

    if nextmap != None:
        if es.exists("map",nextmap):
            return nextmap
        else:
            raise AutoMapChangeException(i18n("map_not_found",opts={ "map" : nextmap}))
    else:
        raise AutoMapChangeException(i18n("nextmap_not_found"))


class Checker(threading.Thread):
    """Singleton gérant le délai jusqu'à la prochaine vérification de l'état du serveur"""

    __instance = None

    def __init__(self):
        # Construction du thread
        threading.Thread.__init__(self)

        # Est-ce que le thread doit mourrir ?
        self.__fini = False

        # Nombre de fois que le serveur a été trouvé inactif
        self.__inactif = 0


    def __new__(classe):

        if classe.__instance == None:
            classe.__instance = object.__new__(classe)
        return classe.__instance


    def run(self):

        while not self.__fini:
            time.sleep(60)
            self.__check()


    def stop(self):
        """Stoppe le thread"""

        self.__fini = True
        self.reset()


    def reset(self):
        """Remet à zéro le nombre de fois que le serveur a été trouvé inactif"""

        self.__inactif = 0


    def __check(self):
        """Contrôle l'inactivité sur le serveur"""

        # Cas où il n'y a pas assez de joueurs
        if es.getplayercount() < int(convar_minplayers):
            self.__inactif += 1

            # Si le changement de map n'est pas pour tout de suite
            if self.__inactif < int(convar_time):
                message("warning",{"minplayers" : str(convar_minplayers), "minutes" : int(convar_time)-self.__inactif})
            # Si le changement de map doit être fait
            else:
                message("changelevel",{"minplayers" : str(convar_minplayers), "minutes" : int(convar_time)})
                try:
                    changelevel(nextMap())
                except AutoMapChangeException, e:
                    message(str(e))

        # Cas où il y a assez de joueurs
        else:
            self.__inactif  = 0 # On reprendra le décompte à zéro


def load():
    Checker().start()


def es_map_start(event_var):
    Checker().reset()

    # Exécution du fichier de configuration
    es.mexec("../addons/eventscripts/%s/configuration.cfg" % info.name)


def unload():
    Checker().stop()
